/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASComposite;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.ApplyForcedFormattingStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.DistinctDataStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import java.util.ArrayList;
import java.util.List;

public abstract class SPDSCompositeAbstract
extends SQLSASComposite {
    protected List _preprocessingCompositeList = new ArrayList();
    protected List _postprocessingCompositeList = new ArrayList();
    protected List _startProcSql = new ArrayList();
    protected List _endProcSql = new ArrayList();
    protected boolean _postprocessingCompositeListInProcSQL = false;

    @Override
    public void prepareSQL() throws GenerationException {
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        String outputTableName = dsProcessor.getTempTableName(this._dataSelection);
        dsProcessor.getTempTableIsView(this._dataSelection);
        super.prepareSQL();
        this._postprocessingCompositeListInProcSQL = false;
        boolean isChildQuery = dsProcessor.getAllSubqueries().contains(this._dataSelection);
        boolean isDistinctNeeded = DistinctDataStep.isNeeded(this._dataSelection, isChildQuery);
        boolean isFFStepNeeded = ApplyForcedFormattingStep.isNeeded(this._dataSelection, isChildQuery);
        if (isDistinctNeeded) {
            SQLStatementFactory.addText((List<SQLComponentAbstract>)this._postprocessingCompositeList, "\n/* enforcing distinct output for " + (isChildQuery ? "child" : "main") + " query" + (IQSystemProperties.isVerboseProcCommentsEnabled(this) ? " (" + this.getClass().getSimpleName() + ")" : "") + " */\n");
            this._postprocessingCompositeListInProcSQL = DistinctDataStep.addCode(this._postprocessingCompositeList, dsProcessor, this._dataSelection, isChildQuery, outputTableName, outputTableName, this._postprocessingCompositeListInProcSQL);
        }
        if (isFFStepNeeded) {
            SQLStatementFactory.addText((List<SQLComponentAbstract>)this._postprocessingCompositeList, "\n/* creating formatted output for " + (isChildQuery ? "child" : "main") + " query" + (IQSystemProperties.isVerboseProcCommentsEnabled(this) ? " (" + this.getClass().getSimpleName() + ")" : "") + " */\n");
            this._postprocessingCompositeListInProcSQL = ApplyForcedFormattingStep.addCode(this._postprocessingCompositeList, dsProcessor, this._dataSelection, isChildQuery, outputTableName, outputTableName, this._postprocessingCompositeListInProcSQL, false);
        }
        if (this._postprocessingCompositeListInProcSQL) {
            SQLStatementFactory.addEndProcSql(this._postprocessingCompositeList, dsProcessor);
            this._postprocessingCompositeListInProcSQL = false;
        }
    }

    @Override
    public String writeSQL() {
        ArrayList<SQLComponentAbstract> compositeList = new ArrayList<SQLComponentAbstract>(this._preprocessingCompositeList);
        compositeList.addAll(this._startProcSql);
        compositeList.addAll(this.getCompositeList());
        compositeList.addAll(this._endProcSql);
        compositeList.addAll(this._postprocessingCompositeList);
        return SPDSCompositeAbstract.writeCompositeList(compositeList);
    }
}

