/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.generation2.MetadataDataSource;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.SetOperationDataSelection;
import com.sas.iquery.metadata.business.impl.EffectiveObjectsCache;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.inmemory.InMemorySASLibrary;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;

public class RelationalMetadataDataSource
extends MetadataDataSource {
    private final DataSelectionProcessorAbstract _dataSelectionProcessor;
    private final Collection<String> _libnameStatements = new ArrayList<String>();

    public RelationalMetadataDataSource(DataSelectionProcessorAbstract dataSelectionProcessor) {
        this._dataSelectionProcessor = dataSelectionProcessor;
    }

    @Override
    public void initializeData() throws MetadataException, GenerationException {
        LinkedHashSet<DataSelection> dsList = new LinkedHashSet<DataSelection>();
        dsList.addAll(this._dataSelectionProcessor.getAllSubqueries());
        dsList.add(this._dataSelectionProcessor.getDataSelection());
        EffectiveObjectsCache effectiveObjectsCache = this._dataSelectionProcessor.getEffectiveObjectsCache();
        for (DataSelection ds : dsList) {
            super.initializeDataForOneModel(ds, effectiveObjectsCache);
            if (ds instanceof CreateTableDataSelection) {
                SASLibrary sasLibrary;
                CreateTableDataSelection createTableDataSelection = (CreateTableDataSelection)ds;
                RelationalSchema accessingSchema = createTableDataSelection.getRelationalSchemaForCreation();
                if (!(accessingSchema instanceof SASLibrary) || (sasLibrary = (SASLibrary)accessingSchema).isPreassigned()) continue;
                this._libnameStatements.add(sasLibrary.getLibnameStatement(false, this._dataSelectionProcessor.getDataSelection().getQueryProperty(BusinessQueryProperty.LIBRARY_ACCESS_READONLY)));
                continue;
            }
            if (!(ds instanceof SetOperationDataSelection)) continue;
            SetOperationDataSelection setOperationDataSelection = (SetOperationDataSelection)ds;
            List<DataSelection> setSelections = setOperationDataSelection.getDataSelections();
            for (DataSelection setSelection : setSelections) {
                super.initializeDataForOneModel(setSelection, effectiveObjectsCache);
            }
        }
    }

    @Override
    public List<String> getLibraryAllocationStatements() throws GenerationException {
        ArrayList<String> allocList = new ArrayList<String>();
        allocList.addAll(this._libnameStatements);
        allocList.addAll(super.getLibraryAllocationStatements());
        allocList.addAll(this._dataSelectionProcessor.getLibnameStatements());
        this.addCreateTableLibnameStatement(allocList);
        List<String> inMemoryQueryTableTexts = this.getQueryTablesTexts();
        for (String inMemoryQueryTableText : inMemoryQueryTableTexts) {
            if (inMemoryQueryTableText == null || inMemoryQueryTableText.trim().length() <= 0) continue;
            allocList.add(inMemoryQueryTableText);
        }
        return allocList;
    }

    private void addCreateTableLibnameStatement(List<String> libraryList) throws GenerationException {
        if (this._dataSelectionProcessor.getActualDataSelection() instanceof CreateTableDataSelection) {
            CreateTableDataSelection createTableDS = (CreateTableDataSelection)this._dataSelectionProcessor.getActualDataSelection();
            try {
                String libname = this.createTableGetLibnameStatement(createTableDS);
                if (libname != null && libname.length() > 0) {
                    libraryList.add(libname);
                }
            }
            catch (MetadataException e) {
                GenerationException ge = new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("TempLibnameGeneration.Library.MetadataException.txt", new Object[0]), (Throwable)e);
                throw ge;
            }
        }
    }

    private String createTableGetLibnameStatement(CreateTableDataSelection createTable) throws MetadataException {
        Export export;
        String libnameStatement = null;
        List<ExportRule> exportRules = createTable.getEffectiveRules(ExportRule.class);
        ExportRule exportRule = exportRules.size() == 0 ? null : exportRules.get(0);
        Export export2 = export = exportRule != null ? exportRule.getExport() : null;
        if (export != null && export.isCreateTableRequiredForExport()) {
            if (export.getSASLibrary() != null) {
                libnameStatement = export.getSASLibrary().getLibnameStatement();
            } else {
                InMemorySASLibrary createTableLib = (InMemorySASLibrary)createTable.getRelationalSchemaForCreation();
                libnameStatement = createTableLib.getLibnameStatement();
            }
        }
        return libnameStatement;
    }

    @Override
    @Nonnull
    public List<String> getQueryTablesTexts() throws GenerationException {
        return this._dataSelectionProcessor.getQueryTablesTexts();
    }

    @Override
    @Nonnull
    public List<String> getQueryTablesPrepareLogs() throws GenerationException {
        return this._dataSelectionProcessor.getQueryTablesPrepareLogs();
    }

    protected DataSelectionProcessorAbstract getDataSelectionProcessor() {
        return this._dataSelectionProcessor;
    }
}

