/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.relational.DataItemRankFilter;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.FractionOfGrandTotalStep;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalSortingStep;
import com.sas.iquery.util.DataSelectionOrganizer;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class RelationalDataSelectionProcessor
extends DataSelectionProcessorAbstract {
    private final LinkedHashSet<DataSelection> _dropTablesList = new LinkedHashSet();
    private boolean _init = false;
    private boolean _hasRankings;
    private boolean _hasFoTs;
    private boolean _hasSortsOnHiddenAggregates;
    private boolean _hasTotals;
    private boolean _hasDetails;

    public RelationalDataSelectionProcessor(DataSelection dataSelection) {
        super(dataSelection);
    }

    public RelationalDataSelectionProcessor(DataSelection dataSelection, boolean hasRankings, boolean hasFoTs, boolean hasSortsOnHiddenAggregates, boolean hasTotals, boolean hasDetails) {
        super(dataSelection);
        this._hasRankings = hasRankings;
        this._hasFoTs = hasFoTs;
        this._hasSortsOnHiddenAggregates = hasSortsOnHiddenAggregates;
        this._hasTotals = hasTotals;
        this._hasDetails = hasDetails;
        this._init = true;
    }

    void doInit() throws GenerationException {
        if (!this._init) {
            DataSelection selection = this.getDataSelection();
            this._hasRankings = DataRetrievalUtil.isModelRanked(selection);
            this._hasFoTs = FractionOfTotalUtilImpl.checkGrandTotalComparisonItems(selection);
            this._hasSortsOnHiddenAggregates = RelationalSortingStep.isModelSortedByHiddenAggregates(selection);
            this._hasTotals = DataRetrievalUtil.isModelGrandTotal(selection);
            this._init = true;
        }
    }

    @Override
    public Collection<DataSelection> populateMultipleDataSelections(DataSelection dataSelection) throws GenerationException {
        this.doInit();
        dataSelection = this.extractCreateTableDataSelection(dataSelection);
        DataSelectionOrganizer organizer = DataSelectionOrganizer.getInstance(this.getEffectiveObjectsCache());
        try {
            this._dsrqSubqueries = DataSelectionOrganizer.getDSRQSubqueries(dataSelection);
            this._allSubqueries = DataSelectionOrganizer.getAllSubqueries(dataSelection);
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("DataSelectionOrganizer.getDataSourceRelationalQueries.owningTableError.txt", new Object[0]);
            throw new GenerationException(formatter, (Throwable)e);
        }
        return this._dsrqSubqueries;
    }

    public boolean isDropped(DataSelection ds) {
        return this._dropTablesList.contains(ds);
    }

    public void tableHasBeenDropped(DataSelection ds) {
        this._dropTablesList.add(ds);
    }

    @Override
    public boolean isNeededForPostProcess(DataSelection dataSelection, DataItem item, Role role) throws GenerationException {
        boolean isInactiveItem;
        DataItem numeratorItem;
        boolean useNumeratorItemInstead;
        this.doInit();
        boolean isFoTGrandTotal = FractionOfTotalUtilImpl.isFractionOfGrandTotalItem(item);
        if (isFoTGrandTotal && (useNumeratorItemInstead = FractionOfGrandTotalStep.useNumeratorAliasForInputVar(this, dataSelection, item, numeratorItem = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(item)))) {
            return false;
        }
        boolean isOutputItem = Role.isOutputResultRole(dataSelection, role);
        if (isOutputItem) {
            return true;
        }
        boolean isUsedInFoTs = FractionOfTotalUtilImpl.isUsedByFractionOfTotalInQuery(this._dataSelection, item);
        if (isUsedInFoTs) {
            return true;
        }
        boolean isRankItem = false;
        List<StepInterface> steps = item.getSteps();
        Iterator<StepInterface> it = steps.iterator();
        while (it.hasNext() && !isRankItem) {
            StepInterface step = it.next();
            if (!(step instanceof DataItemRankFilter)) continue;
            isRankItem = true;
        }
        if (isRankItem) {
            return true;
        }
        boolean isSortItem = false;
        boolean bl = isInactiveItem = role == Role.BACKGROUND || Role.isInactiveRole(this._dataSelection, role);
        if (!isInactiveItem && this.isSortInPostProcess()) {
            boolean isValidSortItem = RelationalSortingStep.isValidInSort(this._dataSelection, item, isOutputItem, isInactiveItem);
            List<DataItem> sortItems = this._dataSelection.getEffectiveSortOrderPrecedence();
            for (DataItem sortItem : sortItems) {
                if (!item.equals(sortItem)) continue;
                isSortItem = isValidSortItem;
            }
        }
        return isSortItem;
    }

    public boolean isSortInPostProcess() throws GenerationException {
        this.doInit();
        return this._hasRankings || this._hasFoTs || this._hasSortsOnHiddenAggregates;
    }

    public boolean hasRankings() {
        return this._hasRankings;
    }

    public boolean hasFoTs() {
        return this._hasFoTs;
    }

    public boolean hasSortsOnHiddenAggregates() {
        return this._hasSortsOnHiddenAggregates;
    }

    public boolean hasTotals() {
        return this._hasTotals;
    }

    public boolean hasDetails() {
        return this._hasDetails;
    }
}

