/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalDataSelectionProcessor;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.util.DataSelectionOrganizer;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DropTableStatement
extends SQLComponentAbstract {
    private List<SQLComponentAbstract> _dropList = new ArrayList<SQLComponentAbstract>();
    private static final Logger _logger = LogManager.getLogger(DropTableStatement.class);

    @Override
    public void prepareSQL() throws GenerationException {
        Collection resources;
        DataSelection ds;
        DataSelection currentDataSelection = this._dataSelection;
        DataSelectionProcessorAbstract dsp = this.getDataSelectionProcessor();
        DataSelectionOrganizer organizer = DataSelectionOrganizer.getInstance(dsp.getEffectiveObjectsCache());
        LinkedHashSet keepList = new LinkedHashSet();
        Collection<DataSelection> childQueries = dsp.getAllSubqueries();
        ArrayList<DataSelection> reverseList = new ArrayList<DataSelection>();
        reverseList.addAll(childQueries);
        reverseList.add(dsp.getDataSelection());
        Iterator iterator = reverseList.iterator();
        while (iterator.hasNext() && !(ds = (DataSelection)iterator.next()).equals(currentDataSelection)) {
            Collection queries;
            try {
                queries = organizer.getQueryDataSources(ds);
            }
            catch (MetadataException e) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("DataSelectionOrganizer.getDataSourceRelationalQueries.owningTableError.txt", new Object[0]);
                throw new GenerationException(msg, (Throwable)e);
            }
            keepList.addAll(queries);
        }
        try {
            resources = organizer.getQueryDataSources(currentDataSelection);
        }
        catch (MetadataException e) {
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("DataSelectionOrganizer.getDataSourceRelationalQueries.owningTableError.txt", e));
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Queries used after " + currentDataSelection.getLabel() + "=" + keepList + " size=" + keepList.size());
            _logger.debug("Data sources used " + resources);
        }
        for (Object resource : resources) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("checking if '" + resource + "' (" + resource.getClass().getSimpleName() + ") is still needed");
            }
            while (resource instanceof DataSourceRelationalQuery) {
                DataSourceRelationalQuery dsrq = (DataSourceRelationalQuery)resource;
                resource = dsrq.getBusinessQuery();
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug(" dsrq has query '" + resource + "' (" + resource.getClass().getSimpleName() + ")");
            }
            DataSelection ds2 = null;
            if (resource instanceof DataSelection) {
                ds2 = (DataSelection)resource;
            } else if (_logger.isEnabled(Level.WARN)) {
                _logger.warn("Data source relational query resource found was not a data selection: " + resource + (resource != null ? ", " + resource.getClass().getSimpleName() : ""));
            }
            if (_logger.isDebugEnabled() && ds2 != null) {
                _logger.debug("  its query is '" + ds2 + "' (" + ds2.getClass().getSimpleName() + ")");
            }
            if (keepList.contains(ds2)) continue;
            if (ds2 != null) {
                RelationalDataSelectionProcessor relationalDsp;
                boolean isDropped;
                boolean createTable = dsp.isTempTable(ds2);
                if (!createTable || !(dsp instanceof RelationalDataSelectionProcessor) || (isDropped = (relationalDsp = (RelationalDataSelectionProcessor)dsp).isDropped(ds2))) continue;
                relationalDsp.tableHasBeenDropped(ds2);
                String tempTableName = dsp.getTempTableName(ds2);
                boolean isView = dsp.getTempTableIsView(ds2);
                if (isView) {
                    SQLStatementFactory.addDropViewByName(this._dropList, dsp, tempTableName);
                    continue;
                }
                SQLStatementFactory.addDropTableByName(this._dropList, dsp, tempTableName);
                continue;
            }
            if (!_logger.isEnabled(Level.WARN)) continue;
            _logger.warn("Data source relational query resource was not in list of processed queries: " + resource + (resource != null ? ", " + resource.getClass().getSimpleName() : ""));
        }
    }

    @Override
    public String writeSQL() {
        return DropTableStatement.writeCompositeList(this._dropList);
    }
}

