/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.subqueries;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.BusinessQueryTotalLocationType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class ApplyForcedFormattingStep {
    public static final String PROPERTY_SASQUERYSERVICES_CLEAR_CATEGORY_TOTALS = "SASQueryServices.ClearCategoryTotals";
    private static final int MAX_SIZE = 79;

    public static boolean isNeeded(DataSelection dataSelection, boolean isChildQuery) {
        boolean isNeeded = false;
        Iterator<SelectedItem> it = dataSelection.getSelectedItems().iterator();
        while (!isNeeded && it.hasNext()) {
            SelectedItem selectedItem = it.next();
            Role role = selectedItem.getRole();
            boolean isOutputResultItem = Role.isOutputResultRole(dataSelection, role);
            if (!isOutputResultItem) continue;
            isNeeded = GenerationUtil.isOutputDataFormatted(dataSelection, selectedItem, isChildQuery);
        }
        return isNeeded;
    }

    public static boolean addCode(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, boolean isChildQuery, String inputTableName, String outputTableName, boolean distinctValues, boolean inProcSQL) throws GenerationException {
        HashMap<String, String> tooLongAlias = new HashMap<String, String>();
        boolean transform = false;
        ArrayList<String> outputColumnIdentifiers = new ArrayList<String>();
        LinkedHashMap<String, String> outputColumnLabels = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> ffColumnSources = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> ffColumnFormats = new LinkedHashMap<String, String>();
        ArrayList<String> ffColumnCategories = new ArrayList<String>();
        for (SelectedItem selectedItem : dataSelection.getSelectedItems()) {
            DataItem dataItem = selectedItem.getItem();
            Role role = selectedItem.getRole();
            boolean isOutputResultItem = Role.isOutputResultRole(dataSelection, role);
            if (!isOutputResultItem) continue;
            String alias = dataItem.getResultSetID();
            boolean formatOutput = GenerationUtil.isOutputDataFormatted(dataSelection, selectedItem, isChildQuery);
            String label = dataItem.getLabel();
            if (formatOutput) {
                boolean useFormat;
                transform = true;
                String format = GenerationUtil.generateFormat(dataItem);
                boolean bl = useFormat = format != null && format.trim().length() > 0;
                if (useFormat) {
                    if ("$.".equals(format)) {
                        format = "$char.";
                    }
                    String oldColumnAlias = ApplyForcedFormattingStep.createAlias(tooLongAlias, "", alias, "_unf");
                    ffColumnSources.put(alias, oldColumnAlias);
                    ffColumnFormats.put(oldColumnAlias, format);
                }
            }
            outputColumnIdentifiers.add(alias);
            outputColumnLabels.put(alias, label);
            if (!dataItem.getUsage().equals(DataItemActionType.USAGE_CATEGORY)) continue;
            ffColumnCategories.add(alias);
        }
        if (transform) {
            if (inProcSQL) {
                SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
                inProcSQL = false;
            }
            StringBuffer dataStep = ApplyForcedFormattingStep.generateApplyForcedFormattingDataStep(dsProcessor, dataSelection, inputTableName, outputTableName, outputColumnIdentifiers, outputColumnLabels, ffColumnSources, ffColumnFormats, ffColumnCategories);
            SQLStatementFactory.addText(compositeList, dataStep);
            if (!inputTableName.equalsIgnoreCase(outputTableName)) {
                SQLStatementFactory.addProcDeleteDataByName(compositeList, dsProcessor, inputTableName);
            }
        } else if (!inputTableName.equalsIgnoreCase(outputTableName)) {
            if (inProcSQL) {
                SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
                inProcSQL = false;
            }
            SQLStatementFactory.addProcDataSetsRename(compositeList, inputTableName, outputTableName);
        }
        return inProcSQL;
    }

    private static StringBuffer generateApplyForcedFormattingDataStep(DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, String inputTableName, String outputTableName, List<String> outputColumnIdentifiers, Map<String, String> outputColumnLabels, Map<String, String> ffColumnSources, Map<String, String> ffColumnFormats, List<String> ffColumnCategories) throws GenerationException {
        boolean clearCatTotalsAtStart = false;
        boolean clearCatTotalsAtEnd = false;
        TotalingType totalingType = dataSelection.getTotalingType(Role.COLUMN);
        if (totalingType != null && !TotalingType.TOTAL_NONE.equals(totalingType) && !ffColumnFormats.isEmpty()) {
            BusinessQueryTotalLocationType totalLocation = dataSelection.getTotalLocation();
            for (int i = 0; i < outputColumnIdentifiers.size(); ++i) {
                String outputColumnName = outputColumnIdentifiers.get(i);
                String oldColumnAlias = ffColumnSources.get(outputColumnName);
                if (oldColumnAlias == null || !ffColumnCategories.contains(outputColumnName)) continue;
                if (totalLocation.equals(BusinessQueryTotalLocationType.TOTAL_TOTAL_ROW_TOP_COLUMN_LEFT)) {
                    clearCatTotalsAtStart = true;
                    break;
                }
                clearCatTotalsAtEnd = true;
                break;
            }
        }
        boolean clearCategoryTotals = false;
        try {
            clearCategoryTotals = Boolean.getBoolean(PROPERTY_SASQUERYSERVICES_CLEAR_CATEGORY_TOTALS);
        }
        catch (Throwable e) {
            clearCategoryTotals = false;
        }
        StringBuffer dataStep = new StringBuffer();
        dataStep.append("data ").append(outputTableName).append("(");
        dataStep.append("\n   keep=");
        ApplyForcedFormattingStep.writeOutputColumns(dataStep, dsProcessor, outputColumnIdentifiers, 8);
        dataStep.append("\n   );");
        dataStep.append("\n   /* pre-assign the label for output columns in order to preserve their order */");
        ApplyForcedFormattingStep.writeOutputColumnAttribs(dataStep, outputColumnIdentifiers, outputColumnLabels, dsProcessor);
        dataStep.append("\n");
        dataStep.append("\n   set ").append(inputTableName);
        if (!ffColumnSources.isEmpty()) {
            dataStep.append("(\n      rename=(");
            ApplyForcedFormattingStep.writeRenameColumns(dataStep, outputColumnIdentifiers, ffColumnSources, dsProcessor, 11);
            dataStep.append(")\n      )");
        }
        if (clearCatTotalsAtEnd && clearCategoryTotals) {
            dataStep.append(" end=eof");
        }
        dataStep.append(";\n");
        if (!ffColumnFormats.isEmpty()) {
            dataStep.append("\n   /* calculate forced formatted output columns */");
            ApplyForcedFormattingStep.writeNewOutputColumnCalcs(dataStep, outputColumnIdentifiers, ffColumnSources, ffColumnFormats, dsProcessor, ffColumnCategories, clearCatTotalsAtStart, clearCatTotalsAtEnd, clearCategoryTotals);
            dataStep.append("\n");
        }
        dataStep.append("\nrun;");
        return dataStep;
    }

    static String createAlias(Map<String, String> aliasMap, String prefix, String stem, String suffix) throws GenerationException {
        String requested;
        String testAlias = requested = prefix + stem + suffix;
        int i = 0;
        while (aliasMap.containsKey(testAlias)) {
            if (testAlias.length() > 31) {
                if (stem.equalsIgnoreCase("ID")) {
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("ApplyForcedFormattingStep.UniqueAliasFail.fmt.txt", requested, testAlias);
                    throw new GenerationException(mft);
                }
                stem = "ID";
                i = 0;
            }
            testAlias = prefix + stem + suffix + ++i;
        }
        aliasMap.put(testAlias, requested);
        return testAlias;
    }

    public static void writeOutputColumns(StringBuffer dataStep, DataSelectionProcessorAbstract dsProcessor, Collection<String> outputColumnIdentifiers, int len) throws GenerationException {
        boolean first = true;
        for (String string : outputColumnIdentifiers) {
            String identifier = dsProcessor.generateDataStepVar(string);
            if ((len += identifier.length()) > 79) {
                dataStep.append("\n      ");
                len = 6 + identifier.length();
            } else if (first) {
                first = false;
            } else {
                dataStep.append(' ');
                ++len;
            }
            dataStep.append(identifier);
        }
    }

    private static void writeRenameColumns(StringBuffer dataStep, List<String> outputColumnIdentifiers, Map<String, String> ffColumnSources, DataSelectionProcessorAbstract dsProcessor, int len) throws GenerationException {
        int found = 0;
        for (int i = 0; i < outputColumnIdentifiers.size(); ++i) {
            String fromColumnName = outputColumnIdentifiers.get(i);
            String destColumnName = ffColumnSources.get(fromColumnName);
            if (destColumnName == null) continue;
            String fromIdentifier = dsProcessor.generateDataStepVar(fromColumnName);
            String destIdentifier = dsProcessor.generateDataStepVar(destColumnName);
            if ((len += fromIdentifier.length() + 1 + destIdentifier.length()) > 79) {
                dataStep.append("\n         ");
                len = 9 + fromIdentifier.length() + 1 + destIdentifier.length();
            } else if (found > 0) {
                dataStep.append(' ');
                ++len;
            }
            dataStep.append(fromIdentifier).append('=').append(destIdentifier);
            ++found;
        }
    }

    private static void writeOutputColumnAttribs(StringBuffer dataStep, List<String> outputColumnIdentifiers, Map<String, String> outputColumnLabels, DataSelectionProcessorAbstract dsProcessor) throws GenerationException {
        for (int i = 0; i < outputColumnIdentifiers.size(); ++i) {
            String outputColumnName = outputColumnIdentifiers.get(i);
            String outputIdentifier = dsProcessor.generateDataStepVar(outputColumnName);
            String quotedLabel = GenerationUtil.generateQuotedLiteral(outputColumnLabels.get(outputColumnName));
            dataStep.append("\n   attrib ").append(outputIdentifier).append(" label=").append(quotedLabel).append(';');
        }
    }

    private static void writeNewOutputColumnCalcs(StringBuffer dataStep, List<String> outputColumnIdentifiers, Map<String, String> ffColumnSources, Map<String, String> ffColumnFormats, DataSelectionProcessorAbstract dsProcessor, List<String> ffColumnCategories, boolean clearCatTotalsAtStart, boolean clearCatTotalsAtEnd, boolean clearCategoryTotals) throws GenerationException {
        for (int i = 0; i < outputColumnIdentifiers.size(); ++i) {
            String outputColumnName = outputColumnIdentifiers.get(i);
            String oldColumnAlias = ffColumnSources.get(outputColumnName);
            if (oldColumnAlias == null) continue;
            String newOutputIdentifier = dsProcessor.generateDataStepVar(outputColumnName);
            String format = ffColumnFormats.get(oldColumnAlias);
            String oldColumnIdentifier = dsProcessor.generateDataStepVar(oldColumnAlias);
            String code = GenerationUtil.generateDataStepPut(oldColumnIdentifier, format);
            if (clearCategoryTotals) {
                if (ffColumnCategories.contains(outputColumnName)) {
                    if (clearCatTotalsAtEnd) {
                        dataStep.append("\n   if not eof then");
                        dataStep.append("\n      ").append(newOutputIdentifier).append(" = ").append(code).append(';');
                        dataStep.append("\n   else ").append(newOutputIdentifier).append(" = ' ';");
                        continue;
                    }
                    if (clearCatTotalsAtStart) {
                        dataStep.append("\n   if _n_ > 1 then");
                        dataStep.append("\n      ").append(newOutputIdentifier).append(" = ").append(code).append(';');
                        dataStep.append("\n   else ").append(newOutputIdentifier).append(" = ' ';");
                        continue;
                    }
                    dataStep.append("\n   ").append(newOutputIdentifier).append(" = ").append(code).append(';');
                    continue;
                }
                dataStep.append("\n   ").append(newOutputIdentifier).append(" = ").append(code).append(';');
                continue;
            }
            dataStep.append("\n   ").append(newOutputIdentifier).append(" = ").append(code).append(';');
        }
    }
}

