/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLCompositeAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLOrderByAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASFactory;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalPostProcessComposite;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalSortingStep;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.rank.SQLSASEmptyOrderBy;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalDataSelectionProcessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RelationalPostProcessFactory
extends SQLSASFactory {
    private final DataSelection _model;
    private final boolean _hasRankings;
    private final boolean _hasFoTs;
    private final boolean _hasSortsOnHiddenAggregates;
    private final boolean _hasTotals;
    private final boolean _hasDetails;
    private static final Logger _logger = LogManager.getLogger(RelationalPostProcessFactory.class);

    public RelationalPostProcessFactory(DataSelection model) throws GenerationException {
        this._model = model;
        this._hasRankings = DataRetrievalUtil.isModelRanked(model);
        this._hasFoTs = FractionOfTotalUtilImpl.checkGrandTotalComparisonItems(model);
        this._hasSortsOnHiddenAggregates = RelationalSortingStep.isModelSortedByHiddenAggregates(model);
        this._hasTotals = DataRetrievalUtil.isModelGrandTotal(model);
        this._hasDetails = DataRetrievalUtil.isModelDetailed(model);
    }

    @Override
    public SQLComponentAbstract createSQLSelect() throws GenerationException {
        SQLComponentAbstract sqlSelect = super.createSQLSelect();
        sqlSelect.setSQLFactory(this);
        return sqlSelect;
    }

    @Override
    public SQLComponentAbstract createSQLOrderBy() throws GenerationException {
        SQLOrderByAbstract sqlOrderBy = null;
        sqlOrderBy = this._hasRankings || this._hasFoTs || this._hasSortsOnHiddenAggregates ? new SQLSASEmptyOrderBy() : (SQLOrderByAbstract)super.createSQLOrderBy();
        sqlOrderBy.setSQLFactory(this);
        return sqlOrderBy;
    }

    @Override
    public DataSelectionProcessorAbstract newDataSelectionProcessor(DataSelection dataSelection) throws GenerationException {
        RelationalDataSelectionProcessor dsProcessor;
        if (this._model != dataSelection) {
            boolean hasRankings = DataRetrievalUtil.isModelRanked(dataSelection);
            boolean hasFoTs = FractionOfTotalUtilImpl.checkGrandTotalComparisonItems(dataSelection);
            boolean hasSortsOnHiddenAggregates = RelationalSortingStep.isModelSortedByHiddenAggregates(dataSelection);
            boolean hasTotals = DataRetrievalUtil.isModelGrandTotal(dataSelection);
            boolean hasDetails = DataRetrievalUtil.isModelDetailed(dataSelection);
            dsProcessor = new RelationalDataSelectionProcessor(dataSelection, hasRankings, hasFoTs, hasSortsOnHiddenAggregates, hasTotals, hasDetails);
        } else {
            dsProcessor = new RelationalDataSelectionProcessor(dataSelection, this._hasRankings, this._hasFoTs, this._hasSortsOnHiddenAggregates, this._hasTotals, this._hasDetails);
        }
        return dsProcessor;
    }

    @Override
    public SQLCompositeAbstract createSQLComposite(DataSelection dataSelection, DataSelectionProcessorAbstract processor) throws GenerationException {
        RelationalPostProcessComposite sqlComposite;
        try {
            processor.populate();
        }
        catch (GenerationException e) {
            _logger.debug("Ignore populate error during setup", (Throwable)e);
        }
        if (processor instanceof RelationalDataSelectionProcessor) {
            RelationalDataSelectionProcessor rdsProcessor = (RelationalDataSelectionProcessor)processor;
            sqlComposite = new RelationalPostProcessComposite(rdsProcessor.hasRankings(), rdsProcessor.hasFoTs(), rdsProcessor.hasSortsOnHiddenAggregates(), rdsProcessor.hasTotals(), rdsProcessor.hasDetails());
        } else {
            sqlComposite = new RelationalPostProcessComposite(DataRetrievalUtil.isModelRanked(dataSelection), FractionOfTotalUtilImpl.checkGrandTotalComparisonItems(dataSelection), RelationalSortingStep.isModelSortedByHiddenAggregates(dataSelection), DataRetrievalUtil.isModelGrandTotal(dataSelection), DataRetrievalUtil.isModelDetailed(dataSelection));
        }
        sqlComposite.setSQLFactory(this);
        sqlComposite.setDataSelection(dataSelection);
        sqlComposite.setDataSelectionProcessor(processor);
        return sqlComposite;
    }
}

