/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.builder.DisabledTotalsBuilder;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.BusinessQueryTotalLocationType;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.physical.RelationalSchema;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLColumnAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLOrderByAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASComposite;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CodeStringAdapterComponent;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CommentStatement;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.DataStepTotalLabel;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.EmptyDataStep;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.FractionOfGrandTotalStep;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.NonVisualTotalsComposite;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.NonVisualTotalsSQLFactory;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.NonVisualTotalsUpdateStep;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.ProcDataSets;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.ProcSQLDecorator;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.ProcSummaryStatement;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalItem;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalSortingStep;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.rank.ProcRankStatement;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.ApplyForcedFormattingStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.DistinctDataStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.util.ChainedException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RelationalPostProcessComposite
extends SQLSASComposite {
    private final boolean _hasRankings;
    private final boolean _hasFoTs;
    private final boolean _hasSortsOnHiddenAggregates;
    private final boolean _hasTotals;
    private final boolean _hasDetails;
    private boolean _sortAdded = false;
    private static final Logger _logger = LogManager.getLogger(RelationalPostProcessComposite.class);

    public RelationalPostProcessComposite(boolean hasRankings, boolean hasFoTs, boolean hasSortsOnHiddenAggregates, boolean hasTotals, boolean hasDetails) {
        this._hasRankings = hasRankings;
        this._hasFoTs = hasFoTs;
        this._hasSortsOnHiddenAggregates = hasSortsOnHiddenAggregates;
        this._hasTotals = hasTotals;
        this._hasDetails = hasDetails;
    }

    @Override
    protected SQLComponentAbstract _generateOrderBy() throws GenerationException {
        SQLOrderByAbstract sqlOrderBy = (SQLOrderByAbstract)super._generateOrderBy();
        this._sortAdded = !sqlOrderBy.delayedSort();
        return sqlOrderBy;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        CommentStatement commentBlock;
        boolean disallowsViews;
        CommentStatement commentBlock2;
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        boolean inProcSQL = false;
        this._sortAdded = false;
        if (this._dataSelection == null) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("RelationalRankAndTotalComposite.prepareSQL.NoDataSelection.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        boolean isInfo = IQSystemProperties.isVerboseProcCommentsEnabled(this);
        boolean procExport = false;
        boolean procLasr = false;
        boolean procMetalib = false;
        Export export = null;
        List<ExportRule> exportRules = this._dataSelection.getEffectiveRules(ExportRule.class);
        if (!exportRules.isEmpty()) {
            export = exportRules.get(0).getExport();
            if (export.getUsage() == ExportType.CSV || export.getUsage() == ExportType.JSON) {
                procExport = true;
            } else if (export.getUsage() == ExportType.LASR_RESULT_SET || export.getUsage() == ExportType.EXPORT_AND_LASR_SAS_LIBNAME || export.getUsage() == ExportType.EXPORT_AND_LASR_SAS_OMALIB) {
                procLasr = true;
            }
            if (export.isMetalibInEffect()) {
                procMetalib = true;
            }
        }
        List<SQLComponentAbstract> compositeList = this.getCompositeList();
        if (isInfo && _logger.isDebugEnabled()) {
            commentBlock2 = new CommentStatement(" Query ");
            commentBlock2.commentOnDataSelection(this._dataSelection);
            compositeList.add(commentBlock2);
        }
        if (isInfo) {
            commentBlock2 = new CommentStatement(1, 1);
            commentBlock2.append(" SQL STEP 1. Extract Data ");
            compositeList.add(commentBlock2);
        }
        String inputTableName = null;
        boolean isView = false;
        if (this._dataSelection instanceof CreateTableDataSelection) {
            CreateTableDataSelection parentDataSelection = (CreateTableDataSelection)this._dataSelection;
            RelationalSchema schema = parentDataSelection.getRelationalSchemaForCreation();
            if (!(schema instanceof SASLibrary)) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("RelationalSASComposite.prepareSQL.NonSAS.txt", new Object[0]);
                throw new GenerationException(formatter);
            }
            SASLibrary tempSasLibrary = (SASLibrary)schema;
            String libname = null;
            try {
                libname = tempSasLibrary.getLibref();
            }
            catch (MetadataException e) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("RelationalSASComposite.prepareSQL.MetadataException.txt", new Object[0]);
                throw new GenerationException(formatter, (Throwable)e);
            }
            inputTableName = libname + "." + dsProcessor.generateTableIdentifier(parentDataSelection.getName());
            isView = parentDataSelection.isView();
            dsProcessor.putTempTableName(this._dataSelection, inputTableName);
            dsProcessor.setTempTableIsView(this._dataSelection, isView);
        } else {
            inputTableName = dsProcessor.getTempTableName(this._dataSelection);
            isView = dsProcessor.getTempTableIsView(this._dataSelection);
        }
        boolean isChildQuery = dsProcessor.getAllSubqueries().contains(this._dataSelection);
        boolean hasFFs = ApplyForcedFormattingStep.isNeeded(this._dataSelection, isChildQuery);
        boolean isDistinctNeeded = DistinctDataStep.isNeeded(this._dataSelection, isChildQuery);
        boolean postProcessed = !isChildQuery && (hasFFs || isDistinctNeeded);
        boolean bl = disallowsViews = !dsProcessor.isTempViewAllowed();
        if (isView && (this._hasRankings || this._hasFoTs || this._hasSortsOnHiddenAggregates || this._hasTotals || postProcessed || disallowsViews)) {
            this.addWhyNoViewComment(compositeList, this._dataSelection, postProcessed, disallowsViews);
            dsProcessor.setTempTableIsView(this._dataSelection, false);
            isView = false;
        }
        boolean useTsSql = dsProcessor.isTSSQL();
        String options = SQLStatementFactory.getProcSqlOptions(useTsSql, this._dataSelection);
        SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, true, options);
        inProcSQL = true;
        SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addCreateAs(compositeList, dsProcessor, inputTableName, isView);
        super.prepareSQL();
        SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
        inProcSQL = false;
        List<RelationalItem> postProcessSortingItems = RelationalSortingStep.getRelationalSortingItems(this._dataSelection, false);
        if (dsProcessor.isTSSQL()) {
            ProcSQLDecorator tsSqlFixup = new ProcSQLDecorator(this._dataSelection, inputTableName);
            List<SQLColumnAbstract> sqlColumns = this.getSQLColumns();
            tsSqlFixup.setSQLColumns(sqlColumns);
            tsSqlFixup.setDataSelectionProcessor(dsProcessor);
            tsSqlFixup.setSQLFactory(this.getSQLFactory());
            tsSqlFixup.prepareSQL();
            compositeList.add(tsSqlFixup);
        }
        if (isInfo) {
            CommentStatement commentBlock3 = new CommentStatement(1, 1);
            commentBlock3.append(" SQL STEP 2. Rank Statement ");
            compositeList.add(commentBlock3);
        }
        if (this._hasRankings) {
            boolean doSortHere = !this._hasFoTs && !this._hasSortsOnHiddenAggregates;
            ProcRankStatement rank = new ProcRankStatement(this._dataSelection, inputTableName, inputTableName, postProcessSortingItems, doSortHere);
            rank.setDataSelectionProcessor(dsProcessor);
            rank.setSQLFactory(this.getSQLFactory());
            rank.setJoinGenerator(this.m_joinGenerator);
            rank.prepareSQL();
            compositeList.add(rank);
            List<RelationalItem> rankSortingItems = rank.getRankSortingItems();
            if (doSortHere) {
                this._sortAdded = true;
            } else {
                postProcessSortingItems.addAll(rankSortingItems);
                this._sortAdded = false;
            }
        }
        if (isInfo) {
            CommentStatement commentBlock4 = new CommentStatement(1, 1);
            commentBlock4.append(" SQL STEP 3. Distinct Statement ");
            this.addComponent(commentBlock4);
        }
        if (isDistinctNeeded && (inProcSQL = DistinctDataStep.addCode(compositeList, dsProcessor, this._dataSelection, isChildQuery, inputTableName, inputTableName, inProcSQL))) {
            SQLStatementFactory.addEndProcSql(compositeList, this.getDataSelectionProcessor());
            inProcSQL = false;
        }
        if (isInfo) {
            CommentStatement commentBlock5 = new CommentStatement(1, 1);
            commentBlock5.append(" SQL STEP 4. Non-Visual Totals Step ");
            this.addComponent(commentBlock5);
        }
        String nvtResultsTableName = inputTableName + "_nvt";
        boolean usesNonVisualtotals = NonVisualTotalsComposite.isNonVisualTotalsCalcNeeded(this._dataSelection);
        boolean isModelDetailed = DataRetrievalUtil.isModelDetailed(this._dataSelection);
        if (usesNonVisualtotals && !isModelDetailed) {
            NonVisualTotalsSQLFactory nvtSQLFactory = new NonVisualTotalsSQLFactory(this._hasRankings, this._hasDetails);
            NonVisualTotalsComposite nvtSQLComposite = nvtSQLFactory.createSQLComposite(this._dataSelection);
            nvtSQLComposite.setDataSelectionProcessor(dsProcessor);
            nvtSQLComposite.setResultsTableName(nvtResultsTableName);
            nvtSQLComposite.setInputTableName(inputTableName);
            List<FilterItem> havingFilters = this._sqlFilterExaminer.getHavingFilters();
            boolean hasAggFilters = !havingFilters.isEmpty();
            nvtSQLComposite.setIsAggPreFiltered(hasAggFilters);
            nvtSQLComposite.prepareSQL();
            this.addComponent(nvtSQLComposite);
        }
        if (isInfo) {
            CommentStatement commentBlock6 = new CommentStatement(1, 1);
            commentBlock6.append(" SQL STEP 5. Fraction of Grand Total Step");
            this.addComponent(commentBlock6);
        }
        if (this._hasFoTs) {
            int applySort = FractionOfGrandTotalStep.GEN_FOT_WITH_SORTING;
            if (this._sortAdded) {
                applySort = FractionOfGrandTotalStep.GEN_FOT_PERSERVING_ORDER;
            } else if (this._hasSortsOnHiddenAggregates) {
                applySort = FractionOfGrandTotalStep.GEN_FOT_IGNORING_ORDER;
            }
            FractionOfGrandTotalStep.addCode(compositeList, dsProcessor, this._dataSelection, this.getSQLFactory(), inputTableName, postProcessSortingItems, applySort);
            if (applySort == FractionOfGrandTotalStep.GEN_FOT_WITH_SORTING) {
                this._sortAdded = true;
            }
        }
        if (isInfo) {
            CommentStatement commentBlock7 = new CommentStatement(1, 1);
            commentBlock7.append(" SQL STEP 6. Sort Step ");
            this.addComponent(commentBlock7);
        }
        if (!this._sortAdded) {
            String sortCode = RelationalSortingStep.generate(dsProcessor, this._dataSelection, inputTableName, postProcessSortingItems);
            this.addComponent(new CodeStringAdapterComponent(sortCode));
            this._sortAdded = true;
        }
        if (isInfo) {
            CommentStatement commentBlock8 = new CommentStatement(1, 1);
            commentBlock8.append(" SQL STEP 7. Grand Total Calculation Step ");
            this.addComponent(commentBlock8);
        }
        boolean totalsAtTop = this._dataSelection.getTotalLocation() == BusinessQueryTotalLocationType.TOTAL_TOTAL_ROW_TOP_COLUMN_LEFT;
        String sumTableName = null;
        if (this._hasTotals) {
            boolean hasSummarizableItems = RelationalPostProcessComposite.hasSummarizeableItems(this._dataSelection);
            if (hasSummarizableItems) {
                ProcSummaryStatement summary = new ProcSummaryStatement(this._dataSelection, inputTableName);
                summary.setDataSelectionProcessor(dsProcessor);
                summary.setSQLFactory(this.getSQLFactory());
                summary.prepareSQL();
                this.addComponent(summary);
                sumTableName = summary.getOutputTableName();
            } else {
                EmptyDataStep emptyRow = new EmptyDataStep(this._dataSelection, inputTableName);
                emptyRow.setSQLFactory(this.getSQLFactory());
                emptyRow.setDataSelectionProcessor(dsProcessor);
                emptyRow.prepareSQL();
                this.addComponent(emptyRow);
                sumTableName = emptyRow.getOutputTableName();
            }
            if (usesNonVisualtotals && !isModelDetailed) {
                this.addNvtUpdateCode(compositeList, nvtResultsTableName, sumTableName);
            }
        }
        if (isInfo) {
            commentBlock = new CommentStatement(1, 1);
            commentBlock.append(" SQL STEP 8. Merging Totals Into Results Step");
            this.addComponent(commentBlock);
        }
        if (this._hasTotals) {
            if (totalsAtTop) {
                String pdvTableName = inputTableName + "_pdv";
                StringBuffer code = this.generateTotalsAtTopDataStep(inputTableName, sumTableName, pdvTableName);
                this.addComponent(new CodeStringAdapterComponent(code));
            } else {
                this.addComponent(new CodeStringAdapterComponent("proc append base=" + inputTableName + " data=" + sumTableName + " force;run;\n"));
            }
            this.addComponent(new CodeStringAdapterComponent("\n"));
        }
        if (isInfo) {
            commentBlock = new CommentStatement(1, 1);
            commentBlock.append(" SQL STEP 9. Apply Forced Formatting Step");
            this.addComponent(commentBlock);
        }
        if (hasFFs) {
            SQLStatementFactory.addText(compositeList, "\n/* creating formatted output for " + (isChildQuery ? "child" : "main") + " query" + (IQSystemProperties.isVerboseProcCommentsEnabled(this) ? " (" + this.getClass().getSimpleName() + ")" : "") + " */\n");
            inProcSQL = ApplyForcedFormattingStep.addCode(compositeList, dsProcessor, this._dataSelection, isChildQuery, inputTableName, inputTableName, inProcSQL, false);
            if (inProcSQL) {
                SQLStatementFactory.addEndProcSql(compositeList, this.getDataSelectionProcessor());
                inProcSQL = false;
            }
        }
        if (isInfo) {
            commentBlock = new CommentStatement(1, 1);
            commentBlock.append(" SQL STEP 10. Apply 'Total' Label Step");
            this.addComponent(commentBlock);
        }
        if (this._hasTotals && this.isTotalLabelApplicable()) {
            DataStepTotalLabel dataStep = new DataStepTotalLabel(this._dataSelection, inputTableName, null, totalsAtTop);
            dataStep.setSQLFactory(this.getSQLFactory());
            dataStep.setDataSelectionProcessor(dsProcessor);
            dataStep.prepareSQL();
            this.addComponent(dataStep);
        }
        if (isInfo) {
            commentBlock = new CommentStatement(1, 1);
            commentBlock.append(" SQL STEP 11. JDBC Accesses follow ");
            this.addComponent(commentBlock);
        }
        if (procLasr) {
            StringBuffer lasrCode = null;
            try {
                lasrCode = export.generateLasrStatement(inputTableName);
            }
            catch (DataRetrievalException e) {
                throw new GenerationException(e);
            }
            this.addComponent(new CodeStringAdapterComponent(lasrCode));
        }
        if (procExport) {
            if (export.getUsage() == ExportType.CSV) {
                StringBuffer exportToCSVCode = null;
                try {
                    exportToCSVCode = export.generateExportStatementForCSV(inputTableName);
                }
                catch (DataRetrievalException e) {
                    throw new GenerationException(e);
                }
                this.addComponent(new CodeStringAdapterComponent(exportToCSVCode));
            } else if (export.getUsage() == ExportType.JSON) {
                StringBuffer exportToJSONCode = null;
                try {
                    exportToJSONCode = export.generateJSONStatement(inputTableName);
                }
                catch (DataRetrievalException e) {
                    throw new GenerationException(e);
                }
                this.addComponent(new CodeStringAdapterComponent(exportToJSONCode));
            }
        }
        if (procMetalib) {
            StringBuffer procMetalibText = null;
            try {
                procMetalibText = export.generateProcMetalib(inputTableName);
            }
            catch (DataRetrievalException e) {
                throw new GenerationException(e);
            }
            this.addComponent(new CodeStringAdapterComponent(procMetalibText));
        }
    }

    private void addWhyNoViewComment(List<SQLComponentAbstract> compositeList, DataSelection dataSelection, boolean postProcessed, boolean disallowsViews) {
        String what = null;
        what = dataSelection != null && dataSelection.getQueryProperty(BusinessQueryProperty.TEMP_IS_VIEW) ? "ignoring query property 'TEMP_IS_VIEW'" : "cannot create view";
        if (this._hasRankings) {
            SQLStatementFactory.addText(compositeList, "/* query has ranking, " + what + " */\n");
        } else if (this._hasTotals) {
            SQLStatementFactory.addText(compositeList, "/* query has totalling calculations, " + what + " */\n");
        } else if (this._hasFoTs) {
            SQLStatementFactory.addText(compositeList, "/* query has percent of total calculations, " + what + " */\n");
        } else if (this._hasSortsOnHiddenAggregates) {
            SQLStatementFactory.addText(compositeList, "/* query has sorting by hidden aggregates, " + what + " */\n");
        } else if (postProcessed) {
            SQLStatementFactory.addText(compositeList, "/* query has processed output, " + what + " */\n");
        } else if (disallowsViews) {
            SQLStatementFactory.addText(compositeList, "/* output library does not support views, " + what + " */\n");
        } else {
            SQLStatementFactory.addText(compositeList, "/* " + what + " */\n");
        }
    }

    private StringBuffer generateTotalsAtTopDataStep(String inputTableName, String sumTableName, String pdvTableName) {
        StringBuffer code = new StringBuffer();
        code.append("DATA " + pdvTableName + "; if 0 then set " + inputTableName + ";stop;\n");
        code.append("proc append base=" + pdvTableName + " data=" + sumTableName + " force;run;\n");
        code.append("proc append base=" + pdvTableName + " data=" + inputTableName + " force;run;\n");
        code.append("PROC Delete data = " + inputTableName + ";run;\n");
        code.append(ProcDataSets.generateRename(pdvTableName, inputTableName));
        return code;
    }

    private boolean isTotalLabelApplicable() {
        String label = this._dataSelection.getTotalLabel(Role.COLUMN, BusinessQuery.GRANDTOTAL);
        if (label == null || label.equals("")) {
            return false;
        }
        return DataStepTotalLabel.getTotalLabelItem(this._dataSelection) != null;
    }

    private void addNvtUpdateCode(List<SQLComponentAbstract> code, String nvtResultsTableName, String sumTableName) throws GenerationException {
        boolean inProcSQL;
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        StringBuffer why = null;
        if (IQSystemProperties.isVerboseProcCommentsEnabled(RelationalPostProcessComposite.class)) {
            why = new StringBuffer();
        }
        ArrayList<String> columnVarUpdateList = new ArrayList<String>();
        ArrayList<String> columnVarSetOneList = new ArrayList<String>();
        for (SelectedItem si : this._dataSelection.getSelectedItems()) {
            DataItem resultItem = si.getItem();
            Role role = si.getRole();
            String alias = resultItem.getResultSetID();
            StringBuffer reason = new StringBuffer();
            boolean needsNonVisualTotalsUpdate = RelationalPostProcessComposite.isNeededForNvtTotalsUpdate(this._dataSelection, resultItem, role, reason);
            if (needsNonVisualTotalsUpdate) {
                boolean isItemTotalDisabled = DisabledTotalsBuilder.isDisabledTotaling(this._dataSelection, resultItem, TotalingType.AXISTOTAL);
                if (!isItemTotalDisabled) {
                    StringBuffer fotReason = why == null ? null : new StringBuffer();
                    boolean needsFotSetToOne = FractionOfGrandTotalStep.needsNonVisualTotalCalc(this._dataSelection, resultItem, role, fotReason);
                    if (needsFotSetToOne) {
                        String aliasGt = FractionOfGrandTotalStep.generateFoTInputVarName(alias, dsProcessor, this._dataSelection, resultItem);
                        columnVarSetOneList.add(alias);
                        if (why == null) continue;
                        why.append("\n *    set to 1 ").append(alias).append(" : Setting bottom line Non-Visual total for ").append(aliasGt).append(" to 100 percent for non-additive Fraction-of-Total measure.");
                        continue;
                    }
                    columnVarUpdateList.add(alias);
                    if (why == null) continue;
                    why.append("\n *    updating ").append(alias).append(" : ").append(reason);
                    continue;
                }
                if (why == null) continue;
                why.append("\n *    ignoring ").append(alias).append(" : ").append(reason);
                continue;
            }
            if (why == null) continue;
            why.append("\n *    ignoring ").append(alias).append(" : disabled total");
        }
        StringBuffer comment = new StringBuffer();
        comment.append("during Post Process GrandTotal step");
        if (why != null) {
            comment.append(why);
        }
        if (inProcSQL = NonVisualTotalsUpdateStep.addCode(code, dsProcessor, columnVarUpdateList, columnVarSetOneList, nvtResultsTableName, sumTableName, comment.toString(), false)) {
            SQLStatementFactory.addEndProcSql(code, dsProcessor);
        }
    }

    static boolean isNeededForNvtTotalsUpdate(DataSelection dataSelection, DataItem resultItem, Role role, StringBuffer reason) throws GenerationException {
        boolean needed = false;
        Function aggType = resultItem.getAggregationType();
        if (DataRetrievalUtil.isGrandTotal(dataSelection)) {
            boolean isItemToSummarize = DataRetrievalUtil.isSummarizableItem(resultItem);
            if (isItemToSummarize) {
                if (Role.isOutputResultRole(dataSelection, role)) {
                    if (role != null && DataRetrievalUtil.isGrandRole(role)) {
                        if (FractionOfTotalUtilImpl.isFractionOfTotalItem(resultItem)) {
                            DataItem numerator = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(resultItem);
                            if (DataRetrievalUtil.isNonAdditiveMeasure(numerator)) {
                                needed = true;
                                if (reason != null) {
                                    reason.append("Non-visual total needed for Axis or Grand Totals of numerator.");
                                }
                            } else if (reason != null) {
                                Function numAggType = numerator.getAggregationType();
                                reason.append("Aggregation for numerator item (").append(numAggType).append(") and usage (" + numerator.getUsage() + ") is additive.");
                            }
                        } else if (DataRetrievalUtil.isNonAdditiveMeasure(resultItem)) {
                            needed = true;
                            if (reason != null) {
                                reason.append("Non-visual total needed for Axis or Grand Totals.");
                            }
                        } else if (reason != null) {
                            reason.append("Aggregation for item (").append(aggType).append(") is additive.");
                        }
                    } else if (reason != null) {
                        reason.append("Item role (").append(role).append(") is not on the Axis or Grand Totals role.");
                    }
                } else if (reason != null) {
                    reason.append("Item role (").append(role).append(") is not an output result role.");
                }
            } else if (reason != null) {
                reason.append("Item will not be summarized in the Axis or Grand Totals.");
            }
        } else if (reason != null) {
            reason.append("Query does not output Axis or Grand Totals.");
        }
        return needed;
    }

    private static boolean hasSummarizeableItems(DataSelection ds) throws GenerationException {
        try {
            return DataRetrievalUtil.hasSummarizeableItems(ds);
        }
        catch (IllegalArgumentException e) {
            Throwable target = ChainedException.getTargetException((Throwable)e);
            if (target instanceof GenerationException) {
                throw (GenerationException)target;
            }
            throw new GenerationException(e);
        }
    }
}

