/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;

public final class RelationalItem {
    private final String _resultSetID;
    private final DataItemActionType _sortDirection;
    private final boolean _isFotItem;
    private final boolean _sortByFormattedValue;
    private final String _format;
    private final boolean _isOutputResultItem;
    private final boolean _isInactiveResultItem;
    private final DataItemActionType _usage;
    private final boolean _groupByFormattedValue;

    public RelationalItem(String resultSetID, DataItemActionType sortDirection, boolean isFotItem, boolean sortByFormattedValue, String format, boolean isOutputResultItem, boolean isInactiveResultItem, DataItemActionType usage, boolean groupByFormattedValue) {
        this._resultSetID = resultSetID;
        this._sortDirection = sortDirection;
        this._isFotItem = isFotItem;
        this._sortByFormattedValue = sortByFormattedValue;
        this._format = format;
        this._isOutputResultItem = isOutputResultItem;
        this._isInactiveResultItem = isInactiveResultItem;
        this._usage = usage;
        this._groupByFormattedValue = groupByFormattedValue;
    }

    public RelationalItem(String resultSetID, DataItemActionType sortDirection) {
        this(resultSetID, sortDirection, false, false, null, false, false, DataItemActionType.USAGE_AGGREGATE, false);
    }

    public String getResultSetID() {
        return this._resultSetID;
    }

    public DataItemActionType getSortDirection() {
        return this._sortDirection;
    }

    public boolean isFotItem() {
        return this._isFotItem;
    }

    public boolean isSortByFormattedValue() {
        return this._sortByFormattedValue;
    }

    public boolean isGroupByFormattedValue() {
        return this._groupByFormattedValue;
    }

    public String getFormat() {
        return this._format;
    }

    public boolean isOutputResultItem() {
        return this._isOutputResultItem;
    }

    public boolean isInactiveResultItem() {
        return this._isInactiveResultItem;
    }

    public DataItemActionType getUsage() {
        return this._usage;
    }

    String generate(DataSelectionProcessorAbstract dsp, boolean invertSortDirections) throws GenerationException {
        boolean sortAscending;
        StringBuffer sql = new StringBuffer();
        String strAlias = dsp.generateColumnIdentifier(this.getResultSetID());
        boolean sortByFormattedValue = this.isSortByFormattedValue();
        if (sortByFormattedValue) {
            String format = this.getFormat();
            sql.append(GenerationUtil.generatePut(dsp, strAlias, format));
        } else {
            sql.append(strAlias);
        }
        boolean bl = sortAscending = this.getSortDirection() == DataItemActionType.SORT_ASCENDING;
        if (invertSortDirections) {
            sortAscending = !sortAscending;
        }
        String strDirection = sortAscending ? "" : " desc";
        sql.append(strDirection);
        return sql.toString();
    }

    public String toString() {
        return "{" + this.getClass().getSimpleName() + ": resultSetID=" + this.getResultSetID() + ", sortDirection=" + this.getSortDirection() + ", isFotItem=" + this.isFotItem() + ", sortByFormattedValue=" + this.isSortByFormattedValue() + ", format=" + this.getFormat() + "}";
    }
}

