/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.strategies.sas.oma.ExpandedProcSummaryStatement;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.AbstractSASStatement;
import java.util.ArrayList;

public class ProcSummaryStatement
extends AbstractSASStatement {
    public ProcSummaryStatement(DataSelection dataSelection, String baseTableName) throws GenerationException {
        super(dataSelection, baseTableName);
    }

    @Override
    public void prepareSQL() throws GenerationException {
        this._stringBuff.append(this.generateProcSummary());
    }

    public String getOutputTableName() {
        return this._baseTableName + "_sum";
    }

    private String generateProcSummary() throws GenerationException {
        boolean isModelDetailed = DataRetrievalUtil.isModelDetailed(this._dataSelection);
        ArrayList<DataItem> categories = new ArrayList<DataItem>();
        ArrayList<DataItem> measures = new ArrayList<DataItem>();
        for (SelectedItem si : this._dataSelection.getSelectedItems()) {
            DataItem dataItem = si.getItem();
            Role role = si.getRole();
            if (!Role.isOutputResultRole(this._dataSelection, role)) continue;
            boolean isItemToSummarize = DataRetrievalUtil.isSummarizableItem(dataItem);
            if (isItemToSummarize) {
                measures.add(dataItem);
                continue;
            }
            categories.add(dataItem);
        }
        boolean sumGroupValues = true;
        if (isModelDetailed) {
            sumGroupValues = false;
        }
        boolean isAsync = IQSystemProperties.isSasSubmitAsync();
        ExpandedProcSummaryStatement statement = new ExpandedProcSummaryStatement(this._dataSelection, this._baseTableName, false, false, null, measures, this.getOutputTableName(), true, true, true, !isAsync, sumGroupValues, null, true, false, false);
        statement.setDataSelectionProcessor(this.getDataSelectionProcessor());
        statement.setSQLFactory(this.getSQLFactory());
        statement.prepareSQL();
        String code = statement.writeSQL();
        return code;
    }
}

