/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.DataItemImpl;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.physical.inmemory.InMemoryColumn;
import com.sas.iquery.metadata.serverprop.Category;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLColumnAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASComposite;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASFromColumn;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcSQLDecorator
extends SQLSASComposite {
    private final String _createTableName;
    private static final String SAS_FORMAT_PREFIX = "tsf_";
    private final Map<SQLColumnAbstract, String> sqlColumn2Format = new LinkedHashMap<SQLColumnAbstract, String>();
    private final Map<String, Map<String, String>> sourcesToColumnsNeedingMacros = new LinkedHashMap<String, Map<String, String>>();
    private static final Logger _logger = LogManager.getLogger(ProcSQLDecorator.class);

    public ProcSQLDecorator(DataSelection dataSelection, String createTableName) {
        this._dataSelection = dataSelection;
        this._createTableName = createTableName;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        List<SQLColumnAbstract> sqlColumns = this.getSQLColumns();
        for (SQLColumnAbstract sqlColumn : sqlColumns) {
            DataItem di;
            String format = this.getFormat(sqlColumn, di = sqlColumn.getItem());
            if (format == null) continue;
            this.sqlColumn2Format.put(sqlColumn, format);
        }
        boolean isTsSQL = this._dataSelectionProcessor.isTSSQL();
        if (isTsSQL) {
            StringBuilder alterColumns;
            StringBuilder dataStep = this.generateMacroDefsDataStep();
            if (dataStep.length() > 0) {
                SQLStatementFactory.addText(this.getCompositeList(), "\n/* create macro variables to support server side formats */\n");
                SQLStatementFactory.addText(this.getCompositeList(), dataStep);
            }
            if ((alterColumns = this.generateAlterColumnsSql()).length() > 0) {
                SQLStatementFactory.addText(this.getCompositeList(), "\n/* Decorate result set with labels and formats */\n");
                SQLStatementFactory.addStartProcSql(this.getCompositeList(), this._dataSelectionProcessor, false, null);
                SQLStatementFactory.addStartSqlStatement(this.getCompositeList(), this._dataSelectionProcessor);
                SQLStatementFactory.addText(this.getCompositeList(), alterColumns);
                SQLStatementFactory.addEndSqlStatement(this.getCompositeList(), this._dataSelectionProcessor);
                SQLStatementFactory.addEndProcSql(this.getCompositeList(), this._dataSelectionProcessor);
            }
        }
    }

    private String getFormat(SQLColumnAbstract sqlColumn, DataItem di) throws GenerationException {
        String outFormat = null;
        DataItemActionType usage = di.getUsage();
        boolean useFormat = false;
        if (sqlColumn instanceof SQLDecoratorColumn) {
            useFormat = ((SQLDecoratorColumn)sqlColumn).useFormat();
            outFormat = ((SQLDecoratorColumn)sqlColumn).getFormat();
        } else if (sqlColumn instanceof SQLSASFromColumn) {
            boolean bl = useFormat = !GenerationUtil.useFormattedValueForSelect(di);
        }
        if (outFormat == null) {
            String diFormat;
            boolean countBased = ProcSQLDecorator.isCountBased(di);
            String sqlFormat = GenerationUtil.getSqlOutputFormat(di);
            if (sqlFormat != null) {
                sqlFormat = sqlFormat.trim();
            }
            if ((diFormat = di.getFormat()) != null) {
                diFormat = diFormat.trim();
            }
            if (useFormat && !countBased) {
                if (diFormat != null) {
                    Function aggregationFunction;
                    ExpressionInterface expression;
                    boolean isValid;
                    if (diFormat.trim().length() > 0 && (isValid = DataItemImpl.isValidFormatForType(diFormat, expression = di.getExpression(), usage, aggregationFunction = di.getAggregationType()))) {
                        outFormat = diFormat;
                    }
                } else {
                    ExpressionInterface expression = di.getExpression();
                    if (expression instanceof QualifiedColumn) {
                        QualifiedColumn qc = (QualifiedColumn)expression;
                        DataSourceTable dst = this.getDataSourceTable(qc);
                        if (dst instanceof DataSourceRelationalQuery) {
                            outFormat = this.getFormat(qc, (DataSourceRelationalQuery)dst);
                        } else {
                            int expressionType;
                            boolean useMacroFormat;
                            int detailsType = expression.getExpressionType();
                            boolean bl = useMacroFormat = detailsType == (expressionType = di.getExpressionType());
                            if (useMacroFormat) {
                                String macroName = this.assignMacro(di, dst, qc);
                                outFormat = "&" + macroName + ".";
                            }
                        }
                    }
                }
            }
        }
        return outFormat;
    }

    private String getFormat(QualifiedColumn qc, DataSourceRelationalQuery dst) throws GenerationException {
        String outFormat = null;
        try {
            String columnName = qc.getSasName().toUpperCase();
            for (QualifiedColumn qc2 : dst.getQualifiedColumns()) {
                if (!qc2.getSasName().equals(columnName)) continue;
                outFormat = this.getSasFormat(qc2);
                break;
            }
        }
        catch (MetadataException e) {
            MessageFormatter messageFormatter = IQDataServicesResourceBundle.getMessageFormatter("ProcSQLDecorator.prepareSQL.ColumnTableAccess.fmt.txt", qc, dst);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(messageFormatter.toString());
            }
            GenerationException ge = new GenerationException(messageFormatter, (Throwable)e);
            throw ge;
        }
        return outFormat;
    }

    private DataSourceTable getDataSourceTable(QualifiedColumn qc) throws GenerationException {
        DataSourceTable dst;
        try {
            dst = qc.getDataSource();
        }
        catch (MetadataException e) {
            MessageFormatter messageFormatter = IQDataServicesResourceBundle.getMessageFormatter("ProcSQLDecorator.prepareSQL.ColumnAccess.fmt.txt", qc);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(messageFormatter.toString());
            }
            GenerationException ge = new GenerationException(messageFormatter, (Throwable)e);
            ge.initCause(e);
            throw ge;
        }
        return dst;
    }

    private String assignMacro(DataItem di, DataSourceTable dst, QualifiedColumn qc) throws GenerationException {
        Schema schema;
        boolean isLibraryOk = false;
        String libString = null;
        if (dst.getAccessPath() != null && (schema = dst.getAccessPath().getSchema()) != null && schema instanceof SASLibrary) {
            SASLibrary sasLibrary = (SASLibrary)schema;
            try {
                libString = sasLibrary.getLibref();
                if (libString != null && libString.trim().length() > 0) {
                    isLibraryOk = true;
                }
            }
            catch (MetadataException e) {
                MessageFormatter messageFormatter = IQDataServicesResourceBundle.getMessageFormatter("ProcSQLDecorator.prepareSQL.LibraryAccess.fmt.txt", sasLibrary);
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(messageFormatter.toString());
                }
                GenerationException ge = new GenerationException(messageFormatter, (Throwable)e);
                ge.initCause(e);
                throw ge;
            }
        }
        StringBuilder tableName = new StringBuilder();
        if (isLibraryOk) {
            tableName.append(libString).append(".");
        }
        String tableIdentifier = this.getDataSelectionProcessor().generateTableIdentifier(dst, 1);
        tableName.append(tableIdentifier);
        String key = tableName.toString();
        Map<String, String> columns = this.sourcesToColumnsNeedingMacros.get(key);
        if (columns == null) {
            columns = new LinkedHashMap<String, String>();
            this.sourcesToColumnsNeedingMacros.put(key, columns);
        }
        String columnName = null;
        try {
            columnName = qc.getSasName();
        }
        catch (MetadataException e) {
            MessageFormatter messageFormatter = IQDataServicesResourceBundle.getMessageFormatter("ProcSQLDecorator.prepareSQL.ColumnTableAccess.fmt.txt", qc, dst);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(messageFormatter.toString());
            }
            GenerationException ge = new GenerationException(messageFormatter, (Throwable)e);
            ge.initCause(e);
            throw ge;
        }
        String columnIdentifier = this.getDataSelectionProcessor().generateColumnIdentifier(columnName, false);
        String macro = ProcSQLDecorator.generateFormatMacroVariableName(di);
        columns.put(macro, columnIdentifier);
        return macro;
    }

    private String getSasFormat(QualifiedColumn qc) throws MetadataException {
        String format = qc.getSasFormat();
        if (format == null) {
            DataSourceTable dst = qc.getDataSource();
            Column c = qc.getColumn();
            if (c instanceof InMemoryColumn) {
                InMemoryColumn imc = (InMemoryColumn)c;
                String imColumnRSID = imc.getSasName();
                if (dst instanceof DataSourceRelationalQuery) {
                    DataSourceRelationalQuery dsrq = (DataSourceRelationalQuery)dst;
                    BusinessQuery bq = dsrq.getBusinessQuery();
                    List<SelectedItem> siList = bq.getSelectedItems();
                    for (SelectedItem si : siList) {
                        DataItem di = si.getItem();
                        String parentItemRSID = di.getResultSetID();
                        if (parentItemRSID == null || !parentItemRSID.equals(imColumnRSID)) continue;
                        format = di.getFormat();
                        if (format != null) {
                            return format;
                        }
                        ExpressionInterface exp = di.getExpression();
                        if (!(exp instanceof QualifiedColumn)) continue;
                        format = this.getSasFormat((QualifiedColumn)exp);
                    }
                }
            }
        }
        return format;
    }

    private static boolean isCountBased(DataItem di) {
        boolean countBased = false;
        DataItemActionType usage = di.getUsage();
        if (usage == DataItemActionType.USAGE_AGGREGATE) {
            Category category;
            Function parentAggFunction = di.getAggregationType();
            DataItem parentItem = di;
            while (parentItem instanceof DataItemReference) {
                DataItemReference dir = (DataItemReference)parentItem;
                Function aggFunctForItemInChain = (parentItem = dir.getBaseDataItem()).getAggregationType();
                if (parentAggFunction == aggFunctForItemInChain || aggFunctForItemInChain == null) continue;
                parentAggFunction = aggFunctForItemInChain;
                break;
            }
            if (parentAggFunction != null && (category = parentAggFunction.getCategory()) != null && category == Category.CAT_COUNTING_AGGREGATE) {
                countBased = true;
            }
        }
        return countBased;
    }

    private StringBuilder generateMacroDefsDataStep() {
        StringBuilder dataStep = new StringBuilder();
        for (String inputTableName : this.sourcesToColumnsNeedingMacros.keySet()) {
            StringBuilder defCode = new StringBuilder();
            Map<String, String> dis2columns = this.sourcesToColumnsNeedingMacros.get(inputTableName);
            for (Map.Entry<String, String> entry : dis2columns.entrySet()) {
                String macro = entry.getKey();
                String columnIdentifier = entry.getValue();
                defCode.append("\n\t").append("call symput('").append(macro).append("',vformat(").append(columnIdentifier).append("));");
            }
            if (defCode.length() == 0) continue;
            dataStep.append("DATA _null_; goto defs; SET ").append(inputTableName);
            dataStep.append(" (KEEP=");
            for (String columnName : dis2columns.values()) {
                dataStep.append(" ");
                dataStep.append(columnName);
            }
            dataStep.append(");\n");
            dataStep.append("  defs:;").append((CharSequence)defCode).append("\n");
            dataStep.append("  stop").append(";\n");
            dataStep.append("run;quit;\n\n");
        }
        return dataStep;
    }

    private StringBuilder generateAlterColumnsSql() throws GenerationException {
        StringBuilder alterColumns = new StringBuilder();
        List<SQLColumnAbstract> sqlColumns = this.getSQLColumns();
        for (SQLColumnAbstract sqlColumn : sqlColumns) {
            DataItem item;
            String rsid;
            boolean hasFormat;
            DataItem di = sqlColumn.getItem();
            String label = di.getLabel();
            String format = this.sqlColumn2Format.get(sqlColumn);
            boolean hasLabel = label != null && !"".equals(label);
            boolean bl = hasFormat = format != null && !"".equals(format);
            if (!hasLabel && !hasFormat || (rsid = (item = sqlColumn.getItem()).getResultSetID()).length() == 0) continue;
            String identifier = this._dataSelectionProcessor.generateColumnIdentifier(rsid, null, 1);
            alterColumns.append("\n\tMODIFY " + identifier + " ");
            if (hasLabel) {
                alterColumns.append("LABEL=");
                alterColumns.append(GenerationUtil.generateQuotedLiteral(label));
            }
            if (hasLabel && hasFormat) {
                alterColumns.append(' ');
            }
            if (!hasFormat) continue;
            alterColumns.append("FORMAT=" + format);
        }
        if (alterColumns.length() > 0) {
            String createTableIdentifier = this.getCreateTableName();
            alterColumns.insert(0, "\tALTER TABLE " + createTableIdentifier);
            alterColumns.append("\n");
        }
        return alterColumns;
    }

    private static String generateFormatMacroVariableName(DataItem item) {
        String rsid = item.getResultSetID();
        return SAS_FORMAT_PREFIX + rsid.replaceAll("[\\W]", "_");
    }

    public String getCreateTableName() {
        return this._createTableName;
    }

    public static boolean addCode(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, DataSelection dataSelection, boolean useTsSql, String tableName, List<SQLColumnAbstract> sqlColumns, boolean isChildQuery, boolean inProcSQL, boolean verbose, String verboseTag) throws GenerationException {
        if (useTsSql && sqlColumns != null && sqlColumns.size() > 0) {
            if (inProcSQL) {
                SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
                inProcSQL = false;
            }
            if (verbose) {
                SQLStatementFactory.addText(compositeList, "/* " + verboseTag + ": decorating columns, query = " + dataSelection + ", useTsSql = " + useTsSql + ", sqlColumns = " + sqlColumns + ", isChildQuery = " + isChildQuery + " */\n");
            }
            ProcSQLDecorator tsSqlFixup = new ProcSQLDecorator(dataSelection, tableName);
            tsSqlFixup.setSQLColumns(sqlColumns);
            tsSqlFixup.setDataSelectionProcessor(dsProcessor);
            tsSqlFixup.prepareSQL();
            compositeList.add(tsSqlFixup);
        }
        return inProcSQL;
    }

    public static SQLDecoratorColumn newSQLDecoratorColumn(DataItem item) throws GenerationException {
        return new SQLDecoratorColumn(item);
    }

    private static final class SQLDecoratorColumn
    extends SQLColumnAbstract
    implements FFDecoratorFormat {
        private boolean _useFormat;
        private String _format = null;

        private SQLDecoratorColumn(DataItem item) throws GenerationException {
            String format;
            this.setItem(item);
            String itemFormat = item.getFormat();
            if (itemFormat != null && itemFormat.trim().length() > 0 && (format = GenerationUtil.getSqlOutputFormat(item)) != null && format.trim().length() > 0) {
                this._format = format;
                this._useFormat = true;
            }
            this.setColumnReference(item.getResultSetID());
        }

        public String getFormat() {
            return this._format;
        }

        @Override
        public boolean useFormat() {
            return this._useFormat;
        }

        @Override
        public void prepareSQL() throws GenerationException {
        }

        @Override
        public String toString() {
            return super.toString() + ", useFormat=" + this._useFormat + ", format=" + this._format;
        }
    }

    public static interface FFDecoratorFormat {
        public boolean useFormat();
    }
}

