/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class NonVisualTotalsUpdateStep {
    private static final boolean allowTsSqlInNonVisualTotalsUpdate = true;

    NonVisualTotalsUpdateStep() {
    }

    public static boolean addCode(List<SQLComponentAbstract> compositeList, DataSelectionProcessorAbstract dsProcessor, List columnVarUpdateList, List columnVarSetOneList, String updateFromTableName, String updateToTableName, String whenNote, boolean parentInProcSQL) throws GenerationException {
        boolean hasOnlyOneVar;
        boolean inProcSQL = parentInProcSQL;
        boolean hasManyVars = columnVarUpdateList != null && columnVarUpdateList.size() != 0;
        boolean bl = hasOnlyOneVar = columnVarSetOneList != null && columnVarSetOneList.size() != 0;
        if (hasManyVars || hasOnlyOneVar) {
            LinkedHashSet uniqueVars = new LinkedHashSet();
            if (columnVarUpdateList != null && columnVarUpdateList.size() > 0) {
                uniqueVars.addAll(columnVarUpdateList);
            }
            if (columnVarSetOneList != null && columnVarSetOneList.size() > 0) {
                uniqueVars.addAll(columnVarSetOneList);
            }
            SQLStatementFactory.addNewLine(compositeList);
            if (!inProcSQL) {
                SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, true, null);
                inProcSQL = true;
            }
            StringBuffer comment1 = new StringBuffer();
            comment1.append("/* start: update non-visual totals ").append(whenNote).append("\n");
            comment1.append(" *    from table ").append(updateFromTableName).append("\n");
            comment1.append(" *      to table ").append(updateToTableName).append(" */\n");
            SQLStatementFactory.addText(compositeList, comment1);
            SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
            StringBuffer updateTable = new StringBuffer();
            updateTable.append("Update ").append(updateToTableName).append("\n");
            SQLStatementFactory.addText(compositeList, updateTable);
            StringBuffer sql = NonVisualTotalsUpdateStep.generateUpdateNntQuery(dsProcessor, columnVarUpdateList, updateFromTableName, uniqueVars);
            SQLStatementFactory.addText(compositeList, sql);
            SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
            StringBuffer comment2 = new StringBuffer();
            comment2.append("/* end: update non-visual totals to ").append(updateToTableName).append(" */\n");
            SQLStatementFactory.addText(compositeList, comment2);
        }
        return inProcSQL;
    }

    private static StringBuffer generateUpdateNntQuery(DataSelectionProcessorAbstract dsProcessor, List columnVarUpdateList, String updateFromTableName, Set uniqueVars) throws GenerationException {
        StringBuffer sql = new StringBuffer();
        String sep = "  set ";
        Iterator iterator = uniqueVars.iterator();
        while (iterator.hasNext()) {
            String alias = (String)iterator.next();
            String rsid = dsProcessor.generateColumnIdentifier(alias);
            sql.append(sep);
            if (columnVarUpdateList != null && columnVarUpdateList.contains(alias)) {
                sql.append(rsid).append(" = (select ").append(rsid).append(" from ").append(updateFromTableName).append(")");
            } else {
                sql.append("").append(rsid).append(" = 1");
            }
            if (iterator.hasNext()) {
                sql.append(',');
            }
            sep = "\n      ";
        }
        return sql;
    }
}

