/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class FunctionCallOptimizer {
    private static Map replaceableFunctions = new HashMap();
    private static final String NEWLINE = "\n";
    private SQLExpressionAbstract sqlExpr;
    private FunctionCall call;
    private Stack functionStack;

    public FunctionCallOptimizer(SQLExpressionAbstract sqlExpr, FunctionCall call) {
        this.sqlExpr = sqlExpr;
        this.call = call;
        this.functionStack = new Stack();
    }

    public static boolean isReplaceable(Function fctn) {
        boolean result = false;
        if (replaceableFunctions.containsKey(fctn.getFunctionNameID())) {
            result = true;
        }
        return result;
    }

    public String extractString(Map exprValues) throws MetadataException, GenerationException {
        String result = null;
        if (FunctionCallOptimizer.isReplaceable(this.call)) {
            List values = this.extractString(this.call, exprValues);
            if (values.size() == 0) {
                result = "";
            } else if (values.size() == 1) {
                result = (String)values.get(0);
            } else {
                StringBuffer dbmsString = new StringBuffer();
                Iterator it = values.iterator();
                while (it.hasNext()) {
                    dbmsString.append((String)it.next());
                    if (!it.hasNext()) continue;
                    dbmsString.append(',');
                    dbmsString.append(NEWLINE);
                }
                result = dbmsString.toString();
            }
        } else {
            result = this.sqlExpr.extractString(this.call, exprValues);
        }
        return result;
    }

    private List extractString(FunctionCall fctnCall, Map exprValues) throws MetadataException, GenerationException {
        List<ExpressionInterface> args = fctnCall.getArguments();
        ArrayList argsSQL = new ArrayList();
        Function function = fctnCall.getFunction();
        FunctionSignature signature = function.getCompatibleSignature(args);
        if (signature != null) {
            this.functionStack.push(function.getFunctionNameID());
            List values = new ArrayList<String>();
            for (int index = 0; index < args.size(); ++index) {
                ExpressionInterface expression = args.get(index);
                if (expression instanceof FunctionCall) {
                    values.addAll(this.extractString((FunctionCall)expression, exprValues));
                } else if (expression instanceof Prompt) {
                    values.addAll(this.sqlExpr.extractString((Prompt)expression, false));
                } else {
                    try {
                        values.add(this.sqlExpr.generateExpressionSQL(expression, 3, exprValues));
                    }
                    catch (GenerationException ge) {
                        this.functionStack.pop();
                        throw ge;
                    }
                }
                values = this.process(expression, values);
                argsSQL.addAll(values);
                values.clear();
            }
        } else {
            ArrayMessageFormatter argsMsg = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, args.toArray(new Object[args.size()]));
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("FunctionCallOptimizer.extractString.NoFunctionSignature.fmt.txt", function, argsMsg));
        }
        this.functionStack.pop();
        return argsSQL;
    }

    private List process(ExpressionInterface expression, List values) {
        FunctionNameID function = (FunctionNameID)this.functionStack.peek();
        Formatter functionFormatter = (Formatter)replaceableFunctions.get(function);
        if (functionFormatter != null) {
            for (int i = 0; i < values.size(); ++i) {
                String value = (String)values.get(i);
                values.set(i, functionFormatter.format(expression, value));
            }
        }
        return values;
    }

    private static boolean isReplaceable(ExpressionInterface exp) {
        boolean returnValue = true;
        if (exp instanceof QualifiedColumn) {
            returnValue = false;
        } else {
            List<QualifiedColumn> resources;
            if (exp instanceof FunctionCall) {
                returnValue = FunctionCallOptimizer.isValidInputFunctionCall((FunctionCall)exp);
            }
            if (returnValue && !(exp instanceof Prompt) && (resources = exp.getResources(QualifiedColumn.class, 65531)).size() > 0) {
                returnValue = false;
            }
        }
        return returnValue;
    }

    private static boolean isValidInputFunctionCall(FunctionCall input) {
        boolean returnValue = true;
        Function call = input.getFunction();
        if (call != null) {
            if (returnValue && !FunctionCallOptimizer.isReplaceable(call) && !call.isIndependentlyEvaluatable()) {
                returnValue = false;
            }
            if (returnValue) {
                returnValue = FunctionCallOptimizer.isValidFunctionArguements(input);
            }
        }
        return returnValue;
    }

    private static boolean isValidFunctionArguements(FunctionCall input) {
        boolean returnValue = true;
        Iterator<ExpressionInterface> iter = input.getArguments().iterator();
        while (iter.hasNext() && returnValue) {
            ExpressionInterface iterValue = iter.next();
            if (!(iterValue instanceof ExpressionInterface) || FunctionCallOptimizer.isReplaceable(iterValue)) continue;
            returnValue = false;
        }
        return returnValue;
    }

    static {
        Formatter trim = new Formatter(){

            @Override
            public String format(ExpressionInterface expression, String value) {
                int len;
                boolean isRASE = this.isResourceAwareStringExpression(expression);
                boolean isCharType = this.isCharacterType(expression);
                if (isRASE) {
                    value = this.stripBrackets(expression, value);
                }
                char[] quote = null;
                StringBuffer bufValue = new StringBuffer(value.trim());
                if (isCharType) {
                    quote = this.stripQuotes(bufValue);
                }
                for (len = bufValue.length(); len > 0 && Character.isWhitespace(bufValue.charAt(len - 1)); --len) {
                }
                bufValue.setLength(len);
                if (isCharType) {
                    this.addQuotes(quote, bufValue);
                }
                if (isRASE) {
                    this.addBrackets(bufValue);
                }
                return bufValue.toString();
            }
        };
        replaceableFunctions.put(FunctionNameID.TRIM, trim);
        replaceableFunctions.put(FunctionNameID.KTRIM, trim);
        Formatter left = new Formatter(){

            @Override
            public String format(ExpressionInterface expression, String value) {
                int st;
                boolean isRASE = this.isResourceAwareStringExpression(expression);
                boolean isCharType = this.isCharacterType(expression);
                String tmpStr = value;
                if (isRASE) {
                    tmpStr = this.stripBrackets(expression, tmpStr);
                }
                char[] quote = null;
                StringBuffer bufValue = new StringBuffer(tmpStr.trim());
                if (isCharType) {
                    quote = this.stripQuotes(bufValue);
                }
                int len = bufValue.length();
                for (st = 0; st < len && Character.isWhitespace(bufValue.charAt(st)); ++st) {
                }
                String result = null;
                if (st > 0) {
                    char[] newVal = new char[len];
                    bufValue.getChars(st, len, newVal, 0);
                    Arrays.fill(newVal, len - st, len, ' ');
                    bufValue.setLength(0);
                    bufValue.append(newVal);
                    if (isCharType) {
                        this.addQuotes(quote, bufValue);
                    }
                    if (isRASE) {
                        this.addBrackets(bufValue);
                    }
                    result = bufValue.toString();
                } else {
                    result = value;
                }
                return result;
            }
        };
        replaceableFunctions.put(FunctionNameID.LEFT, left);
        replaceableFunctions.put(FunctionNameID.KLEFT, left);
        Formatter right = new Formatter(){

            @Override
            public String format(ExpressionInterface expression, String value) {
                int len;
                boolean isRASE = this.isResourceAwareStringExpression(expression);
                boolean isCharType = this.isCharacterType(expression);
                String tmpStr = value;
                if (isRASE) {
                    tmpStr = this.stripBrackets(expression, tmpStr);
                }
                char[] quote = null;
                StringBuffer bufValue = new StringBuffer(tmpStr.trim());
                if (isCharType) {
                    quote = this.stripQuotes(bufValue);
                }
                char[] fill = new char[len];
                for (len = bufValue.length(); len > 0 && Character.isWhitespace(bufValue.charAt(len - 1)); --len) {
                    fill[fill.length - len] = 32;
                }
                String result = null;
                if (len != bufValue.length()) {
                    bufValue.setLength(len);
                    bufValue.insert(0, fill, 0, fill.length - len);
                    if (isCharType) {
                        this.addQuotes(quote, bufValue);
                    }
                    if (isRASE) {
                        this.addBrackets(bufValue);
                    }
                    result = bufValue.toString();
                } else {
                    result = value;
                }
                return result;
            }
        };
        replaceableFunctions.put(FunctionNameID.RIGHT, right);
        replaceableFunctions.put(FunctionNameID.KRIGHT, right);
        Formatter upcase = new Formatter(){

            @Override
            public String format(ExpressionInterface expression, String value) {
                return value.toUpperCase();
            }
        };
        replaceableFunctions.put(FunctionNameID.UPCASE, upcase);
        replaceableFunctions.put(FunctionNameID.KUPCASE, upcase);
        Formatter lowcase = new Formatter(){

            @Override
            public String format(ExpressionInterface expression, String value) {
                return value.toLowerCase();
            }
        };
        replaceableFunctions.put(FunctionNameID.LOWCASE, lowcase);
        replaceableFunctions.put(FunctionNameID.KLOWCASE, lowcase);
        replaceableFunctions.put(FunctionNameID.STRIP, new Formatter(){

            @Override
            public String format(ExpressionInterface expression, String value) {
                boolean isRASE = this.isResourceAwareStringExpression(expression);
                boolean isCharType = this.isCharacterType(expression);
                if (isRASE) {
                    value = this.stripBrackets(expression, value);
                }
                char[] quote = null;
                StringBuffer bufValue = new StringBuffer(value.trim());
                if (isCharType) {
                    quote = this.stripQuotes(bufValue);
                }
                value = bufValue.toString().trim();
                bufValue.setLength(0);
                bufValue.append(value);
                if (isCharType) {
                    this.addQuotes(quote, bufValue);
                }
                if (isRASE) {
                    this.addBrackets(bufValue);
                }
                return bufValue.toString();
            }
        });
    }

    static abstract class Formatter {
        Formatter() {
        }

        public abstract String format(ExpressionInterface var1, String var2);

        char[] stripQuotes(StringBuffer value) {
            char[] result = new char[]{'\u0000', '\u0000'};
            int len = value.length();
            if (len > 1) {
                char first = value.charAt(0);
                char last = value.charAt(len - 1);
                if (!(first != '\'' && first != '\"' || last != '\'' && last != '\"')) {
                    value.setLength(len - 1);
                    value.deleteCharAt(0);
                    result[0] = first;
                    result[1] = last;
                }
            }
            return result;
        }

        String stripBrackets(ExpressionInterface expression, String value) {
            int indexOpenBracket = value.indexOf("(");
            int indexClosingBracket = value.lastIndexOf(")");
            if (indexOpenBracket != -1 && indexClosingBracket != -1 && indexOpenBracket + 1 < value.length()) {
                value = value.substring(indexOpenBracket + 1, indexClosingBracket);
            }
            return value;
        }

        StringBuffer addBrackets(StringBuffer value) {
            value.insert(0, '(');
            value.append(')');
            return value;
        }

        StringBuffer addQuotes(char[] quotes, StringBuffer value) {
            StringBuffer result = value;
            if (quotes != null && (quotes[0] != '\u0000' || quotes[1] != '\u0000')) {
                value.insert(0, quotes[0]);
                value.append(quotes[1]);
            }
            return result;
        }

        boolean isResourceAwareStringExpression(ExpressionInterface expression) {
            boolean result = false;
            if (expression instanceof ResourceAwareStringExpression) {
                result = true;
            }
            return result;
        }

        boolean isCharacterType(ExpressionInterface expression) {
            boolean result = false;
            if (expression.getExpressionType() == 3) {
                result = true;
            }
            return result;
        }
    }
}

