/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.AbstractSASStatement;
import java.util.List;

public class DataStepTotalLabel
extends AbstractSASStatement {
    private String _summaryTableName = null;
    private boolean _totalsAtTop = false;

    public DataStepTotalLabel(DataSelection dataSelection, String baseTableName, String summaryTableName, boolean totalsAtTop) throws GenerationException {
        super(dataSelection, baseTableName);
        this._summaryTableName = summaryTableName;
        this._totalsAtTop = totalsAtTop;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        this._stringBuff.append(this.generateTotalLabelDataStep());
    }

    private String generateTotalLabelDataStep() throws GenerationException {
        return this.generateTotalLabelStatement();
    }

    private String generateTotalLabelStatement() throws GenerationException {
        String label = this._dataSelection.getTotalLabel(Role.COLUMN, BusinessQuery.GRANDTOTAL);
        DataItem totalLabelDataItem = DataStepTotalLabel.getTotalLabelItem(this._dataSelection);
        String varString = totalLabelDataItem.getResultSetID();
        String columnLabel = totalLabelDataItem.getLabel();
        StringBuffer returnBuffer = new StringBuffer();
        String labelLiteral = GenerationUtil.generateQuotedLiteral(label);
        String varnameLiteral = this.getDataSelectionProcessor().generateDataStepVar(varString);
        String columnLabelLiteral = GenerationUtil.generateQuotedLiteral(columnLabel);
        String summarytablename = this._summaryTableName;
        String tablename = this._baseTableName;
        returnBuffer.append("\n%let totlabel=").append(labelLiteral).append(";").append("\n%let totcolumn=%str(").append(varnameLiteral).append(");").append("\n%let maxlen = 0;").append("\ndata _null_;").append("\n  if _n_ = 0 then set ").append(tablename).append(";").append("\n  if _n_ = 1 then").append("\n    do;").append("\n      _format_ = vformat(&totcolumn);").append("\n      if _format_ ne '' then").append("\n        width = vformatw(&totcolumn);").append("\n      else").append("\n        width = vlength(&totcolumn);").append("\n      maxlen = max(width, length(&totlabel));").append("\n      call symput('maxlen',maxlen);").append("\n      stop;").append("\n    end;").append("\nrun;");
        returnBuffer.append("\nDATA ").append(tablename).append("(rename=(DIR_TOT=&totcolumn));");
        returnBuffer.append("\n  if _n_ = 0 then do;");
        boolean totalLabelColumnFound = false;
        List<SelectedItem> selectedItems = this._dataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem item = selectedItem.getItem();
            Role role = selectedItem.getRole();
            String rsid = item.getResultSetID();
            if (!totalLabelColumnFound && item.equals(totalLabelDataItem)) {
                returnBuffer.append("\n    set " + this._baseTableName + "(keep= &totcolumn);").append("\n    length DIR_TOT $&maxlen;").append("\n    label DIR_TOT=").append(columnLabelLiteral).append(";");
                totalLabelColumnFound = true;
                continue;
            }
            boolean isOutputResultItem = Role.isOutputResultRole(this._dataSelection, role);
            if (!isOutputResultItem) continue;
            returnBuffer.append("\n    set " + this._baseTableName + "(keep= ").append(this.getDataSelectionProcessor().generateDataStepVar(rsid)).append(");");
        }
        returnBuffer.append("\n  end;\n");
        returnBuffer.append("\n   set ");
        if (this._totalsAtTop) {
            if (summarytablename != null && summarytablename.trim().length() > 0) {
                returnBuffer.append(summarytablename).append("(in=tots) ");
            }
            returnBuffer.append(tablename);
        } else {
            returnBuffer.append(tablename);
            if (summarytablename != null && summarytablename.trim().length() > 0) {
                returnBuffer.append(" ").append(summarytablename);
            }
            returnBuffer.append(" end=eof");
        }
        returnBuffer.append(";").append("\n  _format_ = vformat(&totcolumn);").append("\n  if _format_ ne '' then").append("\n    do;").append("\n      if vtype(&totcolumn) = 'C' then").append("\n        do;").append("\n          DIR_TOT = putc(&totcolumn, _format_);").append("\n          DIR_TOT = kleft(DIR_TOT);").append("\n        end;").append("\n      else").append("\n        do;").append("\n          DIR_TOT = putn(&totcolumn, _format_);").append("\n          DIR_TOT = kright(DIR_TOT);").append("\n        end;").append("\n    end;").append("\n  else").append("\n    DIR_TOT = repeat('*', &maxlen);");
        if (this._totalsAtTop) {
            if (summarytablename != null && summarytablename.trim().length() > 0) {
                returnBuffer.append("\n  if tots then");
            } else {
                returnBuffer.append("\n  if _n_ = 1 then");
            }
        } else {
            returnBuffer.append("\n  if eof then");
        }
        returnBuffer.append("\n    do;").append("\n      DIR_TOT = &totlabel;").append("\n      if vtype(&totcolumn) = 'C' then").append("\n        DIR_TOT = kleft(DIR_TOT);").append("\n      else").append("\n        DIR_TOT = kright(DIR_TOT);").append("\n      output;").append("\n    end;").append("\n  else").append("\n    output;").append("\n  drop &totcolumn _format_;").append("\nrun;");
        return returnBuffer.toString();
    }

    public static DataItem getTotalLabelItem(DataSelection dataSelection) {
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem item = selectedItem.getItem();
            Role role = selectedItem.getRole();
            DataItemActionType usage = item.getUsage();
            boolean isDetailCharacter = DataItemActionType.USAGE_DETAIL.equals(usage) && item.getExpressionType() == 3;
            boolean isCategory = DataItemActionType.USAGE_CATEGORY.equals(usage);
            boolean isOutputResultItem = Role.isOutputResultRole(dataSelection, role);
            if (!isCategory && !isDetailCharacter || !isOutputResultItem) continue;
            return item;
        }
        return null;
    }
}

