/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import java.util.List;

public final class CommentStatement
extends SQLComponentAbstract {
    StringBuffer _comments = new StringBuffer();
    private String _title = null;
    private boolean _banner = false;
    private boolean _ownLine = false;
    private int _preNewLines = 0;
    private int _postNewLines = 0;

    public CommentStatement() {
    }

    public CommentStatement(String title) {
        this.setTitle(title);
        this.setOwnLine(true);
    }

    public CommentStatement(boolean banner) {
        this.setBanner(banner);
        this.setOwnLine(true);
    }

    public CommentStatement(int preNewLines, int postNewLines) {
        this.setPreNewLines(preNewLines);
        this.setPostNewLines(postNewLines);
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getTitle() {
        return this._title;
    }

    public StringBuffer getComments() {
        return this._comments;
    }

    public CommentStatement append(Object comment) {
        this._comments.append(String.valueOf(comment));
        return this;
    }

    public CommentStatement append(char comment) {
        this._comments.append(comment);
        return this;
    }

    public void setBanner(boolean banner) {
        this._banner = banner;
    }

    public boolean isBanner() {
        return this._banner;
    }

    public void setOwnLine(boolean ownLine) {
        this._ownLine = ownLine;
    }

    public boolean isOwnLine() {
        return this._ownLine;
    }

    public int getPreNewLines() {
        return this._preNewLines;
    }

    public int getPostNewLines() {
        return this._postNewLines;
    }

    public void setPreNewLines(int preNewLines) {
        this._preNewLines = preNewLines;
    }

    public void setPostNewLines(int postNewLines) {
        this._postNewLines = postNewLines;
    }

    @Override
    public void prepareSQL() {
    }

    @Override
    public String writeSQL() {
        return this.compileComment();
    }

    private String compileComment() {
        int i;
        String origSql = String.valueOf(this._comments);
        String title = this.getTitle();
        boolean banner = this.isBanner();
        boolean ownLine = this.isOwnLine();
        StringBuffer sql = new StringBuffer();
        for (i = 0; i < this.getPreNewLines() - (ownLine ? 1 : 0); ++i) {
            sql.append('\n');
        }
        if (ownLine) {
            sql.append('\n');
        }
        if (title != null) {
            sql.append("/**************************** ").append(title).append(" ****************************\n");
        } else if (banner) {
            sql.append("/********************************************************\n");
        } else {
            sql.append("/*");
        }
        sql.append(origSql.replaceAll("\\*/", "\\* /"));
        if (title != null) {
            sql.append("\n **************************** ").append(title).append(" ****************************/");
        } else if (banner) {
            sql.append("\n ********************************************************/");
        } else {
            sql.append("*/");
        }
        if (ownLine) {
            sql.append('\n');
        }
        for (i = 0; i < this.getPostNewLines() - (ownLine ? 1 : 0); ++i) {
            sql.append('\n');
        }
        return sql.toString();
    }

    public void commentOnDataSelection(DataSelection dataSelection) {
        StringBuffer comments = this._comments;
        comments.append(" DataSelection: ").append(dataSelection.getIdentityString());
        for (BusinessModel basedOn = dataSelection.getBaseModel(); basedOn != null; basedOn = basedOn.getBaseModel()) {
            comments.append("\n Based on: ").append(basedOn.getIdentityString());
        }
        List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
        comments.append("\n Selected Items: (").append(selectedItems.size()).append(')');
        for (SelectedItem selectedItem : selectedItems) {
            DataItem resultItem = selectedItem.getItem();
            Role role = selectedItem.getRole();
            int formatType = selectedItem.getFormatType();
            int joinBehavior = selectedItem.getJoinBehavior();
            comments.append("\n   on ").append(role).append(", ").append(resultItem.getIdentityString()).append(", formatType=").append(formatType).append(", joinBehavior=").append(joinBehavior);
            comments.append("\n      item ");
            this.commentOnItem(comments, resultItem);
            ExpressionInterface expr = resultItem.getExpression();
            comments.append("\n      expr=");
            this.commentOnExpression(comments, dataSelection, expr);
            if (expr instanceof FractionOfTotalExpression) {
                FractionOfTotalExpression fote = (FractionOfTotalExpression)expr;
                DataItem numeratorItem = fote.getNumerator();
                DataItem denominatorItem = fote.getDenominator();
                int demType = fote.getDenominatorType();
                comments.append("\n         Fraction of Total Expression with denominator type=").append(demType);
                comments.append("\n           numerator item: ");
                this.commentOnItem(comments, numeratorItem);
                comments.append("\n           denominator item: ");
                this.commentOnItem(comments, denominatorItem);
            }
            List<StepInterface> itemSteps = resultItem.getSteps();
            comments.append("\n      steps=(").append(itemSteps.size()).append(')');
            for (StepInterface step : itemSteps) {
                comments.append("\n         ").append(step.toString());
            }
        }
        List<DataItem> sorts = dataSelection.getSortOrderPrecedence();
        comments.append("\n Sort Items: (").append(sorts.size()).append(')');
        for (DataItem sortItem : sorts) {
            DataItemActionType dataItemActionType = sortItem.getSortDirection();
            comments.append("\n   direction ").append(dataItemActionType);
            comments.append("\n   sort item ");
            this.commentOnItem(comments, sortItem);
            ExpressionInterface expr = sortItem.getExpression();
            comments.append("\n      expr=");
            this.commentOnExpression(comments, dataSelection, expr);
        }
        List<FilterItem> filters = dataSelection.getFilters();
        comments.append("\n Filter Items: (").append(filters.size()).append(')');
        for (FilterItem filterItem : filters) {
            comments.append("\n   ").append(filterItem.getIdentityString());
            comments.append("\n      filter item ");
            this.commentOnFilter(comments, filterItem);
            ExpressionInterface expr = filterItem.getExpression();
            comments.append("\n      expr=");
            this.commentOnExpression(comments, dataSelection, expr);
        }
        List<StepInterface> colSteps = dataSelection.getSteps(Role.COLUMN);
        comments.append("\n Query Steps on COLUMN role: (").append(colSteps.size()).append(')');
        for (StepInterface step : colSteps) {
            comments.append("\n   ").append(step.toString());
        }
        List<StepInterface> list = dataSelection.getSteps(Role.ROW);
        comments.append("\n Query Steps on ROW role: (").append(list.size()).append(')');
        for (StepInterface step : list) {
            comments.append("\n   ").append(step.toString());
        }
    }

    public void commentOnFilter(FilterItem filterItem) {
        this.commentOnFilter(this._comments, filterItem);
    }

    private void commentOnFilter(StringBuffer comments, FilterItem filterItem) {
        if (filterItem == null) {
            comments.append("null <not set>");
        } else {
            String id = null;
            try {
                id = filterItem.getID();
            }
            catch (InvalidIDException e) {
                id = e.toString();
            }
            comments.append("id=").append(id);
        }
    }

    public void commentOnItem(DataItem item) {
        this.commentOnItem(this._comments, item);
    }

    private void commentOnItem(StringBuffer comments, DataItem item) {
        if (item == null) {
            comments.append("null <not set>");
        } else {
            String id = null;
            try {
                id = item.getID();
            }
            catch (InvalidIDException e) {
                id = e.toString();
            }
            comments.append("id=").append(id).append(", rsid=").append(item.getResultSetID()).append(", type=").append(item.getExpressionType()).append(", usage=").append(item.getUsage()).append(", agg=").append(item.getAggregationType()).append(", format=").append(item.getFormat()).append(", ff=").append(item.isFormattingForced()).append(", sort=").append(item.getSortDirection());
        }
    }

    public void commentOnExpression(DataSelection dataSelection, ExpressionInterface expr) {
        this.commentOnExpression(this._comments, dataSelection, expr);
    }

    private void commentOnExpression(StringBuffer comments, DataSelection dataSelection, ExpressionInterface expr) {
        if (expr == null) {
            comments.append("null <not set>");
        } else {
            String text = null;
            try {
                text = StringExpressionUtil.getInstance().getText(expr, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, dataSelection);
            }
            catch (MetadataException e) {
                text = e.toString();
            }
            comments.append("[").append(text).append("] type=").append(expr.getExpressionType());
        }
    }
}

