/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.saslanguage;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.IMStat;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASComposite;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CodeStringAdapterComponent;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CodeStringDataSelectionProcessor;
import com.sas.iquery.util.Preconditions;
import java.util.List;

@SASScope
public class CodeStringComposite
extends SQLSASComposite {
    CodeStringComposite(CodeStringDataSelectionProcessor dataSelectionProcessor) throws GenerationException {
        this._dataSelectionProcessor = dataSelectionProcessor;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        Preconditions.ensureNonNull(this._dataSelection);
        CodeStringDataSelectionProcessor dsProcessor = this.getDataSelectionProcessor();
        dsProcessor.populate();
        List<ExportRule> rules = this._dataSelection.getEffectiveRules(ExportRule.class);
        Export export = rules.isEmpty() ? null : rules.get(0).getExport();
        try {
            if (export != null) {
                StringBuffer lasrCode = export.generateLasrStatement();
                this.addComponent(new CodeStringAdapterComponent(lasrCode));
            } else {
                String tempTablePattern = DataSelectionProcessorAbstract.getTempTablePattern();
                IMStat imStat = new IMStat(dsProcessor, this._dataSelection, tempTablePattern);
                StringBuffer imStatCode = imStat.getQueryText();
                this.addComponent(new CodeStringAdapterComponent(imStatCode));
            }
        }
        catch (DataRetrievalException e) {
            throw new GenerationException(e);
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
    }

    @Override
    public CodeStringDataSelectionProcessor getDataSelectionProcessor() {
        return (CodeStringDataSelectionProcessor)this._dataSelectionProcessor;
    }
}

