/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.join;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.join.JoinGenerationInterface;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalDataSelectionProcessor;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JoinGeneration
implements JoinGenerationInterface {
    private DataSelection _dataSelection;
    private Map<DataSourceTable, String> _correlationMap;
    private List<String> _labelsUsed = new ArrayList<String>();
    private DataSelectionProcessorAbstract _processor;
    private List<? extends DataSource> _uniqueDataSourceList;

    @Override
    public void setDataSelection(DataSelection ds) {
        this._dataSelection = ds;
        if (this._correlationMap != null) {
            this._correlationMap.clear();
            this._correlationMap = null;
        }
        this._labelsUsed.clear();
        if (this._uniqueDataSourceList != null) {
            this._uniqueDataSourceList.clear();
            this._uniqueDataSourceList = null;
        }
        if (this._processor == null) {
            this._processor = new RelationalDataSelectionProcessor(this._dataSelection);
        }
    }

    @Override
    public List<BusinessModelObject> generateJoinPath() throws GenerationException, MetadataException {
        this._uniqueDataSourceList = this.getUniqueDataSources();
        int size = this._uniqueDataSourceList.size();
        if (size == 1) {
            return new ArrayList<BusinessModelObject>(this._uniqueDataSourceList);
        }
        ArrayList<BusinessModelObject> joinList = new ArrayList<BusinessModelObject>();
        try {
            DataSelection dataSelection = this.getDataSelection();
            joinList.addAll(this._processor.getEffectiveJoinPath(dataSelection));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return joinList;
    }

    protected void setCorrelationTableName(DataSourceTable dst, String strCorrelationName) throws GenerationException {
        Map<DataSourceTable, String> map = this.getCorrelationMap();
        if (map.containsValue(strCorrelationName)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("JoinGeneration.setCorrelationName.NameInUse.fmt.txt", strCorrelationName);
            throw new GenerationException(mft);
        }
        map.put(dst, strCorrelationName);
    }

    protected void _assignCorrelationNames(List<DataSource> dataSources) throws GenerationException {
        for (DataSource dataSource : dataSources) {
            if (!(dataSource instanceof DataSourceTable)) continue;
            this.addNewUniqueCorrelatedTable((DataSourceTable)dataSource, "table");
        }
    }

    @Override
    public String addNewUniqueCorrelatedTable(DataSourceTable dst, String baseLabel) throws GenerationException {
        String label = this._genNewCorrelationName(baseLabel);
        this.setCorrelationTableName(dst, label);
        return label;
    }

    @Override
    public void addDuplicateCorrelatedTable(DataSourceTable dataSource, String strCorrelationName) throws GenerationException {
        Map<DataSourceTable, String> map = this.getCorrelationMap();
        map.put(dataSource, strCorrelationName);
    }

    protected String _genNewCorrelationName(String baseLabel) {
        int count = this._getNextAliasCounter();
        String label = baseLabel + count;
        while (this._labelsUsed.contains(label)) {
            count = this._getNextAliasCounter();
            label = baseLabel + count;
        }
        this._labelsUsed.add(label);
        return label;
    }

    private int _getNextAliasCounter() {
        int aliasCounter = this.getDataSelectionProcessor().getAliasCounter();
        return aliasCounter;
    }

    public List<DataSource> getUniqueDataSources() throws MetadataException {
        if (this._uniqueDataSourceList == null) {
            this._uniqueDataSourceList = this._processor.getEffectiveDataSources(this.getDataSelection());
        }
        return new ArrayList<DataSource>(this._uniqueDataSourceList);
    }

    @Override
    public void setUniqueDataSourceList(List<? extends DataSource> uniqueDataSourceList) {
        this._uniqueDataSourceList = uniqueDataSourceList;
    }

    protected Map<DataSourceTable, String> getCorrelationMap() throws GenerationException {
        if (this._correlationMap == null) {
            this._correlationMap = new LinkedHashMap<DataSourceTable, String>();
            try {
                this._assignCorrelationNames(this.getUniqueDataSources());
            }
            catch (MetadataException e) {
                throw new GenerationException(e);
            }
        }
        return this._correlationMap;
    }

    public DataSelection getDataSelection() {
        return this._dataSelection;
    }

    public DataSelectionProcessorAbstract getDataSelectionProcessor() {
        return this._processor;
    }

    public void setDataSelectionProcessor(DataSelectionProcessorAbstract processor) {
        this._processor = processor;
    }

    @Override
    public String getCorrelatedTableName(DataSourceTable dataSource) throws GenerationException {
        Map<DataSourceTable, String> correlationMap = this.getCorrelationMap();
        return correlationMap.get(dataSource);
    }
}

