/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite.sas;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLWhereAbstract;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SQLSASWhere
extends SQLWhereAbstract {
    private String _strWhereClause = "";
    private static final Logger _logger = LogManager.getLogger(SQLSASWhere.class);

    protected SQLSASWhere() {
    }

    @Override
    public void prepareSQL() throws GenerationException {
        String crossJoinConditionsText = this.getCrossJoinConditionsText();
        if (crossJoinConditionsText != null && crossJoinConditionsText.length() > 0) {
            if (this._strWhereClause.length() > 0) {
                this._strWhereClause = this._strWhereClause + " And ";
            }
            this._strWhereClause = this._strWhereClause + crossJoinConditionsText;
        }
        List filters = this.getFilterList();
        for (FilterItem filter : filters) {
            try {
                String strFilters;
                if (!this.useFilter(filter) || (strFilters = this.genSql(filter)) == null || strFilters.length() <= 0) continue;
                if (this._strWhereClause.length() > 0) {
                    this._strWhereClause = this._strWhereClause + " AND \n\t";
                }
                this._strWhereClause = this._strWhereClause + strFilters;
            }
            catch (GenerationException e) {
                _logger.error("Error when generating Where Clause");
                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLSASWhere.prepareSQL.GenerationException.txt", new Object[0]), (Throwable)e);
            }
        }
    }

    protected boolean useFilter(FilterItem filter) {
        boolean returnValue = false;
        if (filter != null) {
            returnValue = true;
        }
        return returnValue;
    }

    @Override
    public String writeSQL() {
        StringBuffer sql = new StringBuffer();
        if (this._strWhereClause.length() > 0) {
            sql.append("\nWHERE\n\t");
            sql.append(this._strWhereClause);
        }
        return sql.toString();
    }

    protected String genSql(FilterItem filterItem) throws GenerationException {
        String sqlString = "";
        ExpressionInterface expression = filterItem.getExpression();
        if (expression != null) {
            SQLExpressionAbstract sqlExpression = (SQLExpressionAbstract)this.generateExpression();
            sqlString = sqlExpression.generateExpressionSQL(expression, 3, null);
        }
        return sqlString;
    }

    public String toString() {
        String debugStr = this.writeSQL();
        return "".equals(debugStr) ? "/* No SQLSASWhere */" : debugStr;
    }
}

