/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite.sas;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLColumnAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLOrderByAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.RelationalSortingStep;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SQLSASOrderBy
extends SQLOrderByAbstract {
    private List<SQLColumnAbstract> _columnList = new ArrayList<SQLColumnAbstract>();

    @Override
    public boolean delayedSort() {
        return false;
    }

    @Override
    public void prepareSQL() throws GenerationException {
        DataSelectionProcessorAbstract dsp = this.getDataSelectionProcessor();
        List<DataItem> dataItems = dsp.getEffectiveSortOrderPrecedence(this._dataSelection);
        for (int index = 0; index < dataItems.size(); ++index) {
            DataItem sortItem = dataItems.get(index);
            boolean useInSort = RelationalSortingStep.isValidInSort(this._dataSelection, sortItem);
            if (!useInSort) continue;
            SQLColumnAbstract sqlColumn = this._generateOrderByColumn(sortItem);
            this.addSortColumn(sqlColumn);
        }
    }

    @Override
    public String writeSQL() {
        StringBuffer sqlColumn = new StringBuffer();
        if (this._columnList.size() > 0) {
            sqlColumn.append("\nORDER BY\n\t");
        }
        Iterator<SQLColumnAbstract> columnIterator = this._columnList.iterator();
        while (columnIterator.hasNext()) {
            SQLComponentAbstract sqlComponentAbstract = columnIterator.next();
            sqlColumn.append(sqlComponentAbstract.writeSQL());
            if (columnIterator.hasNext()) {
                sqlColumn.append(",\n\t");
                continue;
            }
            sqlColumn.append(" ");
        }
        return sqlColumn.toString();
    }

    protected void addSortColumn(SQLColumnAbstract column) {
        this._columnList.add(column);
    }

    @Override
    public List<SQLColumnAbstract> getSortColumns() {
        return this._columnList;
    }
}

