/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite.sas;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLHavingAbstract;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SQLSASHaving
extends SQLHavingAbstract {
    private String _strHavingClause = "";
    private static final Logger _logger = LogManager.getLogger(SQLSASHaving.class);

    @Override
    public void prepareSQL() throws GenerationException {
        List filters = this.getFilterList();
        for (FilterItem filter : filters) {
            try {
                String strFilters;
                if (filter == null || (strFilters = this.genSql(filter)) == null || strFilters.length() <= 0) continue;
                if (this._strHavingClause.length() > 0) {
                    this._strHavingClause = this._strHavingClause + " AND \n\t";
                }
                this._strHavingClause = this._strHavingClause + strFilters;
            }
            catch (GenerationException e) {
                _logger.error("Error when generating Having Clause");
                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLSASHaving.prepareSQL.GenerationException.txt", new Object[0]), (Throwable)e);
            }
        }
    }

    @Override
    public String writeSQL() {
        StringBuffer sql = new StringBuffer();
        if (this._strHavingClause.length() > 0) {
            sql.append("\nHAVING\n\t");
            sql.append(this._strHavingClause);
        }
        return sql.toString();
    }

    protected String genSql(FilterItem filterItem) throws GenerationException {
        String havingColumn = "";
        ExpressionInterface expression = filterItem.getExpression();
        if (expression != null) {
            SQLExpressionAbstract sqlExpression = (SQLExpressionAbstract)this.generateExpression();
            int declareOrReference = 2;
            if (this._dataSelectionProcessor.isTSSQL()) {
                declareOrReference = 3;
            }
            havingColumn = sqlExpression.generateExpressionSQL(expression, declareOrReference, null);
        }
        return havingColumn;
    }

    public String toString() {
        String debugStr = this.writeSQL();
        return "".equals(debugStr) ? "/* No SQLSASHaving */" : debugStr;
    }
}

