/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite.sas;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLColumnAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLGroupByAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLSASGroupBy
extends SQLGroupByAbstract {
    private Collection _groupByList = new ArrayList();

    @Override
    public void prepareSQL() throws GenerationException {
        List<SelectedItem> selectedItemsGroupBy = this._dataSelection.getSelectedItems();
        for (int j = 0; j < selectedItemsGroupBy.size(); ++j) {
            Object obj;
            SelectedItem selectedItem = selectedItemsGroupBy.get(j);
            DataItem item = selectedItem.getItem();
            if (item.getUsage() != DataItemActionType.USAGE_CATEGORY || (obj = this._generateGroupByForItem(selectedItem)) == null) continue;
            this._groupByList.add(obj);
        }
    }

    @Override
    public String writeSQL() {
        StringBuffer sql = new StringBuffer();
        Iterator columnIterator = this._groupByList.iterator();
        while (columnIterator.hasNext()) {
            String string = null;
            Object obj = columnIterator.next();
            if (obj instanceof SQLColumnAbstract) {
                SQLColumnAbstract sqlColumn = (SQLColumnAbstract)obj;
                string = sqlColumn.writeSQL();
            } else if (obj != null) {
                string = obj.toString();
            }
            if (string == null || string.trim().length() <= 0) continue;
            if (sql.length() > 0) {
                sql.append(",\n\t");
            }
            sql.append(string);
        }
        if (sql.length() > 0) {
            sql.insert(0, "\n GROUP BY\n\t");
        }
        return sql.toString();
    }

    public Object _generateGroupByForItem(SelectedItem selectedItem) throws GenerationException {
        Map<String, Object> mapRsidsToPositions;
        DataItem item = selectedItem.getItem();
        Role role = selectedItem.getRole();
        String rsid = item.getResultSetID();
        boolean groupByFormattedValue = GenerationUtil.useFormattedValueForGrouping(item);
        boolean selectFormattedValue = GenerationUtil.useFormattedValueForSelect(item);
        Object position = null;
        if (groupByFormattedValue == selectFormattedValue && (mapRsidsToPositions = this.getGroupByIdentifierPositions()) != null) {
            position = mapRsidsToPositions.get(rsid);
        }
        Object itemObject = null;
        if (position != null) {
            itemObject = position;
        } else {
            boolean isNeededForPostProcess;
            boolean writeGroupByExpression = false;
            writeGroupByExpression = role == Role.HIDDEN ? true : (isNeededForPostProcess = this.getDataSelectionProcessor().isNeededForPostProcess(this._dataSelection, item, role));
            if (writeGroupByExpression) {
                SQLColumnAbstract sqlColumn = this._generateGroupByColumn(item);
                itemObject = sqlColumn;
            }
        }
        return itemObject;
    }
}

