/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite.sas;

import com.sas.iquery.execution.instructions.ExecutionBlock;
import com.sas.iquery.execution.instructions.ExecutionOptions;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASComposite;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.ApplyForcedFormattingStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.DistinctDataStep;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.SQLStatementFactory;
import java.util.ArrayList;
import java.util.List;

public final class RelationalSQLSASComposite
extends SQLSASComposite {
    private List _ffCompositeList = null;
    private boolean _ffCompositeListInProcSql = false;

    @Override
    public void prepareSQL() throws GenerationException {
        boolean disallowsViews;
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        String outputTableName = dsProcessor.getTempTableName(this._dataSelection);
        boolean isView = dsProcessor.getTempTableIsView(this._dataSelection);
        List<SQLComponentAbstract> compositeList = this.getCompositeList();
        boolean isChildQuery = dsProcessor.getAllSubqueries().contains(this._dataSelection);
        boolean isFFStepNeeded = ApplyForcedFormattingStep.isNeeded(this._dataSelection, isChildQuery);
        boolean isDistinctNeeded = DistinctDataStep.isNeeded(this._dataSelection, isChildQuery);
        boolean postProcessed = !isChildQuery && (isFFStepNeeded || isDistinctNeeded);
        boolean bl = disallowsViews = !dsProcessor.isTempViewAllowed();
        if (isView && (postProcessed || disallowsViews)) {
            this.addWhyNoViewComment(compositeList, this._dataSelection, postProcessed, disallowsViews);
            dsProcessor.setTempTableIsView(this._dataSelection, false);
            isView = false;
        }
        super.prepareSQL();
        if (!isChildQuery) {
            this._ffCompositeListInProcSql = false;
            if (isDistinctNeeded || isFFStepNeeded) {
                this._ffCompositeList = new ArrayList();
            }
            if (isDistinctNeeded) {
                SQLStatementFactory.addText((List<SQLComponentAbstract>)this._ffCompositeList, "\n/* enforcing distinct output for " + (isChildQuery ? "child" : "main") + " query" + (IQSystemProperties.isVerboseProcCommentsEnabled(this) ? " (" + this.getClass().getSimpleName() + ")" : "") + " */\n");
                this._ffCompositeListInProcSql = DistinctDataStep.addCode(this._ffCompositeList, dsProcessor, this._dataSelection, isChildQuery, outputTableName, outputTableName, this._ffCompositeListInProcSql);
            }
            if (isFFStepNeeded) {
                SQLStatementFactory.addText((List<SQLComponentAbstract>)this._ffCompositeList, "\n/* creating formatted output for " + (isChildQuery ? "child" : "main") + " query" + (IQSystemProperties.isVerboseProcCommentsEnabled(this) ? " (" + this.getClass().getSimpleName() + ")" : "") + " */\n");
                this._ffCompositeListInProcSql = ApplyForcedFormattingStep.addCode(this._ffCompositeList, dsProcessor, this._dataSelection, isChildQuery, outputTableName, outputTableName, this._ffCompositeListInProcSql, false);
            }
            if (this._ffCompositeListInProcSql) {
                SQLStatementFactory.addEndProcSql(this._ffCompositeList, dsProcessor);
                this._ffCompositeListInProcSql = false;
            }
        }
    }

    private void addWhyNoViewComment(List<SQLComponentAbstract> compositeList, DataSelection dataSelection, boolean postProcessed, boolean disallowsViews) {
        String what = null;
        what = dataSelection != null && dataSelection.getQueryProperty(BusinessQueryProperty.TEMP_IS_VIEW) ? "ignoring query property 'TEMP_IS_VIEW'" : "cannot create view";
        if (postProcessed) {
            SQLStatementFactory.addText(compositeList, "/* query has processed output, " + what + " */\n");
        } else if (disallowsViews) {
            SQLStatementFactory.addText(compositeList, "/* output library does not support views, " + what + " */\n");
        } else {
            SQLStatementFactory.addText(compositeList, "/* " + what + " */\n");
        }
    }

    @Override
    protected void generateCodeInstructions(ExecutionBlock executionBlock, String sqlString, ExecutionOptions executionOptions) throws GenerationException {
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        String outputTableName = dsProcessor.getTempTableName(this._dataSelection);
        boolean isView = dsProcessor.getTempTableIsView(this._dataSelection);
        ArrayList<SQLComponentAbstract> compositeList = new ArrayList<SQLComponentAbstract>();
        if (IQSystemProperties.isVerboseProcCommentsEnabled(this)) {
            SQLStatementFactory.addText(compositeList, "/* " + this.getClass().getSimpleName() + " (SQLCompositeAbstract) generateCodeInstructions() */\n");
        }
        String options = SQLStatementFactory.getProcSqlOptions(dsProcessor.isTSSQL(), this._dataSelection);
        SQLStatementFactory.addStartProcSql(compositeList, dsProcessor, true, options);
        SQLStatementFactory.addStartSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addCreateAs(compositeList, dsProcessor, outputTableName, isView);
        SQLStatementFactory.addText(compositeList, sqlString);
        SQLStatementFactory.addEndSqlStatement(compositeList, dsProcessor);
        SQLStatementFactory.addEndProcSql(compositeList, dsProcessor);
        if (this._ffCompositeList != null) {
            compositeList.addAll(this._ffCompositeList);
        }
        String sasCode = RelationalSQLSASComposite.writeCompositeList(compositeList);
        super.generateCodeInstructions(executionBlock, sasCode, executionOptions);
    }
}

