/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.ColumnManager;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.DataSourceRelationalQuery;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Join;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLExpressionAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLJoinPathFormatter;
import com.sas.iquery.strategies.sas.oma.relational.join.JoinGeneration;
import com.sas.iquery.strategies.sas.oma.relational.join.JoinGenerationInterface;
import com.sas.iquery.strategies.sas.oma.summaryrolap.composite.SQLSASROLAPViewFactory;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class SQLFromAbstract
extends SQLComponentAbstract {
    protected Join _previousJoinWritten = null;
    protected StringBuffer _crossJoinConditionsBuffer = null;
    protected List _crossJoinConditionsFound = null;

    protected String genSQLFromClauseString(List joinImplList) throws MetadataException, GenerationException {
        StringBuffer sqlString = new StringBuffer();
        this._previousJoinWritten = null;
        this._crossJoinConditionsFound = new ArrayList();
        this._crossJoinConditionsBuffer = new StringBuffer();
        List<SelectedItem> selectedItems = this._dataSelection.getSelectedItems();
        SQLJoinPathFormatter jpf = new SQLJoinPathFormatter(){

            @Override
            public String formatTable(DataSourceTable table) throws GenerationException {
                return SQLFromAbstract.this._insertTable(new StringBuffer(), table).toString();
            }

            @Override
            public String formatPredicate(ExpressionInterface joinExp) throws GenerationException {
                SQLExpressionAbstract sqlExpression = (SQLExpressionAbstract)SQLFromAbstract.this.generateExpression();
                return sqlExpression.generateExpressionSQL(joinExp, 3, null);
            }
        };
        boolean disableJoinPathOptimization = this._dataSelection.getQueryProperty(BusinessQueryProperty.JOIN_PATH_OPTIMIZATIONS_DISABLED);
        jpf.setOptimizingSQL(!disableJoinPathOptimization);
        jpf.format(sqlString, this._crossJoinConditionsBuffer, joinImplList, selectedItems);
        this.setCrossJoinConditionsText(this._crossJoinConditionsBuffer.toString());
        return sqlString.toString();
    }

    protected String _constructJoinSqlForOneDataSource(List _uniqueDataSourceList) throws GenerationException {
        StringBuffer sqlString = new StringBuffer();
        DataSource tempDataSource = (DataSource)_uniqueDataSourceList.get(0);
        DataSourceTable tempTable = (DataSourceTable)tempDataSource;
        this._insertTable(sqlString, tempTable);
        return sqlString.toString();
    }

    protected JoinGenerationInterface generateJoinGeneration() throws GenerationException {
        JoinGeneration joinGeneration = new JoinGeneration();
        joinGeneration.setDataSelectionProcessor(this.getDataSelectionProcessor());
        joinGeneration.setDataSelection(this._dataSelection);
        return joinGeneration;
    }

    protected StringBuffer _insertTable(StringBuffer sqlString, DataSourceTable tempTable) throws GenerationException {
        if (tempTable == null) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("SQLFromAbstract.genSQLFromClauseString.RightTableNotATable.fmt.txt", String.valueOf(tempTable));
            throw new GenerationException(mft);
        }
        if (tempTable instanceof DataSourceRelationalQuery) {
            DataSourceRelationalQuery dsrq = (DataSourceRelationalQuery)tempTable;
            this.createDataSourceRelationalQueryColumn(sqlString, dsrq);
        } else {
            this.createDataSourceTableColumn(sqlString, tempTable);
        }
        return sqlString;
    }

    protected StringBuffer createDataSourceTableColumn(StringBuffer sqlString, DataSourceTable tempTable) throws GenerationException {
        Schema schema;
        if (tempTable.getAccessPath() != null && (schema = tempTable.getAccessPath().getSchema()) != null) {
            if (schema instanceof SASLibrary) {
                SASLibrary sasLibrary = (SASLibrary)schema;
                String libString = null;
                try {
                    libString = sasLibrary.getLibref();
                }
                catch (MetadataException e) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLFromAbstract.genSQLFromClauseString.MetadataException.txt", new Object[0]), (Throwable)e);
                }
                if (libString != null && libString.trim().length() > 0) {
                    sqlString.append(libString);
                    sqlString.append(".");
                }
            } else {
                sqlString.append(schema.getLabel());
                sqlString.append(".");
            }
        }
        if (this.getSQLFactory() instanceof SQLSASROLAPViewFactory) {
            this.getDataSelectionProcessor().disableTSSQL();
        }
        String tempTableIdentifier = this.getDataSelectionProcessor().generateTableIdentifier(tempTable);
        sqlString.append(tempTableIdentifier);
        try {
            sqlString.append(this.getDataSetOptionsAsString(tempTable));
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        sqlString.append(" ");
        String tableAlias = this.m_joinGenerator.getCorrelatedTableName(tempTable);
        String aliasIdentifier = this.getDataSelectionProcessor().generateTableIdentifier(tableAlias);
        sqlString.append(aliasIdentifier);
        sqlString.append(" ");
        return sqlString;
    }

    protected String getDataSetOptionsAsString(DataSourceTable dst) throws MetadataException, GenerationException {
        String imleOptions;
        StringBuffer optionsBuf = new StringBuffer();
        String tableOptions = dst.getDataSetOptionsAsString();
        if (tableOptions != null) {
            optionsBuf.append(tableOptions);
        }
        if ((imleOptions = this.getIMLEOptions(dst)).length() > 0) {
            if (optionsBuf.length() > 0) {
                optionsBuf.append(' ');
            }
            optionsBuf.append(imleOptions);
        }
        if (optionsBuf.length() > 0) {
            if (this.getDataSelectionProcessor() != null && this.getDataSelectionProcessor().isSPDS() && this.getDataSelectionProcessor().isUseExplicitSPDS()) {
                optionsBuf.insert(0, '[').append(']');
            } else {
                optionsBuf.insert(0, '(').append(')');
            }
        }
        return optionsBuf.toString();
    }

    private String getIMLEOptions(DataSourceTable dst) throws MetadataException, GenerationException {
        String imleOptions = "";
        if (dst.isIMLETable()) {
            ColumnManager colMgr;
            List keptColumns;
            StringBuffer imleOptionsBuf = new StringBuffer();
            DataSourceTable.IMLETableAggregation howToAggregateIMLEDataSource = dst.getAggregateIMLEData();
            if (howToAggregateIMLEDataSource == DataSourceTable.IMLETableAggregation.AGGREGATE) {
                imleOptionsBuf.append("aggregate=yes");
            } else if (howToAggregateIMLEDataSource == DataSourceTable.IMLETableAggregation.DETAIL) {
                imleOptionsBuf.append("aggregate=no");
            }
            if (dst.getColumnsAreManaged() && (keptColumns = (colMgr = dst.getColumnMgr()).getKeptColumns()).size() > 0) {
                if (imleOptionsBuf.length() > 0) {
                    imleOptionsBuf.append(' ');
                }
                imleOptionsBuf.append("KEEP=");
                Iterator it = keptColumns.iterator();
                while (it.hasNext()) {
                    Column col = (Column)it.next();
                    String sasColumnName = col.getSasName();
                    String identifierToKeep = this.getDataSelectionProcessor().generateColumnIdentifier(sasColumnName, dst);
                    imleOptionsBuf.append(identifierToKeep);
                    if (!it.hasNext()) continue;
                    imleOptionsBuf.append(' ');
                }
            }
            imleOptions = imleOptionsBuf.toString();
        }
        return imleOptions;
    }

    private void createDataSourceRelationalQueryColumn(StringBuffer sqlString, DataSourceRelationalQuery tempDataSource) throws GenerationException {
        DataSourceRelationalQuery tempTable = tempDataSource;
        DataSelection dataSourceDataSelection = (DataSelection)tempDataSource.getBusinessQuery();
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        SQLComponentAbstract sqlColumn = null;
        boolean createTable = dsProcessor.isTempTable(dataSourceDataSelection);
        sqlColumn = createTable ? this.getSQLFactory().createTempTableSASColumn(dataSourceDataSelection) : this.getSQLFactory().createSubSelectSASColumn(dataSourceDataSelection);
        sqlColumn.setDataSelectionProcessor(dsProcessor);
        sqlColumn.prepareSQL();
        sqlString.append(sqlColumn.writeSQL());
        sqlString.append(" ");
        String tableAlias = this.m_joinGenerator.getCorrelatedTableName(tempTable);
        sqlString.append(this.getDataSelectionProcessor().generateTableIdentifier(tableAlias));
        sqlString.append(" ");
    }
}

