/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.impl.IQSystemProperties;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.AbstractModelItem;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.relational.AbstractRelativeTimeValueExpression;
import com.sas.iquery.metadata.expr.relational.CompareWithQueryResultsExpression;
import com.sas.iquery.metadata.expr.relational.ConditionalExpressionAdapter;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.metadata.expr.relational.InQueryResultsExpression;
import com.sas.iquery.metadata.expr.relational.RelationalConditionalExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.Table;
import com.sas.iquery.metadata.serverprop.ConnectionType;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.IndependentExpressionGeneration;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLOrderAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.FunctionCallOptimizer;
import com.sas.iquery.strategies.sas.oma.sff.composite.SQLSASFFOverriddenExpression;
import com.sas.iquery.strategies.sas.oma.summaryrolap.composite.SQLSASROLAPViewFactory;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.models.FileLocationInterface;
import com.sas.models.HyperlinkInterface;
import com.sas.models.metadataSource.MetadataSource;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.TextDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.SupportedSpecialValuesInterface;
import com.sas.util.ValueItem;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SQLExpressionAbstract
extends SQLComponentAbstract {
    private static ThreadLocal<SimpleDateFormat> SAS_DATE7_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("''ddMMMyy'''D'", Locale.US);
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static ThreadLocal<SimpleDateFormat> SAS_DATE9_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("''ddMMMyyyy'''D'", Locale.US);
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static ThreadLocal<SimpleDateFormat> SAS_TIME_LITERAL_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("''HH:mm:ss'''T'", Locale.US);
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static ThreadLocal<SimpleDateFormat> SAS_DATETIME17_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("''ddMMMyy:HH:mm:ss'''DT'", Locale.US);
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static ThreadLocal<SimpleDateFormat> SAS_DATETIME19_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("''ddMMMyyyy:HH:mm:ss'''DT'", Locale.US);
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static ThreadLocal<SimpleDateFormat> SQL99_DATE_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("'DATE'''yyyy-MM-dd''", Locale.US);
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static ThreadLocal<SimpleDateFormat> SQL99_TIME_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("'TIME'''HH:mm:ss''", Locale.US);
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static ThreadLocal<SimpleDateFormat> SQL99_TIMESTAMP_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("'TIMESTAMP'''yyyy-MM-dd HH:mm:ss''", Locale.US);
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static ThreadLocal<SimpleDateFormat> SQL99_DATE_GMT_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("'DATE'''yyyy-MM-dd''", Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static ThreadLocal<SimpleDateFormat> SQL99_TIME_GMT_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("'TIME'''HH:mm:ss''", Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static ThreadLocal<SimpleDateFormat> SQL99_TIMESTAMP_GMT_SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("'TIMESTAMP'''yyyy-MM-dd HH:mm:ss''", Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            sdf.setLenient(false);
            return sdf;
        }
    };
    private static final Pattern SAS_DATE_PATTERN = Pattern.compile("['\"]\\s*[\\w:]*['\"]\\s*[Dd]");
    private static final Pattern SAS_TIME_PATTERN = Pattern.compile("['\"][\\d\\:\\.]*['\"]\\s*[Tt]");
    private static final Pattern SAS_DATETIME_PATTERN = Pattern.compile("['\"][\\w\\s\\:\\.]*['\"]\\s*[Dd]*[Tt]*");
    private static final Pattern SQL99_DATE_PATTERN = Pattern.compile("DATE\\s*'[\\d-]*'*");
    private static final Pattern SQL99_TIME_PATTERN = Pattern.compile("TIME\\s*'[\\d:.]*'*");
    private static final Pattern SQL99_TIMESTAMP_PATTERN = Pattern.compile("TIMESTAMP\\s*'[\\s\\d\\:\\-\\.]*'*");
    private static final String NEWLINE = "\n";
    private boolean _executeMacroExpressions = IQSystemProperties.isBooleanPropertyEnabled("SASQueryServices.EnableMacroExecOfExpressions");
    private boolean _useAltSyntaxForRelDate = Boolean.getBoolean("SASQueryServices.AltRelDateSyntax");
    private static final Logger _logger = LogManager.getLogger(SQLExpressionAbstract.class);
    private static final String COMPARISON_PATTERN = "{0} {1} {2}";
    private static final String BETWEEN_PATTERN = "{0} BETWEEN {1} AND {2}";
    private static final String NOT_BETWEEN_PATTERN = "NOT ( {0} BETWEEN {1} AND {2} )";
    public static final char SQL_LIKE_MATCH_MANY_CHAR = '%';
    public static final char SQL_LIKE_MATCH_ONE_CHAR = '_';
    public static final char SQL_DEFAULT_LIKE_ESCAPE_CHAR = '\\';
    private int MAX_LINE_SIZE = 600;

    public String generateExpressionSQL(ExpressionInterface expression, int declareOrReference, Map<ExpressionInterface, String> exprValues) throws GenerationException {
        boolean independentExpression = false;
        if (_logger.isDebugEnabled()) {
            _logger.debug("_generateExpressionSQL(" + expression + ", " + declareOrReference + ")");
        }
        try {
            AbstractModelItem itemExpression;
            ConditionalExpression conditional;
            RelationalConditionalExpression comparison;
            String returnSQL = null;
            if (expression == null) {
                _logger.debug("In if condition: expresssion == null");
                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.generateExpressionSQL.InvalidNull.txt", new Object[0]));
            }
            if (exprValues != null && exprValues.containsKey(expression)) {
                returnSQL = exprValues.get(expression);
            } else if (expression instanceof AbstractTimeValueExpression) {
                _logger.debug("In if condition: AbstractTimeValueExpression");
                AbstractTimeValueExpression abstractTimeValue = (AbstractTimeValueExpression)expression;
                returnSQL = this.extractStringFromExpression(abstractTimeValue);
            } else if (expression instanceof AbstractRelativeTimeValueExpression) {
                _logger.debug("In if condition: AbstractRelativeTimeValueExpression");
                independentExpression = true;
                AbstractRelativeTimeValueExpression abstractRelativeTimeValue = (AbstractRelativeTimeValueExpression)expression;
                returnSQL = this.extractStringFromExpression(abstractRelativeTimeValue, declareOrReference, exprValues);
            } else if (expression instanceof SimpleConditionalExpression_Comparison) {
                _logger.debug("In if condition: SimpleConditionalExpression_Comparison");
                comparison = (SimpleConditionalExpression_Comparison)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, (SimpleConditionalExpression_Comparison)comparison, exprValues);
            } else if (expression instanceof SimpleConditionalExpression_Between) {
                _logger.debug("In if condition: SimpleConditionalExpression_Between");
                SimpleConditionalExpression_Between between = (SimpleConditionalExpression_Between)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, between, exprValues);
            } else if (expression instanceof SimpleConditionalExpression_Like) {
                _logger.debug("In if condition: SimpleConditionalExpression_Like");
                comparison = (SimpleConditionalExpression_Like)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, (SimpleConditionalExpression_Like)comparison, exprValues);
            } else if (expression instanceof SimpleConditionalExpression_Contains) {
                _logger.debug("In if condition: SimpleConditionalExpression_Contains");
                comparison = (SimpleConditionalExpression_Contains)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, (SimpleConditionalExpression_Contains)comparison, exprValues);
            } else if (expression instanceof SimpleConditionalExpression_In) {
                _logger.debug("In if condition: SimpleConditionalExpression_In");
                SimpleConditionalExpression_In in = (SimpleConditionalExpression_In)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, in, exprValues);
            } else if (expression instanceof SimpleConditionalExpression_TestForNull) {
                _logger.debug("In if condition: SimpleConditionalExpression_TestForNull");
                SimpleConditionalExpression_TestForNull testForNull = (SimpleConditionalExpression_TestForNull)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, testForNull, exprValues);
            } else if (expression instanceof Prompt) {
                _logger.debug("In if condition: Prompt");
                Prompt prompt = (Prompt)expression;
                returnSQL = this.extractStringFromExpression(prompt);
            } else if (expression instanceof ConstantExpression) {
                _logger.debug("In if condition: ConstantExpression");
                ConstantExpression constant = (ConstantExpression)expression;
                returnSQL = this.extractStringFromExpression(constant);
            } else if (expression instanceof CompoundConditionalExpression) {
                _logger.debug("In if condition: CompoundConditionalExpression");
                conditional = (CompoundConditionalExpression)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, (CompoundConditionalExpression)conditional, exprValues);
            } else if (expression instanceof MultipleConditionalExpression) {
                _logger.debug("In if condition: MultipleConditionalExpression");
                conditional = (MultipleConditionalExpression)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, (MultipleConditionalExpression)conditional, exprValues);
            } else if (expression instanceof ResourceAwareStringExpression) {
                _logger.debug("In if condition: ResourceAwareStringExpression");
                ResourceAwareStringExpression rase = (ResourceAwareStringExpression)expression;
                returnSQL = declareOrReference == 4 ? this.extractStringFromExpression(rase, exprValues, 4) : this.extractStringFromExpression(rase, exprValues, 3);
            } else if (expression instanceof ConditionalExpressionAdapter) {
                _logger.debug("In if condition: StringConditionalExpression");
                ConditionalExpressionAdapter cea = (ConditionalExpressionAdapter)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, cea, exprValues);
            } else if (expression instanceof StringExpression) {
                _logger.debug("In if condition: StringExpression");
                StringExpression string = (StringExpression)expression;
                returnSQL = this.extractStringFromExpression(string);
            } else if (expression instanceof FunctionCall) {
                _logger.debug("In if condition: FunctionCall");
                independentExpression = true;
                FunctionCall call = (FunctionCall)expression;
                returnSQL = this.extractStringFromExpression(call, exprValues);
                if (expression.getExpressionType() == 4 && this._useAltSyntaxForRelDate) {
                    returnSQL = "\"'\" || put(" + returnSQL + ",date9.) || \"'d\"";
                }
            } else if (expression instanceof DataItem) {
                _logger.debug("In if condition: DataItem");
                DataItem item = (DataItem)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, item, exprValues);
            } else if (expression instanceof Column) {
                _logger.debug("In if condition: Column");
                Column column = (Column)expression;
                returnSQL = this.extractStringFromExpression(column, declareOrReference);
            } else if (expression instanceof DataItemFormattingExpression) {
                _logger.debug("In if condition: DataItemFormattingExpression");
                itemExpression = (DataItemFormattingExpression)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, (DataItemFormattingExpression)itemExpression, exprValues);
            } else if (expression instanceof CompareWithQueryResultsExpression) {
                _logger.debug("In if condition: CompareWithQueryResultsExpression");
                itemExpression = (CompareWithQueryResultsExpression)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, (CompareWithQueryResultsExpression)itemExpression, exprValues);
            } else if (expression instanceof InQueryResultsExpression) {
                _logger.debug("In if condition: InQueryResultsExpression");
                itemExpression = (InQueryResultsExpression)expression;
                returnSQL = this.extractStringFromExpression(declareOrReference, (InQueryResultsExpression)itemExpression, exprValues);
            } else {
                if (expression instanceof FractionOfTotalExpression) {
                    _logger.debug("In if condition: Invalid FractionOfTotalExpression usage");
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.ExpressionNotDataItem.fmt.txt", expression);
                    throw new GenerationException(mft);
                }
                _logger.debug("In if condition: GenerationException");
                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLComponentAbstract._generateExpressionSQL.UnknownExpression.fmt.txt", expression.getClass().getName()));
            }
            if ((this._executeMacroExpressions || this._useAltSyntaxForRelDate) && independentExpression) {
                DataSelectionProcessorAbstract dsproc = this.getDataSelectionProcessor();
                if (dsproc != null) {
                    IndependentExpressionGeneration ieg = dsproc.getIndependentExpressionGenerator();
                    if (ieg != null) {
                        if (ieg.isReplaceable(expression) && !ieg.isMappedTo(returnSQL)) {
                            returnSQL = ieg.addMapping(expression, returnSQL);
                        }
                    } else {
                        _logger.debug("Null IndependentExpressionGeneration specified");
                    }
                } else {
                    _logger.debug("Null DataSelectionProcessor specified");
                }
            }
            return returnSQL;
        }
        catch (MetadataException e) {
            _logger.debug("The following exception was found while trying to generate SQL", (Throwable)e);
            throw new GenerationException(e);
        }
    }

    protected String extractStringFromExpression(FunctionCall call, Map<ExpressionInterface, String> exprValues) throws GenerationException, MetadataException {
        Function function = call.getFunction();
        if (FunctionCallOptimizer.isReplaceable(function)) {
            FunctionCallOptimizer optimizer = new FunctionCallOptimizer(this, call);
            return optimizer.extractString(exprValues);
        }
        return this.extractString(call, exprValues);
    }

    public String extractString(FunctionCall call, Map<ExpressionInterface, String> exprValues) throws GenerationException, MetadataException {
        List<ExpressionInterface> args = call.getArguments();
        Function function = call.getFunction();
        return this.extractString(function, args, exprValues, false, false);
    }

    private String extractString(Function function, List<? extends ExpressionInterface> args, Map<ExpressionInterface, String> exprValues, boolean applyForcedFormattingToFirstParmAsNeeded, boolean formattingForcedOverrideValue) throws GenerationException, MetadataException {
        FunctionSignature signature = function.getCompatibleSignature(args);
        if (signature != null) {
            boolean canWrap = signature.canParenWrap();
            String template = signature.getSyntaxTemplateFor(args);
            if (template != null) {
                String dbmsString = this.extractString(function, template, args, exprValues, applyForcedFormattingToFirstParmAsNeeded, formattingForcedOverrideValue, canWrap);
                DataSelectionProcessorAbstract dsp = this.getDataSelectionProcessor();
                if (dsp != null && dsp.isTSSQL() && function.getNameID().equals("Put")) {
                    dbmsString = "CAST (" + dbmsString + " AS CHAR)";
                }
                return dbmsString;
            }
        }
        ArrayMessageFormatter argsMsg = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_SHORT, args.toArray(new Object[args.size()]));
        throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractString.NoFunctionSignature.fmt.txt", function, argsMsg));
    }

    private String extractString(Object context, String template, List<? extends ExpressionInterface> args, Map<ExpressionInterface, String> exprValues, boolean applyForcedFormattingToFirstParmAsNeeded, boolean formattingForcedOverrideValue, boolean canWrap) throws GenerationException, MetadataException {
        String[] argsSQL = new String[args.size()];
        for (int index = 0; index < args.size(); ++index) {
            ExpressionInterface expr = args.get(index);
            if (index == 0 && applyForcedFormattingToFirstParmAsNeeded && expr instanceof DataItem) {
                argsSQL[index] = this.generateFormattingForcedOverriddenSQL((DataItem)expr, 3, exprValues, applyForcedFormattingToFirstParmAsNeeded, formattingForcedOverrideValue, true);
                continue;
            }
            if (expr instanceof Prompt) {
                if (ExpressionUtil.returnsSpecialValuesALL(expr, this._dataSelection)) {
                    Object[] msgArgs = new Object[]{context};
                    MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.SpecialValuesNotSupported.fmt.txt", msgArgs);
                    throw new GenerationException(msg);
                }
                List<String> promptValues = this.extractString((Prompt)expr, false);
                if (promptValues.size() < 1) continue;
                argsSQL[index] = promptValues.get(0);
                continue;
            }
            argsSQL[index] = this.generateExpressionSQL(expr, 3, exprValues);
        }
        String pattern = canWrap ? "(" + template + ")" : template;
        String dbmsString = MessageFormat.format(pattern, argsSQL);
        return dbmsString;
    }

    protected String extractStringFromExpression(ResourceAwareStringExpression expression, Map<ExpressionInterface, String> exprValues, int declareOrReference) throws GenerationException, MetadataException {
        HashMap<BusinessModelResource, String> resourceMap = new HashMap<BusinessModelResource, String>();
        for (BusinessModelResource resource : expression.getResources(BusinessModelResource.class, 0)) {
            if (resource instanceof ExpressionInterface) {
                ExpressionInterface expr = (ExpressionInterface)((Object)resource);
                resourceMap.put(resource, this.generateExpressionSQL(expr, declareOrReference, exprValues));
                continue;
            }
            if (!(resource instanceof DataSourceTable)) continue;
            DataSourceTable table = (DataSourceTable)resource;
            String tableName = this.m_joinGenerator.getCorrelatedTableName(table);
            String tableIdentifier = this.getDataSelectionProcessor().generateTableIdentifier(tableName);
            resourceMap.put(resource, tableIdentifier);
        }
        String text = expression.getText(resourceMap);
        boolean hasAll = ExpressionUtil.returnsSpecialValuesALL(expression, this._dataSelection);
        String s = hasAll && expression.getExpressionType() == 9 ? "(1=1 " + this.generateSQLComment(text) + ")" : " ( " + text + " ) ";
        if (this.getDataSelectionProcessor().isTSSQL()) {
            char[] srcArray = s.toCharArray();
            char[] destArray = new char[s.length() * 2];
            boolean insideLiteral = false;
            boolean lastNonBlankWasDot = false;
            int j = 0;
            for (int n : srcArray) {
                if (!insideLiteral) {
                    if (n == 46) {
                        lastNonBlankWasDot = true;
                    } else if (n != 32 && n != 34) {
                        lastNonBlankWasDot = false;
                    }
                }
                if (n == 34) {
                    destArray[j++] = !lastNonBlankWasDot ? 39 : n;
                    if (insideLiteral) {
                        insideLiteral = false;
                        continue;
                    }
                    insideLiteral = true;
                    continue;
                }
                if (n == 39 && insideLiteral) {
                    destArray[j++] = n;
                    destArray[j++] = 39;
                    continue;
                }
                destArray[j++] = n;
            }
            s = new String(destArray, 0, j);
        }
        return s;
    }

    protected String extractStringFromExpression(int declareOrReference, ConditionalExpressionAdapter expression, Map<ExpressionInterface, String> exprValues) throws GenerationException {
        boolean hasAll;
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        boolean isNegated = expression.isNegated();
        ExpressionInterface innerExpr = expression.getExpression();
        String text = this.generateExpressionSQL(innerExpr, declareOrReference, exprValues);
        if (!(innerExpr instanceof ResourceAwareStringExpression || innerExpr instanceof SimpleConditionalExpression_TestForNull || innerExpr instanceof SimpleConditionalExpression_Between || innerExpr instanceof SimpleConditionalExpression_Comparison || innerExpr instanceof SimpleConditionalExpression_In || !(hasAll = ExpressionUtil.returnsSpecialValuesALL(innerExpr, this._dataSelection)))) {
            text = "(1=1 " + this.generateSQLComment(text) + ")";
        }
        dbmsStringStringBuffer.append(text);
        if (isNegated) {
            dbmsStringStringBuffer.insert(0, "NOT ( ");
            dbmsStringStringBuffer.append(" )");
        }
        return dbmsStringStringBuffer.toString();
    }

    protected String extractStringFromExpression(AbstractTimeValueExpression abstractTimeValue) throws MetadataException {
        String dbmsString = this._dataSelectionProcessor != null ? abstractTimeValue.generateQueryText(this._dataSelectionProcessor) : abstractTimeValue.generateQueryText(this._dataSelection, ConnectionType.IOM);
        return dbmsString;
    }

    protected String extractStringFromExpression(AbstractRelativeTimeValueExpression abstractRelativeTimeValue, int declareOrReference, Map<ExpressionInterface, String> exprValues) throws MetadataException, GenerationException {
        ExpressionInterface shiftFromExpr = abstractRelativeTimeValue.getShiftingFrom();
        String shiftFromValue = this.generateExpressionSQL(shiftFromExpr, 3, exprValues);
        String dbmsString = abstractRelativeTimeValue.generateQueryText(this._dataSelection, ConnectionType.IOM, shiftFromValue);
        return dbmsString;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String extractStringFromExpression(int declareOrReference, SimpleConditionalExpression_Comparison comparison, Map<ExpressionInterface, String> exprValues) throws MetadataException, GenerationException {
        boolean addMissingValue;
        StringBuffer addMissingValueNote;
        String strLeft;
        StringBuffer dbmsStringStringBuffer;
        block12: {
            String upperBounds;
            String lowerBounds;
            ComparisonOperator operator;
            block10: {
                ArrayList<String> rangeValues;
                block18: {
                    ExpressionInterface right;
                    block14: {
                        block16: {
                            block17: {
                                block15: {
                                    boolean usesRangePrompts;
                                    block13: {
                                        block11: {
                                            dbmsStringStringBuffer = new StringBuffer();
                                            ExpressionInterface left = comparison.getLeftExpression();
                                            right = comparison.getRightExpression();
                                            operator = comparison.getComparisonOperator();
                                            if (this.isPromptedRange(left)) {
                                                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.ComparisonGeneration.InvalidLeftExpressionDatePeriod.txt", new Object[0]);
                                                throw new GenerationException(mft);
                                            }
                                            boolean ffOverriden = comparison.isFormattingForcedOverridden();
                                            boolean ffValue = comparison.getFormattingForcedOverrideValue();
                                            strLeft = this.generateExpressionSQL(left, declareOrReference, exprValues, ffOverriden, ffValue);
                                            if (operator == null) {
                                                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.generateExpressionSQL.InvalidNull.txt", new Object[0]));
                                            }
                                            addMissingValueNote = new StringBuffer();
                                            addMissingValue = false;
                                            if (!ExpressionUtil.returnsSpecialValuesALL(right, this._dataSelection)) break block11;
                                            if (!operator.equals(ComparisonOperator.COMPARE_EQ)) {
                                                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.SpecialValuesNotSupported.fmt.txt", comparison);
                                                throw new GenerationException(msg);
                                            }
                                            dbmsStringStringBuffer.append("1=1");
                                            dbmsStringStringBuffer.append(this.generateSQLComment(strLeft + " = ALL"));
                                            break block12;
                                        }
                                        usesRangePrompts = this.isPromptedRange(right);
                                        boolean usesValuePrompts = this.isPromptedValue(right);
                                        if (usesRangePrompts || usesValuePrompts) break block13;
                                        dbmsStringStringBuffer.append(MessageFormat.format(COMPARISON_PATTERN, strLeft, operator, this.generateExpressionSQL(right, declareOrReference, exprValues)));
                                        break block12;
                                    }
                                    rangeValues = new ArrayList<String>();
                                    addMissingValue = this.extractValues((Prompt)right, usesRangePrompts, rangeValues, addMissingValueNote, true);
                                    if (!usesRangePrompts || !operator.equals(ComparisonOperator.COMPARE_EQ) && !operator.equals(ComparisonOperator.COMPARE_NEQ)) break block14;
                                    if (rangeValues.size() != 1) break block15;
                                    lowerBounds = (String)rangeValues.get(0);
                                    upperBounds = (String)rangeValues.get(0);
                                    break block10;
                                }
                                if (rangeValues.size() < 2) break block16;
                                int expressionType = right.getExpressionType();
                                if (expressionType == 3) break block17;
                                if (rangeValues.size() == 2) {
                                    lowerBounds = (String)rangeValues.get(0);
                                    upperBounds = (String)rangeValues.get(1);
                                    break block10;
                                } else {
                                    List<ExpressionInterface> exprs = this.promptValuesToExprs(rangeValues, expressionType);
                                    lowerBounds = this.generateNonAggregateFunction("Min", "DescripStatMin", declareOrReference, exprValues, exprs);
                                    upperBounds = this.generateNonAggregateFunction("Max", "DescripStatMax", declareOrReference, exprValues, exprs);
                                }
                                break block10;
                            }
                            lowerBounds = null;
                            upperBounds = null;
                            break block18;
                        }
                        lowerBounds = null;
                        upperBounds = null;
                        break block10;
                    }
                    String generateComparisonPredicate = this.generateComparisonPredicate(declareOrReference, strLeft, operator, right.getExpressionType(), rangeValues, exprValues);
                    dbmsStringStringBuffer.append(generateComparisonPredicate);
                    break block12;
                }
                for (int index = 0; index < rangeValues.size(); ++index) {
                    String value2;
                    String value = (String)rangeValues.get(index);
                    if (value != null && lowerBounds == null) {
                        lowerBounds = value;
                    }
                    if ((value2 = (String)rangeValues.get(rangeValues.size() - (index + 1))) != null && upperBounds == null) {
                        upperBounds = value2;
                    }
                    if (lowerBounds != null && upperBounds != null) break;
                }
            }
            if (!addMissingValue && lowerBounds == null && upperBounds == null) {
                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.generateExpressionSQL.InvalidNull.txt", new Object[0]));
            }
            String generateBetweenPredicate = this.generateBetweenPredicate(operator.equals(ComparisonOperator.COMPARE_NEQ), strLeft, lowerBounds, upperBounds);
            dbmsStringStringBuffer.append(generateBetweenPredicate);
        }
        boolean isNegated = comparison.isNegated();
        if (isNegated && dbmsStringStringBuffer.length() > 0) {
            dbmsStringStringBuffer.insert(0, "NOT ( ");
            dbmsStringStringBuffer.append(" )");
        }
        String dbmsString = dbmsStringStringBuffer.toString();
        if (!addMissingValue) return dbmsString;
        return this.addMissingValue(dbmsString, isNegated, strLeft, addMissingValueNote);
    }

    private String generateFormattingForcedOverriddenSQL(DataItem item, int declareOrReference, Map<ExpressionInterface, String> exprValues, boolean isFormattingForcedOverridden, boolean formattingForcedOverrideValue, boolean isCharacterFormattedWhenNoFormat) throws GenerationException, MetadataException {
        SQLSASFFOverriddenExpression overridden = new SQLSASFFOverriddenExpression(isFormattingForcedOverridden, formattingForcedOverrideValue, isCharacterFormattedWhenNoFormat);
        overridden.setSQLFactory(this.getSQLFactory());
        overridden.setDataSelectionProcessor(this.getDataSelectionProcessor());
        overridden.setDataSelection(this._dataSelection);
        overridden.setJoinGenerator(this.m_joinGenerator);
        StringBuffer sql = new StringBuffer();
        if (declareOrReference == 2) {
            boolean usePutInRef;
            boolean usedPutInDecl = this.forceFormatItemDeclaration(item);
            if (usedPutInDecl != (usePutInRef = overridden.forceFormatItemReference(item))) {
                if (isFormattingForcedOverridden) {
                    declareOrReference = 3;
                }
            } else if (usePutInRef) {
                declareOrReference = 3;
            }
        }
        String text = overridden.generateExpressionSQL(item, declareOrReference, exprValues);
        sql.append(text);
        return sql.toString();
    }

    protected String extractStringFromExpression(int declareOrReference, SimpleConditionalExpression_Between between, Map<ExpressionInterface, String> exprValues) throws MetadataException, GenerationException {
        String result;
        boolean simplifyToComparison;
        ExpressionInterface whatToCompare = between.getWhatToCompare();
        if (this.isPromptedRange(whatToCompare)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.ComparisonGeneration.InvalidLeftExpressionDatePeriod.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        String strWhatToCompare = this.generateExpressionSQL(whatToCompare, declareOrReference, exprValues, between.isFormattingForcedOverridden(), between.getFormattingForcedOverrideValue());
        ExpressionInterface left = between.getLeftExpression();
        ExpressionInterface right = between.getRightExpression();
        boolean specialValueAll = ExpressionUtil.returnsSpecialValuesALL(left, this._dataSelection) || ExpressionUtil.returnsSpecialValuesALL(right, this._dataSelection);
        boolean usesRangePrompts = this.isPromptedRange(left) || this.isPromptedRange(right);
        boolean usesValuePrompts = !specialValueAll && (this.isPromptedValue(left) || this.isPromptedValue(right));
        boolean bl = simplifyToComparison = (left == null || right == null) && !usesRangePrompts && !usesValuePrompts;
        if (simplifyToComparison) {
            ExpressionInterface rightOfEq = null;
            rightOfEq = left != null ? left : right;
            SimpleConditionalExpression_Comparison sceq = new SimpleConditionalExpression_Comparison();
            sceq.setIsNegated(between.isNegated());
            sceq.setLeftExpression(whatToCompare);
            sceq.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
            sceq.setRightExpression(rightOfEq);
            sceq.setFormattingForcedOverridden(between.isFormattingForcedOverridden());
            sceq.setFormattingForcedOverrideValue(between.getFormattingForcedOverrideValue());
            result = this.generateExpressionSQL(sceq, declareOrReference, exprValues);
        } else if (usesRangePrompts || usesValuePrompts) {
            int expressionType = 0;
            if (left != null) {
                expressionType = left.getExpressionType();
            } else if (right != null) {
                expressionType = right.getExpressionType();
            }
            boolean isNegated = between.isNegated();
            result = this.generateBetweenPredicate(declareOrReference, exprValues, expressionType, isNegated, strWhatToCompare, left, right, usesRangePrompts);
        } else {
            if (specialValueAll) {
                Object[] msgArgs = new Object[]{between};
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.SpecialValuesNotSupported.fmt.txt", msgArgs);
                throw new GenerationException(msg);
            }
            String lowerBounds = this.generateExpressionSQL(left, declareOrReference, exprValues);
            String upperBounds = this.generateExpressionSQL(right, declareOrReference, exprValues);
            result = this.generateBetweenPredicate(between.isNegated(), strWhatToCompare, lowerBounds, upperBounds);
        }
        return result;
    }

    private String generateExpressionSQL(ExpressionInterface expression, int declareOrReference, Map<ExpressionInterface, String> exprValues, boolean formattingForcedOverridden, boolean formattingForcedOverrideValue) throws GenerationException, MetadataException {
        String strWhatToCompare = formattingForcedOverridden && expression instanceof DataItem ? this.generateFormattingForcedOverriddenSQL((DataItem)expression, declareOrReference, exprValues, formattingForcedOverridden, formattingForcedOverrideValue, true) : this.generateExpressionSQL(expression, declareOrReference, exprValues);
        return strWhatToCompare;
    }

    private String generateBetweenPredicate(boolean isNegated, String left, String lowerBound, String upperBound) {
        String result = "";
        if (lowerBound == null || upperBound == null || lowerBound.equals(upperBound)) {
            String useValue = lowerBound;
            if (lowerBound == null) {
                useValue = upperBound;
            }
            if (useValue != null) {
                ComparisonOperator operator = isNegated ? ComparisonOperator.COMPARE_NEQ : ComparisonOperator.COMPARE_EQ;
                result = MessageFormat.format(COMPARISON_PATTERN, left, operator, useValue);
            }
        } else {
            String msgFormat = isNegated ? NOT_BETWEEN_PATTERN : BETWEEN_PATTERN;
            result = MessageFormat.format(msgFormat, left, lowerBound, upperBound);
        }
        return result;
    }

    protected String extractStringFromExpression(int declareOrReference, SimpleConditionalExpression_Like like, Map<ExpressionInterface, String> exprValues) throws GenerationException, MetadataException {
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        boolean isNegated = like.isNegated();
        Character escapeChar = like.getEscapeCharacter();
        ExpressionInterface whatToCompare = like.getWhatToCompare();
        ExpressionInterface patternExpr = like.getPatternExpression();
        Character matchManyChar = like.getMatchManyCharacter();
        Character matchOneChar = like.getMatchOneCharacter();
        dbmsStringStringBuffer.append(this.generateExpressionSQL(whatToCompare, declareOrReference, exprValues, like.isFormattingForcedOverridden(), like.getFormattingForcedOverrideValue()));
        dbmsStringStringBuffer.append(" LIKE ");
        String patternString = this.generatePatternSQL(patternExpr, declareOrReference, exprValues, escapeChar, matchManyChar, matchOneChar);
        dbmsStringStringBuffer.append(patternString);
        if (isNegated) {
            dbmsStringStringBuffer.insert(0, "NOT ( ");
            dbmsStringStringBuffer.append(" )");
        }
        String dbmsString = dbmsStringStringBuffer.toString();
        return dbmsString;
    }

    private String generatePatternSQL(ExpressionInterface patternExpr, int declareOrReference, Map<ExpressionInterface, String> exprValues, Character escapeChar, Character matchManyChar, Character matchOneChar) throws GenerationException {
        String pattern = this.generateExpressionSQL(patternExpr, declareOrReference, exprValues);
        if (_logger.isDebugEnabled()) {
            _logger.debug("LIKE: orig pattern [" + pattern + "] escape=" + escapeChar + ", many=" + matchManyChar + ", one=" + matchOneChar);
        }
        boolean replaceMatchMany = matchManyChar != null && matchManyChar.charValue() != '%';
        boolean replaceMatchOne = matchOneChar != null && matchOneChar.charValue() != '_';
        boolean needsEscapeClause = false;
        char useEscapeCh = escapeChar == null ? (char)'\\' : (char)escapeChar.charValue();
        char patternMatchManyCh = replaceMatchMany ? (char)matchManyChar.charValue() : (char)'%';
        char patternMatchOneCh = replaceMatchOne ? (char)matchOneChar.charValue() : (char)'_';
        StringBuffer result = new StringBuffer();
        boolean inQuote = false;
        boolean inComment = false;
        char quoteChar = '\u0000';
        int len = pattern.length();
        for (int i = 0; i < len; ++i) {
            char ch = pattern.charAt(i);
            if (inQuote) {
                if (ch == quoteChar) {
                    inQuote = false;
                    quoteChar = '\u0000';
                } else if (replaceMatchMany && ch == matchManyChar.charValue()) {
                    ch = '%';
                } else if (replaceMatchMany && ch == '%') {
                    result.append(useEscapeCh);
                    needsEscapeClause = true;
                } else if (replaceMatchOne && ch == matchOneChar.charValue()) {
                    ch = '_';
                } else if (replaceMatchOne && ch == '_') {
                    result.append(useEscapeCh);
                    needsEscapeClause = true;
                } else if (ch == useEscapeCh) {
                    boolean inlineNextCh;
                    boolean inlineEscapeCh;
                    boolean notAtEnd = len > i + 1;
                    char next = '\u0000';
                    if (notAtEnd) {
                        next = pattern.charAt(i + 1);
                    }
                    if (notAtEnd && next == patternMatchManyCh) {
                        inlineEscapeCh = !replaceMatchMany;
                        inlineNextCh = true;
                    } else if (notAtEnd && next == patternMatchOneCh) {
                        inlineEscapeCh = !replaceMatchOne;
                        inlineNextCh = true;
                    } else if (notAtEnd && next == useEscapeCh) {
                        inlineEscapeCh = true;
                        inlineNextCh = true;
                    } else {
                        inlineEscapeCh = true;
                        inlineNextCh = false;
                    }
                    if (inlineEscapeCh) {
                        result.append(useEscapeCh);
                        needsEscapeClause = true;
                    }
                    if (inlineNextCh) {
                        ++i;
                        ch = next;
                    }
                }
            } else if (inComment) {
                if (ch == '*' && len > i + 1 && pattern.charAt(i + 1) == '/') {
                    inComment = false;
                }
            } else if (ch == '/' && len > i + 1 && pattern.charAt(i + 1) == '*') {
                inComment = true;
            } else if (ch == '\'' || ch == '\"') {
                inQuote = true;
                quoteChar = ch;
            }
            result.append(ch);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("LIKE: processing vars: needsEscapeClause=" + needsEscapeClause + ", patternMatchManyCh=" + (char)patternMatchManyCh + ", patternMatchOneCh=" + patternMatchOneCh + ", useEscapeCh=" + (char)useEscapeCh);
        }
        if (needsEscapeClause) {
            result.append(" ESCAPE '" + (char)useEscapeCh + "'");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("LIKE: result=[" + result.toString() + "]");
        }
        return result.toString();
    }

    protected String extractStringFromExpression(int declareOrReference, SimpleConditionalExpression_Contains contains, Map<ExpressionInterface, String> exprValues) throws GenerationException, MetadataException {
        ServerProperties srvProps;
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        boolean isNegated = contains.isNegated();
        ExpressionInterface left = contains.getWhatToCompare();
        ExpressionInterface right = contains.getWhatToContain();
        try {
            srvProps = this._dataSelection.getServerProperties();
        }
        catch (MetadataException e) {
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractStringFromExpression.noServerProperties.txt", new Object[0]), (Throwable)e);
        }
        if (srvProps == null) {
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractStringFromExpression.noServerProperties.txt", new Object[0]));
        }
        Function function = srvProps.getFunctionByNameID(FunctionNameID.CONTAINS);
        if (function == null) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Could not find " + FunctionNameID.CONTAINS + " in the server properties");
            }
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractStringFromExpression.ContainsNotSupportedByQueryServer.txt", new Object[0]));
        }
        boolean isFormattingForcedOverriden = contains.isFormattingForcedOverridden();
        boolean formattingForcedOverrideValue = contains.getFormattingForcedOverrideValue();
        String sqlText = this.extractString(function, Arrays.asList(left, right), exprValues, isFormattingForcedOverriden, formattingForcedOverrideValue);
        dbmsStringStringBuffer.append(sqlText);
        if (isNegated) {
            dbmsStringStringBuffer.insert(0, "NOT ( ");
            dbmsStringStringBuffer.append(" )");
        }
        String dbmsString = dbmsStringStringBuffer.toString();
        return dbmsString;
    }

    protected String extractStringFromExpression(int declareOrReference, SimpleConditionalExpression_In in, Map<ExpressionInterface, String> exprValues) throws GenerationException, MetadataException {
        ExpressionInterface whatToCompare = in.getWhatToCompare();
        if (this.isPromptedRange(whatToCompare)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.ComparisonGeneration.InvalidLeftExpressionDatePeriod.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        boolean addMissingValue = false;
        StringBuffer addMissingValueNote = new StringBuffer();
        String strWhatToCompare = null;
        boolean ignoreExpression = false;
        List<ExpressionInterface> comparisonList = in.getComparisonList();
        ArrayList<ExpressionInterface> prComparisonValues = new ArrayList<ExpressionInterface>();
        Iterator<ExpressionInterface> it = comparisonList.iterator();
        while (it.hasNext()) {
            ExpressionInterface expression = it.next();
            if (this.isPromptedRange(expression)) {
                prComparisonValues.add(expression);
                it.remove();
                continue;
            }
            if (!ExpressionUtil.returnsSpecialValuesALL(expression, this._dataSelection)) continue;
            ignoreExpression = true;
        }
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        if (ignoreExpression) {
            dbmsStringStringBuffer.append("1=1");
            strWhatToCompare = this.generateExpressionSQL(whatToCompare, declareOrReference, exprValues, in.isFormattingForcedOverridden(), in.getFormattingForcedOverrideValue());
            dbmsStringStringBuffer.append(this.generateSQLComment(strWhatToCompare + " IN ALL"));
        } else if (prComparisonValues.isEmpty()) {
            StringBuffer valuesBuffer = new StringBuffer();
            for (int index = 0; index < comparisonList.size(); ++index) {
                ExpressionInterface right = comparisonList.get(index);
                if (right instanceof Prompt) {
                    ArrayList<String> extractedStrings = new ArrayList<String>();
                    addMissingValue |= this.extractValues((Prompt)right, false, extractedStrings, addMissingValueNote, true);
                    for (String valueStr : extractedStrings) {
                        int length = valuesBuffer.length();
                        if (length > 0) {
                            valuesBuffer.append(",");
                        }
                        this.smartAppend(valuesBuffer, valueStr);
                    }
                    continue;
                }
                if (right == null) continue;
                String valueStr = this.generateExpressionSQL(right, declareOrReference, exprValues);
                if (valuesBuffer.length() > 0) {
                    valuesBuffer.append(", ");
                    valuesBuffer.append(NEWLINE);
                }
                valuesBuffer.append(valueStr);
            }
            if (valuesBuffer.length() > 0 || !addMissingValue) {
                strWhatToCompare = this.generateExpressionSQL(whatToCompare, declareOrReference, exprValues, in.isFormattingForcedOverridden(), in.getFormattingForcedOverrideValue());
                dbmsStringStringBuffer.append(strWhatToCompare);
                dbmsStringStringBuffer.append(" IN ");
                dbmsStringStringBuffer.append(" ( ");
                dbmsStringStringBuffer.append(valuesBuffer);
                dbmsStringStringBuffer.append(" ) ");
            }
        } else {
            MultipleConditionalExpression mConditionalExpr = new MultipleConditionalExpression();
            mConditionalExpr.setRelationType(ConditionalRelationType.OR);
            it = prComparisonValues.iterator();
            while (it.hasNext()) {
                SimpleConditionalExpression_Comparison sceq = new SimpleConditionalExpression_Comparison();
                sceq.setLeftExpression(whatToCompare);
                sceq.setComparisonOperator(ComparisonOperator.COMPARE_EQ);
                sceq.setRightExpression(it.next());
                sceq.setFormattingForcedOverridden(in.isFormattingForcedOverridden());
                sceq.setFormattingForcedOverrideValue(in.getFormattingForcedOverrideValue());
                mConditionalExpr.addExpression(sceq);
            }
            if (!comparisonList.isEmpty()) {
                SimpleConditionalExpression_In scin = new SimpleConditionalExpression_In();
                scin.setWhatToCompare(whatToCompare);
                scin.setComparisonList(comparisonList);
                scin.setFormattingForcedOverridden(in.isFormattingForcedOverridden());
                scin.setFormattingForcedOverrideValue(in.getFormattingForcedOverrideValue());
                mConditionalExpr.addExpression(scin);
            }
            dbmsStringStringBuffer.append(this.generateExpressionSQL(mConditionalExpr, declareOrReference, exprValues));
        }
        boolean isNegated = in.isNegated();
        if (isNegated && dbmsStringStringBuffer.length() > 0) {
            dbmsStringStringBuffer.insert(0, "NOT ( ");
            dbmsStringStringBuffer.append(" )");
        }
        String dbmsString = dbmsStringStringBuffer.toString();
        if (addMissingValue) {
            if (strWhatToCompare == null) {
                strWhatToCompare = this.generateExpressionSQL(whatToCompare, declareOrReference, exprValues, in.isFormattingForcedOverridden(), in.getFormattingForcedOverrideValue());
            }
            dbmsString = this.addMissingValue(dbmsString, isNegated, strWhatToCompare, addMissingValueNote);
        }
        return dbmsString;
    }

    protected String extractStringFromExpression(int declareOrReference, SimpleConditionalExpression_TestForNull testForNull, Map<ExpressionInterface, String> exprValues) throws GenerationException, MetadataException {
        ExpressionInterface whatToCompare = testForNull.getWhatToCompare();
        if (ExpressionUtil.returnsSpecialValuesALL(whatToCompare, this._dataSelection)) {
            Object[] msgArgs = new Object[]{testForNull};
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.SpecialValuesNotSupported.fmt.txt", msgArgs);
            throw new GenerationException(msg);
        }
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        dbmsStringStringBuffer.append(this.generateExpressionSQL(whatToCompare, declareOrReference, exprValues, testForNull.isFormattingForcedOverridden(), testForNull.getFormattingForcedOverrideValue()));
        boolean isNegated = testForNull.isNegated();
        if (isNegated) {
            dbmsStringStringBuffer.append(" IS NOT NULL");
        } else {
            dbmsStringStringBuffer.append(" IS NULL");
        }
        String dbmsString = dbmsStringStringBuffer.toString();
        return dbmsString;
    }

    protected String extractStringFromExpression(Prompt prompt) throws MetadataException, GenerationException {
        String result;
        List<String> values = this.extractString(prompt, true);
        if (values.size() == 0) {
            result = "";
        } else if (values.size() == 1) {
            result = values.get(0);
        } else {
            StringBuffer buffer = new StringBuffer();
            Iterator<String> it = values.iterator();
            while (it.hasNext()) {
                String value = it.next();
                this.smartAppend(buffer, value);
                if (!it.hasNext()) continue;
                this.smartAppend(buffer, ",");
            }
            result = buffer.toString();
        }
        return result;
    }

    private void smartAppend(StringBuffer dbmsStringStringBuffer, String value) throws MetadataException {
        int sbLen = dbmsStringStringBuffer.length();
        int valueLen = value.length();
        int lastIndex = dbmsStringStringBuffer.lastIndexOf(NEWLINE);
        if (lastIndex != -1) {
            sbLen -= lastIndex;
        }
        if (sbLen + valueLen >= this.MAX_LINE_SIZE) {
            dbmsStringStringBuffer.append(NEWLINE);
        }
        dbmsStringStringBuffer.append(value);
    }

    public List<String> extractString(Prompt prompt, boolean supportsDatePeriod) throws MetadataException, GenerationException {
        PromptDefinitionInterface pdefinition = prompt.getPromptDefinition();
        int eType = prompt.getExpressionType();
        List<Object> pValues = this.extractPromptValues(supportsDatePeriod, pdefinition, eType);
        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(this._dataSelection);
        ArrayList<String> texts = new ArrayList<String>(pValues.size());
        for (Object pValue : pValues) {
            String text = this.extractPromptValueText(pValue, pdefinition, eType, computationalLocale);
            texts.add(text);
        }
        return texts;
    }

    public List<Object> extractPromptValues(boolean supportsDatePeriod, PromptDefinitionInterface pdefinition, int eType) throws GenerationException, MetadataException {
        List<Object> pValues = null;
        PromptValuesInterface promptValues = this._dataSelection.getPromptValues();
        try {
            Object valueObject = promptValues.getPromptValue(pdefinition);
            boolean isAvail = promptValues.isPromptValueAvailable(pdefinition);
            if (valueObject == null && !isAvail) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.ErrNoValue.fmt.txt", pdefinition.getPromptName(), pdefinition, this._dataSelection);
                throw new GenerationException(msg);
            }
            valueObject = this.processSpecialValues(pdefinition, valueObject);
            pValues = this.extractValues(pdefinition, eType, valueObject, supportsDatePeriod);
        }
        catch (PromptValueNotFoundException re) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.ErrRetrieve.fmt.txt", pdefinition.getPromptName(), pdefinition, this._dataSelection);
            throw new GenerationException(msg, (Throwable)re);
        }
        catch (NoSuchElementException re) {
            MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.ErrNoAttr.fmt.txt", pdefinition.getPromptName(), pdefinition, this._dataSelection);
            throw new GenerationException(msg, (Throwable)re);
        }
        return pValues;
    }

    public List<Object> extractValues(PromptDefinitionInterface pdefinition, int eType, Object valueObject, boolean supportDatePeriod) throws MetadataException, PromptValueNotFoundException, NoSuchElementException {
        ArrayList<Object> values;
        if (valueObject instanceof List) {
            List objList = (List)valueObject;
            values = new ArrayList(objList);
        } else {
            values = valueObject instanceof Object[] ? new ArrayList<Object>(Arrays.asList((Object[])valueObject)) : new ArrayList<Object>(Arrays.asList(valueObject));
        }
        ArrayList<Object> pValues = new ArrayList<Object>();
        for (Object value : values) {
            if (supportDatePeriod && value instanceof DatePeriod) {
                DatePeriod dp = (DatePeriod)value;
                DateTypes dts = dp.getPeriodType();
                if (dts != null && dts != DateTypes.DATE && dts != DateTypes.TIMESTAMP && dts != DateTypes.TIME) {
                    pValues.add(dp.getStartOfPeriod());
                    pValues.add(dp.getEndOfPeriod());
                    continue;
                }
                pValues.add(value);
                continue;
            }
            pValues.add(value);
        }
        return pValues;
    }

    public Object processSpecialValues(PromptDefinitionInterface pdefinition, Object value) throws GenerationException {
        ArrayList<Object> result = null;
        if (pdefinition instanceof ValueProviderDefinitionInterface) {
            ValueProviderDefinitionInterface vpdefinition = (ValueProviderDefinitionInterface)pdefinition;
            ValueProviderInterface valueProvider = vpdefinition.getValueProvider();
            if (valueProvider instanceof StaticValueProvider) {
                boolean isSpecialValuesALL = false;
                boolean isValueSupported = true;
                if (value instanceof List) {
                    List objList = value;
                    Iterator it = objList.iterator();
                    while (it.hasNext() && !isSpecialValuesALL && isValueSupported) {
                        Object itValue = it.next();
                        if (!(itValue instanceof SpecialValues)) continue;
                        if (itValue.equals(SpecialValues.ALL)) {
                            isSpecialValuesALL = true;
                            continue;
                        }
                        isValueSupported = false;
                    }
                } else if (value instanceof Object[]) {
                    Object[] arrayValues = (Object[])value;
                    int length = arrayValues.length;
                    for (int i = 0; i < length && !isSpecialValuesALL; ++i) {
                        Object av = arrayValues[i];
                        if (!(av instanceof SpecialValues)) continue;
                        if (av.equals(SpecialValues.ALL)) {
                            isSpecialValuesALL = true;
                            continue;
                        }
                        isValueSupported = false;
                    }
                } else if (value instanceof SpecialValues) {
                    if (((Object)value).equals(SpecialValues.ALL)) {
                        isSpecialValuesALL = true;
                    } else {
                        isValueSupported = false;
                    }
                }
                if (!isValueSupported) {
                    Object[] msgArgs = new Object[]{pdefinition.getPromptName(), pdefinition, this._dataSelection};
                    MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.SpecialValuesALLOnlySupported.fmt.txt", msgArgs);
                    throw new GenerationException(msg);
                }
                if (isSpecialValuesALL) {
                    SupportedSpecialValuesInterface svDefinition;
                    SupportedSpecialValues supportedSpecialValues;
                    ArrayList<Object> values = new ArrayList<Object>();
                    try {
                        StaticValueProvider staticValueProvider = (StaticValueProvider)valueProvider;
                        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(this._dataSelection);
                        List valueItems = (List)staticValueProvider.getValues(computationalLocale);
                        for (ValueItem item : valueItems) {
                            values.add(item.getValue());
                        }
                    }
                    catch (ValueProviderException e) {
                        Object[] msgArgs = new Object[]{pdefinition.getPromptName(), pdefinition, this._dataSelection};
                        MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.ErrRetrieve.fmt.txt", msgArgs);
                        throw new GenerationException(msg, (Throwable)e);
                    }
                    if (pdefinition instanceof SupportedSpecialValuesInterface && (supportedSpecialValues = (svDefinition = (SupportedSpecialValuesInterface)pdefinition).getSupportedSpecialValues()) != null && supportedSpecialValues.isMissingValuesSupported()) {
                        if (pdefinition instanceof TextDefinitionInterface) {
                            values.add(MissingValues._BLANK_);
                        } else {
                            values.add(MissingValues.Dot);
                        }
                    }
                    if (values.isEmpty()) {
                        Object[] msgArgs = new Object[]{pdefinition.getPromptName()};
                        MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.SpecialValuesALL.ListEmpty.fmt.txt", msgArgs);
                        throw new GenerationException(msg);
                    }
                    result = values;
                } else {
                    result = value;
                }
            } else {
                if (valueProvider == null && ExpressionUtil.containsSpecialValuesALL(value)) {
                    Object[] msgArgs = new Object[]{pdefinition.getPromptName()};
                    MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.SpecialValuesALL.ListEmpty.fmt.txt", msgArgs);
                    throw new GenerationException(msg);
                }
                result = value;
            }
        } else {
            result = value;
        }
        return result;
    }

    public String extractPromptValueText(Object value, PromptDefinitionInterface pdefinition, int expressionType, Locale computationalLocale) throws MetadataException {
        String result;
        if (value == null) {
            result = null;
        } else if (value instanceof Date) {
            AbstractTimeValueExpression abstractTimeValue = AbstractTimeValueExpression.newValue((Date)value, expressionType);
            if (this.getSQLFactory() instanceof SQLSASROLAPViewFactory) {
                try {
                    assert (!this._dataSelectionProcessor.isTSSQL());
                }
                catch (GenerationException e) {
                    throw new MetadataException(e);
                }
            }
            result = abstractTimeValue.generateQueryText(this._dataSelectionProcessor);
        } else if (value instanceof MissingValues) {
            result = MissingValues.toQueryString((MissingValues)((MissingValues)value));
            if (expressionType == 3) {
                result = GenerationUtil.generateQuotedLiteral(result);
            }
        } else if (value instanceof HyperlinkInterface) {
            result = ((HyperlinkInterface)value).getLinkLocation();
            if (expressionType == 3) {
                result = GenerationUtil.generateQuotedLiteral(result);
            }
        } else if (value instanceof FileLocationInterface) {
            result = ((FileLocationInterface)value).getFileLocation();
            if (expressionType == 3) {
                result = GenerationUtil.generateQuotedLiteral(result);
            }
        } else if (value instanceof MetadataSource) {
            result = ((MetadataSource)value).getMetadataSourceURL();
            if (expressionType == 3) {
                result = GenerationUtil.generateQuotedLiteral(result);
            }
        } else if (expressionType == 3) {
            String valueString = value.toString();
            valueString = this.applyPromptTransforms(pdefinition, valueString, computationalLocale);
            result = GenerationUtil.generateQuotedLiteral(valueString);
        } else {
            result = value.toString();
        }
        return result;
    }

    public String extractStringFromExpression(ConstantExpression constant) throws GenerationException {
        String dbmsString = constant.getValue();
        if (dbmsString == null) {
            return null;
        }
        int expType = constant.getExpressionType();
        if (expType == 3) {
            dbmsString = GenerationUtil.generateQuotedLiteral(dbmsString);
            return dbmsString;
        }
        try {
            double d = Double.parseDouble(dbmsString);
            if (expType == 2) {
                return dbmsString;
            }
            if (expType == 4) {
                if (this.getDataSelectionProcessor().isTSSQL()) {
                    long l = ((long)Math.floor(d) - 3653L) * 86400L * 1000L;
                    dbmsString = SQL99_DATE_GMT_SDF.get().format(l);
                    return dbmsString;
                }
                return dbmsString;
            }
            if (expType == 5) {
                if (this.getDataSelectionProcessor().isTSSQL()) {
                    long l = (long)(d - 3.156192E8) * 1000L;
                    dbmsString = SQL99_TIME_GMT_SDF.get().format(l);
                    return dbmsString;
                }
                return dbmsString;
            }
            if (expType == 6) {
                if (this.getDataSelectionProcessor().isTSSQL()) {
                    long l = (long)((d - 3.156192E8) * 1000.0);
                    dbmsString = SQL99_TIMESTAMP_GMT_SDF.get().format(l);
                    return dbmsString;
                }
                return dbmsString;
            }
            return dbmsString;
        }
        catch (NumberFormatException d) {
            dbmsString = dbmsString.trim().toUpperCase(Locale.US);
            if (SAS_DATE_PATTERN.matcher(dbmsString).matches()) {
                if (!this.getDataSelectionProcessor().isTSSQL()) {
                    return constant.getValue();
                }
                dbmsString = dbmsString.replace("\"", "'");
                Date dt = null;
                try {
                    dt = SAS_DATE7_SDF.get().parse(dbmsString);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (dt == null) {
                    try {
                        dt = SAS_DATE9_SDF.get().parse(dbmsString);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (dt == null) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractStringFromExpression.ParseException.fmt.txt", constant.getExpressionType(), constant.getValue()));
                }
                dbmsString = SQL99_DATE_SDF.get().format(dt);
                return dbmsString;
            }
            if (SAS_TIME_PATTERN.matcher(dbmsString).matches()) {
                if (!this.getDataSelectionProcessor().isTSSQL()) {
                    return constant.getValue();
                }
                dbmsString = dbmsString.replace("\"", "'");
                dbmsString = dbmsString.substring(1, dbmsString.length() - 2);
                int dotPos = dbmsString.indexOf(46);
                String fractional = null;
                if (dotPos != -1) {
                    fractional = dbmsString.substring(dotPos + 1);
                    dbmsString = dbmsString.substring(0, dotPos);
                }
                if (dbmsString.length() == 5) {
                    dbmsString = dbmsString + ":00";
                }
                Date dt = null;
                try {
                    dbmsString = "'" + dbmsString + "'T";
                    dt = SAS_TIME_LITERAL_SDF.get().parse(dbmsString);
                }
                catch (ParseException pe) {
                    _logger.debug(pe.getMessage(), (Throwable)pe);
                }
                if (dt == null) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractStringFromExpression.ParseException.fmt.txt", constant.getExpressionType(), constant.getValue()));
                }
                dbmsString = SQL99_TIME_SDF.get().format(dt);
                if (fractional != null) {
                    dbmsString = dbmsString.substring(0, dbmsString.length() - 1);
                    dbmsString = dbmsString + "." + fractional + "'";
                }
                return dbmsString;
            }
            if (SAS_DATETIME_PATTERN.matcher(dbmsString).matches()) {
                if (!this.getDataSelectionProcessor().isTSSQL()) {
                    return constant.getValue();
                }
                dbmsString = dbmsString.replace("\"", "'");
                dbmsString = dbmsString.substring(1, dbmsString.length() - 3);
                int dotPos = dbmsString.indexOf(46);
                String fractional = null;
                if (dotPos != -1) {
                    fractional = dbmsString.substring(dotPos + 1);
                    dbmsString = dbmsString.substring(0, dotPos);
                }
                dbmsString = dbmsString.replace(" ", ":");
                char[] dbmsArray = dbmsString.toCharArray();
                int colonCount = 0;
                for (char element : dbmsArray) {
                    if (element != ':') continue;
                    ++colonCount;
                }
                if (colonCount == 2) {
                    dbmsString = dbmsString + ":00";
                }
                Date dt = null;
                try {
                    dbmsString = "'" + dbmsString + "'DT";
                    dt = SAS_DATETIME17_SDF.get().parse(dbmsString);
                }
                catch (ParseException pe) {
                    _logger.debug(pe.getMessage(), (Throwable)pe);
                }
                if (dt == null) {
                    try {
                        dbmsString = "'" + dbmsString + "'DT";
                        dt = SAS_DATETIME19_SDF.get().parse(dbmsString);
                    }
                    catch (ParseException pe) {
                        _logger.debug(pe.getMessage(), (Throwable)pe);
                    }
                }
                if (dt == null) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractStringFromExpression.ParseException.fmt.txt", constant.getExpressionType(), dbmsString));
                }
                dbmsString = SQL99_TIMESTAMP_SDF.get().format(dt);
                if (fractional != null) {
                    dbmsString = dbmsString.substring(0, dbmsString.length() - 1);
                    dbmsString = dbmsString + "." + fractional + "'";
                }
                return dbmsString;
            }
            if (SQL99_DATE_PATTERN.matcher(dbmsString).matches()) {
                if (this.getDataSelectionProcessor().isTSSQL()) {
                    return constant.getValue();
                }
                dbmsString = dbmsString.replaceAll("\\s*", "");
                Date dt = null;
                try {
                    dt = SQL99_DATE_SDF.get().parse(dbmsString);
                }
                catch (ParseException pe) {
                    _logger.debug(pe.getMessage(), (Throwable)pe);
                }
                if (dt == null) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractStringFromExpression.ParseException.fmt.txt", constant.getExpressionType(), constant.getValue()));
                }
                dbmsString = SAS_DATE9_SDF.get().format(dt).toUpperCase();
                return dbmsString;
            }
            if (SQL99_TIME_PATTERN.matcher(dbmsString).matches()) {
                if (this.getDataSelectionProcessor().isTSSQL()) {
                    return constant.getValue();
                }
                dbmsString = dbmsString.replaceAll("\\s*", "");
                dbmsString = dbmsString.substring(5, dbmsString.length() - 1);
                int dotPos = dbmsString.indexOf(46);
                String fractional = null;
                if (dotPos != -1) {
                    fractional = dbmsString.substring(dotPos + 1);
                    dbmsString = dbmsString.substring(0, dotPos);
                }
                if (dbmsString.length() == 5) {
                    dbmsString = dbmsString + ":00";
                }
                Date dt = null;
                try {
                    dbmsString = "TIME'" + dbmsString + "'";
                    dt = SQL99_TIME_SDF.get().parse(dbmsString);
                }
                catch (ParseException pe) {
                    pe.toString();
                }
                if (dt == null || fractional != null && fractional.matches("\\D*")) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractStringFromExpression.ParseException.fmt.txt", constant.getExpressionType(), constant.getValue()));
                }
                dbmsString = SAS_TIME_LITERAL_SDF.get().format(dt);
                if (fractional != null) {
                    dbmsString = dbmsString.substring(0, dbmsString.length() - 2);
                    dbmsString = dbmsString + "." + fractional + "'T";
                }
                dbmsString = dbmsString.toUpperCase();
                return dbmsString;
            }
            if (SQL99_TIMESTAMP_PATTERN.matcher(dbmsString).matches()) {
                if (this.getDataSelectionProcessor().isTSSQL()) {
                    return constant.getValue();
                }
                dbmsString = dbmsString.replaceAll("TIMESTAMP\\s*", "TIMESTAMP");
                dbmsString = dbmsString.substring(10, dbmsString.length() - 1);
                int dotPos = dbmsString.indexOf(46);
                String fractional = null;
                if (dotPos != -1) {
                    fractional = dbmsString.substring(dotPos + 1);
                    dbmsString = dbmsString.substring(0, dotPos);
                }
                char[] dbmsArray = dbmsString.toCharArray();
                int colonCount = 0;
                for (char element : dbmsArray) {
                    if (element != ':') continue;
                    ++colonCount;
                }
                if (colonCount == 1) {
                    dbmsString = dbmsString + ":00";
                }
                Date dt = null;
                try {
                    dbmsString = "TIMESTAMP'" + dbmsString + "'";
                    dt = SQL99_TIMESTAMP_SDF.get().parse(dbmsString);
                }
                catch (ParseException pe) {
                    pe.toString();
                }
                if (dt == null) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractStringFromExpression.ParseException.fmt.txt", constant.getExpressionType(), dbmsString));
                }
                dbmsString = SAS_DATETIME19_SDF.get().format(dt);
                if (fractional != null) {
                    dbmsString = dbmsString.substring(0, dbmsString.length() - 3);
                    dbmsString = dbmsString + "." + fractional + "'DT";
                }
                dbmsString = dbmsString.toUpperCase();
                return dbmsString;
            }
            if (this.getDataSelectionProcessor().isTSSQL() && (expType == 4 || expType == 5 || expType == 6) && _logger.isEnabled(Level.WARN)) {
                MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.extractStringFromExpression.ParseException.fmt.txt", constant.getExpressionType(), dbmsString);
                _logger.warn(msg.toString());
            }
            return constant.getValue();
        }
    }

    protected String extractStringFromExpression(int declareOrReference, CompoundConditionalExpression conditional, Map<ExpressionInterface, String> exprValues) throws GenerationException {
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        boolean isNegated = conditional.isNegated();
        ExpressionInterface left = conditional.getLeftExpression();
        ExpressionInterface right = conditional.getRightExpression();
        ConditionalRelationType type = conditional.getRelationType();
        if (isNegated) {
            dbmsStringStringBuffer.append(" NOT");
        }
        dbmsStringStringBuffer.append(" (");
        if (left != null) {
            dbmsStringStringBuffer.append(this.generateExpressionSQL(left, declareOrReference, exprValues));
        }
        if (type != null) {
            dbmsStringStringBuffer.append(type == ConditionalRelationType.AND ? " AND " : " OR ");
        }
        if (right != null) {
            dbmsStringStringBuffer.append(this.generateExpressionSQL(right, declareOrReference, exprValues));
        }
        dbmsStringStringBuffer.append(") ");
        String dbmsString = dbmsStringStringBuffer.toString();
        return dbmsString;
    }

    protected String extractStringFromExpression(int declareOrReference, MultipleConditionalExpression conditional, Map<ExpressionInterface, String> exprValues) throws GenerationException {
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        boolean isNegated = conditional.isNegated();
        ExpressionInterface[] expressions = conditional.getExpressions();
        ConditionalRelationType type = conditional.getRelationType();
        String typeString = type == ConditionalRelationType.AND ? " AND " : " OR ";
        int count = expressions.length;
        if (isNegated) {
            dbmsStringStringBuffer.append(" NOT");
        }
        dbmsStringStringBuffer.append(" (");
        for (int i = 0; i < count; ++i) {
            String expressionSQL = this.generateExpressionSQL(expressions[i], declareOrReference, exprValues);
            dbmsStringStringBuffer.append(expressionSQL);
            if (type == null || i + 1 >= count) continue;
            dbmsStringStringBuffer.append(typeString);
        }
        dbmsStringStringBuffer.append(") ");
        String dbmsString = dbmsStringStringBuffer.toString();
        return dbmsString;
    }

    protected String extractStringFromExpression(StringExpression string) throws MetadataException {
        String dbmsString = string.getText();
        return dbmsString;
    }

    protected String extractStringFromExpression(Column column, int declareOrReference) throws GenerationException, MetadataException {
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        Table table = column.getOwningTable();
        String columnName = column.getSasName();
        if (table instanceof DataSourceTable && declareOrReference != 4) {
            String tableName = this.m_joinGenerator.getCorrelatedTableName((DataSourceTable)table);
            String tableIdentifier = this.getDataSelectionProcessor().generateTableIdentifier(tableName);
            dbmsStringStringBuffer.append(tableIdentifier);
            dbmsStringStringBuffer.append(".");
        }
        if (this._dataSelectionProcessor.isTSSQL() && this.getSQLFactory() instanceof SQLSASROLAPViewFactory) {
            this._dataSelectionProcessor.disableTSSQL();
        }
        dbmsStringStringBuffer.append(this.getDataSelectionProcessor().generateColumnIdentifier(columnName, table));
        String dbmsString = dbmsStringStringBuffer.toString();
        return dbmsString;
    }

    protected String extractStringFromExpression(int declareOrReference, DataItemFormattingExpression itemExpression, Map<ExpressionInterface, String> exprValues) throws GenerationException, MetadataException {
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        DataItem item = itemExpression.getDataItem();
        boolean isFormatted = itemExpression.isFormatted();
        boolean isCharacterFormattedWhenNoFormat = itemExpression.isCharacterFormattedWhenNoFormat();
        dbmsStringStringBuffer.append(this.generateFormattingForcedOverriddenSQL(item, declareOrReference, exprValues, true, isFormatted, isCharacterFormattedWhenNoFormat));
        String dbmsString = dbmsStringStringBuffer.toString();
        return dbmsString;
    }

    protected String extractStringFromExpression(int declareOrReference, CompareWithQueryResultsExpression itemExpression, Map<ExpressionInterface, String> exprValues) throws GenerationException {
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        ExpressionInterface whatToCompare = itemExpression.getWhatToCompare();
        ComparisonOperator operator = itemExpression.getComparisonOperator();
        DataSelection query = (DataSelection)itemExpression.getQuery();
        dbmsStringStringBuffer.append(this.generateExpressionSQL(whatToCompare, declareOrReference, exprValues));
        dbmsStringStringBuffer.append(" ");
        dbmsStringStringBuffer.append(operator.toString());
        CompareWithQueryResultsExpression.ComparisonType type = itemExpression.getComparisonType();
        if (type == CompareWithQueryResultsExpression.ComparisonType.COMPARE_WITH_ALL_QUERY_RESULT_VALUES) {
            dbmsStringStringBuffer.append(" ALL ");
        } else if (type == CompareWithQueryResultsExpression.ComparisonType.COMPARE_WITH_ANY_QUERY_RESULT_VALUE) {
            dbmsStringStringBuffer.append(" ANY ");
        }
        this.createInlineSubqueryColumn(dbmsStringStringBuffer, query);
        if (itemExpression.isNegated()) {
            dbmsStringStringBuffer.insert(0, "NOT ( ");
            dbmsStringStringBuffer.append(" )");
        }
        String dbmsString = dbmsStringStringBuffer.toString();
        return dbmsString;
    }

    protected String extractStringFromExpression(int declareOrReference, InQueryResultsExpression itemExpression, Map<ExpressionInterface, String> exprValues) throws GenerationException {
        StringBuffer dbmsStringStringBuffer = new StringBuffer();
        ExpressionInterface whatToCompare = itemExpression.getWhatToCompare();
        DataSelection query = (DataSelection)itemExpression.getQuery();
        dbmsStringStringBuffer.append(this.generateExpressionSQL(whatToCompare, declareOrReference, exprValues));
        dbmsStringStringBuffer.append(" IN ");
        this.createInlineSubqueryColumn(dbmsStringStringBuffer, query);
        if (itemExpression.isNegated()) {
            dbmsStringStringBuffer.insert(0, "NOT ( ");
            dbmsStringStringBuffer.append(" )");
        }
        String dbmsString = dbmsStringStringBuffer.toString();
        return dbmsString;
    }

    private String extractStringFromExpression(int declareOrReference, FractionOfTotalExpression itemExpression, Map<ExpressionInterface, String> exprValues, DataItemActionType usage) throws GenerationException {
        DataItem numerator = itemExpression.getNumerator();
        boolean applyAnalysisFunction = this.isAnalysisFunctionApplicable(numerator) && usage != DataItemActionType.USAGE_DETAIL;
        int exprDoR = declareOrReference;
        if (applyAnalysisFunction || declareOrReference == 1) {
            exprDoR = 3;
        }
        String dbmsString = this.generateExpressionSQL(numerator.getExpression(), exprDoR, exprValues);
        if (applyAnalysisFunction) {
            dbmsString = GenerationUtil.generateAnalysisFunction(numerator, dbmsString);
        }
        return dbmsString;
    }

    private void createInlineSubqueryColumn(StringBuffer sqlString, DataSelection dataSelection) throws GenerationException {
        SQLComponentAbstract sqlColumn;
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        boolean createTable = dsProcessor.isTempTable(dataSelection);
        if (createTable) {
            sqlString.append("( ");
            if (IQSystemProperties.isVerboseProcCommentsEnabled(this)) {
                String label = dataSelection.getLabel();
                if (label == null || label.trim().length() == 0) {
                    label = dataSelection.getID();
                }
                label = label.replaceAll("[*][/]", "* /");
                sqlString.append("\n/* " + label + " */\n");
            }
            sqlString.append("Select ");
            for (SelectedItem si : dataSelection.getSelectedItems()) {
                Role role = si.getRole();
                if (!Role.isOutputResultRole(dataSelection, role)) continue;
                DataItem di = si.getItem();
                String alias = dsProcessor.generateColumnIdentifier(di.getResultSetID());
                sqlString.append(alias);
                break;
            }
            sqlString.append(" from ");
            sqlColumn = this.getSQLFactory().createTempTableSASColumn(dataSelection);
        } else {
            sqlColumn = this.getSQLFactory().createSubSelectSASColumn(dataSelection);
        }
        sqlColumn.setDataSelectionProcessor(dsProcessor);
        sqlColumn.prepareSQL();
        sqlString.append(sqlColumn.writeSQL());
        if (createTable) {
            sqlString.append(")");
        }
    }

    protected String extractStringFromExpression(int declareOrReference, DataItem item, Map<ExpressionInterface, String> exprValues) throws InvalidIDException, MetadataException, GenerationException {
        boolean inlineFF;
        StringBuffer sql = new StringBuffer();
        if (declareOrReference == 1) {
            inlineFF = this.forceFormatItemDeclaration(item);
            String declarationSql = this.generateDataItemDeclarationSQL(item, exprValues, inlineFF);
            sql.append(declarationSql);
        } else if (declareOrReference == 3 || declareOrReference == 4) {
            inlineFF = this.forceFormatItemReference(item);
            String shortDeclarationSql = this.generateDataItemSql(item, exprValues, declareOrReference, inlineFF);
            sql.append(shortDeclarationSql);
        } else {
            inlineFF = this.forceFormatItemReference(item);
            String referenceSql = this.generateDataItemReferenceSQL(item, exprValues, 2, inlineFF);
            sql.append(referenceSql);
        }
        String dbmsString = sql.toString();
        return dbmsString;
    }

    protected String generateDataItemReferenceSQL(DataItem item, Map<ExpressionInterface, String> exprValues, int declareOrReference, boolean inlineFF) throws GenerationException {
        boolean droppedRefToPut = false;
        String strAlias = this.getAliasMatching(item, exprValues);
        if (strAlias != null && inlineFF) {
            if (item.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                boolean useFormat;
                String format = GenerationUtil.generateFormat(item);
                boolean bl = useFormat = format != null && format.trim().length() > 0;
                if (useFormat) {
                    DataSelectionProcessorAbstract dsp = this.getDataSelectionProcessor();
                    strAlias = GenerationUtil.generatePut(dsp, strAlias, format);
                    if (_logger.isDebugEnabled()) {
                        strAlias = "/* biq-014: put on agg ref */ " + strAlias;
                    }
                }
            } else {
                droppedRefToPut = true;
                strAlias = null;
            }
        }
        String referenceSql = strAlias != null ? strAlias : this.generateDataItemSql(item, exprValues, declareOrReference, inlineFF);
        if (_logger.isDebugEnabled() && droppedRefToPut) {
            referenceSql = "/* biq-015: no ref to ff */ " + referenceSql;
        }
        return referenceSql;
    }

    public String getAliasMatching(DataItem dataItem, Map<ExpressionInterface, String> exprValues) throws GenerationException {
        boolean nonHiddenResultItem;
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        List<SelectedItem> selectedItems = this._dataSelection.getSelectedItems();
        String alias = null;
        boolean isResultItem = false;
        for (SelectedItem selectedItem : selectedItems) {
            boolean isOutputResultItem;
            DataItem resultItem = selectedItem.getItem();
            Role role = selectedItem.getRole();
            if (!dataItem.equals(resultItem) || !(isOutputResultItem = Role.isOutputResultRole(this._dataSelection, role))) continue;
            isResultItem = true;
            break;
        }
        if (nonHiddenResultItem = isResultItem) {
            alias = dsProcessor.generateColumnIdentifier(dataItem.getResultSetID());
        }
        if (alias == null) {
            String itemSQL = this.generateComparableExpressionSQL(dataItem, exprValues);
            Iterator<SelectedItem> it = selectedItems.iterator();
            while (it.hasNext() && alias == null) {
                String resultItemSql;
                Role role;
                SelectedItem selectedItem = it.next();
                DataItem resultItem = selectedItem.getItem();
                boolean isNeededForPostProcess = dsProcessor.isNeededForPostProcess(this._dataSelection, resultItem, role = selectedItem.getRole());
                if (!isNeededForPostProcess || !itemSQL.equals(resultItemSql = this.generateComparableExpressionSQL(resultItem, exprValues))) continue;
                alias = dsProcessor.generateColumnIdentifier(resultItem.getResultSetID());
            }
        }
        return alias;
    }

    public boolean isPUTFunctionApplicable(DataItem item) throws GenerationException {
        return GenerationUtil.useFormattedValueForReference(item);
    }

    public boolean isAnalysisFunctionApplicable(DataItem item) {
        return GenerationUtil.getAnalysisFunction(item) != null;
    }

    public void createColumnSuffix(StringBuffer sql, DataItem item, String strAlias, String strFormat, boolean enforceFormat) throws GenerationException {
        boolean labelApplicable = this.isLabelApplicable();
        boolean formatApplicable = this.isFormatApplicable(item);
        this.createColumnSuffix(sql, item, strAlias, labelApplicable, formatApplicable, strFormat, enforceFormat);
    }

    public void createColumnSuffix(StringBuffer sql, DataItem item, String strAlias, boolean labelApplicable, boolean formatApplicable, String strFormat, boolean stripStrFormat) throws GenerationException {
        String strLabel;
        if (strAlias != null) {
            sql.append(" AS ");
            sql.append(this.getDataSelectionProcessor().generateColumnIdentifier(strAlias));
        }
        if (labelApplicable && (strLabel = item.getLabel()) != null) {
            sql.append(" LABEL=");
            sql.append(GenerationUtil.generateQuotedLiteral(strLabel));
        }
        if (formatApplicable) {
            boolean isInlineFormatted;
            if (strFormat != null && strFormat.trim().length() != 0) {
                sql.append(" FORMAT=");
                sql.append(strFormat);
            } else if (stripStrFormat && (isInlineFormatted = item.isFormattingForced()) && item.getExpressionTypeIgnoringFormattingForced() == 3) {
                sql.append(" FORMAT=$.");
            }
        }
    }

    public boolean isLabelApplicable() throws GenerationException {
        return !this.getDataSelectionProcessor().isTSSQL();
    }

    public boolean isFormatApplicable(DataItem item) throws GenerationException {
        boolean notFF = !GenerationUtil.useFormattedValueForSelect(item);
        boolean notTSSQL = !this.getDataSelectionProcessor().isTSSQL();
        return notFF && notTSSQL;
    }

    public String generateComparableExpressionSQL(DataItem dataItem, Map<ExpressionInterface, String> exprValues) throws GenerationException {
        String itemSql = "";
        ExpressionInterface expr = dataItem.getExpression();
        if (expr instanceof FractionOfTotalExpression) {
            itemSql = expr.toString();
        } else {
            itemSql = this.generateExpressionSQL(expr, 3, exprValues);
            if (this.isAnalysisFunctionApplicable(dataItem)) {
                itemSql = GenerationUtil.generateAnalysisFunction(dataItem, itemSql);
            }
        }
        if (this.forceFormatItemDeclaration(dataItem)) {
            boolean useFormat;
            String format = GenerationUtil.getSqlOutputFormat(dataItem);
            boolean bl = useFormat = format != null && format.trim().length() > 0;
            if (useFormat) {
                DataSelectionProcessorAbstract dsp = this.getDataSelectionProcessor();
                itemSql = GenerationUtil.generatePut(dsp, itemSql, format);
            }
        }
        return itemSql;
    }

    private boolean isPromptedRange(ExpressionInterface expression) throws GenerationException {
        boolean result = false;
        if (expression instanceof Prompt) {
            if (ExpressionUtil.isRangePrompt((Prompt)expression)) {
                result = true;
            } else {
                PromptDefinitionInterface definition = ((Prompt)expression).getPromptDefinition();
                PromptValuesInterface promptValues = this._dataSelection.getPromptValues();
                try {
                    DatePeriod dp;
                    DateTypes dts;
                    Object definitionValue = promptValues.getPromptValue(definition);
                    if (definitionValue instanceof DatePeriod && (dts = (dp = (DatePeriod)definitionValue).getPeriodType()) != null && dts != DateTypes.DATE && dts != DateTypes.TIMESTAMP && dts != DateTypes.TIME) {
                        result = true;
                    }
                }
                catch (PromptValueNotFoundException e) {
                    Object[] msgArgs = new Object[]{definition.getPromptName(), definition, this._dataSelection};
                    MessageFormatter msg = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.ErrRetrieve.fmt.txt", msgArgs);
                    throw new GenerationException(msg, (Throwable)e);
                }
            }
        }
        return result;
    }

    private String applyPromptTransforms(PromptDefinitionInterface promptDef, String value, Locale locale) {
        String result;
        block9: {
            List valueTransforms;
            block10: {
                result = value;
                if (promptDef == null || !(promptDef instanceof TextDefinitionInterface)) break block9;
                TextDefinitionInterface textDef = (TextDefinitionInterface)promptDef;
                valueTransforms = textDef.getValueTransforms();
                if (valueTransforms != null && !valueTransforms.isEmpty()) break block10;
                String upcasedObject = promptDef.getUserInfo().get("promptValueUpperCased");
                if (_logger.isDebugEnabled()) {
                    _logger.debug("[pre v920] Prompt-upcasedObject = " + upcasedObject);
                }
                if (upcasedObject == null) break block9;
                boolean upcase = false;
                if (upcasedObject instanceof String) {
                    upcase = Boolean.valueOf(upcasedObject);
                } else if (upcasedObject instanceof Boolean) {
                    upcase = (Boolean)((Object)upcasedObject);
                } else {
                    _logger.debug("The object returned from UserInfo map on the prompt definition is not a String or a Boolean object");
                }
                if (!upcase) break block9;
                result = value.toUpperCase(locale);
                break block9;
            }
            int numOfTransforms = valueTransforms.size();
            for (int i = 0; i < numOfTransforms; ++i) {
                Object objTransform = valueTransforms.get(i);
                if (objTransform instanceof String) {
                    String transform = (String)objTransform;
                    if (transform.equals("UPPERCASE")) {
                        result = result.toUpperCase(locale);
                        continue;
                    }
                    if (transform.equals("LOWERCASE")) {
                        result = result.toLowerCase(locale);
                        continue;
                    }
                    if (!transform.equals("TRIM")) continue;
                    result = result.trim();
                    continue;
                }
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug("The prompt transform is not of type string (" + objTransform.toString() + ")");
            }
        }
        return result;
    }

    public void setExecuteMacroExpressions(boolean executeMacroExpressions) {
        this._executeMacroExpressions = executeMacroExpressions;
    }

    public void setUseAltSyntaxForRelDate(boolean useAltSyntaxForRelDate) {
        this._useAltSyntaxForRelDate = useAltSyntaxForRelDate;
    }

    private String generateSQLComment(String comment) {
        StringBuffer sqlComment = new StringBuffer();
        if (comment != null && comment.length() > 0) {
            String tComment = comment.replaceAll("/\\*", "/_");
            tComment = tComment.replaceAll("\\*/", "_/");
            sqlComment.append("/*").append(tComment).append("*/");
        }
        return sqlComment.toString();
    }

    private String generateNonAggregateFunction(String functionTokenText, String svrPropsFuncID, int declareOrReference, Map<ExpressionInterface, String> exprValues, List<? extends ExpressionInterface> rangeValues) throws GenerationException, MetadataException {
        String sql;
        Function function;
        ServerProperties srvProps = this._dataSelection.getServerProperties();
        Function function2 = function = srvProps == null ? null : srvProps.getFunctionByID(svrPropsFuncID);
        if (function == null) {
            StringBuffer template = new StringBuffer();
            if (rangeValues != null && rangeValues.size() > 1) {
                template.append(functionTokenText).append('(');
                for (int index = 0; index < rangeValues.size(); ++index) {
                    if (index != 0) {
                        template.append(',');
                    }
                    template.append("{" + index + "}");
                }
                template.append(')');
            } else {
                template.append("({0})");
            }
            sql = this.extractString(functionTokenText, template.toString(), rangeValues, exprValues, false, false, false);
        } else {
            sql = this.generateExpressionSQL(new FunctionCall(function, rangeValues), declareOrReference, exprValues);
        }
        return sql;
    }

    public String generateDataItemSelectSQL(DataItem item, Object object) throws GenerationException {
        boolean inlineFF = this.forceFormatItemDeclaration(item);
        return this.generateDataItemDeclarationSQL(item, null, inlineFF);
    }

    public String generateDataItemGroupBySQL(DataItem item) throws GenerationException {
        StringBuffer strColumn = new StringBuffer();
        boolean groupByFormattedValue = GenerationUtil.useFormattedValueForGrouping(item);
        if (_logger.isDebugEnabled()) {
            if (groupByFormattedValue) {
                strColumn.append("/* biq-025: group by formatted value */ ");
            } else {
                strColumn.append("/* biq-025: group by unformatted value */ ");
            }
        }
        String sql = this.generateDataItemShortDeclarationSQL(item, null, groupByFormattedValue);
        strColumn.append(sql);
        return strColumn.toString();
    }

    public String generateDataItemOrderBySQL(DataItem item, SQLOrderAbstract sqlSortDirection) throws GenerationException {
        String dbmsString;
        StringBuffer strColumn = new StringBuffer();
        String strAlias = this.getAliasMatching(item, null);
        DataItemActionType sort = item.getSortDirection();
        boolean hasSortDirection = sort != null && sort != DataItemActionType.SORT_NONE;
        boolean sortByFormattedValue = GenerationUtil.useFormattedValueForSorting(item);
        if (strAlias != null) {
            if (_logger.isDebugEnabled()) {
                if (sortByFormattedValue) {
                    strColumn.append("/* biq-026: sort by formatted values using alias */ ");
                } else {
                    strColumn.append("/* biq-026: sort by unformatted values using alias */ ");
                }
            }
            dbmsString = strAlias;
            boolean aliasIsFormatted = this.forceFormatItemDeclaration(item);
            if (hasSortDirection && sortByFormattedValue && !aliasIsFormatted) {
                boolean useFormat;
                String format = GenerationUtil.generateFormat(item);
                boolean bl = useFormat = format != null && format.trim().length() > 0;
                if (useFormat) {
                    DataSelectionProcessorAbstract dsp = this.getDataSelectionProcessor();
                    dbmsString = GenerationUtil.generatePut(dsp, dbmsString, format);
                }
            }
        } else {
            if (_logger.isDebugEnabled()) {
                if (sortByFormattedValue) {
                    strColumn.append("/* biq-027: sort by formatted values */ ");
                } else {
                    strColumn.append("/* biq-027: sort by unformatted values */ ");
                }
            }
            dbmsString = this.generateDataItemSql(item, null, 2, sortByFormattedValue);
        }
        strColumn.append(dbmsString);
        String sqlSortDirectionString = sqlSortDirection.writeSQL();
        strColumn.append(sqlSortDirectionString);
        return strColumn.toString();
    }

    public boolean forceFormatItemDeclaration(DataItem item) throws GenerationException {
        return GenerationUtil.useFormattedValueForSelect(item);
    }

    public boolean forceFormatItemReference(DataItem item) throws GenerationException {
        return GenerationUtil.useFormattedValueForReference(item);
    }

    public String generateDataItemShortDeclarationSQL(DataItem item, Map<ExpressionInterface, String> exprValues, boolean inlineItemFF) throws GenerationException {
        String shortDeclarationSql = this.generateDataItemSql(item, exprValues, 3, inlineItemFF);
        return shortDeclarationSql;
    }

    private String generateDataItemSql(DataItem item, Map<ExpressionInterface, String> exprValues, int childExprDoR, boolean inlineItemFF) throws GenerationException {
        String dataItemSql;
        if (childExprDoR == 1) {
            throw new IllegalArgumentException("Generation does not allow calls to generateDataItemSql() with childExprDoR set to EXP_GEN_DECLARATION");
        }
        ExpressionInterface expression = item.getExpression();
        if (expression instanceof FractionOfTotalExpression) {
            dataItemSql = this.extractStringFromExpression(childExprDoR, (FractionOfTotalExpression)expression, exprValues, item.getUsage());
        } else {
            dataItemSql = this.generateDataItemsExpressionSQL(item, childExprDoR, exprValues);
            boolean applyAnalysisFunction = this.isAnalysisFunctionApplicable(item);
            if (applyAnalysisFunction) {
                dataItemSql = GenerationUtil.generateAnalysisFunction(item, dataItemSql);
            }
            if (inlineItemFF) {
                boolean useFormat;
                String format = GenerationUtil.generateFormat(item);
                boolean bl = useFormat = format != null && format.trim().length() > 0;
                if (useFormat) {
                    DataSelectionProcessorAbstract dsp = this.getDataSelectionProcessor();
                    dataItemSql = GenerationUtil.generatePut(dsp, dataItemSql, format);
                    if (_logger.isDebugEnabled()) {
                        dataItemSql = "/* biq-023: inline put in expr */ " + dataItemSql;
                    }
                }
            }
        }
        return dataItemSql;
    }

    protected String generateDataItemsExpressionSQL(DataItem item, int exprDoR, Map<ExpressionInterface, String> exprValues) throws GenerationException {
        ExpressionInterface expression = item.getExpression();
        return this.generateExpressionSQL(expression, exprDoR, exprValues);
    }

    protected String generateDataItemDeclarationSQL(DataItem item, Map<ExpressionInterface, String> exprValues, boolean inlineItemFF) throws GenerationException {
        boolean enforceFormat = inlineItemFF;
        StringBuffer sql = new StringBuffer();
        ExpressionInterface expression = item.getExpression();
        if (expression instanceof FractionOfTotalExpression) {
            String fotSql = this.extractStringFromExpression(1, (FractionOfTotalExpression)expression, exprValues, item.getUsage());
            sql.append(fotSql);
        } else {
            boolean groupByFormattedValue;
            String dataItemSql = this.generateDataItemsExpressionSQL(item, 3, exprValues);
            boolean applyAnalysisFunction = this.isAnalysisFunctionApplicable(item);
            if (applyAnalysisFunction) {
                dataItemSql = GenerationUtil.generateAnalysisFunction(item, dataItemSql);
            }
            if (inlineItemFF) {
                boolean useFormat;
                String format = GenerationUtil.generateFormat(item);
                boolean bl = useFormat = format != null && format.trim().length() > 0;
                if (useFormat) {
                    if (_logger.isDebugEnabled()) {
                        sql.append("/* biq-011: inline ff */ ");
                    }
                    DataSelectionProcessorAbstract dsp = this.getDataSelectionProcessor();
                    dataItemSql = GenerationUtil.generatePut(dsp, dataItemSql, format);
                }
            } else if (item.getUsage() == DataItemActionType.USAGE_CATEGORY && (groupByFormattedValue = GenerationUtil.useFormattedValueForGrouping(item))) {
                dataItemSql = MessageFormat.format("MIN({0})", dataItemSql);
                enforceFormat = true;
            }
            sql.append(dataItemSql);
        }
        String strAlias = item.getResultSetID();
        String strFormat = GenerationUtil.generateFormat(item, enforceFormat);
        this.createColumnSuffix(sql, item, strAlias, strFormat, true);
        if (_logger.isDebugEnabled()) {
            if (inlineItemFF) {
                sql.append(" /* biq-003: no format for inline ff */");
            } else if (enforceFormat) {
                sql.append(" /* biq-003: added format for groupby ff */");
            } else if (item.isFormattingForced() && item.getExpressionTypeIgnoringFormattingForced() == 3) {
                sql.append(" /* biq-002: FORMAT=$. */");
            }
        }
        return sql.toString();
    }

    private boolean isPromptedValue(ExpressionInterface expression) {
        boolean result = false;
        if (expression instanceof Prompt) {
            result = ExpressionUtil.isMultiSelectionPrompt((Prompt)expression) || ExpressionUtil.isSingleSelectionPrompt((Prompt)expression);
        }
        return result;
    }

    private String generateComparisonPredicate(int declareOrReference, String strLeft, ComparisonOperator operator, int expressionType, List<String> promptValues, Map<ExpressionInterface, String> exprValues) throws GenerationException, MetadataException {
        String text = "";
        if (promptValues.size() == 1) {
            String strRight = promptValues.get(0);
            if (strRight != null) {
                text = MessageFormat.format(COMPARISON_PATTERN, strLeft, operator, strRight);
            }
        } else if (promptValues.size() >= 2) {
            if (expressionType != 3) {
                String strRight = null;
                List<ExpressionInterface> exprs = this.promptValuesToExprs(promptValues, expressionType);
                strRight = operator.equals(ComparisonOperator.COMPARE_LT) || operator.equals(ComparisonOperator.COMPARE_GE) ? this.generateNonAggregateFunction("Min", "DescripStatMin", declareOrReference, exprValues, exprs) : this.generateNonAggregateFunction("Max", "DescripStatMax", declareOrReference, exprValues, exprs);
                if (strRight != null) {
                    text = MessageFormat.format(COMPARISON_PATTERN, strLeft, operator, strRight);
                }
            } else {
                boolean inclusive = operator.equals(ComparisonOperator.COMPARE_EQ) || operator.equals(ComparisonOperator.COMPARE_LE) || operator.equals(ComparisonOperator.COMPARE_GE);
                boolean wrap = false;
                StringBuffer buffer = new StringBuffer();
                for (String strRight : promptValues) {
                    if (strRight == null) continue;
                    if (buffer.length() > 0) {
                        buffer.append(inclusive ? " OR " : " AND ");
                        wrap = true;
                    }
                    buffer.append(MessageFormat.format(COMPARISON_PATTERN, strLeft, operator, strRight));
                }
                if (wrap) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
                text = buffer.toString();
            }
        }
        return text;
    }

    private List<ExpressionInterface> promptValuesToExprs(List<?> promptValues, int expressionType) {
        ArrayList<ExpressionInterface> exprs = new ArrayList<ExpressionInterface>(promptValues.size());
        for (int index = 0; index < promptValues.size(); ++index) {
            Object value = promptValues.get(index);
            if (value == null) continue;
            String text = value instanceof MissingValues ? MissingValues.toQueryString((MissingValues)((MissingValues)value)) : (value instanceof String ? (String)value : String.valueOf(value));
            ConstantExpression cExp = new ConstantExpression(text, expressionType);
            exprs.add(cExp);
        }
        return exprs;
    }

    private boolean extractValues(Prompt prompt, boolean usesRangePrompts, List<String> extractedStrings, StringBuffer note, boolean dropSimpleMissingValues) throws GenerationException, MetadataException {
        boolean addMissingValue = false;
        PromptDefinitionInterface pdefinition = prompt.getPromptDefinition();
        Locale computationalLocale = LocaleUtilities.getDefaultComputationalLocale(this._dataSelection);
        int eType = prompt.getExpressionType();
        List<Object> pValues = this.extractPromptValues(true, pdefinition, eType);
        for (Object pValue : pValues) {
            if (pValue == null) {
                addMissingValue |= true;
                if (note.length() != 0) continue;
                note.append(usesRangePrompts ? " /* null in prompted range values */" : " /* null in prompted value */");
                continue;
            }
            if (dropSimpleMissingValues) {
                boolean sasSimpleMissingValue;
                boolean bl = sasSimpleMissingValue = pValue.equals(MissingValues._BLANK_) || pValue.equals(MissingValues.Dot);
                if (sasSimpleMissingValue) {
                    addMissingValue |= true;
                    continue;
                }
                String text = this.extractPromptValueText(pValue, pdefinition, eType, computationalLocale);
                extractedStrings.add(text);
                continue;
            }
            String text = this.extractPromptValueText(pValue, pdefinition, eType, computationalLocale);
            extractedStrings.add(text);
        }
        return addMissingValue;
    }

    private String generateBetweenPredicate(int declareOrReference, Map<ExpressionInterface, String> exprValues, int expressionType, boolean isNegated, String strWhatToCompare, ExpressionInterface left, ExpressionInterface right, boolean usesRangePrompts) throws GenerationException, MetadataException {
        String generateExpressionSQL;
        Locale computationalLocale;
        String valueString;
        AbstractTimeValueExpression abstractTimeValue;
        Object extract;
        List<Object> pValues;
        int eType;
        PromptDefinitionInterface pdefinition;
        Prompt prompt;
        boolean addMissingValue = false;
        StringBuffer addMissingValueNote = new StringBuffer();
        ArrayList<Object> rangeValues = new ArrayList<Object>();
        if (left instanceof Prompt) {
            prompt = (Prompt)left;
            pdefinition = prompt.getPromptDefinition();
            eType = prompt.getExpressionType();
            pValues = this.extractPromptValues(true, pdefinition, eType);
            for (Object pValue : pValues) {
                if (pValue == null) {
                    addMissingValue |= true;
                    if (addMissingValueNote.length() != 0) continue;
                    addMissingValueNote.append(usesRangePrompts ? " /* null in prompted range values */" : " /* null in prompted value */");
                    continue;
                }
                if (pValue instanceof MissingValues) {
                    extract = pValue;
                } else if (pValue instanceof Date) {
                    abstractTimeValue = AbstractTimeValueExpression.newValue((Date)pValue, eType);
                    extract = abstractTimeValue.generateQueryText(this._dataSelection, ConnectionType.IOM);
                } else if (eType == 3) {
                    valueString = pValue.toString();
                    computationalLocale = LocaleUtilities.getDefaultComputationalLocale(this._dataSelection);
                    valueString = this.applyPromptTransforms(pdefinition, valueString, computationalLocale);
                    extract = GenerationUtil.generateQuotedLiteral(valueString);
                } else {
                    extract = pValue.toString();
                }
                rangeValues.add(extract);
            }
        } else if (left != null) {
            generateExpressionSQL = this.generateExpressionSQL(left, declareOrReference, exprValues);
            rangeValues.add(generateExpressionSQL);
        }
        if (right instanceof Prompt) {
            prompt = (Prompt)right;
            pdefinition = prompt.getPromptDefinition();
            eType = prompt.getExpressionType();
            pValues = this.extractPromptValues(true, pdefinition, eType);
            for (Object pValue : pValues) {
                if (pValue == null) {
                    addMissingValue |= true;
                    if (addMissingValueNote.length() != 0) continue;
                    addMissingValueNote.append(usesRangePrompts ? " /* null in prompted range values */" : " /* null in prompted value */");
                    continue;
                }
                if (pValue instanceof MissingValues) {
                    extract = pValue;
                } else if (pValue instanceof Date) {
                    abstractTimeValue = AbstractTimeValueExpression.newValue((Date)pValue, eType);
                    extract = abstractTimeValue.generateQueryText(this._dataSelection, ConnectionType.IOM);
                } else if (eType == 3) {
                    valueString = pValue.toString();
                    computationalLocale = this._dataSelection.getComputationalLocale();
                    valueString = this.applyPromptTransforms(pdefinition, valueString, computationalLocale);
                    extract = GenerationUtil.generateQuotedLiteral(valueString);
                } else {
                    extract = pValue.toString();
                }
                rangeValues.add(extract);
            }
        } else if (right != null) {
            generateExpressionSQL = this.generateExpressionSQL(right, declareOrReference, exprValues);
            rangeValues.add(generateExpressionSQL);
        }
        Object lowerBounds = null;
        String upperBounds = null;
        if (rangeValues.size() == 1) {
            lowerBounds = rangeValues.get(0);
            upperBounds = (String)rangeValues.get(0);
        } else if (rangeValues.size() >= 2) {
            if (expressionType != 3) {
                if (rangeValues.size() == 2) {
                    lowerBounds = rangeValues.get(0);
                    upperBounds = (String)rangeValues.get(1);
                } else {
                    List<ExpressionInterface> exprs = this.promptValuesToExprs(rangeValues, expressionType);
                    lowerBounds = this.generateNonAggregateFunction("Min", "DescripStatMin", declareOrReference, exprValues, exprs);
                    upperBounds = this.generateNonAggregateFunction("Max", "DescripStatMax", declareOrReference, exprValues, exprs);
                }
            } else {
                lowerBounds = null;
                upperBounds = null;
                for (int index = 0; index < rangeValues.size(); ++index) {
                    Object value2;
                    Object value = rangeValues.get(index);
                    if (value != null && lowerBounds == null) {
                        lowerBounds = value;
                    }
                    if ((value2 = rangeValues.get(rangeValues.size() - (index + 1))) != null && upperBounds == null) {
                        upperBounds = value2;
                    }
                    if (lowerBounds != null && upperBounds != null) break;
                }
            }
        }
        if (!addMissingValue && lowerBounds == null && upperBounds == null) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("SQLExpressionAbstract.BetweenGeneration.RequireTwoArguments.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        addMissingValue |= lowerBounds == null || upperBounds == null;
        String result = "";
        if (lowerBounds == null || upperBounds == null || lowerBounds.equals(upperBounds)) {
            Object useValue = lowerBounds;
            if (lowerBounds == null) {
                useValue = upperBounds;
            }
            if (useValue != null) {
                boolean isSimpleCharacterMissing;
                boolean isSimpleNumericMissing = expressionType != 3 && useValue.equals(MissingValues.Dot);
                boolean bl = isSimpleCharacterMissing = expressionType == 3 && useValue.equals(MissingValues._BLANK_);
                if (isSimpleNumericMissing || isSimpleCharacterMissing) {
                    result = isNegated ? strWhatToCompare + " IS NOT NULL" : strWhatToCompare + " IS NULL";
                } else {
                    if (useValue instanceof MissingValues) {
                        useValue = MissingValues.toQueryString((MissingValues)((MissingValues)useValue));
                        if (expressionType == 3) {
                            useValue = GenerationUtil.generateQuotedLiteral((String)useValue);
                        }
                    }
                    ComparisonOperator operator = isNegated ? ComparisonOperator.COMPARE_NEQ : ComparisonOperator.COMPARE_EQ;
                    result = MessageFormat.format(COMPARISON_PATTERN, strWhatToCompare, operator, useValue);
                }
            }
        } else {
            if (lowerBounds instanceof MissingValues) {
                lowerBounds = MissingValues.toQueryString((MissingValues)((MissingValues)lowerBounds));
                if (expressionType == 3) {
                    lowerBounds = GenerationUtil.generateQuotedLiteral((String)lowerBounds);
                }
            }
            if (upperBounds instanceof MissingValues) {
                upperBounds = MissingValues.toQueryString((MissingValues)((MissingValues)upperBounds));
                if (expressionType == 3) {
                    upperBounds = GenerationUtil.generateQuotedLiteral(upperBounds);
                }
            }
            String msgFormat = isNegated ? NOT_BETWEEN_PATTERN : BETWEEN_PATTERN;
            result = MessageFormat.format(msgFormat, strWhatToCompare, lowerBounds, upperBounds);
        }
        if (addMissingValue) {
            result = this.addMissingValue(result, isNegated, strWhatToCompare, addMissingValueNote);
        }
        return result;
    }

    private String addMissingValue(String result, boolean isNegated, String strWhatToCompare, StringBuffer note) {
        boolean notEmpty = result == null ? false : result.length() > 0;
        StringBuffer buffer = new StringBuffer();
        if (notEmpty) {
            buffer.append('(').append(result).append(isNegated ? " AND " : " OR ");
        }
        buffer.append(strWhatToCompare);
        if (isNegated) {
            buffer.append(" IS NOT NULL");
        } else {
            buffer.append(" IS NULL");
        }
        if (note != null && note.length() != 0) {
            buffer.append(note);
        }
        if (notEmpty) {
            buffer.append(')');
        }
        return buffer.toString();
    }
}

