/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational.composite;

import com.sas.iquery.dataretrieval.StoredProcessHandler;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.OverrideLocaleInterface;
import com.sas.iquery.execution.OverrideMLSLookupsInterface;
import com.sas.iquery.execution.OverrideStpNamesInterface;
import com.sas.iquery.execution.instructions.AbstractExecutionInstruction;
import com.sas.iquery.execution.instructions.AllocationInstruction;
import com.sas.iquery.execution.instructions.ConnectionInstruction;
import com.sas.iquery.execution.instructions.EngineTraceInstruction;
import com.sas.iquery.execution.instructions.ExecutionBlock;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution.instructions.ExecutionOptions;
import com.sas.iquery.execution.instructions.LocaleInstruction;
import com.sas.iquery.execution.instructions.MacroExecutionInstruction;
import com.sas.iquery.execution.instructions.OptionsInstruction;
import com.sas.iquery.execution.instructions.StoredProcessInstruction;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution.instructions.SubmitInstructionFactory;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.generation2.MetadataDataSource;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSource;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Governing;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.DataSourceTableImpl2;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.strategies.sas.oma.relational.IndependentExpressionGeneration;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLColumnAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLComponentAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFilterExaminerAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLFromAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLGroupByAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLHavingAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLOrderByAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLSelectAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLWhereAbstract;
import com.sas.iquery.strategies.sas.oma.relational.saslanguage.CodeStringMetadataDataSource;
import com.sas.iquery.strategies.sas.oma.relational.subqueries.RelationalMetadataDataSource;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.services.information.metadata.LogicalServerInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class SQLCompositeAbstract
extends SQLComponentAbstract
implements OverrideLocaleInterface,
OverrideMLSLookupsInterface,
OverrideStpNamesInterface {
    private List<SQLComponentAbstract> _compositeList = new ArrayList<SQLComponentAbstract>();
    protected SQLFilterExaminerAbstract _sqlFilterExaminer = null;
    private Locale _computationLocale = null;
    private StpNames _stpNames = null;
    private Map<String, MLSLookup> _mlsLookups = null;

    protected String getOutputTablePattern() throws GenerationException {
        return DataSelectionProcessorAbstract.getTempTablePattern();
    }

    protected SQLComponentAbstract _generateSelect() throws GenerationException {
        SQLSelectAbstract sqlSelect = (SQLSelectAbstract)this.getSQLFactory().createSQLSelect();
        DataSelectionProcessorAbstract dataSelectionProcessor = this.getDataSelectionProcessor();
        sqlSelect.setDataSelectionProcessor(dataSelectionProcessor);
        sqlSelect.setDataSelection(this._dataSelection);
        sqlSelect.setJoinGenerator(this.m_joinGenerator);
        sqlSelect.setDistinct(dataSelectionProcessor.isDistinct(this._dataSelection));
        List<FilterItem> havingFilters = this._sqlFilterExaminer.getHavingFilters();
        boolean hasAggFilters = havingFilters != null && !havingFilters.isEmpty();
        sqlSelect.setHasAggFilters(hasAggFilters);
        if (dataSelectionProcessor.isTSSQL()) {
            List<DataItem> items = this._dataSelection.getEffectiveResultItems();
            for (DataItem di : items) {
                if (!GenerationUtil.isInvalidTSSQL(this._dataSelection, di)) continue;
                dataSelectionProcessor.disableTSSQL();
                break;
            }
        }
        if (dataSelectionProcessor.isTSSQL()) {
            boolean hasDetailed = false;
            boolean hasSummary = false;
            List<SelectedItem> items = this._dataSelection.getSelectedItems();
            for (SelectedItem si : items) {
                boolean detailed;
                Role role = si.getRole();
                DataItem di = si.getItem();
                boolean isNeeded = dataSelectionProcessor.isNeededForPostProcess(this._dataSelection, di, role);
                if (!isNeeded) continue;
                DataItemActionType usage = di.getUsage();
                boolean bl = detailed = usage == null || usage == DataItemActionType.USAGE_DETAIL;
                if (detailed) {
                    hasDetailed = true;
                    continue;
                }
                hasSummary = true;
            }
            if (hasDetailed && hasSummary) {
                dataSelectionProcessor.disableTSSQL();
            }
        }
        sqlSelect.prepareSQL();
        this.setGroupByIdentifierPositions(sqlSelect.getGroupByIdentifierPositions());
        List<SQLColumnAbstract> sqlColumns = sqlSelect.getSQLColumns();
        if (this.getSQLColumns().isEmpty()) {
            this.setSQLColumns(sqlColumns);
        }
        return sqlSelect;
    }

    protected SQLComponentAbstract _generateFrom() throws GenerationException {
        SQLFromAbstract sqlFrom = (SQLFromAbstract)this.getSQLFactory().createSQLFrom();
        sqlFrom.setDataSelectionProcessor(this.getDataSelectionProcessor());
        sqlFrom.setDataSelection(this._dataSelection);
        sqlFrom.prepareSQL();
        this.setCrossJoinConditionsText(sqlFrom.getCrossJoinConditionsText());
        this.m_joinGenerator = sqlFrom.getJoinGenerator();
        return sqlFrom;
    }

    protected SQLComponentAbstract _examineFilters() throws GenerationException {
        this._sqlFilterExaminer = (SQLFilterExaminerAbstract)this.getSQLFactory().createSQLFilterExaminer();
        this._sqlFilterExaminer.setDataSelection(this._dataSelection);
        this._sqlFilterExaminer.setDataSelectionProcessor(this.getDataSelectionProcessor());
        this._sqlFilterExaminer.examineFilters();
        return this._sqlFilterExaminer;
    }

    protected SQLComponentAbstract _generateWhere() throws GenerationException {
        SQLWhereAbstract sqlWhere = (SQLWhereAbstract)this.getSQLFactory().createSQLWhere();
        sqlWhere.setDataSelection(this._dataSelection);
        sqlWhere.setDataSelectionProcessor(this.getDataSelectionProcessor());
        sqlWhere.setFilterList(this._sqlFilterExaminer.getWhereFilters());
        sqlWhere.setJoinGenerator(this.m_joinGenerator);
        List<FilterItem> havingFilters = this._sqlFilterExaminer.getHavingFilters();
        boolean hasAggFilters = havingFilters != null && !havingFilters.isEmpty();
        sqlWhere.setHasAggFilters(hasAggFilters);
        sqlWhere.setCrossJoinConditionsText(this.getCrossJoinConditionsText());
        sqlWhere.prepareSQL();
        return sqlWhere;
    }

    protected SQLComponentAbstract _generateHaving() throws GenerationException {
        SQLHavingAbstract sqlHaving = (SQLHavingAbstract)this.getSQLFactory().createSQLHaving();
        sqlHaving.setDataSelection(this._dataSelection);
        sqlHaving.setDataSelectionProcessor(this.getDataSelectionProcessor());
        sqlHaving.setFilterList(this._sqlFilterExaminer.getHavingFilters());
        sqlHaving.setJoinGenerator(this.m_joinGenerator);
        sqlHaving.prepareSQL();
        return sqlHaving;
    }

    protected SQLComponentAbstract _generateGroupBy() throws GenerationException {
        SQLGroupByAbstract sqlGroupBy = (SQLGroupByAbstract)this.getSQLFactory().createSQLGroupBy();
        sqlGroupBy.setDataSelection(this._dataSelection);
        sqlGroupBy.setDataSelectionProcessor(this.getDataSelectionProcessor());
        sqlGroupBy.setJoinGenerator(this.m_joinGenerator);
        sqlGroupBy.setGroupByIdentifierPositions(this.getGroupByIdentifierPositions());
        sqlGroupBy.prepareSQL();
        this.setByGroupItems(sqlGroupBy.getByGroupItems());
        return sqlGroupBy;
    }

    protected SQLComponentAbstract _generateOrderBy() throws GenerationException {
        SQLOrderByAbstract sqlOrderBy = (SQLOrderByAbstract)this.getSQLFactory().createSQLOrderBy();
        sqlOrderBy.setDataSelection(this._dataSelection);
        sqlOrderBy.setDataSelectionProcessor(this.getDataSelectionProcessor());
        sqlOrderBy.setJoinGenerator(this.m_joinGenerator);
        sqlOrderBy.prepareSQL();
        return sqlOrderBy;
    }

    public ExecutionInstructionInterface createInstruction(String sqlStr) throws GenerationException {
        ExecutionBlock executionBlock = new ExecutionBlock();
        MetadataDataSource dataSource = this.createMetadataDataSource();
        LogicalServerInterface logicalServer = null;
        try {
            logicalServer = dataSource.getLogicalServerInterface();
        }
        catch (MetadataException e) {
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLCompositeAbstract.createInstruction.MetadataException.txt", new Object[0]), (Throwable)e);
        }
        this.generatePrepareLogs(executionBlock, dataSource);
        StoredProcessHandler storedProcessHandler = new StoredProcessHandler(this._dataSelection);
        ConnectionInstruction connection = new ConnectionInstruction(this._dataSelection, logicalServer);
        executionBlock.addInstruction(connection);
        this.generateLocaleInstruction(executionBlock);
        this.generateEngineTraceInstruction(executionBlock);
        ExecutionOptions executionOptions = this.createExecutionOptions(dataSource);
        this.generateOptionsInstruction(executionBlock, executionOptions);
        this.generateAllocationInstruction(executionBlock, dataSource);
        this.generateMacroExecutionInstructions(executionBlock, dataSource);
        if (storedProcessHandler.hasStoredProcess()) {
            this.generateStoredProcessInstruction(executionBlock, storedProcessHandler);
        }
        this.generateCodeInstructions(executionBlock, sqlStr, executionOptions);
        return executionBlock;
    }

    private void generateMacroExecutionInstructions(ExecutionBlock executionBlock, MetadataDataSource dataSource) {
        IndependentExpressionGeneration ieg = null;
        DataSelectionProcessorAbstract dsproc = this.getDataSelectionProcessor();
        if (dsproc != null) {
            ieg = dsproc.getIndependentExpressionGenerator();
        }
        MacroExecutionInstruction options = new MacroExecutionInstruction(ieg);
        executionBlock.addInstruction(options);
    }

    private void generateStoredProcessInstruction(ExecutionBlock executionBlock, StoredProcessHandler storedProcessHandler) {
        StoredProcessInstruction storedProcessInstruction = new StoredProcessInstruction(storedProcessHandler);
        executionBlock.addInstruction(storedProcessInstruction);
    }

    protected void generateAllocationInstruction(ExecutionBlock executionBlock, MetadataDataSource dataSource) throws GenerationException {
        List<String> allocList = dataSource.getLibraryAllocationStatements();
        for (String statement : allocList) {
            AllocationInstruction alloc = new AllocationInstruction(statement);
            executionBlock.addInstruction(alloc);
        }
    }

    private void generateLocaleInstruction(ExecutionBlock executionBlock) {
        Locale originalComputationLocale = LocaleUtilities.getDefaultComputationalLocale(this._dataSelection);
        Locale effectiveComputationLocale = GenerationUtil.getEffectiveComputationalLocale(this._dataSelection, this);
        LocaleInstruction loc = new LocaleInstruction(effectiveComputationLocale, originalComputationLocale);
        executionBlock.addInstruction(loc);
    }

    public void generateEngineTraceInstruction(ExecutionBlock executionBlock) {
        EngineTraceInstruction engineTrace = new EngineTraceInstruction();
        if (engineTrace.toString().length() != 0) {
            executionBlock.addInstruction(engineTrace);
        }
    }

    private void generateOptionsInstruction(ExecutionBlock executionBlock, ExecutionOptions executionOptions) throws GenerationException {
        OptionsInstruction options = new OptionsInstruction(executionOptions);
        executionBlock.addInstruction(options);
    }

    public ExecutionOptions createExecutionOptions(MetadataDataSource dataSource) throws GenerationException {
        ExecutionOptions executionOptions = new ExecutionOptions();
        boolean isFormattingApplied = !this._dataSelection.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
        executionOptions.setFormatted(isFormattingApplied);
        List<Governing> governingOptions = this._dataSelection.getEffectiveRules(Governing.class);
        if (governingOptions != null && !governingOptions.isEmpty()) {
            Governing governing = governingOptions.get(0);
            executionOptions.setMaxOutputRows(governing.getOutputObservations());
            executionOptions.setMaxInputRows(governing.getInputObservations());
        }
        DataSelectionProcessorAbstract processor = this.getDataSelectionProcessor();
        boolean useValidVarNameAny = processor.getUseValidVarNameAny();
        boolean useValidMemNameExtend = processor.getUseValidMemNameExtend();
        boolean isSpecCharEnabled = false;
        try {
            for (DataSource ds : dataSource.getUniqueDataSources()) {
                DataSourceTableImpl2 dst;
                if (!(ds instanceof DataSourceTableImpl2) || !(dst = (DataSourceTableImpl2)ds).isCaseEnabled() && !dst.isSpecialCharEnabled()) continue;
                isSpecCharEnabled = true;
                break;
            }
        }
        catch (MetadataException e) {
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("SQLCompositeAbstract.createInstruction.SpecCharException.txt", new Object[0]), (Throwable)e);
        }
        executionOptions.setUseValidVarNameAny(useValidVarNameAny || isSpecCharEnabled);
        executionOptions.setUseValidMemNameExtend(useValidMemNameExtend || isSpecCharEnabled);
        return executionOptions;
    }

    protected void generateCodeInstructions(ExecutionBlock executionBlock, String sasCode, ExecutionOptions executionOptions) throws GenerationException {
        DataSelectionProcessorAbstract dsProcessor = this.getDataSelectionProcessor();
        String outputTableName = dsProcessor.getTempTableName(this._dataSelection);
        dsProcessor.getTempTableIsView(this._dataSelection);
        String outputTablePattern = this.getOutputTablePattern();
        executionOptions.setMaxOutputRows(-1);
        AbstractExecutionInstruction instruction = SubmitInstructionFactory.getSubmitInstruction(sasCode, outputTableName, outputTablePattern, executionOptions, this._dataSelection);
        executionBlock.addInstruction(instruction);
    }

    @Override
    public String writeSQL() {
        return SQLCompositeAbstract.writeCompositeList(this.getCompositeList());
    }

    protected MetadataDataSource createMetadataDataSource() throws GenerationException {
        boolean isOmaTable;
        Export export;
        boolean procLasr = false;
        List<ExportRule> rules = this.getDataSelectionProcessor().getDataSelection().getEffectiveRules(ExportRule.class);
        Export export2 = export = rules.isEmpty() ? null : rules.get(0).getExport();
        boolean bl = export == null ? false : (isOmaTable = export.getUsage() == ExportType.LASR_OMA_TABLE);
        if (isOmaTable) {
            procLasr = true;
        }
        RelationalMetadataDataSource dataSource = procLasr ? new CodeStringMetadataDataSource(this.getDataSelectionProcessor()) : new RelationalMetadataDataSource(this.getDataSelectionProcessor());
        try {
            ((MetadataDataSource)dataSource).initializeData();
        }
        catch (MetadataException e) {
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("RelationalSASComposite.createMetadataDataSource.MetadataException.txt", new Object[0]), (Throwable)e);
        }
        return dataSource;
    }

    protected void addComponent(SQLComponentAbstract sqlComponent) {
        this._compositeList.add(sqlComponent);
    }

    public List<SQLComponentAbstract> getCompositeList() {
        return this._compositeList;
    }

    @Override
    public Locale getComputationalLocale() {
        return this._computationLocale;
    }

    @Override
    public void setComputationalLocale(Locale overrideComputationalLocale) {
        this._computationLocale = overrideComputationalLocale;
    }

    @Override
    public StpNames getStpNames() {
        return this._stpNames;
    }

    @Override
    public void setStpNames(StpNames stpNames) {
        this._stpNames = stpNames;
    }

    @Override
    public Map<String, MLSLookup> getMLSLookups() {
        return this._mlsLookups;
    }

    @Override
    public void setMLSLookups(Map<String, MLSLookup> mlsLookupsByColumnName) {
        this._mlsLookups = mlsLookupsByColumnName;
    }

    private void generatePrepareLogs(ExecutionBlock executionBlock, MetadataDataSource dataSource) throws GenerationException {
        final List<String> logs = dataSource.getQueryTablesPrepareLogs();
        if (logs != null && logs.size() > 0) {
            AbstractExecutionInstruction prepareLogs = new AbstractExecutionInstruction(){

                @Override
                public void execute() throws ExecutionException {
                    ExecutionContext context = this.getExecutionContext();
                    for (String log : logs) {
                        context.appendRunningLog(log);
                    }
                }

                @Override
                public String getText() throws GenerationException, MetadataException {
                    return "/* using previously prepared tables */";
                }
            };
            executionBlock.addInstruction(prepareLogs);
        }
    }
}

