/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.ExportType;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.strategies.sas.oma.olap.AbstractCodeGenerator;
import com.sas.iquery.strategies.sas.oma.relational.composite.SQLCompositeAbstract;
import com.sas.iquery.strategies.sas.oma.relational.composite.sas.SQLSASFactory;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SQLGeneration
extends AbstractCodeGenerator {
    protected SQLSASFactory _factory = new SQLSASFactory();
    private static final Logger _logger = LogManager.getLogger(SQLGeneration.class);

    @Override
    public ExecutionInstructionInterface generateInstructions(DataSelection selection, String uniqueID) throws GenerationException {
        Export export;
        this.checkValid(selection);
        SQLCompositeAbstract sqlComposite = this._factory.createSQLComposite(selection);
        sqlComposite.setComputationalLocale(this.getComputationalLocale());
        sqlComposite.setStpNames(this.getStpNames());
        sqlComposite.setMLSLookups(this.getMLSLookups());
        List<ExportRule> exportRules = selection.getEffectiveRules(ExportRule.class);
        Export export2 = export = exportRules.isEmpty() ? null : exportRules.get(0).getExport();
        if (export != null && export.getUsage() == ExportType.LASR_RESULT_SET && export.isViewOnly()) {
            sqlComposite.getDataSelectionProcessor().setTempTableIsView(selection, true);
        }
        sqlComposite.prepareSQL();
        String writeSQL = sqlComposite.writeSQL();
        ExecutionInstructionInterface instruction = sqlComposite.createInstruction(writeSQL);
        return instruction;
    }

    protected void checkValid(DataSelection selection) throws GenerationException {
        List<Reason> reasons = selection.getReasonsNotValid();
        if (reasons != null && reasons.size() > 0) {
            String reasonMessage = null;
            if (_logger.isEnabled(Level.ERROR)) {
                Locale viewerLocale = LocaleUtilities.getDefaultViewerLocale(selection);
                for (Reason reason : reasons) {
                    reasonMessage = reason.getReasonString(viewerLocale);
                    _logger.error(reasonMessage);
                }
            }
            MessageFormatter baseMessage = IQDataServicesResourceBundle.getMessageFormatter("SQLGeneration.checkValid.invalid.txt", new Object[0]);
            MessageFormatter reasonListFormatter = Reason.getMessageFormatter(baseMessage, reasons, false);
            GenerationException e = new GenerationException(reasonListFormatter, reasons);
            throw e;
        }
    }
}

