/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.relational;

import com.sas.entities.EntityInterface;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.StrategyInterface;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ExecutionProcessor;
import com.sas.iquery.execution.OverrideConnectionInterface;
import com.sas.iquery.execution.OverrideLocaleInterface;
import com.sas.iquery.execution.OverrideMLSLookupsInterface;
import com.sas.iquery.execution.OverrideStpNamesInterface;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CreateTableDataSelection;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Export;
import com.sas.iquery.metadata.business.ExportRule;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.strategies.sas.oma.AbstractStrategy;
import com.sas.iquery.strategies.sas.oma.relational.CodeGenerationFactory;
import com.sas.iquery.strategies.sas.oma.relational.CodeGenerationInterface;
import com.sas.iquery.strategies.sas.oma.summaryrolap.SummaryROLAPGeneration;
import com.sas.iquery.util.DataSelectionUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.connection.ConnectionInterface;
import java.util.List;

public class RelationalStrategy
extends AbstractStrategy
implements StrategyInterface,
OverrideConnectionInterface {
    private ConnectionInterface _connection = null;
    private IWorkspace _workspace = null;
    private CodeGenerationFactory _generationFactory = new CodeGenerationFactory();

    private AbstractStrategy retrieveDelegateStrategy(BusinessQuery businessQuery) throws IntelligentQueryException {
        CodeGenerationInterface codeGenerator;
        try {
            codeGenerator = this._generationFactory.selectCodeGenerator((DataSelection)businessQuery, this.getRetrievalPolicy());
        }
        catch (GenerationException e) {
            throw new IntelligentQueryException(IQDataServicesResourceBundle.getMessageFormatter("RelationalStrategy.getPhysicalQuery.GenerationException.txt", new Object[0]), (Throwable)e);
        }
        RelationalStrategy delegateStrategy = null;
        delegateStrategy = codeGenerator instanceof SummaryROLAPGeneration ? new ROLAPStrategy(codeGenerator) : new SQLStrategy(codeGenerator);
        delegateStrategy.setComputationalLocale(this.getComputationalLocale());
        delegateStrategy.setStpNames(this.getStpNames());
        delegateStrategy.setMLSLookups(this.getMLSLookups());
        return delegateStrategy;
    }

    @Override
    public ExecutionInstructionInterface createInstructions(DataSelection businessQuery, EntityInterface entity) throws IQueryServicesException {
        this.checkValid(businessQuery);
        businessQuery = this.checkValidQueryForDataAcquisition(businessQuery);
        AbstractStrategy delegateStrategy = null;
        try {
            delegateStrategy = this.retrieveDelegateStrategy(businessQuery);
        }
        catch (IntelligentQueryException e) {
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("RelationalStrategy.createInstructions.IntelligentQueryException.txt", new Object[0]), (Throwable)e);
        }
        delegateStrategy.setComputationalLocale(this.getComputationalLocale());
        delegateStrategy.setStpNames(this.getStpNames());
        delegateStrategy.setMLSLookups(this.getMLSLookups());
        ExecutionInstructionInterface instructons = delegateStrategy.createInstructions(businessQuery, entity);
        return instructons;
    }

    @Override
    public String getPhysicalQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
        AbstractStrategy delegateStrategy = this.retrieveDelegateStrategy(businessQuery);
        delegateStrategy.setComputationalLocale(this.getComputationalLocale());
        delegateStrategy.setStpNames(this.getStpNames());
        delegateStrategy.setMLSLookups(this.getMLSLookups());
        return delegateStrategy.getPhysicalQuery(businessQuery);
    }

    private String getAbstractStrategyPhysicalQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
        return super.getPhysicalQuery(businessQuery);
    }

    @Override
    public String getResultSetStructure(BusinessQuery businessQuery, RetrievalPolicy retrievalPolicy) throws IntelligentQueryException {
        DataSelection model = (DataSelection)businessQuery;
        try {
            this.checkValid(model);
        }
        catch (GenerationException e) {
            throw new IntelligentQueryException(IQDataServicesResourceBundle.getMessageFormatter("RelationalStrategy.getResultSetStructure.GenerationException.txt", new Object[0]), (Throwable)e);
        }
        AbstractStrategy delegateStrategy = this.retrieveDelegateStrategy(businessQuery);
        return delegateStrategy.getResultSetStructure(businessQuery, retrievalPolicy);
    }

    private void checkValid(DataSelection model) throws GenerationException {
        int columnsCount = 0;
        List<DataItem> resultItems = model.getResultItems();
        try {
            for (DataItem item : resultItems) {
                Role role = model.getResultItemRole(item);
                if (role != Role.COLUMN) continue;
                ++columnsCount;
            }
        }
        catch (MetadataException e) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("RelationalStrategy.checkValid.MetadataException.txt", new Object[0]);
            throw new GenerationException(mft, (Throwable)e);
        }
        if (columnsCount == 0) {
            // empty if block
        }
    }

    private DataSelection checkValidQueryForDataAcquisition(DataSelection businessQuery) throws GenerationException, MetadataException {
        DataSelection dataSelection = businessQuery;
        Export export = null;
        List<ExportRule> returnList = businessQuery.getEffectiveRules(ExportRule.class);
        if (!returnList.isEmpty()) {
            export = returnList.get(0).getExport();
        }
        if (export != null) {
            if (dataSelection instanceof CreateTableDataSelection) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("RelationalStrategy.checkValid.MetadataException.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            if (export.isAllDetail() || export.isDetailWithFilters()) {
                dataSelection = DataSelectionUtilities.convertDataSelectionToDetail(businessQuery, this);
            }
            if (export.isCreateTableRequiredForExport()) {
                dataSelection = export.createTableDataSelection(dataSelection, this);
            }
        }
        return dataSelection;
    }

    @Override
    protected ExecutionProcessor newExecutionProcessor(RetrievalPolicy retrievalPolicy) {
        ExecutionProcessor processor = super.newExecutionProcessor(retrievalPolicy);
        if (processor instanceof OverrideConnectionInterface) {
            ConnectionInterface overrideConnectionInterface;
            IWorkspace overrideWorkspace = this.getWorkspace();
            if (overrideWorkspace != null) {
                processor.setWorkspace(overrideWorkspace);
            }
            if ((overrideConnectionInterface = this.getConnection()) != null) {
                processor.setConnection(overrideConnectionInterface);
            }
        }
        return processor;
    }

    @Override
    public ConnectionInterface getConnection() {
        return this._connection;
    }

    @Override
    public IWorkspace getWorkspace() {
        return this._workspace;
    }

    @Override
    public void setConnection(ConnectionInterface connection) {
        this._connection = connection;
    }

    @Override
    public void setWorkspace(IWorkspace workspace) {
        this._workspace = workspace;
    }

    public class ROLAPStrategy
    extends RelationalStrategy {
        final CodeGenerationInterface _codeGenerator;

        public ROLAPStrategy(CodeGenerationInterface codeGenerator) throws DataRetrievalException {
            this._codeGenerator = codeGenerator;
        }

        @Override
        public ExecutionInstructionInterface createInstructions(DataSelection model, EntityInterface entity) throws GenerationException {
            if (this._codeGenerator instanceof OverrideLocaleInterface) {
                ((OverrideLocaleInterface)((Object)this._codeGenerator)).setComputationalLocale(this.getComputationalLocale());
            }
            if (this._codeGenerator instanceof OverrideStpNamesInterface) {
                ((OverrideStpNamesInterface)((Object)this._codeGenerator)).setStpNames(this.getStpNames());
            }
            if (this._codeGenerator instanceof OverrideMLSLookupsInterface) {
                ((OverrideMLSLookupsInterface)((Object)this._codeGenerator)).setMLSLookups(this.getMLSLookups());
            }
            ExecutionInstructionInterface instruction = this._codeGenerator.generateInstructions(model, this._generateUniqueID());
            return instruction;
        }

        @Override
        public String getPhysicalQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
            return RelationalStrategy.this.getAbstractStrategyPhysicalQuery(businessQuery);
        }

        @Override
        public String getResultSetStructure(BusinessQuery businessQuery, RetrievalPolicy retrievalPolicy) throws IntelligentQueryException {
            return "MultiDimensional";
        }
    }

    public class SQLStrategy
    extends RelationalStrategy {
        final CodeGenerationInterface _codeGenerator;

        public SQLStrategy(CodeGenerationInterface codeGenerator) throws DataRetrievalException {
            this._codeGenerator = codeGenerator;
        }

        @Override
        public ExecutionInstructionInterface createInstructions(DataSelection model, EntityInterface entity) throws GenerationException {
            if (this._codeGenerator instanceof OverrideLocaleInterface) {
                ((OverrideLocaleInterface)((Object)this._codeGenerator)).setComputationalLocale(this.getComputationalLocale());
            }
            if (this._codeGenerator instanceof OverrideStpNamesInterface) {
                ((OverrideStpNamesInterface)((Object)this._codeGenerator)).setStpNames(this.getStpNames());
            }
            if (this._codeGenerator instanceof OverrideMLSLookupsInterface) {
                ((OverrideMLSLookupsInterface)((Object)this._codeGenerator)).setMLSLookups(this.getMLSLookups());
            }
            ExecutionInstructionInterface instruction = this._codeGenerator.generateInstructions(model, this._generateUniqueID());
            return instruction;
        }

        @Override
        public String getPhysicalQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
            return RelationalStrategy.this.getAbstractStrategyPhysicalQuery(businessQuery);
        }

        @Override
        public String getResultSetStructure(BusinessQuery businessQuery, RetrievalPolicy retrievalPolicy) throws IntelligentQueryException {
            return "Tabular";
        }
    }
}

