/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.Locale;

public class TimeRangeFilter {
    private static String DEFAULTMEM = ".HIERARCHY.DEFAULTMEMBER)";

    public static String getMDXExpression(DataItemTimeRangeFilter step, DataSelection dataSelection) throws GenerationException {
        return TimeRangeFilter.getExpression(step.getLevelName(), step.getStartMember(), step.getEndMember(), dataSelection, step.getMemberLocale());
    }

    public static String getMDXExpression(TimeRangeFilterExpression expression, DataSelection dataSelection) throws GenerationException {
        return TimeRangeFilter.getExpression(expression.getLevelName(), expression.getStartMember(), expression.getEndMember(), dataSelection, expression.getMemberLocale());
    }

    public static String getExpression(ExpressionInterface levelI, ExpressionInterface startDateI, ExpressionInterface endDateI, DataSelection dataSelection, Locale locale) throws GenerationException {
        String startDate = MDXGenerationUtil.getExpressionValue(startDateI, dataSelection, locale);
        String endDate = MDXGenerationUtil.getExpressionValue(endDateI, dataSelection, locale);
        String level = MDXGenerationUtil.getExpressionValue(levelI, dataSelection, locale);
        StringBuilder MDXExpression = new StringBuilder();
        if (level != null && endDate == null && startDate == null) {
            MDXExpression.append(level).append(".Members");
            return MDXExpression.toString();
        }
        if (level == null && endDate == null && startDate == null) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("TimeRangeFilterNull.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        if (startDate != null) {
            MDXExpression.append("( ").append(startDate);
        } else if (level != null && endDate != null && startDate == null) {
            MDXExpression.append("(OPENINGPERIOD(").append(level).append(",").append(level).append(DEFAULTMEM);
        }
        MDXExpression.append(" : ");
        if (endDate != null) {
            MDXExpression.append(endDate);
        } else if (level != null && startDate != null && endDate == null) {
            MDXExpression.append("CLOSINGPERIOD(").append(level).append(",").append(level).append(DEFAULTMEM);
        }
        MDXExpression.append(")");
        return MDXExpression.toString();
    }
}

