/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFirstLastPeriodsFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimeFirstLastPeriodsFilter {
    private static final Logger _logger = LogManager.getLogger(TimeFirstLastPeriodsFilter.class);

    public static String getMDXExpression(DataItemTimeFirstLastPeriodsFilter step, DataSelection dataSelection) throws GenerationException {
        return TimeFirstLastPeriodsFilter.getExpression(step.getLevel(), step.getPeriods(), step.getSearchDirection(), dataSelection);
    }

    public static String getMDXExpression(TimeFilterFirstLastPeriodsExpression expression, DataSelection dataSelection) throws GenerationException {
        return TimeFirstLastPeriodsFilter.getExpression(expression.getLevel(), expression.getPeriods(), expression.getSearchDirection(), dataSelection);
    }

    private static String getExpression(ExpressionInterface level, ExpressionInterface periodsI, String searchDirection, DataSelection dataSelection) throws GenerationException {
        StringBuilder MDXExpression = new StringBuilder();
        String levelName = MDXGenerationUtil.getExpressionValue(level, dataSelection, null);
        String periodString = "0";
        if (periodsI != null) {
            periodString = MDXGenerationUtil.getExpressionValue(periodsI, dataSelection, null);
        }
        int nPeriods = Integer.parseInt(periodString);
        MDXExpression.append("LASTPERIODS(");
        if (searchDirection == null) {
            _logger.debug("No search direction is defined. continue processing");
        } else if (searchDirection != null) {
            if (searchDirection.equalsIgnoreCase("FORWARD")) {
                if (nPeriods > 0) {
                    MDXExpression.append("-");
                }
                MDXExpression.append(nPeriods).append(", ").append("OPENINGPERIOD(");
            } else if (searchDirection.equalsIgnoreCase("BACKWARD")) {
                MDXExpression.append(nPeriods).append(", ").append("CLOSINGPERIOD(");
            }
        }
        MDXExpression.append(levelName).append(", ");
        MDXExpression.append(levelName).append(".HIERARCHY.DEFAULTMEMBER").append(")").append(")");
        return MDXExpression.toString();
    }
}

