/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepFilterInterface;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryTupleFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFirstLastPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNParallelPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPItemType;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.strategies.sas.oma.olapv2.BusinessQueryTotal;
import com.sas.iquery.strategies.sas.oma.olapv2.step.BusinessQueryFilterDataBased;
import com.sas.iquery.strategies.sas.oma.olapv2.step.BusinessQueryFilterRank;
import com.sas.iquery.strategies.sas.oma.olapv2.step.BusinessQueryFilterTuple;
import com.sas.iquery.strategies.sas.oma.olapv2.step.DataBasedFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.MemberFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.MemberPropertyFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.NavigationFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.RankFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeFirstLastPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeNParallelPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeNPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.TimeRangeFilter;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StepManager {
    private CompoundStep _compoundStep;
    private String _condition = null;
    private String _dataBasedFilterMDX = null;
    private DataItem _dataItem;
    private Map _drillMemberList = null;
    private int _endOfSteps;
    private boolean _isMemberFilterOn = false;
    private boolean _isMultiSortWithQueryFilter = false;
    private boolean _isNegate = false;
    private String _memberFilterMDX = null;
    private String _memberPropertyFilterMDX = null;
    private String _navigationFilterMDX = null;
    private StepInterface _nextStepInCompoundStep = null;
    private OLAPValues _olapValues;
    private StepInterface _previousStepInCompoundStep = null;
    private String _rankFilterMDX = null;
    private Role _role = Role.COLUMN;
    private List<StepInterface> _stepsBeingProcessed;
    private Map _measureBeingRankedMDXVar = null;
    private List _listOfBQTupleFilters = new ArrayList();
    private List _listOfBQRankFilters = new ArrayList();
    private Map _listOfTupleFiltersCombined = new LinkedHashMap();
    private String _measureInQuery = null;
    private boolean _isMeasureOnBottom = false;
    private boolean _specialDataBaseFilterCondition = false;
    private String _axisDefinition = "ROW_AXIS";
    private static final Logger _logger = LogManager.getLogger(StepManager.class);

    public StepManager(CompoundStep compoundStep) {
        int stepNumber;
        this._dataItem = null;
        this._compoundStep = compoundStep;
        this._stepsBeingProcessed = compoundStep.getSteps();
        this._endOfSteps = stepNumber = this._stepsBeingProcessed.size();
    }

    public StepManager(CompoundStep compoundStep, int stepNumber) {
        this._dataItem = null;
        this._compoundStep = compoundStep;
        this._stepsBeingProcessed = compoundStep.getSteps();
        this._endOfSteps = stepNumber;
    }

    public StepManager(DataItem dataItem) {
        int stepNumber;
        this._dataItem = dataItem;
        this._compoundStep = null;
        this._stepsBeingProcessed = dataItem.getSteps();
        this._endOfSteps = stepNumber = this._stepsBeingProcessed.size();
    }

    public StepManager(DataItem dataItem, int stepNumber) {
        this._dataItem = dataItem;
        this._compoundStep = null;
        this._endOfSteps = stepNumber;
    }

    public StepManager(DataSelection ds, Role role) {
        int stepNumber;
        this._role = role;
        this._stepsBeingProcessed = ds.getSteps(role);
        this._endOfSteps = stepNumber = this._stepsBeingProcessed.size();
    }

    private String completeStepMDX(String stepExpression, int actionType, StepFilterInterface step, String currentExpression) {
        StringBuilder MDXExpression = new StringBuilder();
        switch (actionType) {
            case 1: {
                MDXExpression.append(", ").append(stepExpression);
                break;
            }
            case 4: {
                MDXExpression.append("EXCEPT(").append(currentExpression).append(", ").append(stepExpression).append(")");
                break;
            }
            case 3: {
                MDXExpression = new StringBuilder(stepExpression);
                break;
            }
            case 5: {
                MDXExpression.append("INTERSECT(").append(currentExpression).append(", ").append(stepExpression).append(")");
                break;
            }
            case 7: {
                MDXExpression.append("UNION(").append(currentExpression).append(", ").append(stepExpression).append(")");
                break;
            }
            case 2: {
                MDXExpression.append(", ").append(currentExpression);
                break;
            }
            default: {
                MDXExpression = new StringBuilder(stepExpression);
            }
        }
        return MDXExpression.toString();
    }

    public String generateMDX(DataSelection dataSelection, String currentExpression) throws GenerationException {
        StringBuilder MDXExpression = new StringBuilder();
        this._drillMemberList = new LinkedHashMap();
        String stepExpression = null;
        stepExpression = this._dataItem == null && this._compoundStep != null ? this.processSteps(dataSelection, this._compoundStep, currentExpression) : (this._dataItem == null && this._role != null ? this.processSteps(dataSelection, currentExpression) : this.processSteps(dataSelection, this._dataItem, currentExpression));
        MDXExpression.append(stepExpression);
        if (!this._drillMemberList.isEmpty()) {
            String finalizeSteps = this.processRecursiveMDX(MDXExpression.toString());
            return finalizeSteps;
        }
        return MDXExpression.toString();
    }

    public boolean isMemberFilterOn() {
        return this._isMemberFilterOn;
    }

    public boolean isMultiSortWithQueryFilter() {
        return this._isMultiSortWithQueryFilter;
    }

    public void setAxisDefinition(String axisDefinition) {
        this._axisDefinition = axisDefinition;
    }

    private String processRecursiveMDX(String currentExpression) {
        StringBuilder tempExpression = new StringBuilder();
        tempExpression.append("EXCEPT(DRILLDOWNMEMBER({").append(currentExpression).append("}").append(", ");
        Iterator iterator = this._drillMemberList.entrySet().iterator();
        StringBuilder drillMemberExpression = new StringBuilder("{");
        while (iterator.hasNext()) {
            String key = (String)iterator.next().getKey();
            drillMemberExpression.append(key).append(", ");
        }
        drillMemberExpression.setLength(drillMemberExpression.length() - 2);
        drillMemberExpression.append("}");
        tempExpression.append((CharSequence)drillMemberExpression).append(", RECURSIVE), ").append((CharSequence)drillMemberExpression).append(")");
        return tempExpression.toString();
    }

    public void setBottomExcludeMissingMeasures(Map measureBeingRankedMDXVar) {
        this._measureBeingRankedMDXVar = measureBeingRankedMDXVar;
    }

    public void setMeasures(String measures, boolean isMeasureOnBottom) {
        this._measureInQuery = measures;
        this._isMeasureOnBottom = isMeasureOnBottom;
    }

    public void setSpecialDataBaseFilterCondition(boolean specialDataBaseFilterCondition) {
        this._specialDataBaseFilterCondition = specialDataBaseFilterCondition;
    }

    private String processStep(DataSelection dataSelection, StepInterface step, String currentExpression, String initialExpression, DataItem dataItem) throws GenerationException {
        block118: {
            int paren = 0;
            int sep = 0;
            StringBuilder MDXExpression = new StringBuilder();
            if (step instanceof CompoundStep) {
                CompoundStep cStep = (CompoundStep)step;
                StepManager sm = new StepManager(cStep);
                sm.setOLAPValue(this._olapValues);
                String compoundExpression = sm.generateMDX(dataSelection, currentExpression);
                return compoundExpression;
            }
            StepFilterInterface sf = (StepFilterInterface)step;
            int stepActionType = sf.getActionType();
            boolean specialOperation = false;
            if (stepActionType == 6 && step instanceof DataItemNavigationFilter) {
                specialOperation = true;
            }
            boolean applySeparator = false;
            boolean applyParenFirst = false;
            if (!specialOperation) {
                if (!this._drillMemberList.isEmpty()) {
                    currentExpression = this.processRecursiveMDX(currentExpression);
                    this._drillMemberList.clear();
                }
                if (step instanceof DataItemTimeFirstLastPeriodsFilter || step instanceof DataItemTimeNParallelPeriodsFilter || step instanceof DataItemTimeNPeriodsFilter || step instanceof DataItemTimeRangeFilter) {
                    if (this._compoundStep != null && this._previousStepInCompoundStep != null) {
                        if (this._isNegate) {
                            stepActionType = 4;
                        } else if (this._condition.equals("OR")) {
                            stepActionType = 7;
                        } else if (this._condition.equals("AND")) {
                            stepActionType = 5;
                        }
                    }
                    if (step instanceof DataItemTimeFirstLastPeriodsFilter) {
                        this._memberFilterMDX = TimeFirstLastPeriodsFilter.getMDXExpression((DataItemTimeFirstLastPeriodsFilter)step, dataSelection);
                    } else if (step instanceof DataItemTimeNParallelPeriodsFilter) {
                        this._memberFilterMDX = TimeNParallelPeriodsFilter.getMDXExpression((DataItemTimeNParallelPeriodsFilter)step, dataSelection);
                    } else if (step instanceof DataItemTimeNPeriodsFilter) {
                        this._memberFilterMDX = TimeNPeriodsFilter.getMDXExpression((DataItemTimeNPeriodsFilter)step, dataSelection);
                    } else if (step instanceof DataItemTimeRangeFilter) {
                        this._memberFilterMDX = TimeRangeFilter.getMDXExpression((DataItemTimeRangeFilter)step, dataSelection);
                    } else {
                        _logger.error("Step is not a valid RelativeTimeFilter step, filter ignored");
                    }
                    if (this._memberFilterMDX != null) {
                        String Expression = this.completeStepMDX(this._memberFilterMDX, stepActionType, sf, currentExpression);
                        MDXExpression.append(Expression);
                    }
                    currentExpression = MDXExpression.toString();
                    return currentExpression;
                }
                if (step instanceof DataItemDataBasedFilter) {
                    StringBuilder filterExp = new StringBuilder();
                    if (this._compoundStep != null) {
                        if (!(this._nextStepInCompoundStep instanceof DataItemDataBasedFilter)) {
                            filterExp.append("  FILTER({").append(initialExpression).append("}, ");
                            applySeparator = true;
                            ++paren;
                            applyParenFirst = true;
                            if (this._isNegate) {
                                filterExp.append(" NOT (");
                                ++paren;
                            }
                        }
                        if (this._previousStepInCompoundStep instanceof DataItemDataBasedFilter) {
                            filterExp.append(currentExpression);
                            filterExp.append(" ");
                            if (this._condition.equals("AND")) {
                                filterExp.append("AND");
                            }
                            if (this._condition.equals("OR")) {
                                filterExp.append("OR");
                            }
                            filterExp.append(" ");
                        } else if (this._previousStepInCompoundStep != null) {
                            if (this._condition.equals("OR")) {
                                stepActionType = 7;
                            } else if (this._condition.equals("AND")) {
                                stepActionType = 5;
                            }
                        }
                    } else {
                        filterExp.append(" FILTER({").append(currentExpression).append("}, ");
                        applySeparator = true;
                        ++paren;
                        if (this._isNegate) {
                            filterExp.append(" NOT (");
                            ++paren;
                        }
                    }
                    String filterExpStr = filterExp.toString();
                    this._dataBasedFilterMDX = DataBasedFilter.getMDXExpression(dataSelection, filterExpStr, (DataItemDataBasedFilter)step, this._olapValues);
                    if (applyParenFirst && (stepActionType == 7 || stepActionType == 5)) {
                        --paren;
                    }
                    if (this._dataBasedFilterMDX != null) {
                        String Expression = this.completeStepMDX(this._dataBasedFilterMDX, stepActionType, sf, currentExpression);
                        MDXExpression.append(Expression);
                        if (applySeparator) {
                            int i;
                            for (i = 0; i < paren; ++i) {
                                MDXExpression.append(")");
                            }
                            for (i = 0; i < sep; ++i) {
                                MDXExpression.append("}");
                            }
                            if (applyParenFirst && (stepActionType == 7 || stepActionType == 5)) {
                                MDXExpression.append(")");
                            }
                        }
                    }
                    currentExpression = MDXExpression.toString();
                    return currentExpression;
                }
                if (step instanceof DataItemMemberPropertiesFilter) {
                    int i;
                    StringBuilder filterExp = new StringBuilder();
                    Filter filter = (Filter)this._olapValues.getOLAPValue(dataItem, OLAPItemType.FILTER);
                    Filter filter1 = (Filter)this._olapValues.getOLAPValue(dataItem, OLAPItemType.FILTER);
                    MetadataInterface metaI = this._olapValues.getMetadataInterface();
                    String hierarchyName = this._olapValues.getOLAPValue(dataItem, OLAPItemType.HIERNAME).toString();
                    if (this._compoundStep != null) {
                        if (!(this._nextStepInCompoundStep instanceof DataItemDataBasedFilter)) {
                            filterExp.append(" { FILTER({").append(initialExpression).append("}, ");
                            applySeparator = true;
                            ++paren;
                            ++sep;
                            applyParenFirst = true;
                            if (this._isNegate) {
                                filterExp.append(" NOT (");
                                ++paren;
                            }
                        }
                        if (this._previousStepInCompoundStep instanceof DataItemDataBasedFilter) {
                            filterExp.append(currentExpression).append(" ");
                            if (this._condition.equals("AND")) {
                                filterExp.append("AND");
                            }
                            if (this._condition.equals("OR")) {
                                filterExp.append("OR");
                            }
                            filterExp.append(" ");
                        } else if (this._previousStepInCompoundStep != null) {
                            if (this._condition.equals("OR")) {
                                stepActionType = 7;
                            } else if (this._condition.equals("AND")) {
                                stepActionType = 5;
                            }
                        }
                    } else {
                        filterExp.append(" FILTER({").append(currentExpression).append("}, ");
                        applySeparator = true;
                        ++paren;
                        if (this._isNegate) {
                            filterExp.append(" NOT (");
                            ++paren;
                        }
                    }
                    String filterExpStr = filterExp.toString();
                    DataItemMemberPropertiesFilter pF = (DataItemMemberPropertiesFilter)step;
                    String propName = pF.getMemberPropertyName();
                    filter.setPropertyName(propName);
                    PropertyInterface propL = null;
                    Class<String> propDataType = null;
                    ArrayList<String> listOfLevels = new ArrayList<String>();
                    boolean continueOn = true;
                    try {
                        propL = metaI.getProperty(filter);
                        PropertyInterface[] props = metaI.getProperties(filter1);
                        if (props == null) {
                            if (_logger.isEnabled(Level.ERROR)) {
                                _logger.error(IQDataServicesResourceBundle.getStringResource("StepManagerCantGetProperty.txt"));
                            }
                            continueOn = false;
                        } else if (props.length == 0) {
                            if (_logger.isEnabled(Level.ERROR)) {
                                _logger.error(IQDataServicesResourceBundle.getStringResource("StepManagerCantGetProperty.txt"));
                            }
                            continueOn = false;
                        } else {
                            for (i = 0; i < props.length; ++i) {
                                LevelInterface l1;
                                HierarchyInterface h1;
                                String s1;
                                PropertyInterface p1 = props[i];
                                if (!propName.equalsIgnoreCase(p1.getName()) || !(s1 = (h1 = (l1 = p1.getLevel()).getHierarchy()).getUniqueName()).equalsIgnoreCase(hierarchyName)) continue;
                                String levelName = l1.getName();
                                listOfLevels.add(levelName);
                            }
                        }
                        if (propL == null) {
                            if (_logger.isEnabled(Level.ERROR)) {
                                _logger.error(IQDataServicesResourceBundle.getStringResource("StepManagerCantGetProperty.txt"));
                            }
                            propDataType = String.class;
                        } else {
                            propDataType = propL.getDataType();
                        }
                    }
                    catch (OLAPException e) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            _logger.error(IQDataServicesResourceBundle.getStringResource("StepManagerCantGetProperty.txt"), (Throwable)e);
                        }
                        continueOn = false;
                    }
                    if (continueOn) {
                        this._memberPropertyFilterMDX = MemberPropertyFilter.getMDXExpression(dataSelection, filterExpStr, (DataItemMemberPropertiesFilter)step, propDataType, dataItem, listOfLevels);
                    }
                    if (this._memberPropertyFilterMDX != null) {
                        String Expression = this.completeStepMDX(this._memberPropertyFilterMDX, stepActionType, sf, currentExpression);
                        MDXExpression.append(Expression);
                        if (applySeparator) {
                            for (i = 0; i < paren; ++i) {
                                MDXExpression.append(")");
                            }
                            for (i = 0; i < sep; ++i) {
                                MDXExpression.append("}");
                            }
                        }
                    } else {
                        MDXExpression.append(currentExpression);
                    }
                    currentExpression = MDXExpression.toString();
                    return currentExpression;
                }
                if (step instanceof DataItemRankFilter) {
                    StringBuilder rankExp = new StringBuilder();
                    if (this._compoundStep != null && this._previousStepInCompoundStep != null) {
                        if (this._previousStepInCompoundStep instanceof DataItemRankFilter) {
                            if (this._condition.equals("OR")) {
                                rankExp.append(" ,");
                            }
                        } else if (this._isNegate) {
                            stepActionType = 4;
                        } else if (this._condition.equals("OR")) {
                            stepActionType = 7;
                        }
                    }
                    rankExp.append(currentExpression);
                    String rankExprStr = rankExp.toString();
                    this._rankFilterMDX = RankFilter.getMDXExpression(rankExprStr, (DataItemRankFilter)step, this._olapValues);
                    if (this._rankFilterMDX != null) {
                        String Expression = this.completeStepMDX(this._rankFilterMDX, stepActionType, sf, currentExpression);
                        MDXExpression.append(Expression);
                    }
                    currentExpression = MDXExpression.toString();
                    return currentExpression;
                }
                if (step instanceof DataItemMemberFilter) {
                    if (this._compoundStep != null && this._previousStepInCompoundStep != null) {
                        if (this._isNegate) {
                            stepActionType = 4;
                        } else if (this._condition.equals("OR")) {
                            stepActionType = 7;
                        } else if (this._condition.equals("AND")) {
                            stepActionType = 5;
                        }
                    }
                    this._isMemberFilterOn = true;
                    this._memberFilterMDX = MemberFilter.getMDXExpression(dataSelection, initialExpression, (DataItemMemberFilter)step);
                    if (this._memberFilterMDX != null) {
                        StringBuilder temp = new StringBuilder();
                        temp.append("{ ").append(this._memberFilterMDX).append("} ");
                        String expressionString = this.completeStepMDX(temp.toString(), stepActionType, sf, currentExpression);
                        temp = null;
                        MDXExpression.append("{ ").append(expressionString).append("} ");
                    }
                    currentExpression = MDXExpression.toString();
                    return currentExpression;
                }
                if (step instanceof DataItemNavigationFilter) {
                    this._navigationFilterMDX = NavigationFilter.getMDXExpression(currentExpression, (DataItemNavigationFilter)step, dataSelection, dataItem);
                    if (this._navigationFilterMDX != null) {
                        String expression = this.completeStepMDX(this._navigationFilterMDX, stepActionType, sf, currentExpression);
                        if (this._compoundStep != null) {
                            if (this._previousStepInCompoundStep != null) {
                                int i;
                                if (this._isNegate) {
                                    MDXExpression.append("{ EXCEPT(");
                                } else if (this._condition.equals("OR")) {
                                    MDXExpression.append("{ UNION(");
                                } else if (this._condition.equals("AND")) {
                                    MDXExpression.append("{ INTERSECT(");
                                }
                                if (this._condition.equals("AND") || this._condition.equals("OR")) {
                                    MDXExpression.append(currentExpression).append(", ").append(expression);
                                    applySeparator = true;
                                    ++paren;
                                    ++sep;
                                }
                                for (i = 0; i < paren; ++i) {
                                    MDXExpression.append(")");
                                }
                                for (i = 0; i < sep; ++i) {
                                    MDXExpression.append("}");
                                }
                            } else {
                                MDXExpression.append(expression);
                            }
                        } else {
                            MDXExpression.append(expression);
                        }
                    }
                    currentExpression = MDXExpression.toString();
                    return currentExpression;
                }
            } else {
                String drillMemberName = ((DataItemNavigationFilter)step).getNavigationName();
                StringExpression transMem = new StringExpression();
                transMem.setText(drillMemberName);
                transMem.setExpressionType(3);
                StringExpression translated = StepManager.translate(dataSelection, transMem, ((DataItemNavigationFilter)step).getMemberLocale());
                try {
                    drillMemberName = translated.getText();
                }
                catch (MetadataException e) {
                    GenerationException ge = new GenerationException(e, e.getLocalizedMessage());
                    throw ge;
                }
                if (((DataItemNavigationFilter)step).getNavigationFilterType() == 4) {
                    this._drillMemberList.put(drillMemberName, null);
                } else {
                    this._drillMemberList.remove(drillMemberName);
                }
            }
            DataSelection bs = dataSelection;
            BusinessQueryActionType sortDirection = bs.getSortDirection(this._role);
            if (step instanceof BusinessQueryRankFilter) {
                this._listOfBQRankFilters.add(step);
            } else if (step instanceof BusinessQueryDataBasedFilter) {
                String businessBusinessQueryDataBasedFilterMDX = BusinessQueryFilterDataBased.getMDXExpression(dataSelection, this._specialDataBaseFilterCondition, this._axisDefinition, currentExpression, (BusinessQueryDataBasedFilter)step, this._olapValues);
                currentExpression = businessBusinessQueryDataBasedFilterMDX != null ? businessBusinessQueryDataBasedFilterMDX : MDXExpression.toString();
            } else if (step instanceof BusinessQueryTupleFilter) {
                this._listOfBQTupleFilters.add(step);
            }
            try {
                if (!(step instanceof BusinessQueryDataBasedFilter) && !(step instanceof BusinessQueryRankFilter) || sortDirection == BusinessQueryActionType.SORT_NONE) break block118;
                for (DataItem resultItem : dataSelection.getResultItems()) {
                    DataItemActionType dataSortDir;
                    Role role = dataSelection.getResultItemRole(resultItem);
                    if (!role.equals(this._role) || (dataSortDir = resultItem.getSortDirection()) == DataItemActionType.SORT_NONE) continue;
                    this._isMultiSortWithQueryFilter = true;
                    break;
                }
            }
            catch (MetadataException ex) {
                if (_logger.isEnabled(Level.ERROR)) {
                    Object[] msgArgs2 = new Object[]{currentExpression, ex.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("DataServices.UnknownDataItemID.Message.txt")};
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                    _logger.error((Object)msF, (Throwable)ex);
                }
                GenerationException ge = new GenerationException(ex);
                throw ge;
            }
        }
        _logger.info(currentExpression);
        return currentExpression;
    }

    private static String buildByRankSortField(Object measureObject, OLAPValues olapValues) throws GenerationException {
        String measure = "";
        if (measureObject instanceof StringExpression) {
            try {
                measure = ((StringExpression)measureObject).getText();
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                GenerationException ge = new GenerationException((MessageFormatter)null, (Throwable)e);
                throw ge;
            }
        } else if (measureObject instanceof ExpressionInterface) {
            ExpressionInterface measureExpression = (ExpressionInterface)measureObject;
            measure = MDXGenerationUtil.buildCoreExpression(measureExpression, olapValues);
        }
        return measure;
    }

    private static StringExpression translate(DataSelection dataSelection, StringExpression memberName, Locale locale) {
        ArrayList<StringExpression> memberList = new ArrayList<StringExpression>();
        memberList.add(memberName);
        List<StringExpression> tranMembers = IOMServerUtils.translateOLAPMembers(dataSelection, memberList, locale);
        if (!tranMembers.isEmpty()) {
            StringExpression newMemberName;
            memberName = newMemberName = tranMembers.get(0);
        }
        return memberName;
    }

    private String processSteps(DataSelection dataSelection, CompoundStep step, String initialExpression) throws GenerationException {
        StepInterface stepInCompoundStep;
        int stepNumber;
        StringBuilder MDXExpression = new StringBuilder();
        String currentExpression = initialExpression;
        List<String> conditionsOfSteps = step.getStepsConditions();
        if (this._stepsBeingProcessed.size() == 0) {
            return currentExpression;
        }
        --this._endOfSteps;
        int numberOfConditions = conditionsOfSteps.size();
        --numberOfConditions;
        this._isNegate = step.isNegated();
        ArrayList<StepInterface> reversedCompoundSteps = new ArrayList<StepInterface>();
        ArrayList<String> reversedConditionOfSteps = new ArrayList<String>();
        for (stepNumber = this._endOfSteps; stepNumber > -1; --stepNumber) {
            stepInCompoundStep = this._stepsBeingProcessed.get(stepNumber);
            reversedCompoundSteps.add(stepInCompoundStep);
        }
        for (stepNumber = numberOfConditions; stepNumber > -1; --stepNumber) {
            String conditionInCompoundStep = conditionsOfSteps.get(stepNumber);
            reversedConditionOfSteps.add(conditionInCompoundStep);
        }
        for (stepNumber = this._endOfSteps; stepNumber > -1; --stepNumber) {
            stepInCompoundStep = (StepInterface)reversedCompoundSteps.get(stepNumber);
            int nextNumber = stepNumber;
            this._nextStepInCompoundStep = --nextNumber > -1 ? (StepInterface)reversedCompoundSteps.get(nextNumber) : null;
            currentExpression = this.processStep(dataSelection, stepInCompoundStep, currentExpression, initialExpression, null);
            this._previousStepInCompoundStep = stepInCompoundStep;
            if (numberOfConditions > -1) {
                this._condition = (String)reversedConditionOfSteps.get(numberOfConditions);
            }
            --numberOfConditions;
        }
        MDXExpression.append(currentExpression);
        currentExpression = MDXExpression.toString();
        _logger.info(currentExpression);
        return currentExpression;
    }

    private String processSteps(DataSelection dataSelection, DataItem dataItem, String initialExpression) throws GenerationException {
        String currentExpression = initialExpression;
        for (int stepNumber = 0; stepNumber < this._endOfSteps; ++stepNumber) {
            StepInterface step = dataItem.getStep(stepNumber);
            currentExpression = this.processStep(dataSelection, step, currentExpression, initialExpression, dataItem);
            _logger.info(currentExpression);
        }
        return currentExpression;
    }

    private String processQueryTupleFilters(BusinessQueryTupleFilter step, DataSelection dataSelection) throws GenerationException {
        String returnExpression = BusinessQueryFilterTuple.createSingleBusinessQueryFilterTupleExpression(dataSelection, this._role, step, this._olapValues);
        MDXGenerationUtil.applyDebugStatement("Create a single BusinessQueryFilterTupleExpression " + returnExpression, this.getClass());
        if (returnExpression != null) {
            MDXGenerationUtil.applyDebugStatement("BusinessQueryTupleFilter: " + returnExpression, this.getClass());
        } else if (_logger.isEnabled(Level.ERROR)) {
            _logger.error(IQDataServicesResourceBundle.getStringResource("BusinessQueryFilterTupleNoTupleNoMeasure.txt"));
        }
        return returnExpression;
    }

    private String processRankFilter(String initialExpression, BusinessQuery model) throws GenerationException {
        String currentExpression = initialExpression;
        if (!this._listOfBQRankFilters.isEmpty()) {
            String businessQueryRankFilterMDX;
            Object step = this._listOfBQRankFilters.get(this._listOfBQRankFilters.size() - 1);
            if (step instanceof BusinessQueryRankFilter && (businessQueryRankFilterMDX = BusinessQueryFilterRank.getMDXExpression(currentExpression, (BusinessQueryRankFilter)step, this._olapValues, this._measureBeingRankedMDXVar)) != null) {
                currentExpression = businessQueryRankFilterMDX;
            }
            BusinessQueryActionType sortDirection = model.getSortDirection(this._role);
            if (!this._isMultiSortWithQueryFilter && sortDirection == BusinessQueryActionType.SORT_NONE) {
                String bQFilterMDX;
                StringBuilder overLay = new StringBuilder();
                if (model.getTotalType(Role.COLUMN).equalsIgnoreCase(BusinessQuery.ALLTOTAL) || model.getTotalType(Role.COLUMN).equalsIgnoreCase(BusinessQuery.SUBTOTAL) || model.getTotalType(Role.ROW).equalsIgnoreCase(BusinessQuery.ALLTOTAL) || model.getTotalType(Role.ROW).equalsIgnoreCase(BusinessQuery.SUBTOTAL)) {
                    overLay.append("HIERARCHIZE(").append(currentExpression).append(")");
                } else {
                    overLay.append("ORDER(").append(currentExpression).append(",");
                    String measure = this._olapValues.getMeasureCaption() + ".CURRENTMEMBER";
                    List listOfMeas = ((BusinessQueryRankFilter)step).getRankQualifiers();
                    if (listOfMeas != null) {
                        if (listOfMeas.size() > 0) {
                            if (listOfMeas.size() > 1) {
                                overLay.append("(");
                            }
                            int ctt = 1;
                            for (Object measureObject : listOfMeas) {
                                String measureit = StepManager.buildByRankSortField(measureObject, this._olapValues);
                                if (measureit.length() > 0) {
                                    measure = measureit;
                                }
                                overLay.append(measure);
                                if (ctt < listOfMeas.size()) {
                                    overLay.append(",");
                                }
                                ++ctt;
                            }
                        } else {
                            overLay.append(measure);
                        }
                    } else {
                        overLay.append(measure);
                    }
                    if (listOfMeas.size() > 1) {
                        overLay.append(")");
                    }
                    overLay.append(", BASC)");
                }
                currentExpression = bQFilterMDX = overLay.toString();
            }
        }
        return currentExpression;
    }

    private String processTupleFilter(String initialExpression, DataSelection dataSelection) throws GenerationException {
        String currentExpression = initialExpression;
        ArrayList<String> listOfTupleExpression = new ArrayList<String>();
        this._listOfTupleFiltersCombined.clear();
        currentExpression = initialExpression;
        if (!this._listOfBQTupleFilters.isEmpty()) {
            Iterator iterator = this._listOfBQTupleFilters.iterator();
            MDXGenerationUtil.applyDebugStatement("Processing business query tuple by gathering  each one up and merge into one MDX string.", this.getClass());
            while (iterator.hasNext()) {
                BusinessQueryTupleFilter step = (BusinessQueryTupleFilter)iterator.next();
                String singleProcessCrossjoin = this.processQueryTupleFilters(step, dataSelection);
                listOfTupleExpression.add(singleProcessCrossjoin);
            }
            BusinessQueryTotal totalObject = new BusinessQueryTotal(dataSelection, this._role);
            currentExpression = "{ " + totalObject.generateAddParents(currentExpression, false) + "}";
            currentExpression = BusinessQueryFilterTuple.mergeEachTupleExceptExpression(currentExpression, listOfTupleExpression, this._measureInQuery, this._isMeasureOnBottom);
            this._listOfBQTupleFilters.clear();
            this._listOfTupleFiltersCombined.clear();
            MDXGenerationUtil.applyDebugStatement("Merging all single tuple filter expression into a UNION/EXCEPT command", this.getClass());
        }
        return currentExpression;
    }

    private String processSteps(DataSelection dataSelection, String initialExpression) throws GenerationException {
        String currentExpression = initialExpression;
        for (int stepNumber = 0; stepNumber < this._endOfSteps; ++stepNumber) {
            StepInterface step = dataSelection.getStep(stepNumber, this._role);
            currentExpression = this.processStep(dataSelection, step, currentExpression, initialExpression, null);
            MDXGenerationUtil.applyDebugStatement(currentExpression, this.getClass());
        }
        currentExpression = this.processTupleFilter(currentExpression, dataSelection);
        currentExpression = this.processRankFilter(currentExpression, dataSelection);
        return currentExpression;
    }

    public void setOLAPValue(OLAPValues olapValues) {
        this._olapValues = olapValues;
    }
}

