/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.IOMServerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NavigationFilter {
    private static final Logger _logger = LogManager.getLogger(MDXGenerationUtil.class);

    /*
     * Unable to fully structure code
     */
    public static String getMDXExpression(String currentExpression, DataItemNavigationFilter step, DataSelection dataSelection, DataItem dataItem) {
        MDXExpression = new StringBuilder();
        navigationFilterType = step.getNavigationFilterType();
        navigatedName = step.getNavigationName();
        expression = step.getLevel();
        levelName = step.getLevelName();
        switch (navigationFilterType) {
            case 0: {
                navigatedName = NavigationFilter.translate(dataSelection, navigatedName, step.getMemberLocale());
                MDXExpression.append(navigatedName).append(".PARENT");
                break;
            }
            case 8: {
                navigatedName = NavigationFilter.translate(dataSelection, navigatedName, step.getMemberLocale());
                MDXExpression.append(navigatedName).append(".PARENT.LEVEL.MEMBERS");
                break;
            }
            case 1: {
                navigatedName = NavigationFilter.translate(dataSelection, navigatedName, step.getMemberLocale());
                MDXExpression.append("ANCESTORS(").append(navigatedName).append(", ").append(step.getLevelName()).append(", SELF)");
                break;
            }
            case 2: {
                navigatedName = NavigationFilter.translate(dataSelection, navigatedName, step.getMemberLocale());
                MDXExpression.append("DESCENDANTS(").append(navigatedName).append(", ").append(step.getLevelName()).append(", SELF)");
                break;
            }
            case 3: {
                navigatedName = NavigationFilter.translate(dataSelection, navigatedName, step.getMemberLocale());
                MDXExpression.append(navigatedName).append(".SIBLINGS");
                break;
            }
            case 4: {
                navigatedName = NavigationFilter.translate(dataSelection, navigatedName, step.getMemberLocale());
                MDXExpression.append(navigatedName).append(".CHILDREN");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (expression != null) {
                    if (levelName == null) {
                        navigatedName = NavigationFilter.translate(dataSelection, navigatedName, step.getMemberLocale());
                        MDXExpression.append(navigatedName).append(".MEMBERS");
                    } else {
                        MDXExpression.append(levelName).append(".MEMBERS");
                    }
                } else {
                    navigatedName = NavigationFilter.translate(dataSelection, navigatedName, step.getMemberLocale());
                    MDXExpression.append(navigatedName);
                    if (levelName == null) {
                        MDXExpression.append(".MEMBERS");
                    } else {
                        MDXExpression.append(".").append(levelName).append(".MEMBERS");
                    }
                }
                expressionOfDataItem = null;
                if (dataItem != null) {
                    expressionOfDataItem = dataItem.getExpression();
                    if (dataSelection == null && (busModel = dataItem.getBusinessModel()) instanceof DataSelection) {
                        dataSelection = (DataSelection)busModel;
                    }
                }
                if (dataSelection == null || !dataSelection.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_CALCULATED_MEMBERS) || expressionOfDataItem == null) break;
                hasCalculatedMembers = false;
                if (expressionOfDataItem instanceof ResourceAwareStringExpression || !(expressionOfDataItem instanceof Hierarchy)) ** GOTO lbl72
                hierarchy = (Hierarchy)expression;
                try {
                    if (hierarchy.getCalculatedMembers().size() > 0) {
                        hasCalculatedMembers = true;
                    }
                }
                catch (MetadataException e) {
                    if (!NavigationFilter._logger.isEnabled(Level.ERROR)) ** GOTO lbl72
                    NavigationFilter._logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
lbl72:
                // 4 sources

                if (!hasCalculatedMembers) break;
                MDXExpression.insert(0, "AddCalculatedMembers(").append(")");
                break;
            }
            default: {
                MDXExpression.append(currentExpression);
            }
        }
        return MDXExpression.toString();
    }

    private static String translate(DataSelection model, String valueString, Locale inLocale) {
        String returnValue = valueString;
        try {
            if (model != null) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug("A Model or data was defined for the building of a MDX Expression, translation will ccur.");
                }
                ArrayList<StringExpression> memberList = new ArrayList<StringExpression>();
                StringExpression value = new StringExpression();
                value.setText(valueString);
                value.setExpressionType(3);
                memberList.add(value);
                List<StringExpression> tranMembers = IOMServerUtils.translateOLAPMembers(model, memberList, inLocale);
                if (!tranMembers.isEmpty()) {
                    StringExpression newMemberName = tranMembers.get(0);
                    returnValue = newMemberName.getText();
                }
            } else if (_logger.isDebugEnabled()) {
                _logger.debug("No Model was defined for the building of a MDX Expression, so no translation can occur.");
            }
        }
        catch (MetadataException me) {
            _logger.error("No translation on navigation name occurred. ", (Throwable)me);
        }
        return returnValue;
    }
}

