/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.strategies.sas.oma.olapv2.MDXGeneration;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemberPropertyFilter {
    private static final Logger _logger = LogManager.getLogger(MemberPropertyFilter.class);
    private static final Logger _mdxLogger = LogManager.getLogger(MDXGeneration.class);

    public static String getMDXExpression(DataSelection dataSelection, String currentExpression, DataItemMemberPropertiesFilter step, Class<?> dataType, DataItem dataItem, List<String> listOfLevels) throws GenerationException {
        try {
            List<NonCalculatedValue> memberPropertyValues = step.getRightExpression();
            int openParenthesesCount = 0;
            if (memberPropertyValues.size() == 0) {
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("MemberPropertyFilterNoRight.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            ExpressionInterface expression = dataItem.getExpression();
            Hierarchy hierOfExpression = null;
            if (expression instanceof Hierarchy) {
                hierOfExpression = (Hierarchy)expression;
            } else if (expression instanceof NamedSet) {
                NamedSet namedSet = (NamedSet)expression;
                try {
                    hierOfExpression = namedSet.getOwningHierarchy();
                }
                catch (MetadataException e) {
                    throw new GenerationException(e);
                }
            }
            StringBuilder MDXExpression = new StringBuilder();
            MDXExpression.append(currentExpression);
            Iterator<String> iter = listOfLevels.iterator();
            Class<String> dataClass = String.class;
            while (iter.hasNext()) {
                int quotePosition2;
                String stringExpressionValue;
                String levelName = iter.next();
                ++openParenthesesCount;
                MDXExpression.append(" iif([").append(hierOfExpression).append("].currentmember.level is [").append(hierOfExpression).append("].[").append(levelName).append("],[").append(hierOfExpression).append("].currentmember.properties(").append('\"').append(step.getMemberPropertyName()).append('\"');
                if (!dataType.equals(dataClass)) {
                    MDXExpression.append(", TRUE");
                }
                MDXExpression.append(") ").append(step.getOperator().toString()).append(" ");
                ExpressionInterface value = (ExpressionInterface)((Object)memberPropertyValues.get(0));
                if (value instanceof StringExpression) {
                    stringExpressionValue = ((StringExpression)value).getText();
                    if (dataType.equals(dataClass)) {
                        quotePosition2 = stringExpressionValue.indexOf(34);
                        if (quotePosition2 > -1) {
                            MDXExpression.append("'");
                        } else {
                            MDXExpression.append('\"');
                        }
                        int quotePosition = stringExpressionValue.indexOf("'");
                        if (quotePosition > -1) {
                            stringExpressionValue = stringExpressionValue.replaceAll("'", "''");
                        }
                        MDXExpression.append(stringExpressionValue);
                        quotePosition2 = stringExpressionValue.indexOf(34);
                        if (quotePosition2 > -1) {
                            MDXExpression.append("'");
                        } else {
                            MDXExpression.append('\"');
                        }
                    } else {
                        MDXExpression.append(stringExpressionValue);
                    }
                } else if (value instanceof ConstantExpression) {
                    stringExpressionValue = ((ConstantExpression)value).getValue();
                    if (dataType.equals(dataClass)) {
                        quotePosition2 = stringExpressionValue.indexOf(34);
                        if (quotePosition2 > -1) {
                            MDXExpression.append("'");
                        } else {
                            MDXExpression.append('\"');
                        }
                        MDXExpression.append(stringExpressionValue);
                        quotePosition2 = stringExpressionValue.indexOf(34);
                        if (quotePosition2 > -1) {
                            MDXExpression.append("'");
                        } else {
                            MDXExpression.append('\"');
                        }
                    } else {
                        MDXExpression.append(stringExpressionValue);
                    }
                } else {
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("DataBasedFilter.getMDXExpression.BadValueType.fmt.txt", value.getClass().getName());
                    _logger.error((Object)mft);
                    throw new GenerationException(mft);
                }
                if (!iter.hasNext()) continue;
                MDXExpression.append(",");
            }
            MDXExpression.append(", 0");
            StringBuilder closeParentheses = new StringBuilder();
            for (int i = 0; i < openParenthesesCount; ++i) {
                closeParentheses.append(")");
            }
            MDXExpression.append(closeParentheses.toString());
            return MDXExpression.toString();
        }
        catch (MetadataException ex) {
            if (_mdxLogger.isEnabled(Level.ERROR)) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, currentExpression);
                _mdxLogger.error(msF.toString(), (Throwable)ex);
            }
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("MemberPropertyMeEx.txt", currentExpression));
        }
    }
}

