/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.SpecialValues;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.BusinessGroupMemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberTuple;
import com.sas.iquery.metadata.expr.olap.SlicerFilterExpression;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class MemberFilter {
    public static String getMDXExpression(DataSelection dataSelection, String currentExpression, DataItemMemberFilter step) throws GenerationException {
        StringBuilder mdx = new StringBuilder(900);
        if (step.isNegated()) {
            mdx.append("EXCEPT({").append(currentExpression).append("} ");
            currentExpression = mdx.toString();
        }
        return MemberFilter.getExpression(dataSelection, currentExpression, step.getMemberNames(), step.getMemberFilterType(), step.isNegated(), null, null, step.getMemberLocale());
    }

    public static String getMDXExpression(DataSelection dataSelection, String currentExpression, MemberFilterExpression expression) throws GenerationException {
        return MemberFilter.getMDXExpression(dataSelection, currentExpression, expression, null);
    }

    public static String getMDXExpression(DataSelection dataSelection, String currentExpression, MemberFilterExpression expression, List promptList) throws GenerationException {
        List<ExpressionInterface> memberName = expression.getMemberNames();
        Locale expressionLocale = expression.getMemberLocale();
        return MemberFilter.getExpression(dataSelection, currentExpression, memberName, 0, expression.isNegated(), expression, promptList, expressionLocale);
    }

    private static String getExpression(DataSelection dataSelection, String currentExpression, List memberNames, int memberFilterType, boolean isNegate, MemberFilterExpression filterExpression, List promptList, Locale locale) throws GenerationException {
        try {
            StringBuilder MDXExpression = new StringBuilder();
            if (promptList == null) {
                promptList = new ArrayList<String>();
            }
            if (isNegate) {
                MDXExpression.append(currentExpression).append(" ,{");
            }
            List filterTuples = null;
            if (filterExpression != null) {
                filterTuples = filterExpression.getFilterTupleList();
            }
            switch (memberFilterType) {
                case 0: {
                    Iterator iterator = memberNames.iterator();
                    int ct = 0;
                    while (iterator.hasNext()) {
                        ExpressionInterface expressionValue = (ExpressionInterface)iterator.next();
                        String valueString = MDXGenerationUtil.getExpressionValue(expressionValue, dataSelection, locale);
                        if (expressionValue instanceof Prompt) {
                            Object object;
                            List pvalue;
                            PromptValuesInterface promptValues = dataSelection.getPromptValues();
                            PromptDefinitionInterface promptDefinition = ((Prompt)expressionValue).getPromptDefinition();
                            try {
                                pvalue = promptValues.getPromptValueAsList(promptDefinition);
                            }
                            catch (PromptValueNotFoundException e) {
                                throw new GenerationException(e);
                            }
                            if (pvalue.size() == 1 && (object = pvalue.get(0)).equals(SpecialValues.ALL)) {
                                return currentExpression;
                            }
                        }
                        if (!(filterExpression == null || filterExpression instanceof BusinessGroupMemberFilterExpression || filterExpression instanceof SlicerFilterExpression || isNegate)) {
                            if (filterTuples.size() == 0 && filterExpression.getResources(Prompt.class, 65535).size() == 0) {
                                Object[] args = new Object[]{currentExpression};
                                throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("MemberFilterNoTuples.fmt.txt", args));
                            }
                            if (filterExpression.getResources(Prompt.class, 65535).size() == 0) {
                                if (filterExpression.isOrphanMembersInFilterFixed() && filterExpression.containsOrphans()) {
                                    MDXExpression.append(MDXGenerationUtil.fixOrphanFilterMember((MemberTuple)filterTuples.get(ct)));
                                }
                                valueString = MDXGenerationUtil.applyFilterAttributes(valueString, (MemberTuple)filterTuples.get(ct));
                            } else {
                                promptList.add(valueString);
                            }
                        }
                        MDXExpression.append(valueString);
                        ++ct;
                        if (!iterator.hasNext()) continue;
                        MDXExpression.append(", ").append(MDXGenerationUtil.NEWLINE);
                    }
                    break;
                }
                case 1: {
                    StringExpression memberName;
                    if (memberNames.size() == 1) {
                        memberName = (StringExpression)memberNames.get(0);
                        memberName = MemberFilter.translate(dataSelection, memberName, locale);
                        MDXExpression.append(memberName.getText()).append(":").append(memberName.getText()).append(".LASTSIBLING");
                    } else if (memberNames.size() > 1) {
                        memberName = (StringExpression)memberNames.get(0);
                        memberName = MemberFilter.translate(dataSelection, memberName, locale);
                        MDXExpression.append(memberName.getText()).append(":");
                        memberName = (StringExpression)memberNames.get(1);
                        memberName = MemberFilter.translate(dataSelection, memberName, locale);
                        MDXExpression.append(memberName.getText());
                    }
                    if (filterTuples == null || isNegate) break;
                    StringBuilder wrapperDescendent = new StringBuilder();
                    wrapperDescendent.append("Descendants(").append(MDXExpression.toString()).append(")");
                    return wrapperDescendent.toString();
                }
            }
            if (isNegate) {
                MDXExpression.append("})").append(MDXGenerationUtil.NEWLINE);
            }
            return MDXExpression.toString();
        }
        catch (MetadataException ex) {
            Object[] msgArgs2 = new Object[]{currentExpression, IQDataServicesResourceBundle.getStringResource("MemberFilterMetaE.txt"), ex.getLocalizedMessage()};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            GenerationException ee = new GenerationException(msF);
            ee.initCause(ex);
            throw ee;
        }
    }

    private static StringExpression translate(DataSelection dataSelection, StringExpression memberName, Locale locale) {
        ArrayList<StringExpression> memberList = new ArrayList<StringExpression>();
        memberList.add(memberName);
        List<StringExpression> tranMembers = IOMServerUtils.translateOLAPMembers(dataSelection, memberList, locale);
        if (!tranMembers.isEmpty()) {
            StringExpression newMemberName;
            memberName = newMemberName = tranMembers.get(0);
        }
        return memberName;
    }
}

