/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import java.util.Iterator;
import java.util.List;

public class DataBasedFilter {
    /*
     * Enabled aggressive block sorting
     */
    public static String getMDXExpression(DataSelection dataSelection, String currentExpression, DataItemDataBasedFilter step, OLAPValues olapValues) throws GenerationException {
        StringBuilder MDXExpression = new StringBuilder();
        List<ExpressionInterface> memberNames = step.getLeftExpression();
        List<NonCalculatedValue> memberValues = step.getRightExpression();
        if (memberNames.size() == 0) {
            Object[] msgArgs2 = new Object[]{currentExpression, IQDataServicesResourceBundle.getStringResource("DataBasedFilterNoLeft.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            throw new GenerationException(msF);
        }
        if (memberValues.size() == 0) {
            Object[] msgArgs2 = new Object[]{currentExpression, IQDataServicesResourceBundle.getStringResource("DataBasedFilterNoRight.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            throw new GenerationException(msF);
        }
        MDXExpression.append(currentExpression).append("(");
        if (memberNames.size() > 1) {
            MDXExpression.append("( ");
        }
        Iterator<ExpressionInterface> iterator = memberNames.iterator();
        while (iterator.hasNext()) {
            ExpressionInterface obj = iterator.next();
            MDXExpression.append(MDXGenerationUtil.buildCoreExpression(obj, olapValues));
            if (!iterator.hasNext()) continue;
            MDXExpression.append(", ");
        }
        if (memberNames.size() > 1) {
            MDXExpression.append(" )");
        }
        MDXExpression.append(" ").append(step.getOperator().toString()).append(" ");
        ExpressionInterface value = (ExpressionInterface)((Object)memberValues.get(0));
        List<DataItem> dataItemList = value.getResources(DataItem.class, 0);
        if (dataItemList.size() > 0) {
            DataItem dataItem = dataItemList.get(0);
            StructureOfDataItem st = dataItem.getStructure();
            if (st != StructureOfDataItem.STRUCTURE_MEASURE) {
                Object[] msgArgs2 = new Object[]{currentExpression, value, IQDataServicesResourceBundle.getStringResource("BusinessQueryDataBasedNonMeasure.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                throw new GenerationException(msF);
            }
            ExpressionInterface expression = dataItem.getExpression();
            MDXExpression.append(MDXGenerationUtil.buildCoreExpression(expression, olapValues));
        } else {
            MDXExpression.append(MDXGenerationUtil.buildCoreExpression(value, olapValues));
        }
        MDXExpression.append(")");
        return MDXExpression.toString();
    }
}

