/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXVariable;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BusinessQueryFilterRank {
    private static final Logger _logger = LogManager.getLogger(BusinessQueryFilterRank.class);

    public static String getMDXExpression(String currentExpression, BusinessQueryRankFilter step, OLAPValues olapValues, Map measureBeingRankedMDXVar) throws GenerationException {
        if (step.isIncludeTies() && !step.getRankType().equalsIgnoreCase("Count")) {
            if (_logger.isEnabled(Level.ERROR)) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("RankFilterIncludeTiesError.txt", new Object[0]);
                _logger.error((Object)formatter);
            }
            return currentExpression;
        }
        StringBuilder MDXExpression = new StringBuilder();
        MDXExpression.append(MDXGenerationUtil.NEWLINE).append("     ");
        if (step.getRankOrder().equals("Top")) {
            MDXExpression.append("Top");
        } else if (step.getRankOrder().equals("Bottom")) {
            MDXExpression.append("Bottom");
        } else {
            if (_logger.isEnabled(Level.ERROR)) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("RankFilterRankOrderError.txt", new Object[0]);
                _logger.error((Object)formatter);
            }
            return currentExpression;
        }
        if (step.getRankType().equals("Count")) {
            MDXExpression.append("Count").append("(");
        } else if (step.getRankType().equals("Percent")) {
            MDXExpression.append("Percent").append("(");
        } else if (step.getRankType().equals("Sum")) {
            MDXExpression.append("Sum").append("(");
        } else {
            if (_logger.isEnabled(Level.ERROR)) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("RankFilterRankTypeError.txt", new Object[0]);
                _logger.error((Object)formatter);
            }
            return currentExpression;
        }
        MDXExpression.append("{").append(currentExpression).append("}").append(", ");
        ArrayList<String> byNames = null;
        List byRankQualifier = step.getRankQualifiers();
        if (byRankQualifier != null) {
            byNames = new ArrayList<String>();
            for (Object object : byRankQualifier) {
                if (object instanceof ExpressionInterface) {
                    Object obj;
                    String key;
                    String core = MDXGenerationUtil.buildCoreExpression((ExpressionInterface)object, olapValues);
                    if (step.getRankOrder().equalsIgnoreCase("Bottom") && object instanceof DataItem && measureBeingRankedMDXVar.containsKey(key = ((DataItem)object).getLabel()) && (obj = measureBeingRankedMDXVar.get(key)) instanceof MDXVariable) {
                        core = ((MDXVariable)obj).getLabel();
                    }
                    if (core == null) continue;
                    byNames.add(core);
                    continue;
                }
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error("Item in Rank Qualifier list is not a expression interface object. ");
                }
                return currentExpression;
            }
        }
        MDXExpression.append(step.getValue());
        if (byNames == null) {
            MDXExpression.append(",[Measures].CURRENTMEMBER");
            if (step.isIncludeTies()) {
                MDXExpression.append(", TRUE");
            }
            MDXExpression.append(")");
            return MDXExpression.toString();
        }
        if (byNames.size() == 0) {
            MDXExpression.append(",[Measures].CURRENTMEMBER");
            if (step.isIncludeTies()) {
                MDXExpression.append(", TRUE");
            }
            MDXExpression.append(")");
            return MDXExpression.toString();
        }
        if (byNames.size() == 1) {
            String itemByNames = (String)byNames.get(0);
            if (itemByNames != null) {
                MDXExpression.append(", ");
                MDXExpression.append(itemByNames);
            }
        } else {
            StringBuilder RankNameBuf = new StringBuilder();
            int numOfRankNames = 0;
            for (int i = 0; i < byNames.size(); ++i) {
                String rankName;
                if (i == 0) {
                    MDXExpression.append(", ");
                }
                if ((rankName = (String)byNames.get(i)) == null) {
                    i = byNames.size();
                    continue;
                }
                if (i > 0) {
                    RankNameBuf.append(", ");
                }
                RankNameBuf.append((String)byNames.get(i));
                ++numOfRankNames;
            }
            if (numOfRankNames > 1) {
                MDXExpression.append("(");
            }
            MDXExpression.append(RankNameBuf.toString());
            if (numOfRankNames > 1) {
                MDXExpression.append(")");
            }
        }
        if (step.isIncludeTies()) {
            MDXExpression.append(", TRUE");
        }
        MDXExpression.append(")");
        return MDXExpression.toString();
    }
}

