/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.Iterator;
import java.util.List;

public class BusinessQueryFilterDataBased {
    public static final String packageName = "com.sas.iquery.strategies.sas.oma.olapv2.step.BusinessQueryFilterDataBased";

    /*
     * Enabled aggressive block sorting
     */
    public static String getMDXExpression(DataSelection dataSelection, boolean specialDataBaseFilterCondition, String axisDefinition, String currentExpression, BusinessQueryDataBasedFilter step, OLAPValues olapValues) throws GenerationException {
        StringBuilder MDXExpression = new StringBuilder();
        List<ExpressionInterface> memberNames = step.getLeftExpression();
        List<NonCalculatedValue> memberValues = step.getRightExpression();
        if (memberNames.isEmpty()) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("DataBasedFilterNoLeft.txt", new Object[0]);
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, currentExpression, formatter.toString());
            throw new GenerationException(msF);
        }
        if (memberValues.isEmpty()) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("DataBasedFilterNoRight.txt", new Object[0]);
            ArrayMessageFormatter amf = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, currentExpression, formatter.toString());
            throw new GenerationException(amf);
        }
        MDXExpression.append("Filter(").append(currentExpression).append(",(");
        boolean createDataBasedEdgeCase = false;
        ExpressionInterface objectFromDataBasedFilter = null;
        if (specialDataBaseFilterCondition && memberNames.size() == 1) {
            ExpressionInterface expression;
            objectFromDataBasedFilter = memberNames.get(0);
            if (objectFromDataBasedFilter instanceof Measure) {
                createDataBasedEdgeCase = true;
            } else if (objectFromDataBasedFilter instanceof DataItem && (expression = ((DataItem)objectFromDataBasedFilter).getExpression()) instanceof Measure) {
                createDataBasedEdgeCase = true;
            }
        }
        if (createDataBasedEdgeCase && objectFromDataBasedFilter != null) {
            MDXExpression.append(" crossjoin([").append(axisDefinition).append("].item(measures.vtsize), ").append(MDXGenerationUtil.buildCoreExpression(objectFromDataBasedFilter, olapValues)).append(").item(0)");
        } else {
            if (memberNames.size() > 1) {
                MDXExpression.append("( ");
            }
            Iterator<ExpressionInterface> iterator = memberNames.iterator();
            while (iterator.hasNext()) {
                ExpressionInterface expr = iterator.next();
                MDXExpression.append(MDXGenerationUtil.buildCoreExpression(expr, olapValues));
                if (!iterator.hasNext()) continue;
                MDXExpression.append(", ");
            }
            if (memberNames.size() > 1) {
                MDXExpression.append(" )");
            }
        }
        MDXExpression.append(" ").append(step.getOperator().toString()).append(" ");
        ExpressionInterface value = (ExpressionInterface)((Object)memberValues.get(0));
        List<DataItem> dataItemList = value.getResources(DataItem.class, 0);
        if (dataItemList.size() > 0) {
            DataItem dataItem = dataItemList.get(0);
            StructureOfDataItem st = dataItem.getStructure();
            if (!st.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
                MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedNonMeasure.txt", new Object[0]);
                ArrayMessageFormatter amf = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, currentExpression, value, formatter.toString());
                throw new GenerationException(amf);
            }
            ExpressionInterface expression = dataItem.getExpression();
            MDXExpression.append(MDXGenerationUtil.buildCoreExpression(expression, olapValues));
        } else {
            MDXExpression.append(MDXGenerationUtil.buildCoreExpression(value, olapValues));
        }
        MDXExpression.append("))");
        return MDXExpression.toString();
    }
}

