/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2.expr;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Level;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.olap.AllLevel;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXVariable;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPItemType;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimeMeasureExpression {
    private static final Logger _logger = LogManager.getLogger(TimeMeasureExpression.class);
    private static final Logger _mdxLogger = LogManager.getLogger(MDXGenerationUtil.class);

    public static String generateMDX(List<? extends DataItem> resultItems, DataSelection model, TimeExpressionMeasure tcmExpress, DataItem tcmDataItem, StringBuilder cummulate, boolean checkMeasureInResultItem, OLAPValues olapValues) throws GenerationException {
        MessageFormatter mft;
        String labelOfDataItem;
        String nameOfExp;
        DataItem dataItem;
        String function;
        String allLevelName;
        StringBuilder MDXExpression;
        String hierName;
        Level topLevel;
        String hierUName;
        block51: {
            hierUName = null;
            topLevel = null;
            cummulate.delete(0, cummulate.length());
            String orphanMeasure = null;
            hierName = null;
            MDXExpression = new StringBuilder();
            boolean isTimeDimension = olapValues.isTimeDimensionPresent();
            if (!isTimeDimension) {
                MessageFormatter mft2 = IQDataServicesResourceBundle.getMessageFormatter("TimeMeasureExpressionNoTimeHierarchy.txt", new Object[0]);
                throw new GenerationException(mft2);
            }
            allLevelName = "Levels(0)";
            hierName = olapValues.getTimeHierName();
            hierUName = olapValues.getTimeHierUniqueName();
            for (DataItem dataItem2 : resultItems) {
                try {
                    Hierarchy timeHiearchy;
                    List<Level> levels;
                    ExpressionInterface itemExpression = dataItem2.getExpression();
                    int dimType = BusinessQueryOLAPUtil.getDimensionType(dataItem2, (Object)itemExpression);
                    if (dimType != 1 || !(itemExpression instanceof Hierarchy) || (levels = (timeHiearchy = (Hierarchy)itemExpression).getLevels()).isEmpty()) continue;
                    topLevel = levels.get(0);
                    if (topLevel instanceof AllLevel) {
                        allLevelName = "[" + topLevel.getLevelName() + "]";
                        break;
                    }
                    topLevel = null;
                }
                catch (MetadataException e) {
                    _mdxLogger.error((Object)e);
                }
            }
            function = tcmExpress.getFunction();
            dataItem = tcmExpress.getMeasure();
            boolean isTimeValueAMeasure = true;
            boolean measureInResultItem = MDXGenerationUtil.isResultItemInList(resultItems, dataItem);
            if (measureInResultItem) {
                isTimeValueAMeasure = olapValues.isMeasure(dataItem);
            }
            ExpressionInterface expression = dataItem.getExpression();
            nameOfExp = tcmDataItem.getLabel();
            labelOfDataItem = null;
            boolean isCalculatedMeasure = dataItem.isCalculatedItem();
            try {
                if (measureInResultItem && !isCalculatedMeasure) {
                    Role role = model.getResultItemRole(dataItem);
                    if (!Role.isOutputResultRole(model, role)) {
                        measureInResultItem = false;
                    } else if (role == null) {
                        measureInResultItem = false;
                    }
                }
                if (!measureInResultItem) {
                    if (expression instanceof Measure) {
                        Measure measure = (Measure)expression;
                        orphanMeasure = measure.getUniqueName();
                    } else if (expression instanceof ResourceAwareStringExpression || expression instanceof StringExpression) {
                        StringExpressionUtil stringExprUtil = StringExpressionUtil.getInstance();
                        orphanMeasure = stringExprUtil.getReadableText(expression);
                        isCalculatedMeasure = true;
                    } else {
                        mft = IQDataServicesResourceBundle.getMessageFormatter("TimeMeasureExpressionNoMeasure.fmt.txt", dataItem.getLabel());
                        _logger.error((Object)mft);
                        throw new GenerationException(mft);
                    }
                    if (orphanMeasure != null) {
                        orphanMeasure = orphanMeasure.replaceAll(">", "");
                        orphanMeasure = orphanMeasure.replaceAll("<", "");
                    }
                    if (orphanMeasure != null && !measureInResultItem && isCalculatedMeasure) {
                        StringBuilder tempLabMeas = new StringBuilder();
                        String dataItemLabelForMeasure = dataItem.getLabel();
                        tempLabMeas.append(olapValues.getMeasureCaption()).append(".[").append(dataItemLabelForMeasure).append("]");
                        labelOfDataItem = tempLabMeas.toString();
                        boolean hasOLAPValue = olapValues.hasOLAPValue(dataItem);
                        if (!hasOLAPValue) {
                            MDXVariable mdxVariable = new MDXVariable(olapValues.getMetadataInterface(), dataItem, false, model);
                            mdxVariable.setLabel(olapValues.getMeasureCaption());
                            mdxVariable.setCounter(1);
                            mdxVariable.setMDXExpression(orphanMeasure);
                            cummulate.append(mdxVariable.getMDXPhrase());
                            olapValues.setOLAPValue(dataItem, OLAPItemType.MDXVARIABLE, mdxVariable);
                            olapValues.setOLAPValue(dataItem, OLAPItemType.ISMEASURE, Boolean.TRUE);
                        } else {
                            MDXVariable mdxVar = (MDXVariable)olapValues.getOLAPValue(dataItem, OLAPItemType.MDXVARIABLE);
                            mdxVar.setCounter(mdxVar.getCounter());
                            labelOfDataItem = mdxVar.getLabel();
                        }
                    } else if (orphanMeasure != null && !measureInResultItem) {
                        labelOfDataItem = orphanMeasure;
                    }
                    break block51;
                }
                if (isTimeValueAMeasure) {
                    labelOfDataItem = TimeMeasureExpression.buildCoreExpression(dataItem, olapValues);
                    break block51;
                }
                Object[] msgArgs2 = new Object[]{expression.toString(), IQDataServicesResourceBundle.getStringResource("TimeMeasureExpressionNoMeasure.fmt.txt", dataItem.getLabel())};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException ge = new GenerationException(msF);
                throw ge;
            }
            catch (MetadataException e) {
                Object[] msgArgs2 = new Object[]{expression.toString(), IQDataServicesResourceBundle.getStringResource("TimeMeasureExpressionMetaE.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                throw new GenerationException((MessageFormatter)msF, (Throwable)e);
            }
        }
        if (function.equals("DIFFERENCE_PREVIOUS_YEAR") || function.equals("DIFFERENCE_PREVIOUS_PERIOD")) {
            StringBuilder differenceMDX = new StringBuilder();
            if (function.equals("DIFFERENCE_PREVIOUS_YEAR")) {
                differenceMDX.append("iif(PARALLELPERIOD(").append(olapValues.getTimeTopLevelName()).append(", 1, ").append(hierName).append(".CURRENTMEMBER) is ");
            } else {
                differenceMDX.append("iif(").append(hierName).append(".PREVMEMBER is ");
            }
            differenceMDX.append("NULL, NULL, ").append("(").append(labelOfDataItem);
            differenceMDX.append(", ").append(hierName).append(".CURRENTMEMBER)");
            differenceMDX.append(" - (").append(labelOfDataItem).append(", ");
            if (function.equals("DIFFERENCE_PREVIOUS_YEAR")) {
                differenceMDX.append("ParallelPeriod(").append(hierUName).append(",1,").append(hierName).append(".CURRENTMEMBER");
            } else {
                differenceMDX.append(hierName).append(".PREVMEMBER)");
            }
            if (function.equals("DIFFERENCE_PREVIOUS_YEAR")) {
                differenceMDX.append("))");
            }
            differenceMDX.append(")");
            MDXExpression.append((CharSequence)differenceMDX);
        } else if (function.equals("PERCENTCHANGE_PREVIOUS_PERIOD") || function.equals("PERCENTCHANGE_PREVIOUS_YEAR")) {
            StringBuilder percentMDX = new StringBuilder();
            StringBuilder dMDX = new StringBuilder();
            if (function.equals("DIFFERENCE_PREVIOUS_YEAR")) {
                percentMDX.append("iif(PARALLELPERIOD(").append(olapValues.getTimeTopLevelName()).append(", 1, ").append(hierName).append(".CURRENTMEMBER) is ");
            } else {
                percentMDX.append("iif(").append(hierName).append(".PREVMEMBER is ");
            }
            percentMDX.append("NULL, NULL, ");
            dMDX.append("(").append(labelOfDataItem);
            if (function.equals("PERCENTCHANGE_PREVIOUS_YEAR")) {
                dMDX.append(")");
            } else {
                dMDX.append(", ").append(hierName).append(".CURRENTMEMBER)");
            }
            dMDX.append(" - (").append(labelOfDataItem).append(", ");
            if (function.equals("PERCENTCHANGE_PREVIOUS_YEAR")) {
                dMDX.append("ParallelPeriod(").append(hierUName).append(",1,").append(hierName).append(".CURRENTMEMBER");
            } else {
                dMDX.append(hierName).append(".PREVMEMBER)");
            }
            if (function.equals("PERCENTCHANGE_PREVIOUS_YEAR")) {
                dMDX.append("))");
            }
            dMDX.append(")");
            percentMDX.append("( ( ").append(dMDX.toString()).append(") / (").append(labelOfDataItem).append(", ");
            if (function.equals("PERCENTCHANGE_PREVIOUS_YEAR")) {
                percentMDX.append("ParallelPeriod(").append(hierUName).append(",1,").append(hierName).append(".CURRENTMEMBER");
            } else {
                percentMDX.append(hierName);
                percentMDX.append(".PREVMEMBER)");
            }
            if (function.equals("PERCENTCHANGE_PREVIOUS_YEAR")) {
                percentMDX.append("))");
            }
            percentMDX.append(")");
            MDXExpression.append((CharSequence)percentMDX);
        } else if (function.equals("CUMULATIVE")) {
            StringBuilder cumulativeMDX;
            if (tcmExpress.getPeriod() == null) {
                cumulativeMDX = new StringBuilder();
                boolean addParen1 = false;
                boolean addParen2 = false;
                cumulativeMDX.append("iif(").append(hierName).append(".CURRENTMEMBER.level.ordinal > 1 ").append(", AGGREGATE( CROSSJOIN( {PeriodsToDate(").append(hierUName).append(", ").append(hierName).append(".CURRENTMEMBER)}, {").append(labelOfDataItem).append("} ) )").append(", ").append("iif(isempty(").append(labelOfDataItem).append("), NULL, ").append("AGGREGATE( CROSSJOIN( {PeriodsToDate( ");
                if (topLevel == null) {
                    cumulativeMDX.append(hierName).append(".").append(allLevelName).append(",");
                } else {
                    cumulativeMDX.append(allLevelName).append(",");
                }
                cumulativeMDX.append(hierName).append(".CURRENTMEMBER)}, {").append(labelOfDataItem).append("} ) )").append(" ))");
                if (addParen1) {
                    cumulativeMDX.append(" )");
                }
                if (addParen2) {
                    cumulativeMDX.append(" )");
                }
                MDXExpression.append((CharSequence)cumulativeMDX);
            } else {
                cummulate.append(MDXGenerationUtil.NEWLINE).append("MEMBER ").append(olapValues.getMeasureCaption()).append(".[&#&").append(nameOfExp).append("] AS").append(MDXGenerationUtil.NEWLINE + "     ").append("'iif(").append(tcmExpress.getPeriod()).append(".Level.Ordinal < ").append(hierName).append(".CURRENTMEMBER.level.Ordinal, ").append("AGGREGATE(Head(Descendants(").append(tcmExpress.getPeriod()).append(", ").append(hierName).append(".CURRENTMEMBER.Level,SELF),1).Item(0):").append(hierName).append(".CURRENTMEMBER,").append(labelOfDataItem).append("), ").append("AGGREGATE(").append(tcmExpress.getPeriod()).append(": Tail(Ancestors(").append(hierName).append(".CURRENTMEMBER, ").append(tcmExpress.getPeriod()).append(".Level,SELF),1).Item(0),").append(labelOfDataItem).append("))'");
                cumulativeMDX = new StringBuilder();
                cumulativeMDX.append("iif(").append("ISEMPTY(").append(labelOfDataItem).append("), NULL,").append(olapValues.getMeasureCaption()).append(".[&#&").append(nameOfExp).append("])");
                MDXExpression.append((CharSequence)cumulativeMDX);
            }
        } else {
            mft = IQDataServicesResourceBundle.getMessageFormatter("TimeMeasureExpressionNoMeasure.fmt.txt", dataItem.getLabel());
            _logger.error((Object)mft);
            throw new GenerationException(mft);
        }
        return MDXExpression.toString();
    }

    private static String buildCoreExpression(ExpressionInterface expression, OLAPValues olapValues) throws GenerationException {
        String returnValue;
        block8: {
            returnValue = "";
            try {
                if (expression instanceof Measure) {
                    String measureName = null;
                    returnValue = measureName = ((Measure)expression).getUniqueName();
                    break block8;
                }
                if (expression instanceof ConstantExpression || expression instanceof StringExpression || expression instanceof Prompt) {
                    returnValue = MDXGenerationUtil.getExpressionValue(expression, olapValues.getDataSelection(), null);
                    break block8;
                }
                if (expression instanceof DataItem) {
                    if (((DataItem)expression).getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) {
                        ExpressionInterface expr = ((DataItem)expression).getExpression();
                        if (expr instanceof ResourceAwareStringExpression || expr instanceof TimeExpressionMeasure) {
                            returnValue = MDXGenerationUtil.buildCoreExpression((DataItem)expression, olapValues);
                            break block8;
                        }
                        if (expr instanceof Measure) {
                            String measureName = ((Measure)expr).getUniqueName();
                            returnValue = measureName + " ";
                            break block8;
                        }
                        Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationMeasureLevelNameException.txt")};
                        _mdxLogger.error((Object)expr);
                        ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                        throw new GenerationException(msF);
                    }
                    Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationMeasureLevelNameException.txt")};
                    _mdxLogger.error((Object)((DataItem)expression).getStructure());
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                    throw new GenerationException(msF);
                }
                Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationMeasureLevelNameException.txt")};
                _mdxLogger.error((Object)expression);
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                throw new GenerationException(msF);
            }
            catch (MetadataException e) {
                Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationMeasureLevelNameException.txt")};
                _mdxLogger.error((Object)expression);
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                _logger.error((Object)msF);
                throw new GenerationException((MessageFormatter)msF, (Throwable)e);
            }
        }
        return returnValue;
    }
}

