/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2;

import com.sas.iquery.builder.DisabledTotalsBuilder;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution.instructions.MDXInstruction;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessGroup;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.BusinessQueryTotalLocationType;
import com.sas.iquery.metadata.business.BusinessQueryTotalModeType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BaseFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryTupleFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFilter;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.iquery.metadata.expr.NonCalculatedValue;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.expr.olap.BusinessGroupMemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression_Between;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.SlicerFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMeasure;
import com.sas.iquery.metadata.physical.oma.OMAMeasure;
import com.sas.iquery.strategies.sas.oma.GenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.AbstractCodeGenerator;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXVariable;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPItemType;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.strategies.sas.oma.olapv2.BusinessQueryDataBaseSort;
import com.sas.iquery.strategies.sas.oma.olapv2.BusinessQueryTotal;
import com.sas.iquery.strategies.sas.oma.olapv2.DataItemSort;
import com.sas.iquery.strategies.sas.oma.olapv2.expr.FractionTotalExpression;
import com.sas.iquery.strategies.sas.oma.olapv2.expr.TimeMeasureExpression;
import com.sas.iquery.strategies.sas.oma.olapv2.step.MemberFilter;
import com.sas.iquery.strategies.sas.oma.olapv2.step.StepManager;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.CalculatedMeasure;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.storage.olap.MetadataInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MDXGeneration
extends AbstractCodeGenerator {
    private static final String MDX_DIM_PROP = " DIMENSION PROPERTIES ";
    private static final String MDX_TOTAL_PROP = " ORIGINAL_UNIQUE_NAME ";
    private static final String MDX_COMMA = ",";
    private static final String VTSIZE = "[measures].[vtsize]";
    private static final String ROWAXISLABEL = "ROW_AXIS";
    private static final String COLUMNAXISLABEL = "COLUMN_AXIS";
    private static final String GROUP = " GROUP ";
    private final Map<String, String> _labelNameMap = new LinkedHashMap<String, String>();
    private TotalingType _anyTotalInColumn;
    private TotalingType _anyTotalInRow;
    private boolean _colHasMeasureWithPercentage = false;
    private List<DataItem> _disableTotaledMeasures = new ArrayList<DataItem>();
    private String _disableHierarchy = null;
    private boolean _colHasMeasure = false;
    private String _axisDefForDataBasedSpecials = "ROW_AXIS";
    private StringBuilder _colAlternateString = new StringBuilder();
    private List<String> _columnProperty = new ArrayList<String>();
    private String _cubeName = "";
    private List<DataItem> _dataItemsInAllQuerySort = new ArrayList<DataItem>();
    private List<DataItem> _dataItemsInAllQuerySteps = new ArrayList<DataItem>();
    private List<Object> _dataItemsInOtherDataItems = new ArrayList<Object>();
    private List<DataItem> _dataItemsInQuerySort = new ArrayList<DataItem>();
    private List<DataItem> _dataItemsInQuerySteps = new ArrayList<DataItem>();
    private List<DataItem> _hiddenResults = new ArrayList<DataItem>();
    private boolean _isColTotalContribution = false;
    private boolean _isGrandTotalContribution = false;
    private boolean _isMeasureIncludedInCrossJoin = true;
    private boolean _isMultipleMeasures = false;
    private boolean _isMultiSortWithQueryFilter = false;
    private boolean _isNoColsForContribution = false;
    private boolean _isNoRowsForContribution = false;
    private boolean _isRowTotalContribution = false;
    private boolean _isVisualTotalOnOnlyCol = false;
    private boolean _isVisualTotalOnOnlyRow = false;
    private Map<String, String> _mdxClauseMap = new LinkedHashMap<String, String>();
    private int _measureOnTop = 0;
    private int _measureOnTopRecheck = 0;
    private MetadataInterface _metaInterface = null;
    private DataSelection _model;
    private StringBuilder _multipleMeasures = new StringBuilder();
    private OLAPValues _olapValues;
    private String _preFilterString = null;
    private StringBuilder _relativeTimeOrphanedMeasures = new StringBuilder();
    private Map<DataItem, String> _resultItemMap;
    private boolean _rowHasMeasureWithPercentage = false;
    private boolean _rowHasMeasure = false;
    private StringBuilder _rowAlternateString = new StringBuilder();
    private List<String> _rowProperty = new ArrayList<String>();
    private DataItem _rtmMeasure = null;
    private LogicalServerInterface _server = null;
    private Map<DataItem, String> _slicerPhraseWhereMap = new LinkedHashMap<DataItem, String>();
    private List<DataItem> _slicerWhereList = new ArrayList<DataItem>();
    private BusinessQueryTotal _totalColumn;
    private List<FractionTotalExpression> _totalPercentASList = new ArrayList<FractionTotalExpression>();
    private BusinessQueryTotal _totalRow;
    private StringBuilder _WITHClause = new StringBuilder();
    private Map<String, DataItem> _measureBeingCountRanked = new LinkedHashMap<String, DataItem>();
    private Map<String, MDXVariable> _measureBeingRankedCountSumPercentMDXVar = new LinkedHashMap<String, MDXVariable>();
    private List<DataItem> _rows = new ArrayList<DataItem>();
    private List<DataItem> _columns = new ArrayList<DataItem>();
    private boolean _bottomRankPercentExcludeRow = false;
    private boolean _bottomRankPercentExcludeCol = false;
    private String _sortedSetWithMeasures = null;
    private String _specialSortedMeasureDefintion = null;
    private Role _sortedTotalRole = null;
    private boolean _sortedVisualMeasureOn = false;
    private int _countOfMeasuresOnAxis = 1;
    private boolean _hasDatabasedFilterChildFilterWithTotals = false;
    private StringBuilder _hasDatabasedFilterEdgeWithClause = new StringBuilder();
    private String USE_NON_NESTED_CROSSJOIN_DEFAULT = "true";
    private OLAPConnectionResource _olapConnection;
    private static final Logger _logger = LogManager.getLogger(MDXGeneration.class);
    private String _sortMeasure = null;

    private String applyMeasureInCrossJoin(String select, Role role) {
        StringBuilder clause = new StringBuilder();
        boolean isBusinessQueryTupleFilterInSteps = false;
        for (StepInterface step : this._model.getSteps(role)) {
            if (!(step instanceof BusinessQueryTupleFilter) || TotalingType.TOTAL_NONE == this._model.getTotalingType(role)) continue;
            isBusinessQueryTupleFilterInSteps = true;
        }
        if (!isBusinessQueryTupleFilterInSteps) {
            clause.append(MDXGenerationUtil.NEWLINE).append("     ").append("CROSSJOIN").append("( ");
            if (this._measureOnTopRecheck == 1) {
                clause.append(this._multipleMeasures.toString()).append(", ").append(MDXGenerationUtil.NEWLINE).append(select).append(" )");
                this._measureOnTopRecheck = 0;
            } else {
                clause.append(select).append(MDX_COMMA).append(MDXGenerationUtil.NEWLINE).append(this._multipleMeasures.toString()).append(" )");
            }
        } else {
            clause.append(select);
        }
        return clause.toString();
    }

    private String applyStepsToQuery(Role role, String coreExpression) throws GenerationException {
        if (this._model.getSteps(role).isEmpty()) {
            return coreExpression;
        }
        StepManager stepManager = new StepManager(this._model, role);
        stepManager.setOLAPValue(this._olapValues);
        stepManager.setBottomExcludeMissingMeasures(this._measureBeingRankedCountSumPercentMDXVar);
        stepManager.setSpecialDataBaseFilterCondition(this._hasDatabasedFilterChildFilterWithTotals);
        stepManager.setAxisDefinition(this._axisDefForDataBasedSpecials);
        boolean isMeasureOnBottom = true;
        if (this._measureOnTop == 1) {
            isMeasureOnBottom = false;
        }
        boolean isTotalOn = false;
        if (role == Role.COLUMN) {
            if (TotalingType.TOTAL_NONE != this._model.getTotalingType(Role.COLUMN)) {
                isTotalOn = true;
            }
        } else if (role == Role.ROW && TotalingType.TOTAL_NONE != this._model.getTotalingType(Role.ROW)) {
            isTotalOn = true;
        }
        if (isTotalOn && role == Role.ROW && this._rowHasMeasure || isTotalOn && role == Role.COLUMN && this._colHasMeasure) {
            stepManager.setMeasures(this._multipleMeasures.toString(), isMeasureOnBottom);
        }
        String stepQueryExpression = stepManager.generateMDX(this._model, coreExpression);
        this._isMultiSortWithQueryFilter = stepManager.isMultiSortWithQueryFilter();
        return stepQueryExpression;
    }

    private void buildDisabledTotals(BusinessQuery query, List<DataItem> dsDataItems) throws MetadataException {
        Role roleOfMeasures = null;
        Role roleToCheck = null;
        for (DataItem dataItem : dsDataItems) {
            roleOfMeasures = query.getResultItemRole(dataItem);
            StructureOfDataItem structure = dataItem.getStructure();
            if (!structure.equals(StructureOfDataItem.STRUCTURE_MEASURE)) continue;
            roleOfMeasures = query.getResultItemRole(dataItem);
            break;
        }
        StringBuilder definitionOfDimension = new StringBuilder();
        if (roleOfMeasures == null || roleOfMeasures.equals(Role.HIDDEN) || roleOfMeasures.equals(Role.BACKGROUND)) {
            Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationBadRoleInDisable.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msF.toString());
            }
            return;
        }
        roleToCheck = Role.COLUMN;
        if (roleOfMeasures.equals(Role.COLUMN)) {
            roleToCheck = Role.ROW;
        }
        TotalingType rowTotalingType = query.getTotalingType(Role.ROW);
        TotalingType colTotalingType = query.getTotalingType(Role.COLUMN);
        boolean isTotalingOnRow = rowTotalingType != null && !rowTotalingType.equals(TotalingType.TOTAL_NONE);
        boolean isTotalingOnColumn = colTotalingType != null && !colTotalingType.equals(TotalingType.TOTAL_NONE);
        this._disableTotaledMeasures.clear();
        ArrayList<String> hierarhcyString = new ArrayList<String>();
        for (DataItem dataItem : dsDataItems) {
            ExpressionInterface expr;
            StructureOfDataItem structure = dataItem.getStructure();
            Role currentRole = query.getResultItemRole(dataItem);
            if (structure.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
                boolean isDisabled;
                boolean foundDisableSetting = false;
                if (isTotalingOnRow && (isDisabled = DisabledTotalsBuilder.isDisabledTotaling(query, dataItem, rowTotalingType))) {
                    foundDisableSetting = true;
                }
                if (isTotalingOnColumn && (isDisabled = DisabledTotalsBuilder.isDisabledTotaling(query, dataItem, colTotalingType))) {
                    foundDisableSetting = true;
                }
                if (!foundDisableSetting) continue;
                this._disableTotaledMeasures.add(dataItem);
                continue;
            }
            if (!structure.equals(StructureOfDataItem.STRUCTURE_HIERARCHY) || currentRole.equals(roleOfMeasures) || !((expr = dataItem.getExpression()) instanceof Hierarchy)) continue;
            Hierarchy hiearchary = (Hierarchy)expr;
            hierarhcyString.add(hiearchary.getUniqueName());
        }
        if (!this._disableTotaledMeasures.isEmpty()) {
            int end = hierarhcyString.size();
            int ct = 0;
            for (String string : hierarhcyString) {
                definitionOfDimension.append(string);
                if (++ct >= end) continue;
                definitionOfDimension.append(MDX_COMMA);
            }
            this._disableHierarchy = definitionOfDimension.toString();
        }
    }

    private String buildFinalSort(String labelTemp) throws GenerationException {
        List<DataItem> dataItems = this._model.getResultItems();
        StringBuilder finalSortBuffer = new StringBuilder();
        finalSortBuffer.append("");
        try {
            for (DataItem resultItem : dataItems) {
                ExpressionInterface expression;
                DataItemActionType sortDirection = resultItem.getSortDirection();
                if (sortDirection == DataItemActionType.SORT_NONE || !((expression = resultItem.getExpression()) instanceof Hierarchy)) continue;
                Hierarchy omaH = (Hierarchy)expression;
                String sortName = null;
                Dimension omaD = omaH.getOwningDimension();
                int dimType = omaD.getDimensionType();
                if (dimType != 0) {
                    sortName = (String)this.getOLAPValue(resultItem, OLAPItemType.MEMBERNAME);
                }
                if (sortName == null) continue;
                finalSortBuffer.append("ORDER(").append(labelTemp).append(MDX_COMMA).append(sortName).append(".CURRENTMEMBER.CAPTION");
                if (sortDirection == DataItemActionType.SORT_HIERARCHICAL_ASCENDING) {
                    finalSortBuffer.append(", ASC)");
                } else if (sortDirection == DataItemActionType.SORT_HIERARCHICAL_DESCENDING) {
                    finalSortBuffer.append(", DESC)");
                } else if (sortDirection == DataItemActionType.SORT_ASCENDING) {
                    finalSortBuffer.append(", BASC)");
                } else if (sortDirection == DataItemActionType.SORT_DESCENDING) {
                    finalSortBuffer.append(", BDESC)");
                }
                break;
            }
        }
        catch (MetadataException e) {
            Object[] msgArgs2 = new Object[]{e.getLocalizedMessage(), labelTemp, IQDataServicesResourceBundle.getStringResource("MDXGenerationBadFilterTypes.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msF.toString(), (Throwable)e);
            }
            return labelTemp;
        }
        return finalSortBuffer.toString();
    }

    private String buildFROMClause() throws GenerationException {
        StringBuilder FROMClause = new StringBuilder();
        FROMClause.append(MDXGenerationUtil.NEWLINE).append("FROM ").append("[").append(this._cubeName).append("]");
        return FROMClause.toString();
    }

    private String buildMDXBasedOnValueInFilterItemExpression(DataItem resultItem, String coreExpression) throws GenerationException {
        List<FilterItem> filters = this._olapValues.getFilterListForMDX();
        ExpressionInterface exprFilter = null;
        boolean found = false;
        for (FilterItem filter : filters) {
            exprFilter = filter.getExpression();
            String filterId = "";
            try {
                filterId = filter.getID();
            }
            catch (InvalidIDException e) {
                throw new GenerationException(e);
            }
            boolean isOldByGroup = false;
            if (exprFilter instanceof MemberFilterExpression && !(exprFilter instanceof BusinessGroupMemberFilterExpression) && filterId.length() > 0) {
                isOldByGroup = MDXGenerationUtil.isOldByGroupExpression(exprFilter, this._model, filterId, filter);
            }
            if (exprFilter instanceof DataBasedFilterExpression_Between || exprFilter instanceof SlicerFilterExpression || exprFilter instanceof BusinessGroupMemberFilterExpression || exprFilter instanceof DataBasedFilterExpression || isOldByGroup) {
                found = MDXGenerationUtil.doesFilterDataItemMatchResultItemBeingRead(exprFilter, resultItem);
            } else if (exprFilter instanceof MultipleConditionalExpression) {
                MultipleConditionalExpression baseMultiExprFilter = (MultipleConditionalExpression)exprFilter;
                List<ExpressionInterface> expressionMulti = baseMultiExprFilter.getExpressionList();
                for (ExpressionInterface expressionFromMultiCondi : expressionMulti) {
                    DataBasedFilterExpression_Between betweenExpr;
                    BaseFilterExpression baseFilter;
                    if (expressionFromMultiCondi instanceof BaseFilterExpression ? (found = MDXGenerationUtil.doesFilterDataItemMatchResultItemBeingRead(baseFilter = (BaseFilterExpression)expressionFromMultiCondi, resultItem)) : expressionFromMultiCondi instanceof DataBasedFilterExpression_Between && (found = MDXGenerationUtil.doesFilterDataItemMatchResultItemBeingRead(betweenExpr = (DataBasedFilterExpression_Between)expressionFromMultiCondi, resultItem))) break;
                }
            }
            if (!found) continue;
            break;
        }
        String MDXExpression = coreExpression;
        if (found) {
            CompoundStep filterStepForDataItem = new CompoundStep();
            StepInterface step = MDXGenerationUtil.generateStepsForFilterExpression(exprFilter);
            if (step != null) {
                filterStepForDataItem.addStep(step);
                if (exprFilter instanceof MultipleConditionalExpression) {
                    filterStepForDataItem.setConditionType("AND");
                }
            }
            StepManager manager = new StepManager(filterStepForDataItem);
            manager.setOLAPValue(this._olapValues);
            MDXExpression = manager.generateMDX(this._model, coreExpression);
        }
        return MDXExpression;
    }

    private String buildMDXForDataItemThatArePartOfAStepButNotInResultItems(List<DataItem> resultItemsWithStep) throws GenerationException {
        List<DataItem> orphanedStepDataItems;
        StringBuilder mdxStep = new StringBuilder();
        ArrayList<ExpressionInterface> listOfPossibleDataItem = new ArrayList<ExpressionInterface>();
        for (DataItem resultItem : resultItemsWithStep) {
            List<StepInterface> stepsCheck;
            if (!resultItem.hasSteps() || (stepsCheck = resultItem.getSteps()) == null || stepsCheck.size() <= 0) continue;
            for (StepInterface step : stepsCheck) {
                DataItemRankFilter datatItemRankDefinition;
                List<ExpressionInterface> rankQualifiers;
                if (step instanceof DataItemDataBasedFilter) {
                    DataItemDataBasedFilter dataItemDBFilterDefinition = (DataItemDataBasedFilter)step;
                    List<ExpressionInterface> leftExpression = dataItemDBFilterDefinition.getLeftExpression();
                    if (!leftExpression.isEmpty()) {
                        listOfPossibleDataItem.addAll(leftExpression);
                    }
                    ArrayList<NonCalculatedValue> rightExpression = new ArrayList<NonCalculatedValue>();
                    rightExpression.addAll(dataItemDBFilterDefinition.getRightExpression());
                    if (rightExpression.isEmpty()) continue;
                    listOfPossibleDataItem.addAll(rightExpression);
                    continue;
                }
                if (!(step instanceof DataItemRankFilter) || (rankQualifiers = (datatItemRankDefinition = (DataItemRankFilter)step).getRankQualifiers()) == null || rankQualifiers.isEmpty()) continue;
                listOfPossibleDataItem.addAll(rankQualifiers);
            }
        }
        List<DataItem> dataItemsFound = MDXGenerationUtil.getListOfAllDataItemsHiddenAndShown(listOfPossibleDataItem.iterator());
        if (!dataItemsFound.isEmpty() && (orphanedStepDataItems = MDXGenerationUtil.getOrphanedList(dataItemsFound, this._olapValues)) != null) {
            this._olapValues.buildOLAPDataItemComponents(orphanedStepDataItems, this._olapValues.getOLAPConstantValues(), true, this._cubeName);
            for (DataItem dataItem : orphanedStepDataItems) {
                if (dataItem == null || dataItem.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE || MDXGenerationUtil.isHiddenItem(dataItem, this.getHiddenResults())) continue;
                String buildMDXForOrphan = MDXGenerationUtil.buildMDXForOrphan(dataItem, mdxStep.toString(), this._olapValues, this._model);
                mdxStep.append(buildMDXForOrphan);
            }
        }
        return mdxStep.toString();
    }

    private List<String> buildMDXForDataItemWithCubePropeties(List<String> memberPropertyList, String fullMemberAddress) {
        ArrayList<String> individualPropertyList = new ArrayList<String>();
        StringBuilder buildPropMDX = new StringBuilder();
        for (String valueOfIndividualPropertyInList : memberPropertyList) {
            if (valueOfIndividualPropertyInList.length() > 0) {
                buildPropMDX.append(fullMemberAddress).append(".[").append(valueOfIndividualPropertyInList).append("]");
            }
            individualPropertyList.add(buildPropMDX.toString());
            buildPropMDX.replace(0, buildPropMDX.length(), "");
        }
        return individualPropertyList;
    }

    private String buildUserDimensionPropertyMDX(List<String> propertyList) {
        String separator = MDX_COMMA + MDXGenerationUtil.NEWLINE;
        return StringUtils.join(propertyList, (String)separator);
    }

    private void buildMDXForFilterWithDataItemNotInResultItems() throws GenerationException {
        List<FilterItem> filters = this._olapValues.getFilterListForMDX();
        for (FilterItem filter : filters) {
            GenerationException ge;
            DataItem filterDataItem = this.getOrphanedFilterDataItem(filter);
            if (filterDataItem == null) {
                return;
            }
            String asClause = MDXGenerationUtil.buildAsClauseForOrphanedFilter(filter, filterDataItem, this._model, this._olapValues);
            String filterId = null;
            if (filter == null) {
                Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationNullFilterId.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                ge = new GenerationException(msF);
                throw ge;
            }
            ExpressionInterface filterExpression = filter.getExpression();
            try {
                filterId = filter.getID();
            }
            catch (InvalidIDException e) {
                _logger.error((Object)filter);
                throw new GenerationException(e);
            }
            if (filterId == null) {
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, IQDataServicesResourceBundle.getStringResource("MDXGenerationNullFilterId.txt"));
                ge = new GenerationException(msF);
                throw ge;
            }
            boolean isOldByGroup = MDXGenerationUtil.isOldByGroupExpression(filterExpression, this._model, filterId, filter);
            if (filterExpression instanceof SlicerFilterExpression) {
                this._slicerPhraseWhereMap.put(filterDataItem, asClause);
                this._slicerWhereList.add(filterDataItem);
                continue;
            }
            if (isOldByGroup) {
                this._slicerPhraseWhereMap.put(filterDataItem, asClause);
                this._slicerWhereList.add(filterDataItem);
                continue;
            }
            if (filterDataItem == null) continue;
            MDXVariable mdxVariable = MDXGenerationUtil.getOrphanedMDXVariableOrCreate(filterDataItem, null, this._olapValues, this._model);
            mdxVariable.setAggregateOn(true);
            mdxVariable.setMDXExpression(asClause);
            this._olapValues.setOLAPValue(filterDataItem, OLAPItemType.MDXVARIABLE, mdxVariable);
            this._WITHClause.append(MDXGenerationUtil.NEWLINE).append("     ").append(mdxVariable.getMDXPhrase());
        }
    }

    private void buildMDXForHiddenBackgroundDataItem(List<DataItem> resultItems) throws GenerationException {
        List<DataItem> hiddens = this.getHiddenResults();
        for (DataItem resultItem : hiddens) {
            String core;
            if (this._olapValues.isSlicerFilterApplied(resultItem.getLabel()) && !MDXGenerationUtil.isHiddenGroupFilter(resultItem, this._olapValues)) continue;
            boolean isApplyDataItemToWith = true;
            boolean applytoSlicer = true;
            boolean isCalculated = false;
            String whereStep = core = MDXGenerationUtil.buildMembersDefinition(resultItem, this._olapValues, this._model);
            ExpressionInterface expressionForResultItem = resultItem.getExpression();
            StructureOfDataItem struct = resultItem.getStructure();
            MDXVariable mdxVariable = null;
            if (expressionForResultItem instanceof ResourceAwareStringExpression || expressionForResultItem instanceof TimeExpressionMeasure) {
                isCalculated = true;
            }
            try {
                int indexA;
                Object lastStepNav;
                if (MDXGenerationUtil.isDataItemInList(this._dataItemsInQuerySteps, resultItem.getLabel()) && struct == StructureOfDataItem.STRUCTURE_MEASURE) {
                    applytoSlicer = false;
                } else if (expressionForResultItem instanceof FractionOfTotalExpression) {
                    applytoSlicer = false;
                }
                boolean hasSteps = resultItem.hasSteps();
                Role role = this._model.getResultItemRole(resultItem);
                if (role == null) {
                    role = struct == StructureOfDataItem.STRUCTURE_MEASURE ? Role.BACKGROUND : Role.COLUMN;
                }
                if (MDXGenerationUtil.isDataItemInList(this._dataItemsInQuerySteps, resultItem.getLabel()) && struct == StructureOfDataItem.STRUCTURE_MEASURE && !isCalculated && role == Role.BACKGROUND) {
                    applytoSlicer = true;
                }
                if (hasSteps) {
                    if (resultItem.getSteps().size() > 0) {
                        StepInterface lastStep = resultItem.getStep(-999);
                        if (lastStep instanceof DataItemMemberFilter) {
                            DataItemMemberFilter daMemFilterStep = (DataItemMemberFilter)lastStep;
                            if (!daMemFilterStep.isNegated()) {
                                isApplyDataItemToWith = MDXGenerationUtil.isMultipleMemberInStep(lastStep, resultItem);
                                whereStep = MemberFilter.getMDXExpression(this._model, core, (DataItemMemberFilter)lastStep);
                            }
                        } else if (lastStep instanceof DataItemNavigationFilter && ((DataItemNavigationFilter)(lastStepNav = (DataItemNavigationFilter)lastStep)).getNavigationFilterType() == 4 && ((BaseFilter)lastStepNav).getActionType() != 6) {
                            whereStep = ((DataItemNavigationFilter)lastStepNav).getNavigationName();
                            isApplyDataItemToWith = false;
                        }
                    }
                } else if (!Role.isOutputResultRole(this._model, role) && struct != StructureOfDataItem.STRUCTURE_MEASURE && !isCalculated) {
                    applytoSlicer = false;
                }
                if (role == Role.HIDDEN && struct == StructureOfDataItem.STRUCTURE_MEASURE) {
                    applytoSlicer = false;
                    if (!isCalculated) {
                        isApplyDataItemToWith = false;
                    }
                }
                if (!(MDXGenerationUtil.isDataItemInList(this._dataItemsInAllQuerySteps, resultItem.getLabel()) || applytoSlicer || MDXGenerationUtil.isDataItemInList(this._dataItemsInOtherDataItems, resultItem.getLabel()) || MDXGenerationUtil.isDataItemInList(this._dataItemsInQuerySort, resultItem.getLabel()))) {
                    isApplyDataItemToWith = false;
                }
                if (expressionForResultItem instanceof OLAPResourceAwareStringExpression && !hasSteps && struct != StructureOfDataItem.STRUCTURE_MEASURE) {
                    OLAPResourceAwareStringExpression olapRase = (OLAPResourceAwareStringExpression)expressionForResultItem;
                    isApplyDataItemToWith = olapRase.hasMultipleMembers();
                    if (olapRase.getParentOfChild().length() > 0 && !isApplyDataItemToWith) {
                        whereStep = olapRase.getParentOfChild();
                    }
                }
                if (!(!isApplyDataItemToWith || this._olapValues.isFormatDifferent(resultItem) || expressionForResultItem instanceof OLAPResourceAwareStringExpression || expressionForResultItem instanceof TimeExpressionMeasure || isCalculated || struct != StructureOfDataItem.STRUCTURE_MEASURE || MDXGenerationUtil.isDataItemInList(this._dataItemsInOtherDataItems, resultItem.getLabel()))) {
                    isApplyDataItemToWith = false;
                }
                if (this._olapValues.isSlicerFilterApplied(resultItem.getLabel()) && !hasSteps && role == Role.HIDDEN && MDXGenerationUtil.isHiddenGroupFilter(resultItem, this._olapValues)) {
                    List<FilterItem> filters = this._olapValues.getFilterListForMDX();
                    lastStepNav = filters.iterator();
                    while (lastStepNav.hasNext()) {
                        DataItemMemberFilter daMemFilterStep;
                        StepInterface lastStep;
                        FilterItem filter = (FilterItem)lastStepNav.next();
                        ExpressionInterface filterExpression = filter.getExpression();
                        if (!(filterExpression instanceof BusinessGroupMemberFilterExpression) || !((lastStep = MDXGenerationUtil.generateStepsForFilterExpression(filterExpression)) instanceof DataItemMemberFilter) || (daMemFilterStep = (DataItemMemberFilter)lastStep).isNegated()) continue;
                        isApplyDataItemToWith = true;
                        whereStep = MemberFilter.getMDXExpression(this._model, core, (DataItemMemberFilter)lastStep);
                    }
                }
                if (isApplyDataItemToWith && struct == StructureOfDataItem.STRUCTURE_MEASURE) {
                    mdxVariable = MDXGenerationUtil.getOrphanedMDXVariableOrCreate(resultItem, this._olapValues.getMeasureCaption(), this._olapValues, this._model);
                    mdxVariable.setSpecialLabel(true);
                    mdxVariable.setCounter(mdxVariable.getCounter());
                    mdxVariable.setLabel(this._olapValues.getMeasureCaption());
                    if (expressionForResultItem instanceof TimeExpressionMeasure) {
                        mdxVariable.setMDXExpression(this.buildRelativeTimeMeasureMDX(expressionForResultItem, resultItem, resultItems));
                    }
                    this._olapValues.setOLAPValue(resultItem, OLAPItemType.MDXVARIABLE, mdxVariable);
                    this._WITHClause.append(mdxVariable.getMDXPhrase());
                    if (!applytoSlicer) continue;
                    this._slicerPhraseWhereMap.put(resultItem, mdxVariable.getLabel());
                    continue;
                }
                if (isApplyDataItemToWith && struct != StructureOfDataItem.STRUCTURE_MEASURE) {
                    mdxVariable = MDXGenerationUtil.getOrphanedMDXVariableOrCreate(resultItem, null, this._olapValues, this._model);
                    mdxVariable.setAggregateOn(true);
                    StepManager sm = new StepManager(resultItem);
                    sm.setOLAPValue(this._olapValues);
                    mdxVariable.setSteps(sm, this._model);
                    String mdx = mdxVariable.getMDXPhrase();
                    this._olapValues.setOLAPValue(resultItem, OLAPItemType.MDXVARIABLE, mdxVariable);
                    this._WITHClause.append(mdx);
                    continue;
                }
                if (!applytoSlicer) continue;
                if (whereStep.startsWith("{ ")) {
                    whereStep = whereStep.substring(1);
                }
                if ((indexA = whereStep.indexOf("} ")) > 0) {
                    whereStep = whereStep.substring(0, indexA);
                }
                this._slicerPhraseWhereMap.put(resultItem, whereStep);
            }
            catch (MetadataException e) {
                Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationMetaExcOrphanFil.txt")};
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(resultItem.toString());
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(msF.toString());
                }
                throw new GenerationException((MessageFormatter)msF, (Throwable)e);
            }
        }
    }

    private String buildRelativeTimeMeasureMDX(ExpressionInterface expressionForRTM, DataItem resultItem, List<DataItem> resultItems) throws GenerationException {
        TimeExpressionMeasure tcmExpress = (TimeExpressionMeasure)expressionForRTM;
        DataItem rtmMeasureT = tcmExpress.getMeasure();
        boolean checkCalculatedInMeasure = true;
        if (this._rtmMeasure != null && rtmMeasureT.getLabel().equalsIgnoreCase(this._rtmMeasure.getLabel())) {
            checkCalculatedInMeasure = false;
        }
        this._rtmMeasure = rtmMeasureT;
        return TimeMeasureExpression.generateMDX(resultItems, this._model, tcmExpress, resultItem, this._relativeTimeOrphanedMeasures, checkCalculatedInMeasure, this._olapValues);
    }

    private void getRowsAndColumns(List<DataItem> resultItems) throws GenerationException {
        for (DataItem resultItem : resultItems) {
            Role role = null;
            try {
                role = this._model.getResultItemRole(resultItem);
            }
            catch (MetadataException me) {
                Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationMetaExcSelect.txt")};
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(resultItem.toString());
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(msF.toString());
                }
                throw new GenerationException((MessageFormatter)msF, (Throwable)me);
            }
            if (role == null) {
                if (resultItem.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) continue;
                this._columns.add(resultItem);
                continue;
            }
            if (role == Role.ROW) {
                this._rows.add(resultItem);
                continue;
            }
            if (role == Role.COLUMN) {
                this._columns.add(resultItem);
                continue;
            }
            if (role == Role.PAGE) {
                Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationBadFilterTypes.txt")};
                if (_logger.isEnabled(Level.ERROR)) {
                    _logger.error(role.toString());
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException ge = new GenerationException(msF);
                throw ge;
            }
            if (!Role.isOutputResultRole(this._model, role)) continue;
            this._columns.add(resultItem);
        }
    }

    private String constructSpecialOrderVisuallyTotaledColumn(String select, String sortedMeasure) {
        StringBuilder mdx = new StringBuilder();
        List<SelectedItem> selected = this._model.getSelectedItems();
        Iterator<SelectedItem> selIterator = selected.iterator();
        int numberOfPercent = 0;
        String foundSortedMeasure = "";
        while (selIterator.hasNext()) {
            String label;
            SelectedItem item = selIterator.next();
            DataItem dataItem = item.getItem();
            if (!dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE) || !(label = dataItem.getLabel()).equals(sortedMeasure)) continue;
            foundSortedMeasure = label;
        }
        for (SelectedItem item : selected) {
            DataItem dataItem = item.getItem();
            String label = dataItem.getLabel();
            if (!dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE)) continue;
            ExpressionInterface expression = dataItem.getExpression();
            if (expression instanceof FractionOfTotalExpression) {
                ++numberOfPercent;
            } else if (!(foundSortedMeasure.equals("") || expression instanceof FractionOfTotalExpression || label.equalsIgnoreCase(sortedMeasure))) {
                ++numberOfPercent;
            }
            if (expression instanceof FractionOfTotalExpression || !label.equalsIgnoreCase(sortedMeasure)) continue;
            break;
        }
        String localMeasure = MDXGenerationUtil.getLocalMeasure(this._model, this._metaInterface);
        mdx.append(MDXGenerationUtil.NEWLINE).append(" SET ").append(this._sortedSetWithMeasures).append(" AS '").append(select).append("' ").append(MDXGenerationUtil.NEWLINE).append(" member ").append(localMeasure);
        if (this._model.getTotalLocation().equals(BusinessQueryTotalLocationType.TOTAL_TOTAL_ROW_TOP_COLUMN_LEFT)) {
            mdx.append(".[COUNTOFSET] as '").append(numberOfPercent);
        } else {
            mdx.append(".[COUNTOFSET] as 'count(").append(this._sortedSetWithMeasures).append(")-").append(this._countOfMeasuresOnAxis);
        }
        mdx.append("'").append(MDXGenerationUtil.NEWLINE);
        return mdx.toString();
    }

    private void determineCountForLastRealColumnOfSelectedSortedMeasure(Role role, String sortedMeasureLabel) throws MetadataException {
        if (this._measureOnTopRecheck > 1) {
            ArrayList<String> tempList = new ArrayList<String>();
            List<DataItem> dataItems = this._model.getResultItems(role);
            for (DataItem dataItem : dataItems) {
                StructureOfDataItem structure = dataItem.getStructure();
                if (structure != StructureOfDataItem.STRUCTURE_MEASURE) continue;
                tempList.add(dataItem.getLabel());
            }
            int ctt = tempList.size();
            for (int i = 0; i < tempList.size(); ++i) {
                --ctt;
                String check = (String)tempList.get(i);
                if (sortedMeasureLabel.equalsIgnoreCase(check)) break;
            }
            this._countOfMeasuresOnAxis += ctt;
        }
    }

    private void determineIfRoleIsVisualTotaledAndSorted(Role roleOfSort, Role roleOfTotal, Locale effectiveComputationLocale) throws MetadataException {
        BusinessQueryActionType sortDirection = this._model.getSortDirection(roleOfSort);
        if (sortDirection != BusinessQueryActionType.SORT_NONE && this._model.getTotalMode() == BusinessQueryTotalModeType.VISUAL_VALUES && TotalingType.TOTAL_NONE != this._model.getTotalingType(roleOfTotal)) {
            List<Object> sortCriteria = this._model.getSortCriteria(roleOfSort);
            this._sortMeasure = MDXGenerationUtil.getLabelForSelectedSortedMeasure(sortCriteria, this._olapValues);
            if (this._sortMeasure != null) {
                List<String> dimensionWithAllMembers = MDXGenerationUtil.getAllLevelsForDimensionOnAxis(roleOfTotal, this._model);
                this.determineCountForLastRealColumnOfSelectedSortedMeasure(roleOfTotal, this._sortMeasure);
                if (dimensionWithAllMembers.size() > 0) {
                    this._sortedVisualMeasureOn = MDXGenerationUtil.isAllLevelsSelectedInSort(sortCriteria, dimensionWithAllMembers);
                    if (this._sortedVisualMeasureOn) {
                        this._sortedTotalRole = roleOfTotal;
                        String roleOfTotalText = roleOfTotal.toString(effectiveComputationLocale);
                        this._sortedSetWithMeasures = "[&&" + roleOfTotalText + "]";
                        String localMeasure = MDXGenerationUtil.getLocalMeasure(this._model, this._metaInterface);
                        this._specialSortedMeasureDefintion = this._sortedSetWithMeasures + ".ITEM(" + localMeasure + ".[COUNTOFSET])";
                    }
                }
            }
        }
    }

    private String buildSELECTClause(List<DataItem> resultItems, Locale effectiveComputationLocale) throws GenerationException {
        String rowSelect;
        StringBuilder SELECTClause = new StringBuilder();
        this.getRowsAndColumns(resultItems);
        MDXGenerationUtil.applyDebugStatement("SELECT Clause in MDX generation being built: ", this.getClass());
        boolean isNonEmpty = this._model.getQueryProperty(BusinessQueryProperty.EXCLUDE_EMPTY_DATA);
        String columnSelect = this.buildSelectParcel(this._columns, Role.COLUMN, this._anyTotalInColumn, this._totalColumn, effectiveComputationLocale);
        if (columnSelect.length() > 0) {
            columnSelect = this.setNamedSetForDataBasedFilterEdgeCase(COLUMNAXISLABEL, columnSelect, Role.COLUMN);
        }
        if (TotalingType.TOTAL_NONE != this._anyTotalInColumn) {
            columnSelect = this._totalColumn.generateFinalTotal(columnSelect);
            if (!this._isMeasureIncludedInCrossJoin && this._measureOnTop > 0) {
                columnSelect = columnSelect.length() > 0 ? this.applyMeasureInCrossJoin(columnSelect, Role.COLUMN) : this._multipleMeasures.toString();
                this._measureOnTop = 0;
                this._isMeasureIncludedInCrossJoin = true;
            }
        }
        if ((rowSelect = this.buildSelectParcel(this._rows, Role.ROW, this._anyTotalInRow, this._totalRow, effectiveComputationLocale)).length() > 0) {
            rowSelect = this.setNamedSetForDataBasedFilterEdgeCase(ROWAXISLABEL, rowSelect, Role.ROW);
        }
        this._measureBeingRankedCountSumPercentMDXVar.clear();
        if (TotalingType.TOTAL_NONE != this._anyTotalInRow) {
            rowSelect = this._totalRow.generateFinalTotal(rowSelect);
            if (!this._isMeasureIncludedInCrossJoin && this._measureOnTop > 0) {
                rowSelect = rowSelect.length() > 0 ? this.applyMeasureInCrossJoin(rowSelect, Role.ROW) : this._multipleMeasures.toString();
                this._measureOnTop = 0;
                this._isMeasureIncludedInCrossJoin = true;
            }
        }
        if (this._colAlternateString.length() > 2) {
            if (TotalingType.TOTAL_NONE == this._anyTotalInColumn && (this._isGrandTotalContribution || this._isColTotalContribution || this._isRowTotalContribution)) {
                this._totalColumn.setIsNoTotalWithRelativeContribution(true);
            }
            String wrapperTotCol = this._totalColumn.generateFinalTotal(this._colAlternateString.toString());
            this._colAlternateString.delete(0, this._colAlternateString.length());
            this._colAlternateString.append(wrapperTotCol);
        }
        if (this._rowAlternateString.length() > 2) {
            if (TotalingType.TOTAL_NONE == this._anyTotalInRow && (this._isGrandTotalContribution || this._isRowTotalContribution || this._isColTotalContribution)) {
                this._totalRow.setIsNoTotalWithRelativeContribution(true);
            }
            String wrapperTotRow = this._totalRow.generateFinalTotal(this._rowAlternateString.toString());
            this._rowAlternateString.delete(0, this._rowAlternateString.length());
            this._rowAlternateString.append(wrapperTotRow);
        }
        if (this._totalPercentASList.size() > 0) {
            boolean applyPercentRow = true;
            boolean applyPercentCol = true;
            boolean applyPercentGrand = true;
            String stringToContributionCol = columnSelect;
            if (this._rowHasMeasureWithPercentage || TotalingType.TOTAL_NONE == this._anyTotalInColumn) {
                stringToContributionCol = this._colAlternateString.toString();
            }
            String stringToContributionRow = rowSelect;
            if (this._colHasMeasureWithPercentage || TotalingType.TOTAL_NONE == this._anyTotalInRow) {
                stringToContributionRow = this._rowAlternateString.toString();
            }
            String colAdditionToSelect = "";
            String rowAdditionToSelect = "";
            boolean addWithPhrase = true;
            for (FractionTotalExpression fTotalExpGen : this._totalPercentASList) {
                String fTotalExpGenAxis = fTotalExpGen.getaxisApplied();
                if (this._WITHClause.length() == 0 && addWithPhrase && SELECTClause.length() == 0) {
                    SELECTClause.append("WITH");
                    addWithPhrase = false;
                }
                SELECTClause.append(MDXGenerationUtil.NEWLINE).append(MDXGenerationUtil.NEWLINE).append(fTotalExpGen.getOrphanedNumerator());
                fTotalExpGen.setFractionalSet(stringToContributionRow, stringToContributionCol);
                SELECTClause.append(MDXGenerationUtil.NEWLINE).append(fTotalExpGen.getFractionTotalExpression());
                if (fTotalExpGenAxis.equalsIgnoreCase(ROWAXISLABEL) && applyPercentCol) {
                    applyPercentCol = false;
                    rowAdditionToSelect = fTotalExpGen.getFractionalSet(Role.ROW);
                    rowSelect = fTotalExpGen.getSelectLabel(Role.ROW);
                    if (!this._rowHasMeasure) continue;
                    rowSelect = this.applyMeasureInCrossJoin(rowSelect, Role.ROW);
                    continue;
                }
                if (fTotalExpGenAxis.equalsIgnoreCase(COLUMNAXISLABEL) && applyPercentRow) {
                    applyPercentRow = false;
                    colAdditionToSelect = fTotalExpGen.getFractionalSet(Role.COLUMN);
                    columnSelect = fTotalExpGen.getSelectLabel(Role.COLUMN);
                    if (!this._colHasMeasure) continue;
                    columnSelect = this.applyMeasureInCrossJoin(columnSelect, Role.COLUMN);
                    continue;
                }
                if (!fTotalExpGenAxis.equalsIgnoreCase("GRAND_AXIS") || !applyPercentGrand) continue;
                applyPercentGrand = false;
                applyPercentRow = false;
                applyPercentCol = false;
                colAdditionToSelect = fTotalExpGen.getFractionalSet(Role.COLUMN);
                rowAdditionToSelect = fTotalExpGen.getFractionalSet(Role.ROW);
                rowSelect = fTotalExpGen.getSelectLabel(Role.ROW);
                columnSelect = fTotalExpGen.getSelectLabel(Role.COLUMN);
                if (this._rowHasMeasure) {
                    rowSelect = this.applyMeasureInCrossJoin(rowSelect, Role.ROW);
                }
                if (!this._colHasMeasure) continue;
                columnSelect = this.applyMeasureInCrossJoin(columnSelect, Role.COLUMN);
            }
            SELECTClause.append(MDXGenerationUtil.NEWLINE).append(colAdditionToSelect).append(MDXGenerationUtil.NEWLINE).append(rowAdditionToSelect);
        }
        if (this._sortedVisualMeasureOn) {
            if (this._sortedTotalRole == Role.COLUMN) {
                if (this._WITHClause.length() == 0 && SELECTClause.length() == 0) {
                    SELECTClause.append("WITH ");
                }
                SELECTClause.append(this.constructSpecialOrderVisuallyTotaledColumn(columnSelect, this._sortMeasure));
                columnSelect = this._sortedSetWithMeasures;
            } else if (this._sortedTotalRole == Role.ROW) {
                if (this._WITHClause.length() == 0 && SELECTClause.length() == 0) {
                    SELECTClause.append("WITH ");
                }
                SELECTClause.append(this.constructSpecialOrderVisuallyTotaledColumn(rowSelect, this._sortMeasure));
                rowSelect = this._sortedSetWithMeasures;
            }
        } else if (this._hasDatabasedFilterChildFilterWithTotals) {
            if (this._WITHClause.length() == 0 && SELECTClause.length() == 0) {
                SELECTClause.append("WITH ");
            }
            SELECTClause.append(this._hasDatabasedFilterEdgeWithClause.toString());
        }
        if (this._preFilterString != null && this._preFilterString.length() > 0) {
            SELECTClause.append(MDXGenerationUtil.NEWLINE).append(this._preFilterString).append(MDXGenerationUtil.NEWLINE);
        }
        SELECTClause.append(MDXGenerationUtil.NEWLINE).append("SELECT ");
        if (isNonEmpty) {
            SELECTClause.append(" NON EMPTY ");
        }
        SELECTClause.append(columnSelect);
        if (this._colHasMeasure && this._model.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_MEASURE_GROUPING)) {
            this._columnProperty.add(GROUP);
        }
        if (TotalingType.TOTAL_NONE != this._anyTotalInColumn || this._isVisualTotalOnOnlyCol) {
            this._columnProperty.add(MDX_TOTAL_PROP);
        }
        if (this._columnProperty.size() > 0) {
            SELECTClause.append(MDX_DIM_PROP);
            String columnPropertyString = this.buildUserDimensionPropertyMDX(this._columnProperty);
            SELECTClause.append(columnPropertyString);
        }
        SELECTClause.append(" ON COLUMNS ");
        if (rowSelect.length() > 0) {
            SELECTClause.append(", ").append(MDXGenerationUtil.NEWLINE);
            if (isNonEmpty) {
                SELECTClause.append(" NON EMPTY ");
            }
            SELECTClause.append(rowSelect);
            if (this._rowHasMeasure && this._model.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_MEASURE_GROUPING)) {
                this._rowProperty.add(GROUP);
            }
            if (TotalingType.TOTAL_NONE != this._anyTotalInRow || this._isVisualTotalOnOnlyRow) {
                this._rowProperty.add(MDX_TOTAL_PROP);
            }
            if (this._rowProperty.size() > 0) {
                SELECTClause.append(MDX_DIM_PROP);
                String rowPropertyString = this.buildUserDimensionPropertyMDX(this._rowProperty);
                SELECTClause.append(rowPropertyString);
            }
            SELECTClause.append(" ON ROWS ").append(MDXGenerationUtil.NEWLINE);
        }
        return SELECTClause.toString();
    }

    private String setNamedSetForDataBasedFilterEdgeCase(String setWrapperLabel, String clause, Role role) {
        String returnValue = clause;
        if (this._hasDatabasedFilterChildFilterWithTotals) {
            StringBuilder mdx = new StringBuilder();
            if (role == Role.ROW) {
                if (TotalingType.TOTAL_NONE != this._model.getTotalingType(Role.ROW) && this._colHasMeasure) {
                    this.buildVTSIZEclause(clause);
                }
            } else if (role == Role.COLUMN && TotalingType.TOTAL_NONE != this._model.getTotalingType(Role.COLUMN) && this._rowHasMeasure) {
                this.buildVTSIZEclause(clause);
            }
            if (TotalingType.TOTAL_NONE != this._model.getTotalingType(Role.ROW)) {
                clause = this._totalRow.generateFinalTotal(clause);
            } else if (TotalingType.TOTAL_NONE != this._model.getTotalingType(Role.COLUMN)) {
                clause = this._totalColumn.generateFinalTotal(clause);
            }
            this._axisDefForDataBasedSpecials = setWrapperLabel;
            mdx.append(" SET ").append(setWrapperLabel).append(" AS '").append(clause).append("'");
            this._hasDatabasedFilterEdgeWithClause.append(MDXGenerationUtil.NEWLINE).append(mdx.toString());
            returnValue = "[" + setWrapperLabel + "]";
        }
        return returnValue;
    }

    private String buildSelectParcel(List<DataItem> rowOrColumn, Role role, TotalingType totalType, BusinessQueryTotal totalIt, Locale effectiveComputationLocale) throws GenerationException {
        boolean isOutputResultRole;
        Object structResultItem;
        int openParnCount = 0;
        int openParnCountAlt = 0;
        int numSetsinXJoin = 0;
        String nonEmptyCrossJoin = "NONEMPTYCROSSJOIN";
        BusinessQueryActionType sortDirectionColumnOrRow = this._model.getSortDirection(role);
        boolean continueAddingParents = true;
        boolean addParentOnRow = true;
        boolean addParentOnCol = true;
        boolean measureTopOrBottom = false;
        boolean isUseNonNestedCJ = Boolean.valueOf(System.getProperty("SASQueryServices.useNonNestedCrossJoin", this.USE_NON_NESTED_CROSSJOIN_DEFAULT));
        for (StepInterface step : this._model.getSteps(role)) {
            if (!(step instanceof BusinessQueryRankFilter) || !this._model.getQueryProperty(BusinessQueryProperty.EXCLUDE_EMPTY_DATA)) continue;
            if (role == Role.ROW) {
                this._bottomRankPercentExcludeRow = true;
                break;
            }
            if (role != Role.COLUMN) continue;
            this._bottomRankPercentExcludeCol = true;
            break;
        }
        StringBuilder rowOrColumnBuffer = new StringBuilder();
        StringBuilder rowOrColumnSelect = new StringBuilder();
        int iteratorCount = 0;
        boolean measureFoundHere = false;
        int hierCount = 0;
        for (DataItem resultItem : rowOrColumn) {
            structResultItem = resultItem.getStructure();
            isOutputResultRole = Role.isOutputResultRole(this._model, role);
            ++iteratorCount;
            if (!isOutputResultRole || structResultItem != StructureOfDataItem.STRUCTURE_MEASURE) continue;
            measureFoundHere = true;
            this._measureOnTopRecheck = iteratorCount;
            break;
        }
        for (DataItem resultItem : rowOrColumn) {
            structResultItem = resultItem.getStructure();
            isOutputResultRole = Role.isOutputResultRole(this._model, role);
            if (!isOutputResultRole || structResultItem != StructureOfDataItem.STRUCTURE_HIERARCHY) continue;
            ++hierCount;
        }
        if (!(TotalingType.TOTAL_NONE == totalType || this._isGrandTotalContribution || this._isColTotalContribution || this._isRowTotalContribution)) {
            if (measureFoundHere && (iteratorCount == 1 || iteratorCount == rowOrColumn.size())) {
                this._isMeasureIncludedInCrossJoin = false;
                this._measureOnTop = iteratorCount;
            }
        } else if ((this._isGrandTotalContribution || this._isColTotalContribution || this._isRowTotalContribution) && measureFoundHere && (iteratorCount == 1 || iteratorCount == rowOrColumn.size())) {
            measureTopOrBottom = true;
        }
        if (measureFoundHere) {
            MessageFormatter formatter;
            if (role == Role.COLUMN) {
                this._colHasMeasure = true;
                try {
                    this.determineIfRoleIsVisualTotaledAndSorted(Role.ROW, role, effectiveComputationLocale);
                }
                catch (MetadataException e) {
                    formatter = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationCannotDetermineAllMember.txt", new Object[0]);
                    _logger.error((Object)formatter, (Throwable)e);
                    throw new GenerationException(formatter, (Throwable)e);
                }
            }
            if (role == Role.ROW) {
                this._rowHasMeasure = true;
                try {
                    this.determineIfRoleIsVisualTotaledAndSorted(Role.COLUMN, role, effectiveComputationLocale);
                }
                catch (MetadataException e) {
                    formatter = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationCannotDetermineAllMember.txt", new Object[0]);
                    _logger.error((Object)formatter, (Throwable)e);
                    throw new GenerationException(formatter, (Throwable)e);
                }
            }
        }
        iteratorCount = 0;
        boolean isAlreadyInNECrossJoin = false;
        boolean isAlreadyInCrossJoin = false;
        for (DataItem resultItem : rowOrColumn) {
            StringBuilder clause;
            boolean bl;
            StructureOfDataItem structResultItem2 = resultItem.getStructure();
            boolean containsMemberOrTimeFilter = false;
            List<StepInterface> searchForSpecificStep = resultItem.getSteps();
            for (StepInterface stepInterface : searchForSpecificStep) {
                if (!(stepInterface instanceof DataItemMemberFilter) && !(stepInterface instanceof DataItemTimeFilter)) continue;
                containsMemberOrTimeFilter = true;
                break;
            }
            boolean containsMemberOrNavigationFilter = false;
            for (StepInterface step : searchForSpecificStep) {
                if (!(step instanceof DataItemNavigationFilter) && !(step instanceof DataItemMemberFilter)) continue;
                containsMemberOrNavigationFilter = true;
                break;
            }
            if (!(bl = Role.isOutputResultRole(this._model, role))) continue;
            StructureOfDataItem structureOfLookAhead = structResultItem2;
            if (++iteratorCount < rowOrColumn.size() && structureOfLookAhead != StructureOfDataItem.STRUCTURE_MEASURE && measureTopOrBottom) {
                structureOfLookAhead = rowOrColumn.get(iteratorCount).getStructure();
            }
            boolean applyCrossJoinStatement = true;
            if (resultItem.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE && iteratorCount < rowOrColumn.size()) {
                if (rowOrColumn.get(iteratorCount).getStructure() == StructureOfDataItem.STRUCTURE_MEASURE && !this._isMeasureIncludedInCrossJoin) {
                    applyCrossJoinStatement = false;
                }
            } else if (resultItem.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE && this._measureOnTop == 1) {
                applyCrossJoinStatement = false;
            }
            if (iteratorCount < rowOrColumn.size() && applyCrossJoinStatement) {
                clause = new StringBuilder();
                clause.append(MDXGenerationUtil.NEWLINE).append("     ");
                if ((TotalingType.ALLTOTAL == totalType || TotalingType.SUBTOTAL == totalType) && this._model.getTotalMode() == BusinessQueryTotalModeType.CUBE_VALUES && this._model.getQueryProperty(BusinessQueryProperty.EXCLUDE_EMPTY_DATA) && this._dataItemsInAllQuerySteps.size() > 0) {
                    if (isUseNonNestedCJ) {
                        if (!isAlreadyInNECrossJoin) {
                            clause.append("NONEMPTYCROSSJOIN").append("( ");
                            ++openParnCount;
                            isAlreadyInNECrossJoin = true;
                            isAlreadyInCrossJoin = false;
                        }
                    } else {
                        clause.append("NONEMPTYCROSSJOIN");
                    }
                } else if (this._model.getQueryProperty(BusinessQueryProperty.EXCLUDE_EMPTY_DATA) && (role == Role.ROW && this._bottomRankPercentExcludeRow || role == Role.COLUMN && this._bottomRankPercentExcludeCol)) {
                    if (isUseNonNestedCJ) {
                        if (!isAlreadyInNECrossJoin) {
                            clause.append("NONEMPTYCROSSJOIN").append("( ");
                            ++openParnCount;
                            isAlreadyInNECrossJoin = true;
                            isAlreadyInCrossJoin = false;
                        }
                    } else {
                        clause.append("NONEMPTYCROSSJOIN");
                    }
                } else if (isUseNonNestedCJ) {
                    if (!isAlreadyInCrossJoin) {
                        clause.append("CROSSJOIN").append("( ");
                        ++openParnCount;
                        isAlreadyInCrossJoin = true;
                        isAlreadyInNECrossJoin = false;
                    }
                } else {
                    clause.append("CROSSJOIN");
                }
                if (!isUseNonNestedCJ) {
                    clause.append("( ");
                }
                this.constructAlternateString(role, clause.toString(), structureOfLookAhead, hierCount);
                if ((structResultItem2 != StructureOfDataItem.STRUCTURE_MEASURE || this._isMeasureIncludedInCrossJoin) && structureOfLookAhead != StructureOfDataItem.STRUCTURE_MEASURE) {
                    openParnCountAlt = !isUseNonNestedCJ ? ++openParnCountAlt : 1;
                }
                if ((structResultItem2 != StructureOfDataItem.STRUCTURE_MEASURE || this._isMeasureIncludedInCrossJoin) && !isUseNonNestedCJ) {
                    ++openParnCount;
                }
                rowOrColumnBuffer.append((CharSequence)clause);
            }
            if (structResultItem2 == StructureOfDataItem.STRUCTURE_MEASURE) {
                if (this._isMeasureIncludedInCrossJoin) {
                    rowOrColumnBuffer.append(this._multipleMeasures.toString());
                    ++numSetsinXJoin;
                }
            } else {
                String fromMDXMapKey;
                clause = new StringBuilder(500);
                String fromMap = this._resultItemMap.get(resultItem);
                String mapValueFromAMap = fromMDXMapKey = fromMap.toString();
                String fromMDXMap = this._mdxClauseMap.get(fromMap);
                if (fromMDXMap != null) {
                    mapValueFromAMap = fromMDXMap.toString();
                }
                if (!this._model.isAxisValuesCoalesced() && !containsMemberOrTimeFilter && structResultItem2 != StructureOfDataItem.STRUCTURE_MEASURE && TotalingType.TOTAL_NONE != totalType) {
                    if (TotalingType.AXISTOTAL != totalType || continueAddingParents) {
                        if (role == Role.ROW && addParentOnRow) {
                            mapValueFromAMap = totalIt.generateAddParents(mapValueFromAMap, true);
                            if (TotalingType.AXISTOTAL == totalType) {
                                addParentOnRow = false;
                            }
                        } else if (role == Role.COLUMN && addParentOnCol) {
                            mapValueFromAMap = totalIt.generateAddParents(mapValueFromAMap, true);
                            if (TotalingType.AXISTOTAL == totalType) {
                                addParentOnCol = false;
                            }
                        }
                    }
                    if (TotalingType.AXISTOTAL == totalType) {
                        continueAddingParents = false;
                    }
                }
                clause.append(MDXGenerationUtil.NEWLINE).append("     ").append("{ ").append(mapValueFromAMap).append("} ");
                StructureOfDataItem structure = resultItem.getStructure();
                this.constructAlternateString(role, clause.toString(), structure, hierCount);
                if (this._olapValues.isFilterDDLApplied(resultItem, false)) {
                    ExpressionInterface dIFilterExpression;
                    boolean ignoreDrillUp;
                    boolean continueWithDrillUp = true;
                    if (containsMemberOrNavigationFilter) {
                        continueWithDrillUp = false;
                    }
                    if (TotalingType.AXISTOTAL == totalType || TotalingType.ALLTOTAL == totalType) {
                        String tempClause = MDXGenerationUtil.addAllMemberToAddParents(resultItem, clause.toString(), this._olapValues);
                        clause.delete(0, clause.length());
                        clause.append(tempClause);
                    }
                    if (ignoreDrillUp = this._model.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_DRILLUP_IGNORED_WHEN_GETTING_BYGROUP_VALUES)) {
                        continueWithDrillUp = false;
                    }
                    if (continueWithDrillUp && (dIFilterExpression = this._olapValues.getFilterExpressionListForDDL(resultItem.getLabel())) instanceof MemberFilterExpression && !(dIFilterExpression instanceof BusinessGroupMemberFilterExpression)) {
                        MemberFilterExpression mfe = (MemberFilterExpression)dIFilterExpression;
                        String root = mfe.getMemberLevelRoot();
                        if (!mfe.isNegated() && root != null) {
                            StringBuilder filterWrapper = new StringBuilder();
                            filterWrapper.append(" DrillupLevel(").append("{ ").append((CharSequence)clause).append("} ").append(" ,").append(root).append(")");
                            clause.delete(0, clause.length());
                            clause.append(filterWrapper.toString());
                        }
                    }
                }
                rowOrColumnBuffer.append((CharSequence)clause);
                ++numSetsinXJoin;
                MDXGenerationUtil.applyDebugStatement("Constructing individual selection clause: " + clause.toString(), this.getClass());
            }
            if (iteratorCount >= rowOrColumn.size()) continue;
            if (structResultItem2 != StructureOfDataItem.STRUCTURE_MEASURE || this._isMeasureIncludedInCrossJoin) {
                rowOrColumnBuffer.append(MDX_COMMA);
            }
            this.constructAlternateString(role, MDX_COMMA, structResultItem2, hierCount);
        }
        StringBuilder queryColOrRow = new StringBuilder();
        if (role == Role.COLUMN) {
            if ((this._isGrandTotalContribution || this._isColTotalContribution || this._isRowTotalContribution) && this._colAlternateString.length() != rowOrColumnBuffer.length() && this._colAlternateString.length() > 0) {
                this.stripLastComma(this._colAlternateString);
                this._rowHasMeasureWithPercentage = true;
            }
        } else if (role == Role.ROW && (this._isGrandTotalContribution || this._isRowTotalContribution || this._isColTotalContribution) && this._rowAlternateString.length() != rowOrColumnBuffer.length() && this._rowAlternateString.length() > 0) {
            this.stripLastComma(this._rowAlternateString);
            this._colHasMeasureWithPercentage = true;
        }
        this.stripLastComma(rowOrColumnBuffer);
        if (isUseNonNestedCJ && numSetsinXJoin > 2) {
            rowOrColumnBuffer.append(", ").append(numSetsinXJoin);
        }
        if (rowOrColumnBuffer.length() > 2) {
            StringBuilder closeParentheses = new StringBuilder();
            for (int i = 0; i < openParnCount; ++i) {
                closeParentheses.append(" )");
                isAlreadyInNECrossJoin = false;
                isAlreadyInCrossJoin = false;
            }
            StringBuilder closeParenthesesAlt = new StringBuilder();
            for (int i = 0; i < openParnCountAlt; ++i) {
                closeParenthesesAlt.append(" )");
                isAlreadyInNECrossJoin = false;
                isAlreadyInCrossJoin = false;
            }
            if (openParnCount > 0) {
                rowOrColumnBuffer.append(closeParentheses.toString());
            }
            if (openParnCountAlt > 0) {
                if (this._colAlternateString.length() > 2 && role == Role.COLUMN) {
                    this._colAlternateString.append(closeParenthesesAlt.toString());
                }
                if (this._rowAlternateString.length() > 2 && role == Role.ROW) {
                    this._rowAlternateString.append(closeParenthesesAlt.toString());
                }
            }
            String queryWithSteps = this.applyStepsToQuery(role, rowOrColumnBuffer.toString());
            if (this._colHasMeasureWithPercentage && role == Role.COLUMN) {
                String tempStepAlternate1 = this.applyStepsToQuery(role, this._colAlternateString.toString());
                this._colAlternateString.delete(0, this._colAlternateString.length());
                this._colAlternateString.append(tempStepAlternate1);
            }
            if (this._rowHasMeasureWithPercentage && role == Role.ROW) {
                String tempStepAlternate2 = this.applyStepsToQuery(role, this._rowAlternateString.toString());
                this._rowAlternateString.delete(0, this._rowAlternateString.length());
                this._rowAlternateString.append(tempStepAlternate2);
            }
            queryColOrRow.append(MDXGenerationUtil.NEWLINE + "     ").append(queryWithSteps);
            if (sortDirectionColumnOrRow != BusinessQueryActionType.SORT_NONE) {
                String string;
                boolean testForRemainingDataSort = false;
                String tempMDX = BusinessQueryDataBaseSort.generateMDX(queryColOrRow.toString(), this._model, role, this._resultItemMap, rowOrColumn, this._multipleMeasures.toString(), this._mdxClauseMap, this._isMultiSortWithQueryFilter, testForRemainingDataSort, this._olapValues, this._specialSortedMeasureDefintion);
                if (this._colHasMeasureWithPercentage && role == Role.COLUMN) {
                    String finalSortC;
                    String string2 = BusinessQueryDataBaseSort.generateMDX(this._colAlternateString.toString(), this._model, role, this._resultItemMap, rowOrColumn, this._multipleMeasures.toString(), this._mdxClauseMap, this._isMultiSortWithQueryFilter, testForRemainingDataSort, this._olapValues, this._specialSortedMeasureDefintion);
                    this._colAlternateString.delete(0, this._colAlternateString.length());
                    this._colAlternateString.append(string2);
                    if (this._isMultiSortWithQueryFilter && (finalSortC = this.buildFinalSort(this._colAlternateString.toString())).length() > 0) {
                        this._colAlternateString.delete(0, this._colAlternateString.length());
                        this._colAlternateString.append(finalSortC);
                    }
                }
                if (this._rowHasMeasureWithPercentage && role == Role.ROW) {
                    String finalSortR;
                    String string3 = BusinessQueryDataBaseSort.generateMDX(this._rowAlternateString.toString(), this._model, role, this._resultItemMap, rowOrColumn, this._multipleMeasures.toString(), this._mdxClauseMap, this._isMultiSortWithQueryFilter, testForRemainingDataSort, this._olapValues, this._specialSortedMeasureDefintion);
                    this._rowAlternateString.delete(0, this._rowAlternateString.length());
                    this._rowAlternateString.append(string3);
                    if (this._isMultiSortWithQueryFilter && (finalSortR = this.buildFinalSort(this._rowAlternateString.toString())) != null && finalSortR.length() > 0) {
                        this._rowAlternateString.delete(0, this._rowAlternateString.length());
                        this._rowAlternateString.append(finalSortR);
                    }
                }
                rowOrColumnSelect.append(MDXGenerationUtil.NEWLINE).append("     ").append(tempMDX);
                if (this._isMultiSortWithQueryFilter && (string = this.buildFinalSort(rowOrColumnSelect.toString())) != null && string.length() > 0) {
                    rowOrColumnSelect.delete(0, rowOrColumnSelect.length());
                    rowOrColumnSelect.append(string);
                }
            } else {
                rowOrColumnSelect.append(queryColOrRow.toString());
            }
        }
        return rowOrColumnSelect.toString();
    }

    private String buildWHEREClause() throws GenerationException {
        StringBuilder WHEREClause = new StringBuilder();
        List<DataItem> resultItems = this._model.getResultItems();
        DataItem singleUnassignedMeasure = null;
        int measureCount = 0;
        IdentityList assignedToWhere = new IdentityList();
        for (DataItem resultItem : resultItems) {
            StructureOfDataItem structure = resultItem.getStructure();
            if (this._slicerPhraseWhereMap.containsKey(resultItem) && !this._slicerWhereList.contains(resultItem)) {
                try {
                    Role role = this._model.getResultItemRole(resultItem);
                    if (role == null && structure == StructureOfDataItem.STRUCTURE_MEASURE) {
                        role = Role.BACKGROUND;
                    }
                    if (!Role.isOutputResultRole(this._model, role)) {
                        if (structure == StructureOfDataItem.STRUCTURE_MEASURE) {
                            if (resultItem.getExpression() instanceof FractionOfTotalExpression) {
                                FractionOfTotalExpression fractionMeasure = (FractionOfTotalExpression)resultItem.getExpression();
                                DataItem demoData = fractionMeasure.getNumerator();
                                WHEREClause.append(MDXGenerationUtil.buildCoreExpression(demoData, this._olapValues));
                            } else if (this._slicerPhraseWhereMap.containsKey(resultItem)) {
                                String slicerString = this._slicerPhraseWhereMap.get(resultItem) + " ";
                                WHEREClause.append(slicerString);
                            } else {
                                WHEREClause.append(MDXGenerationUtil.buildCoreExpression(resultItem, this._olapValues));
                            }
                            WHEREClause.append(", ");
                        } else {
                            String itemL = this._slicerPhraseWhereMap.get(resultItem);
                            WHEREClause.append(itemL).append(", ");
                        }
                        assignedToWhere.add(resultItem.getLabel());
                    } else if (structure == StructureOfDataItem.STRUCTURE_MEASURE) {
                        singleUnassignedMeasure = role == null && ++measureCount == 1 ? resultItem : null;
                    }
                }
                catch (MetadataException me) {
                    MessageFormatter msF = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationMetaExcWher.fmt.txt", resultItem);
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(msF.toString());
                    }
                    throw new GenerationException(msF, (Throwable)me);
                }
            }
            if (singleUnassignedMeasure == null) continue;
            WHEREClause.append(this._resultItemMap.get(singleUnassignedMeasure)).append(", ");
            assignedToWhere.add(resultItem.getLabel());
        }
        for (DataItem resultItem1 : this._slicerWhereList) {
            if (assignedToWhere.contains(resultItem1.getLabel())) continue;
            WHEREClause.append(this._slicerPhraseWhereMap.get(resultItem1)).append(", ");
            assignedToWhere.add(resultItem1.getLabel());
        }
        if (WHEREClause.length() > 2) {
            WHEREClause.replace(WHEREClause.length() - 2, WHEREClause.length(), " )");
            WHEREClause.insert(0, " WHERE (");
        }
        MDXGenerationUtil.applyDebugStatement("Constructing Where clause", this.getClass());
        return WHEREClause.toString();
    }

    private void buildNonDirectItemIntoWith(List<BusinessItem> modelResultItems) throws GenerationException {
        for (BusinessItem object : modelResultItems) {
            String checkLabel;
            DataItem dataItemCalcOrphaned;
            if (!(object instanceof DataItem) || this._olapValues.isDataItemOrphaned((dataItemCalcOrphaned = (DataItem)object).getLabel())) continue;
            ExpressionInterface expressionDataItem = dataItemCalcOrphaned.getExpression();
            StructureOfDataItem rSt = dataItemCalcOrphaned.getStructure();
            if (!(expressionDataItem instanceof StringExpression) && !(expressionDataItem instanceof ConstantExpression) && !(expressionDataItem instanceof FractionOfTotalExpression) && !(expressionDataItem instanceof TimeMeasureExpression) && (!(expressionDataItem instanceof ResourceAwareStringExpression) || MDXGenerationUtil.isHiddenItem(dataItemCalcOrphaned, this.getHiddenResults())) || rSt != StructureOfDataItem.STRUCTURE_MEASURE || this._olapValues.hasOLAPValue(dataItemCalcOrphaned) || !MDXGenerationUtil.isDataItemInList(this._dataItemsInAllQuerySteps, checkLabel = dataItemCalcOrphaned.getLabel()) && !MDXGenerationUtil.isDataItemInList(this._dataItemsInAllQuerySort, checkLabel)) continue;
            MDXVariable mdxVariable = new MDXVariable(this._metaInterface, dataItemCalcOrphaned, true, this._model);
            mdxVariable.setLabel(this._olapValues.getMeasureCaption());
            String mdxString = MDXGenerationUtil.buildMembersDefinition(dataItemCalcOrphaned, this._olapValues, this._model);
            if (mdxString == null || mdxString.length() <= 0) continue;
            mdxVariable.setMDXExpression(mdxString);
            this._WITHClause.append(mdxVariable.getMDXPhrase());
            this._olapValues.setOLAPValue(dataItemCalcOrphaned, OLAPItemType.MDXVARIABLE, mdxVariable);
        }
    }

    private String buildWITHClause(List<DataItem> resultItems) throws GenerationException {
        this.getRowsAndColumns(resultItems);
        if (this._columns.size() > 0) {
            this.getByQualifierInBQRankStep(Role.COLUMN);
        }
        if (this._rows.size() > 0) {
            this.getByQualifierInBQRankStep(Role.ROW);
        }
        this._columns.clear();
        this._rows.clear();
        try {
            this._resultItemMap = new LinkedHashMap<DataItem, String>();
            List<BusinessItem> modelResultItems = this._model.getBusinessModel().getResources(BusinessItem.class);
            this.buildNonDirectItemIntoWith(modelResultItems);
            String mdxPartsStepExpr = this.buildMDXForDataItemThatArePartOfAStepButNotInResultItems(resultItems);
            if (mdxPartsStepExpr != null && mdxPartsStepExpr.length() != 0) {
                this._WITHClause.append(mdxPartsStepExpr);
            }
            int measureCounter = 0;
            WeakHashMap<String, String> prefixMap = new WeakHashMap<String, String>();
            this._multipleMeasures.append("{ ");
            for (DataItem resultItem : resultItems) {
                String _tempMDX;
                boolean addIntoWith = false;
                ExpressionInterface expressionForResultItem = resultItem.getExpression();
                Role role = this._model.getResultItemRole(resultItem);
                String rtmMeasureString = "";
                MDXVariable mdxVariable = null;
                Object objectMDX = this._olapValues.getOLAPValue(resultItem, OLAPItemType.MDXVARIABLE);
                mdxVariable = objectMDX == null ? new MDXVariable(this._metaInterface, resultItem, Role.isOutputResultRole(this._model, role), this._model) : (MDXVariable)objectMDX;
                StructureOfDataItem resultItemStructure = resultItem.getStructure();
                String resultItemLabel = resultItem.getLabel();
                boolean foundLabel = prefixMap.containsKey(resultItemLabel);
                int counter = 1;
                if (foundLabel) {
                    String countera = (String)prefixMap.get(resultItemLabel);
                    prefixMap.remove(resultItemLabel);
                    counter = Integer.parseInt(countera);
                    ++counter;
                }
                String realPrefix = Integer.toString(counter);
                prefixMap.put(resultItemLabel, realPrefix);
                if (objectMDX == null) {
                    mdxVariable.setCounter(counter);
                }
                if (expressionForResultItem instanceof ResourceAwareStringExpression || expressionForResultItem instanceof TimeExpressionMeasure || expressionForResultItem instanceof FractionOfTotalExpression) {
                    if (resultItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
                        if (objectMDX == null) {
                            mdxVariable.setSpecialLabel(true);
                            mdxVariable.setLabel(this._olapValues.getMeasureCaption());
                        }
                        mdxVariable.setFormat(resultItem.getFormat());
                        addIntoWith = true;
                        this._multipleMeasures.append(MDXGenerationUtil.NEWLINE).append(mdxVariable.getLabel()).append(MDX_COMMA);
                        if (measureCounter == 0) {
                            this._resultItemMap.put(resultItem, mdxVariable.getLabel());
                        }
                        if (objectMDX == null) {
                            this._olapValues.setOLAPValue(resultItem, OLAPItemType.MDXVARIABLE, mdxVariable);
                        }
                        if (expressionForResultItem instanceof FractionOfTotalExpression) {
                            ++measureCounter;
                            FractionTotalExpression fractExp = new FractionTotalExpression(this._model, this._olapValues, mdxVariable, resultItem, this._isNoColsForContribution, this._isNoRowsForContribution, this._disableTotaledMeasures.contains(resultItem), this._disableHierarchy);
                            this._totalPercentASList.add(fractExp);
                        } else if (expressionForResultItem instanceof TimeExpressionMeasure && (rtmMeasureString = this.buildRelativeTimeMeasureMDX(expressionForResultItem, resultItem, resultItems)) != null && this._relativeTimeOrphanedMeasures.length() > 0) {
                            this._WITHClause.append((CharSequence)this._relativeTimeOrphanedMeasures);
                            this._relativeTimeOrphanedMeasures.delete(0, this._relativeTimeOrphanedMeasures.length());
                        }
                        if (this._disableTotaledMeasures.contains(resultItem)) {
                            mdxVariable.setDisableTotal(true);
                            addIntoWith = true;
                            mdxVariable.setFirstAxisDimension(this._disableHierarchy);
                            mdxVariable.setSpecialLabel(true);
                            mdxVariable.setLabel(this._olapValues.getMeasureCaption());
                        }
                    } else {
                        if (objectMDX == null) {
                            mdxVariable.setSpecialLabel(true);
                            mdxVariable.setLabel(this.getOLAPValue(resultItem, OLAPItemType.UNIQUENAME).toString());
                            this._olapValues.setOLAPValue(resultItem, OLAPItemType.MDXVARIABLE, mdxVariable);
                        }
                        addIntoWith = true;
                        this._resultItemMap.put(resultItem, mdxVariable.getLabel());
                    }
                } else if (resultItemStructure != StructureOfDataItem.STRUCTURE_MEASURE) {
                    if (Role.isOutputResultRole(this._model, role) && objectMDX == null) {
                        mdxVariable.setLabel(this.getOLAPValue(resultItem, OLAPItemType.UNIQUENAME).toString());
                    }
                } else if (resultItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
                    Measure meaExpression;
                    boolean isFormatDiff = this._olapValues.isFormatDifferent(resultItem);
                    if (this._disableTotaledMeasures.contains(resultItem)) {
                        mdxVariable.setDisableTotal(true);
                        addIntoWith = true;
                        mdxVariable.setFirstAxisDimension(this._disableHierarchy);
                        mdxVariable.setSpecialLabel(true);
                        mdxVariable.setCounter(counter);
                        mdxVariable.setLabel(this._olapValues.getMeasureCaption());
                    }
                    if (isFormatDiff) {
                        addIntoWith = true;
                        mdxVariable.setFormat(resultItem.getFormat());
                    }
                    String metadataLabel = (String)this.getOLAPValue(resultItem, OLAPItemType.LABEL);
                    String uniqueName = (String)this.getOLAPValue(resultItem, OLAPItemType.UNIQUENAME);
                    String tempLabelx = "[Measures].[" + metadataLabel + "]";
                    if (!tempLabelx.equals(uniqueName)) {
                        this._labelNameMap.put(uniqueName, metadataLabel);
                    }
                    if (!addIntoWith && expressionForResultItem instanceof Measure && (meaExpression = (Measure)expressionForResultItem) instanceof OMAMeasure) {
                        OMAMeasure omaMeasure;
                        CMetadata CMMeasure;
                        TotalingType totalMode = TotalingType.TOTAL_NONE;
                        if (this._model instanceof DataSelection) {
                            DataSelection busQuery = this._model;
                            totalMode = busQuery.getTotalingType(role);
                        }
                        if ((CMMeasure = (omaMeasure = (OMAMeasure)meaExpression).getOMAObject()) instanceof CalculatedMeasure && TotalingType.TOTAL_NONE != totalMode) {
                            addIntoWith = true;
                            mdxVariable.setSpecialLabel(true);
                            mdxVariable.setCounter(counter);
                            mdxVariable.setLabel(this._olapValues.getMeasureCaption());
                        }
                    }
                    if (objectMDX == null) {
                        mdxVariable.setLabel(this._olapValues.getMeasureCaption());
                    }
                    this._multipleMeasures.append(MDXGenerationUtil.NEWLINE).append(mdxVariable.getLabel()).append(MDX_COMMA);
                    if (measureCounter == 0) {
                        this._resultItemMap.put(resultItem, this._olapValues.getOLAPValue(resultItem, OLAPItemType.UNIQUENAME).toString());
                    }
                    this._olapValues.setOLAPValue(resultItem, OLAPItemType.MDXVARIABLE, mdxVariable);
                    ++measureCounter;
                }
                if (!addIntoWith && this._model.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_MEASURE_GROUPING)) {
                    List<BusinessGroup> effectiveMeasureGroupsForDI = this._model.getEffectiveGroupsContaining(resultItem, BusinessGroup.Type.GROUPED_MEASURES);
                    if (effectiveMeasureGroupsForDI.size() >= 1) {
                        addIntoWith = true;
                        mdxVariable.setSpecialLabel(true);
                        mdxVariable.setCounter(counter);
                        mdxVariable.setLabel(this._olapValues.getMeasureCaption());
                    } else {
                        OMACalculatedMeasure calcMeasure;
                        String groupLabel;
                        ExpressionInterface expression = resultItem.getExpression();
                        if (expression instanceof Measure && expression instanceof OMACalculatedMeasure && (groupLabel = (calcMeasure = (OMACalculatedMeasure)expression).getGroupLabel()).trim().length() > 0) {
                            addIntoWith = true;
                            mdxVariable.setSpecialLabel(true);
                            mdxVariable.setCounter(counter);
                            mdxVariable.setLabel(this._olapValues.getMeasureCaption());
                        }
                    }
                }
                if (resultItemStructure != StructureOfDataItem.STRUCTURE_MEASURE && Role.isOutputResultRole(this._model, role)) {
                    String memberLabel = this.getOLAPValue(resultItem, OLAPItemType.MEMBERNAME).toString();
                    if (resultItem.getMemberProperties().size() > 0 && memberLabel.length() > 0) {
                        List<String> propertyStringByMember;
                        if (role == Role.COLUMN) {
                            propertyStringByMember = this.buildMDXForDataItemWithCubePropeties(resultItem.getMemberProperties(), memberLabel);
                            this._columnProperty.addAll(propertyStringByMember);
                        } else {
                            propertyStringByMember = this.buildMDXForDataItemWithCubePropeties(resultItem.getMemberProperties(), memberLabel);
                            this._rowProperty.addAll(propertyStringByMember);
                        }
                    }
                }
                String MDXExpression = null;
                if (expressionForResultItem instanceof TimeExpressionMeasure) {
                    if (rtmMeasureString != null && rtmMeasureString.length() > 0) {
                        MDXExpression = rtmMeasureString;
                    }
                } else {
                    MDXExpression = MDXGenerationUtil.buildMembersDefinition(resultItem, this._olapValues, this._model);
                }
                MDXExpression = this.buildMDXBasedOnValueInFilterItemExpression(resultItem, MDXExpression);
                if (resultItem.hasSteps()) {
                    StepManager stepManager = new StepManager(resultItem);
                    stepManager.setOLAPValue(this._olapValues);
                    MDXExpression = stepManager.generateMDX(this._model, MDXExpression);
                    if (this._model.getTotalMode() == BusinessQueryTotalModeType.VISUAL_VALUES && stepManager.isMemberFilterOn() && TotalingType.TOTAL_NONE == this._anyTotalInRow && !this._isGrandTotalContribution && TotalingType.TOTAL_NONE == this._anyTotalInColumn && resultItemStructure != StructureOfDataItem.STRUCTURE_MEASURE) {
                        if (role == Role.ROW && !this._isColTotalContribution) {
                            this._isVisualTotalOnOnlyRow = true;
                            MDXExpression = this._totalRow.generateVisualTotalOnly(MDXExpression);
                        } else if (role == Role.COLUMN && !this._isRowTotalContribution) {
                            this._isVisualTotalOnOnlyCol = true;
                            MDXExpression = this._totalColumn.generateVisualTotalOnly(MDXExpression);
                        }
                    }
                }
                MDXExpression = _tempMDX = DataItemSort.generateMDX(MDXExpression, resultItem, this._model, this._olapValues);
                if (resultItemStructure == StructureOfDataItem.STRUCTURE_HIERARCHY || resultItemStructure == StructureOfDataItem.STRUCTURE_LEVEL || resultItemStructure == StructureOfDataItem.STRUCTURE_NAMED_SET || resultItemStructure == StructureOfDataItem.STRUCTURE_CALCULATED_MEMBER || resultItemStructure == StructureOfDataItem.STRUCTURE_DIMENSION) {
                    this._resultItemMap.put(resultItem, mdxVariable.getLabel());
                }
                if (addIntoWith) {
                    if (MDXExpression != null && MDXExpression.length() > 0) {
                        mdxVariable.setMDXExpression(MDXExpression);
                        this._WITHClause.append(mdxVariable.getMDXPhrase());
                    }
                } else {
                    this._mdxClauseMap.put(this._resultItemMap.get(resultItem), MDXExpression);
                    mdxVariable.setMDXExpression(MDXExpression);
                }
                this._olapValues.setOLAPValue(resultItem, OLAPItemType.MDXVARIABLE, mdxVariable);
                MDXGenerationUtil.applyDebugStatement("MDXVariable: " + mdxVariable.toString(), this.getClass());
            }
            this.buildMDXForFilterWithDataItemNotInResultItems();
            this.buildMDXForHiddenBackgroundDataItem(resultItems);
            this.buildMDXForSpecialCoalsceWith();
            if (this._multipleMeasures != null && this._multipleMeasures.length() > 2) {
                this._isMultipleMeasures = true;
                this._multipleMeasures.replace(this._multipleMeasures.length() - 2, this._multipleMeasures.length(), "} ");
            }
            if (this._WITHClause.length() > 0) {
                this._WITHClause.insert(0, " WITH ");
            }
        }
        catch (MetadataException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationMetaExcWith.txt", new Object[0]);
            _logger.error((Object)formatter, (Throwable)e);
            throw new GenerationException(formatter, (Throwable)e);
        }
        catch (DataServicesException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("MDXGenerationDataExcWith.txt", new Object[0]);
            _logger.error((Object)formatter, (Throwable)e);
            throw new GenerationException(formatter, (Throwable)e);
        }
        return this._WITHClause.toString();
    }

    private void buildVTSIZEclause(String clause) {
        if (this._hasDatabasedFilterChildFilterWithTotals) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" MEMBER ").append(VTSIZE).append(MDXGenerationUtil.NEWLINE).append(" AS 'Count(").append(clause).append(")'");
            this._hasDatabasedFilterEdgeWithClause.append(stringBuilder.toString());
        }
    }

    private void buildMDXForSpecialCoalsceWith() throws GenerationException {
        for (Map.Entry<String, DataItem> entry : this._measureBeingCountRanked.entrySet()) {
            DataItem dataItemBottomRankQualifier = entry.getValue();
            String rankedObject = entry.getKey();
            MDXVariable mdxVariable = new MDXVariable(this._metaInterface, dataItemBottomRankQualifier, true, this._model);
            mdxVariable.setCoalesceEmpty(true);
            mdxVariable.setCounter(9999);
            mdxVariable.setSpecialLabel(true);
            mdxVariable.setLabel(this._olapValues.getMeasureCaption());
            mdxVariable.setMDXExpression(MDXGenerationUtil.buildMembersDefinition(dataItemBottomRankQualifier, this._olapValues, this._model));
            this._WITHClause.append(mdxVariable.getMDXPhrase());
            this._measureBeingRankedCountSumPercentMDXVar.put(rankedObject, mdxVariable);
        }
        this._measureBeingCountRanked.clear();
    }

    private void constructAlternateString(Role role, String clause, StructureOfDataItem structure, int hierCount) {
        if (structure == StructureOfDataItem.STRUCTURE_MEASURE) {
            if (clause.contains("CROSSJOIN") && hierCount > 1) {
                clause = MDXGenerationUtil.repairQuotes(clause);
                if (role == Role.COLUMN) {
                    this._colAlternateString.append(clause);
                } else if (role == Role.ROW) {
                    this._rowAlternateString.append(clause);
                }
            }
            return;
        }
        clause = MDXGenerationUtil.repairQuotes(clause);
        if (role == Role.COLUMN) {
            this._colAlternateString.append(clause);
        } else if (role == Role.ROW) {
            this._rowAlternateString.append(clause);
        }
    }

    public ExecutionInstructionInterface createExecutionInstructionInterface(DataSelection dataSelection, StringBuilder MDXQuery) {
        MDXInstruction mdxInstruction = new MDXInstruction(this._server, dataSelection, MDXQuery.toString(), null);
        mdxInstruction.setLabelNameMap(this._labelNameMap);
        return mdxInstruction;
    }

    private void getByQualifierInBQRankStep(Role role) throws GenerationException {
        if (this._model.getQueryProperty(BusinessQueryProperty.EXCLUDE_EMPTY_DATA)) {
            for (StepInterface step : this._model.getSteps(role)) {
                BusinessQueryRankFilter bqRankFilter;
                if (!(step instanceof BusinessQueryRankFilter) || !(bqRankFilter = (BusinessQueryRankFilter)step).getRankOrder().equals("Bottom") || !this._model.getQueryProperty(BusinessQueryProperty.EXCLUDE_EMPTY_DATA)) continue;
                List byQualifiers = bqRankFilter.getRankQualifiers();
                for (Object obj : byQualifiers) {
                    DataItem dataItem;
                    StructureOfDataItem struct;
                    ExpressionInterface expression;
                    if (!(obj instanceof ExpressionInterface) || !((expression = (ExpressionInterface)obj) instanceof DataItem) || (struct = (dataItem = (DataItem)expression).getStructure()) != StructureOfDataItem.STRUCTURE_MEASURE || !bqRankFilter.getRankType().equals("Count")) continue;
                    this._measureBeingCountRanked.put(dataItem.getLabel(), dataItem);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private List<DataItem> eliminateDataItemWithHiddenBackgroundRoles(List<DataItem> resultItems) throws GenerationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<DataItem> eliminateInvalidFractionTotals(List<DataItem> resultItems) throws GenerationException {
        int numberOfRows = 0;
        int numberOfColumns = 0;
        try {
            for (DataItem resultItem : resultItems) {
                Role role = null;
                role = this._model.getResultItemRole(resultItem);
                if (role == null) continue;
                if (role == Role.ROW) {
                    if (resultItem.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) continue;
                    ++numberOfRows;
                    continue;
                }
                if (role != Role.COLUMN || resultItem.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) continue;
                ++numberOfColumns;
            }
            ListIterator<DataItem> listIt = resultItems.listIterator();
            while (listIt.hasNext()) {
                DataItem resultItem;
                resultItem = listIt.next();
                ExpressionInterface ex = resultItem.getExpression();
                if (!(ex instanceof FractionOfTotalExpression)) continue;
                FractionOfTotalExpression fe = (FractionOfTotalExpression)ex;
                if (fe.getDenominatorType() == 0) {
                    DataItem feOldDeno = fe.getDenominator();
                    Role roleOfOlDeno = this._model.getResultItemRole(feOldDeno);
                    if (roleOfOlDeno == null) {
                        fe.setDenominatorType(5);
                    } else if (roleOfOlDeno == Role.ROW) {
                        fe.setDenominatorType(4);
                    } else if (roleOfOlDeno == Role.COLUMN) {
                        fe.setDenominatorType(5);
                    }
                }
                if (fe.getDenominatorType() == 1) {
                    this._isGrandTotalContribution = true;
                    if (numberOfColumns == 0 && numberOfRows == 0) {
                        listIt.remove();
                        if (_logger.isEnabled(Level.ERROR)) {
                            _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationTotPercProb1.txt"));
                        }
                    }
                    if (numberOfColumns == 0 && _logger.isEnabled(Level.WARN)) {
                        _logger.warn(IQDataServicesResourceBundle.getStringResource("MDXGenerationTotPercProb2.txt"));
                        _logger.warn(IQDataServicesResourceBundle.getStringResource("MDXGenerationTotPercProb3.txt"));
                    }
                }
                if (fe.getDenominatorType() == 2 || fe.getDenominatorType() == 4) {
                    this._isRowTotalContribution = true;
                    if (numberOfColumns == 0) {
                        listIt.remove();
                        if (_logger.isEnabled(Level.ERROR)) {
                            _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationTotPercProb4.txt"));
                        }
                    }
                }
                if (fe.getDenominatorType() != 3 && fe.getDenominatorType() != 5) continue;
                this._isColTotalContribution = true;
                if (numberOfRows != 0) continue;
                listIt.remove();
                if (!_logger.isEnabled(Level.ERROR)) continue;
                _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationTotPercProb5.txt"));
            }
        }
        catch (MetadataException e) {
            Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationTotPercProb6.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msF.toString());
            }
            throw new GenerationException((MessageFormatter)msF, (Throwable)e);
        }
        if (numberOfRows == 0) {
            this._isNoRowsForContribution = true;
        }
        if (numberOfColumns == 0) {
            this._isNoColsForContribution = true;
        }
        return resultItems;
    }

    private void whatAxisIsMeasure(List<DataItem> resultItems) {
        for (DataItem resultItem : resultItems) {
            Role role;
            StructureOfDataItem structResultItem;
            block4: {
                structResultItem = resultItem.getStructure();
                role = null;
                try {
                    role = this._model.getResultItemRole(resultItem);
                }
                catch (MetadataException e) {
                    if (!_logger.isEnabled(Level.ERROR)) break block4;
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (role == null || structResultItem != StructureOfDataItem.STRUCTURE_MEASURE) continue;
            if (role == Role.COLUMN) {
                this._colHasMeasure = true;
                break;
            }
            if (role != Role.ROW) continue;
            this._rowHasMeasure = true;
            break;
        }
    }

    @Override
    public ExecutionInstructionInterface generateInstructions(DataSelection dataSelection, String uniqueID) throws GenerationException {
        StringBuilder MDXQuery = new StringBuilder();
        this._model = dataSelection;
        List<DataItem> resultItems = this._model.getResultItems();
        Locale effectiveComputationLocale = GenerationUtil.getEffectiveComputationalLocale(this._model, this);
        this._dataItemsInAllQuerySteps = MDXGenerationUtil.buildDataItemListInSteps(this._model, true);
        this._dataItemsInAllQuerySort = MDXGenerationUtil.buildDataItemListInSort(this._model, true);
        this._dataItemsInOtherDataItems = MDXGenerationUtil.buildDataItemListInOtherDataItems(this._model, resultItems);
        this._dataItemsInQuerySteps = MDXGenerationUtil.buildDataItemListInSteps(this._model, false);
        this._dataItemsInQuerySort = MDXGenerationUtil.buildDataItemListInSort(this._model, false);
        resultItems = this.eliminateDataItemWithHiddenBackgroundRoles(resultItems);
        try {
            this.buildDisabledTotals(this._model, resultItems);
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        this._anyTotalInColumn = this._model.getTotalingType(Role.COLUMN);
        this._anyTotalInRow = this._model.getTotalingType(Role.ROW);
        resultItems = this.eliminateInvalidFractionTotals(resultItems);
        this._totalColumn = new BusinessQueryTotal(this._model, Role.COLUMN, effectiveComputationLocale);
        this._totalRow = new BusinessQueryTotal(this._model, Role.ROW, effectiveComputationLocale);
        this.whatAxisIsMeasure(resultItems);
        this.determineChildFilterWithDataBasedFilter();
        String buildWITHClause = this.buildWITHClause(resultItems);
        List<DataItem> removeMultipleMeasureForPerformanceGain = this.removeMultipleMeasureForPerformanceGain(resultItems);
        String buildSELECTClause = this.buildSELECTClause(removeMultipleMeasureForPerformanceGain, effectiveComputationLocale);
        String buildFROMClause = this.buildFROMClause();
        String buildWHEREClause = this.buildWHEREClause();
        if (this._labelNameMap.size() > 0) {
            StringBuilder renameComments = new StringBuilder();
            Set<String> labelKey = this._labelNameMap.keySet();
            Object[] labelK = labelKey.toArray();
            Collection<String> values = this._labelNameMap.values();
            int ct = 0;
            renameComments.append("/*");
            for (String value : values) {
                renameComments.append(labelK[ct]).append("=").append(value).append(MDXGenerationUtil.NEWLINE);
            }
            renameComments.append("*/");
            MDXQuery.append(renameComments.toString());
        }
        MDXQuery.append(buildWITHClause).append(buildSELECTClause).append(buildFROMClause).append(buildWHEREClause);
        ExecutionInstructionInterface executionInstruction = this.createExecutionInstructionInterface(dataSelection, MDXQuery);
        return executionInstruction;
    }

    private void determineChildFilterWithDataBasedFilter() {
        Role roleOfMeasure = null;
        Role roleOfOppositeAxis = null;
        if (this._colHasMeasure) {
            roleOfMeasure = Role.COLUMN;
            roleOfOppositeAxis = Role.ROW;
            MDXGenerationUtil.applyDebugStatement("Measures is applied to column. ", MDXGeneration.class);
        } else if (this._rowHasMeasure) {
            roleOfMeasure = Role.ROW;
            roleOfOppositeAxis = Role.COLUMN;
            MDXGenerationUtil.applyDebugStatement("Measures is applied to row axis. ", MDXGeneration.class);
        }
        if (roleOfMeasure != null) {
            BusinessQueryTotalModeType totalMode = this._model.getTotalMode();
            TotalingType totalType = this._model.getTotalingType(roleOfOppositeAxis);
            if (totalMode == BusinessQueryTotalModeType.VISUAL_VALUES && TotalingType.TOTAL_NONE != totalType) {
                for (StepInterface step : this._model.getSteps(roleOfMeasure)) {
                    if (!(step instanceof BusinessQueryDataBasedFilter)) continue;
                    try {
                        List<DataItem> resultItemsForRole = this._model.getResultItems(roleOfOppositeAxis);
                        for (DataItem resultItem : resultItemsForRole) {
                            this._hasDatabasedFilterChildFilterWithTotals = resultItem.hasSteps();
                            if (!this._hasDatabasedFilterChildFilterWithTotals) continue;
                            MDXGenerationUtil.applyDebugStatement("This query has a databased filter, child filter, and visual totals turned on", MDXGeneration.class);
                            return;
                        }
                    }
                    catch (MetadataException e) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            _logger.error(e.getLocalizedMessage(), (Throwable)e);
                        }
                        return;
                    }
                }
            }
        } else {
            MDXGenerationUtil.applyDebugStatement("Measures is not applied to column or row axis. ", MDXGeneration.class);
        }
    }

    protected Object getOLAPValue(DataItem dataItem, OLAPItemType key) throws GenerationException {
        return this._olapValues.getOLAPValue(dataItem, key);
    }

    private DataItem getOrphanedFilterDataItem(FilterItem filter) throws GenerationException {
        ExpressionInterface exprFilter = filter.getExpression();
        String filterId = "";
        try {
            filterId = filter.getID();
        }
        catch (InvalidIDException iE) {
            Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("DataServices.UnknownDataItemID.Message.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(filter.toString());
            }
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msF.toString());
            }
            throw new GenerationException((MessageFormatter)msF, (Throwable)iE);
        }
        if (filterId == null) {
            Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("DataServices.UnknownDataItemID.Message.txt")};
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(filter.toString());
            }
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            throw new GenerationException(msF);
        }
        boolean isOldByGroup = false;
        if (exprFilter instanceof MemberFilterExpression && !(exprFilter instanceof BusinessGroupMemberFilterExpression) && filterId.length() > 0) {
            isOldByGroup = MDXGenerationUtil.isOldByGroupExpression(exprFilter, this._model, filterId, filter);
        }
        if (exprFilter instanceof DataBasedFilterExpression_Between || exprFilter instanceof DataBasedFilterExpression || exprFilter instanceof SlicerFilterExpression || exprFilter instanceof MultipleConditionalExpression || isOldByGroup) {
            List<DataItem> filterDataItems = filter.getDataItems(0);
            if (filterDataItems.size() == 0) {
                return null;
            }
            DataItem filterDataItem = filterDataItems.get(0);
            boolean foundMatchingDataItem = MDXGenerationUtil.isDataItemVisibleOrOrphaned(filterDataItem, this._olapValues);
            if (!foundMatchingDataItem) {
                ArrayList<DataItem> orphanedInOLAPValues = new ArrayList<DataItem>();
                orphanedInOLAPValues.add(filterDataItem);
                this._olapValues.buildOLAPDataItemComponents(orphanedInOLAPValues, this._olapValues.getOLAPConstantValues(), true, this._cubeName);
                orphanedInOLAPValues = null;
            }
            if (!foundMatchingDataItem) {
                return filterDataItem;
            }
            return null;
        }
        return null;
    }

    private List<DataItem> removeMultipleMeasureForPerformanceGain(List<DataItem> resultItems) throws GenerationException {
        if (!this._isMultipleMeasures) {
            return resultItems;
        }
        int numberOfMeasure = 0;
        ArrayList<DataItem> smallerList = new ArrayList<DataItem>();
        for (DataItem resultItem : resultItems) {
            StructureOfDataItem structure = resultItem.getStructure();
            if (structure == StructureOfDataItem.STRUCTURE_MEASURE) {
                if (numberOfMeasure != 0) continue;
                smallerList.add(resultItem);
                ++numberOfMeasure;
                continue;
            }
            smallerList.add(resultItem);
        }
        return smallerList;
    }

    public void setCubeName(String cubeName) {
        this._cubeName = cubeName;
    }

    public void setLogicalServer(LogicalServerInterface server) {
        this._server = server;
    }

    public void setMetadataInterface(MetadataInterface metaI) {
        this._metaInterface = metaI;
    }

    public void setOLAPValues(OLAPValues olapValues) {
        this._olapValues = olapValues;
    }

    public void setPrefilterString(String preFilterString) {
        this._preFilterString = preFilterString;
    }

    private void stripLastComma(StringBuilder columnBuffer) {
        int lastCom;
        int endOfBuf;
        if (columnBuffer.length() > 2 && (endOfBuf = columnBuffer.length() - 1) == (lastCom = columnBuffer.lastIndexOf(MDX_COMMA))) {
            columnBuffer.deleteCharAt(lastCom);
        }
    }

    public void setOLAPConnection(OLAPConnectionResource olapConnection) {
        this._olapConnection = olapConnection;
    }

    public void setHiddenResults(List<DataItem> hiddenResults) {
        this._hiddenResults = hiddenResults;
    }

    public List<DataItem> getHiddenResults() {
        return this._hiddenResults;
    }
}

