/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataItemSort {
    private static final Logger _logger = LogManager.getLogger(DataItemSort.class);

    public static String generateMDX(String coreMDXExpression, DataItem dataItem, DataSelection model, OLAPValues olapValues) {
        int i;
        DataItemActionType sortDirection = dataItem.getSortDirection();
        if (sortDirection == DataItemActionType.SORT_NONE) {
            return coreMDXExpression;
        }
        String sortValueString = null;
        try {
            sortValueString = MDXGenerationUtil.getTypeOfSortString(sortDirection);
        }
        catch (GenerationException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return coreMDXExpression;
        }
        List<String[]> sortCriteria = dataItem.getSortCriteria();
        boolean isTimeDimension = false;
        StringBuilder MDXExpression = new StringBuilder();
        String sortName = null;
        try {
            isTimeDimension = MDXGenerationUtil.isTimeDimension(dataItem);
            if (isTimeDimension) {
                MDXExpression.append("Hierarchize({").append(coreMDXExpression).append("}");
                if (sortDirection.equals(DataItemActionType.SORT_ASCENDING) || sortDirection.equals(DataItemActionType.SORT_HIERARCHICAL_ASCENDING)) {
                    MDXExpression.append(")");
                } else if (sortDirection.equals(DataItemActionType.SORT_DESCENDING) || sortDirection.equals(DataItemActionType.SORT_HIERARCHICAL_DESCENDING)) {
                    MDXExpression.append(",REVERSE)");
                } else {
                    if (_logger.isEnabled(Level.ERROR)) {
                        _logger.error(sortDirection.toString());
                        _logger.error(IQDataServicesResourceBundle.getStringResource("DataItemSortBadSortType.txt"));
                    }
                    return coreMDXExpression;
                }
                return MDXExpression.toString();
            }
            sortName = MDXGenerationUtil.getSortName(dataItem, olapValues, model);
        }
        catch (GenerationException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            return coreMDXExpression;
        }
        boolean memberSort = false;
        String[] measureNames = null;
        String[] memberNames = null;
        if (sortCriteria == null) {
            memberSort = true;
        } else if (sortCriteria.isEmpty()) {
            memberSort = true;
        } else {
            measureNames = sortCriteria.get(0);
        }
        if (sortCriteria != null && sortCriteria.size() > 1) {
            memberNames = sortCriteria.get(1);
        }
        if (memberSort) {
            MDXExpression.append("ORDER({").append(coreMDXExpression).append("},").append(sortName).append(".CURRENTMEMBER.CAPTION").append(sortValueString);
            return MDXExpression.toString();
        }
        int end3 = 0;
        int end4 = 0;
        if (memberNames != null) {
            end4 = memberNames.length;
        }
        MDXExpression.append("ORDER(").append(coreMDXExpression);
        if (measureNames != null) {
            end3 = measureNames.length;
        }
        if (end3 > 0) {
            for (i = 0; i < end3; ++i) {
                if (i == 0) {
                    MDXExpression.append(",");
                    if (end4 > 0) {
                        MDXExpression.append("(");
                    }
                    if (end3 > 0) {
                        MDXExpression.append("(");
                    }
                }
                sortName = measureNames[i];
                MDXExpression.append(sortName);
                if (i >= end3 - 1) continue;
                MDXExpression.append(" + ");
            }
            if (end3 > 0) {
                MDXExpression.append(")");
            }
        }
        if (memberNames != null) {
            for (i = 0; i < end4; ++i) {
                MDXExpression.append(",  ").append(memberNames[i]);
            }
            if (end4 > 0) {
                MDXExpression.append(")");
            }
        }
        MDXExpression.append(sortValueString);
        if (_logger.isInfoEnabled()) {
            _logger.info(MDXExpression.toString());
        }
        return MDXExpression.toString();
    }
}

