/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2;

import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.BusinessQueryTotalLocationType;
import com.sas.iquery.metadata.business.BusinessQueryTotalModeType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryTupleFilter;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BusinessQueryTotal {
    private static String LINEQUOTE = "\"";
    private static String VISUAL = " VisualTotals(";
    private static String PARENT = " ParentTotals(";
    private String _totalingType;
    private BusinessQuery _businessQuery = null;
    private boolean _isNoTotalWithRelativeContribution = false;
    private BusinessQueryTotalLocationType _totalLocation;
    private String _defaultTotalLabelRow = null;
    private String _defaultTotalLabelColumn = null;
    private BusinessQueryTotalModeType _totalMode;
    private String _topperLabel;
    private Role _totalRole = null;
    private static final Logger _logger = LogManager.getLogger(BusinessQueryTotal.class);

    public BusinessQueryTotal(DataSelection ds, Role totalRole) {
        this(ds, totalRole, ds.getComputationalLocale());
    }

    public BusinessQueryTotal(DataSelection ds, Role totalRole, Locale computationalLocale) {
        this._defaultTotalLabelRow = ds.getTotalLabel(Role.ROW, BusinessQuery.SUBTOTAL);
        this._defaultTotalLabelColumn = ds.getTotalLabel(Role.COLUMN, BusinessQuery.SUBTOTAL);
        if (this._defaultTotalLabelRow == null) {
            this._defaultTotalLabelRow = IQMetadataResourceBundle.getStringResource("BusinessQueryImplSubTotalLabel.txt", computationalLocale);
        }
        if (this._defaultTotalLabelColumn == null) {
            this._defaultTotalLabelColumn = IQMetadataResourceBundle.getStringResource("BusinessQueryImplSubTotalLabel.txt", computationalLocale);
        }
        this._totalingType = ds.getTotalType(totalRole);
        this._totalMode = ds.getTotalMode();
        this._totalRole = totalRole;
        this._businessQuery = ds;
        this._totalLocation = ds.getTotalLocation();
        if (this._totalLocation == null) {
            this._totalLocation = BusinessQueryTotalLocationType.TOTAL_ROW_BOTTOM_COLUMN_RIGHT;
        }
        this._topperLabel = VISUAL;
        if (this._totalMode.equals(BusinessQueryTotalModeType.CUBE_VALUES)) {
            this._topperLabel = PARENT;
        }
        if (_logger.isInfoEnabled()) {
            _logger.info("Totaling being applied:");
            _logger.info(this._totalingType);
            _logger.info(this._totalLocation.toString());
            _logger.info(this._totalMode.toString());
            _logger.info(this._totalRole.toString());
        }
    }

    public String generateAddParents(String MDXExpression, boolean enclosedAddParent) {
        StringBuilder mdxParents = new StringBuilder();
        if (this._businessQuery.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_PARENT_VALUES_TOTAL_VALUES_IGNORED) || this._totalingType.equals(BusinessQuery.TOTAL_NONE) && !this._isNoTotalWithRelativeContribution || MDXExpression.length() == 0) {
            return MDXExpression;
        }
        if (enclosedAddParent && !this._totalingType.equals(BusinessQuery.TOTAL_NONE) && !this._businessQuery.isAxisValuesCoalesced()) {
            List<StepInterface> steps = this._businessQuery.getSteps(this._totalRole);
            for (StepInterface step : steps) {
                if (!(step instanceof BusinessQueryRankFilter)) continue;
                return MDXExpression;
            }
        }
        String strip = "";
        String comma = ",";
        String underscore = "_";
        mdxParents.append(MDXGenerationUtil.NEWLINE).append(" AddParents(").append(MDXExpression);
        if (this._totalingType.equalsIgnoreCase(BusinessQuery.GRANDTOTAL) || this._totalingType.equalsIgnoreCase(BusinessQuery.AXISTOTAL)) {
            strip = "TOTALS";
        } else if (this._totalingType.equalsIgnoreCase(BusinessQuery.SUBTOTAL)) {
            strip = "SUBTOTALS";
        } else {
            underscore = "";
        }
        if (strip.length() == 0 && !this._totalLocation.equals(BusinessQueryTotalLocationType.TOTAL_ROW_BOTTOM_COLUMN_RIGHT)) {
            comma = "";
        }
        if (this._totalLocation.equals(BusinessQueryTotalLocationType.TOTAL_ROW_BOTTOM_COLUMN_RIGHT)) {
            mdxParents.append(comma).append(strip).append(underscore).append("POST)");
        } else {
            mdxParents.append(comma).append(strip).append(")");
        }
        return mdxParents.toString();
    }

    public String generateFinalTotal(String MDXExpression) {
        if (MDXExpression.length() == 0 || this._totalingType.equalsIgnoreCase(BusinessQuery.TOTAL_NONE) && !this._isNoTotalWithRelativeContribution && this._totalMode.equals(BusinessQueryTotalModeType.CUBE_VALUES)) {
            return MDXExpression;
        }
        for (StepInterface step : this._businessQuery.getSteps(this._totalRole)) {
            if (!(step instanceof BusinessQueryTupleFilter)) continue;
            return this.generateVisualTotalOnly(MDXExpression);
        }
        return this.generateVisualTotals(this.generateAddParents(MDXExpression, false), false);
    }

    public String generateVisualTotalOnly(String MDXExpression) {
        if (MDXExpression.length() == 0) {
            return MDXExpression;
        }
        return this.generateVisualTotals(MDXExpression, true);
    }

    private String generateVisualTotals(String MDXExpression, boolean ignoreCoalesce) {
        StringBuilder mdxVisualTotals = new StringBuilder();
        String totalLabel = this._defaultTotalLabelRow;
        if (this._totalRole.equals(Role.COLUMN)) {
            totalLabel = this._defaultTotalLabelColumn;
        }
        mdxVisualTotals.append(this._topperLabel).append(MDXExpression);
        if (!this._totalMode.equals(BusinessQueryTotalModeType.CUBE_VALUES)) {
            mdxVisualTotals.append(", ").append(LINEQUOTE).append(totalLabel).append(": *").append(LINEQUOTE);
        }
        if (!this._businessQuery.getQueryProperty(BusinessQueryProperty.OLAP_SELECTED_PARENTS_ONLY) && !ignoreCoalesce && this._businessQuery.isAxisValuesCoalesced()) {
            mdxVisualTotals.append(", Coalesce)");
        } else {
            mdxVisualTotals.append(")");
        }
        return mdxVisualTotals.toString();
    }

    public void setIsNoTotalWithRelativeContribution(boolean indicator) {
        this._isNoTotalWithRelativeContribution = indicator;
    }
}

