/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olapv2;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BusinessQueryDataBaseSort {
    private static final Logger _logger = LogManager.getLogger(BusinessQueryDataBaseSort.class);

    private static String buildCoreExpression(ExpressionInterface expression, DataSelection businessQuery, OLAPValues olapValues) throws GenerationException {
        StringBuilder coreExpression = new StringBuilder();
        if (!MDXGenerationUtil.isMeasure(expression)) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("DataItemDataBasedDataItemMustBeMeasure.txt", new Object[0]);
            throw new GenerationException(formatter);
        }
        ExpressionInterface expressionOfDataItem = null;
        expressionOfDataItem = expression instanceof DataItem ? ((DataItem)expression).getExpression() : expression;
        if (expressionOfDataItem instanceof FractionOfTotalExpression) {
            FractionOfTotalExpression fractionMeasure = (FractionOfTotalExpression)expressionOfDataItem;
            DataItem demonatorDataItem = fractionMeasure.getNumerator();
            String daCore = MDXGenerationUtil.buildCoreExpression(demonatorDataItem, olapValues);
            coreExpression.append(daCore);
        } else {
            String coreMDX = MDXGenerationUtil.buildCoreExpression(expression, olapValues);
            coreExpression.append(coreMDX);
        }
        return coreExpression.toString();
    }

    public static String generateMDX(String coreMDXExpression, DataSelection businessQuery, Role businessQueryRole, Map<DataItem, String> resultMap, List<DataItem> rowsOrColumns, String multipleMeasures, Map<String, String> MDXClauseMap, boolean isMultiSortWithQueryFilter, boolean testForRemainingDataSort, OLAPValues olapValues, String specialSortedMeasureDefintion) {
        int end;
        BusinessQueryActionType sortDirection = businessQuery.getSortDirection(businessQueryRole);
        if (sortDirection == BusinessQueryActionType.SORT_NONE) {
            return coreMDXExpression;
        }
        String sortValueString = null;
        try {
            sortValueString = MDXGenerationUtil.getTypeOfSortString(sortDirection);
        }
        catch (GenerationException e) {
            return coreMDXExpression;
        }
        List<Object> sortCriteria = businessQuery.getSortCriteria(businessQueryRole);
        if (sortCriteria == null || sortCriteria.isEmpty()) {
            return coreMDXExpression;
        }
        ArrayList<String> sortNames = new ArrayList<String>();
        ArrayList<DataItem> sortedDataItems = new ArrayList<DataItem>();
        ArrayList<DataItem> nonSortedDataItems = new ArrayList<DataItem>();
        boolean isTimeIndicator = false;
        String sortName = null;
        StringBuilder MDXExpression = new StringBuilder();
        boolean buildSortWithGenerate = false;
        int sortIndex = end = rowsOrColumns.size();
        boolean sortOnLastDimension = false;
        boolean businessQueryPrecedence = businessQuery.getQueryProperty(BusinessQueryProperty.BUSINESS_QUERY_OLAP_SORT_PRECEDENCE);
        int sortIndexPred = -1;
        String lastDimensionSortName = null;
        if (!businessQueryPrecedence) {
            for (int i = 0; i < end; ++i) {
                DataItem itemFromRowColumnList = rowsOrColumns.get(i);
                buildSortWithGenerate = false;
                boolean notSorted = false;
                DataItemActionType _itemDirection = itemFromRowColumnList.getSortDirection();
                if (_itemDirection == DataItemActionType.SORT_HIERARCHICAL_ASCENDING || _itemDirection == DataItemActionType.SORT_HIERARCHICAL_DESCENDING || _itemDirection == DataItemActionType.SORT_ASCENDING || _itemDirection == DataItemActionType.SORT_DESCENDING) {
                    buildSortWithGenerate = true;
                    sortIndexPred = i;
                } else if (i < end && sortIndexPred == -1) {
                    notSorted = true;
                    buildSortWithGenerate = true;
                }
                if (buildSortWithGenerate) {
                    try {
                        isTimeIndicator = MDXGenerationUtil.isTimeDimension(itemFromRowColumnList);
                    }
                    catch (GenerationException e) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("DataItemSortBadHierarchyName.txt", new Object[0]);
                            _logger.error((Object)formatter, (Throwable)e);
                        }
                        return coreMDXExpression;
                    }
                }
                if (!buildSortWithGenerate) continue;
                try {
                    sortName = MDXGenerationUtil.getSortName(itemFromRowColumnList, olapValues, businessQuery);
                }
                catch (GenerationException e) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("DataItemSortBadHierarchyName.txt", new Object[0]);
                        _logger.error((Object)formatter, (Throwable)e);
                    }
                    return coreMDXExpression;
                }
                if (sortName != null && i == end - 1 && !sortName.equals(olapValues.getMeasureCaption()) && _itemDirection != DataItemActionType.SORT_NONE) {
                    sortOnLastDimension = true;
                    lastDimensionSortName = sortName;
                    sortNames.add(sortName);
                    sortedDataItems.add(itemFromRowColumnList);
                    continue;
                }
                if (notSorted && itemFromRowColumnList != null) {
                    nonSortedDataItems.add(itemFromRowColumnList);
                    buildSortWithGenerate = false;
                    continue;
                }
                if (sortName == null) continue;
                sortNames.add(sortName);
                sortedDataItems.add(itemFromRowColumnList);
                sortIndex = i;
            }
        }
        if (sortOnLastDimension && sortNames.size() > 0 && buildSortWithGenerate) {
            return coreMDXExpression;
        }
        if (sortOnLastDimension && sortNames.size() > 1 && lastDimensionSortName != null) {
            int lastSortLocation = sortNames.indexOf(lastDimensionSortName);
            sortNames.remove(lastSortLocation);
            sortedDataItems.remove(lastSortLocation);
        }
        buildSortWithGenerate = sortNames.size() != 0;
        if (isMultiSortWithQueryFilter && buildSortWithGenerate) {
            buildSortWithGenerate = false;
            testForRemainingDataSort = true;
        }
        boolean isUseNonNestedCJ = Boolean.valueOf(System.getProperty("SASQueryServices.useNonNestedCrossJoin", "true"));
        int endOfNonSortedDataItem = nonSortedDataItems.size();
        if (isTimeIndicator) {
            buildSortWithGenerate = false;
        }
        ArrayList<Object> measuresNames = new ArrayList<Object>();
        ArrayList<Object> memberNames = new ArrayList<Object>();
        BusinessQueryDataBaseSort.buildMemberAndMeasureLists(sortCriteria, measuresNames, memberNames);
        if (measuresNames.isEmpty() && memberNames.isEmpty() && !buildSortWithGenerate) {
            return coreMDXExpression;
        }
        if (buildSortWithGenerate) {
            MessageFormatter formatter;
            int crossJoinParenthesesCountEnd = 0;
            int numSetsInCJ = 0;
            if (isUseNonNestedCJ && endOfNonSortedDataItem > 0) {
                MDXExpression.append("CROSSJOIN").append("(");
                ++crossJoinParenthesesCountEnd;
            }
            for (int count = 0; count < endOfNonSortedDataItem; ++count) {
                DataItem nonSortedDataItem;
                String stringOfSortedDataItem;
                String fromMDXMap;
                if (!isUseNonNestedCJ) {
                    MDXExpression.append("CROSSJOIN").append("(");
                    ++crossJoinParenthesesCountEnd;
                }
                if ((fromMDXMap = MDXClauseMap.get(stringOfSortedDataItem = resultMap.get(nonSortedDataItem = (DataItem)nonSortedDataItems.get(count)))) != null) {
                    stringOfSortedDataItem = fromMDXMap;
                }
                MDXExpression.append(stringOfSortedDataItem).append(",");
                ++numSetsInCJ;
            }
            MDXExpression.append(" GENERATE(");
            String generatedMemberString = BusinessQueryDataBaseSort.generateMember(resultMap, MDXClauseMap, sortNames, sortedDataItems, isUseNonNestedCJ);
            String generatedMemberCurrentName = "";
            try {
                generatedMemberCurrentName = BusinessQueryDataBaseSort.generateMemberCurrentName(resultMap, MDXClauseMap, sortNames, sortedDataItems, rowsOrColumns, multipleMeasures, businessQuery, isUseNonNestedCJ, sortIndex, sortCriteria, coreMDXExpression, specialSortedMeasureDefintion, olapValues, sortValueString, measuresNames, memberNames);
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    formatter = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedSortGettingRoleException.txt", new Object[0]);
                    _logger.error((Object)formatter, (Throwable)e);
                }
                return coreMDXExpression;
            }
            catch (GenerationException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    formatter = IQDataServicesResourceBundle.getMessageFormatter("DataItemSortBadTypeForDataItem.txt", new Object[0]);
                    _logger.error((Object)formatter, (Throwable)e);
                }
                return coreMDXExpression;
            }
            MDXExpression.append(generatedMemberString).append(", ").append(generatedMemberCurrentName);
            MDXExpression.append(" )");
            if (numSetsInCJ > 1 && isUseNonNestedCJ) {
                MDXExpression.append(", ").append(numSetsInCJ);
            }
            for (int i = 0; i < crossJoinParenthesesCountEnd; ++i) {
                MDXExpression.append(")");
            }
        } else if (!measuresNames.isEmpty() || !memberNames.isEmpty()) {
            String measuresAndMembers;
            MDXExpression.append("ORDER(").append(coreMDXExpression);
            try {
                measuresAndMembers = BusinessQueryDataBaseSort.getMeasuresAndMembers(sortCriteria, coreMDXExpression, specialSortedMeasureDefintion, olapValues, businessQuery, sortValueString, measuresNames, memberNames);
            }
            catch (GenerationException e) {
                if (_logger.isEnabled(Level.ERROR)) {
                    MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("DataItemSortBadTypeForDataItem.txt", new Object[0]);
                    _logger.error((Object)formatter, (Throwable)e);
                }
                return coreMDXExpression;
            }
            MDXExpression.append(",(").append(measuresAndMembers).append(")");
            MDXExpression.append(sortValueString);
        }
        return MDXExpression.toString();
    }

    private static String generateMember(Map<DataItem, String> resultMap, Map<String, String> MDXClauseMap, ArrayList<String> sortNames, ArrayList<DataItem> sortedDataItems, boolean isUseNonNestedCJ) {
        StringBuilder generatedMember = new StringBuilder();
        int crossJoinParenthesesCount = 0;
        int numOfSortDataItems = sortedDataItems.size();
        if (isUseNonNestedCJ && numOfSortDataItems > 1) {
            generatedMember.append("CROSSJOIN").append("(");
            ++crossJoinParenthesesCount;
        }
        for (int a = 0; a < numOfSortDataItems; ++a) {
            DataItem dataItem;
            String resultItemString;
            String fromMDXMap;
            if (!isUseNonNestedCJ && a < numOfSortDataItems - 1) {
                generatedMember.append("CROSSJOIN").append("(");
                ++crossJoinParenthesesCount;
            }
            if ((fromMDXMap = MDXClauseMap.get(resultItemString = resultMap.get(dataItem = sortedDataItems.get(a)))) != null) {
                resultItemString = fromMDXMap;
            }
            generatedMember.append(resultItemString);
            if (a >= numOfSortDataItems - 1) continue;
            generatedMember.append(",");
        }
        int lastCommaIndex = generatedMember.lastIndexOf(",");
        if (lastCommaIndex >= generatedMember.length() - 2) {
            generatedMember.setLength(lastCommaIndex);
        }
        if (isUseNonNestedCJ) {
            if (numOfSortDataItems > 1) {
                if (numOfSortDataItems > 2) {
                    generatedMember.append(", ").append(numOfSortDataItems);
                }
                generatedMember.append(")");
            }
        } else if (generatedMember.length() > 2) {
            for (int i = 0; i < crossJoinParenthesesCount; ++i) {
                generatedMember.append(")");
            }
        }
        return generatedMember.toString();
    }

    public static String generateMemberCurrentName(Map<DataItem, String> resultMap, Map<String, String> MDXClauseMap, ArrayList<String> sortNames, ArrayList<DataItem> sortedDataItems, List<DataItem> rowsOrColumns, String multipleMeasures, DataSelection businessQuery, boolean isUseNonNestedCJ, int sortIndex, List<Object> sortCriteria, String coreMDXExpression, String specialSortedMeasureDefintion, OLAPValues olapValues, Object sortValueString, List<Object> measuresNames, List<Object> memberNames) throws MetadataException, GenerationException {
        StringBuilder generatedMemberCurrentName = new StringBuilder();
        StringBuilder generateMemberCurrentNameOrder = new StringBuilder();
        int numSetsInOuterCJ = 0;
        int numOfOuterCJ = 0;
        if (isUseNonNestedCJ) {
            generatedMemberCurrentName.append("CROSSJOIN(");
            ++numOfOuterCJ;
        }
        for (String sortedDimensionName : sortNames) {
            if (!isUseNonNestedCJ) {
                generatedMemberCurrentName.append("CROSSJOIN(");
                ++numOfOuterCJ;
            }
            generatedMemberCurrentName.append(" {").append(sortedDimensionName).append(".CURRENTMEMBER},");
            ++numSetsInOuterCJ;
            generateMemberCurrentNameOrder.append(sortedDimensionName).append(".CURRENTMEMBER, ");
        }
        generatedMemberCurrentName.append(" ORDER({");
        ++numSetsInOuterCJ;
        int nestedInnerCrossJoins = 0;
        int numSetsInInnerCJ = 0;
        int end = rowsOrColumns.size();
        if (isUseNonNestedCJ && sortIndex < end - 2) {
            generatedMemberCurrentName.append("CROSSJOIN").append("(");
            ++nestedInnerCrossJoins;
        }
        for (int x = sortIndex + 1; x < end; ++x) {
            DataItem resultItem;
            Role businessRole;
            if (!isUseNonNestedCJ && x < end - 1) {
                generatedMemberCurrentName.append("CROSSJOIN").append("(");
                ++nestedInnerCrossJoins;
            }
            if ((businessRole = businessQuery.getResultItemRole(resultItem = rowsOrColumns.get(x))) == null) {
                businessRole = Role.BACKGROUND;
            }
            if (resultItem.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE && Role.isOutputResultRole(businessQuery, businessRole)) {
                generatedMemberCurrentName.append(multipleMeasures);
                ++numSetsInInnerCJ;
                generatedMemberCurrentName.append(",");
                continue;
            }
            generatedMemberCurrentName.append("{");
            String resultItemString = resultMap.get(resultItem);
            String fromMDXMap = MDXClauseMap.get(resultItemString);
            if (fromMDXMap != null) {
                resultItemString = fromMDXMap;
            }
            generatedMemberCurrentName.append(resultItemString).append("}");
            ++numSetsInInnerCJ;
            generatedMemberCurrentName.append(",");
        }
        int lastCommaIndex = generatedMemberCurrentName.lastIndexOf(",");
        if (lastCommaIndex >= generatedMemberCurrentName.length() - 2) {
            generatedMemberCurrentName.setLength(lastCommaIndex);
        }
        if (isUseNonNestedCJ && numSetsInInnerCJ > 2) {
            generatedMemberCurrentName.append(", ").append(numSetsInInnerCJ);
        }
        for (int i = 0; i < nestedInnerCrossJoins; ++i) {
            generatedMemberCurrentName.append(")");
        }
        generatedMemberCurrentName.append("}");
        String measuresAndMembers = BusinessQueryDataBaseSort.getMeasuresAndMembers(sortCriteria, coreMDXExpression, specialSortedMeasureDefintion, olapValues, businessQuery, sortValueString, measuresNames, memberNames);
        generateMemberCurrentNameOrder.append(measuresAndMembers);
        if (generateMemberCurrentNameOrder.length() > 0) {
            generatedMemberCurrentName.append(", (").append((CharSequence)generateMemberCurrentNameOrder).append(")");
        }
        if (sortValueString != null) {
            generatedMemberCurrentName.append(sortValueString);
        } else {
            generatedMemberCurrentName.append(")");
        }
        if (isUseNonNestedCJ && numSetsInOuterCJ > 2) {
            generatedMemberCurrentName.append(", ").append(numSetsInOuterCJ);
        }
        for (int i = 0; i < numOfOuterCJ; ++i) {
            generatedMemberCurrentName.append(" )");
        }
        return generatedMemberCurrentName.toString();
    }

    public static String getMeasuresAndMembers(List<Object> sortCriteria, String coreMDXExpression, String specialSortedMeasureDefintion, OLAPValues olapValues, DataSelection businessQuery, Object sortValueString, List<Object> measuresNames, List<Object> memberNames) throws GenerationException {
        int lastCommaIndex;
        int i;
        StringBuilder measuresAndMembers = new StringBuilder();
        int endOfMembers = memberNames.size();
        int endOfMeasures = measuresNames.size();
        if (endOfMeasures > 0) {
            if (endOfMeasures > 1 && specialSortedMeasureDefintion == null) {
                measuresAndMembers.append("(");
            }
            for (i = 0; i < endOfMeasures; ++i) {
                Object obj = measuresNames.get(i);
                String sortNameForMeasure = null;
                if (obj instanceof String) {
                    sortNameForMeasure = (String)obj;
                } else if (obj instanceof ExpressionInterface) {
                    ExpressionInterface da = (ExpressionInterface)obj;
                    sortNameForMeasure = BusinessQueryDataBaseSort.buildCoreExpression(da, businessQuery, olapValues);
                }
                if (sortNameForMeasure == null) continue;
                if (sortNameForMeasure.indexOf("&SS") > 0 || sortNameForMeasure.indexOf("&TT") > 0) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedSortIllegalSortName.fmt.txt", new Object[0]));
                }
                if (specialSortedMeasureDefintion != null) {
                    measuresAndMembers.append(specialSortedMeasureDefintion);
                    break;
                }
                measuresAndMembers.append(sortNameForMeasure);
                if (i >= endOfMeasures - 1) continue;
                measuresAndMembers.append(",");
            }
            if (endOfMeasures > 1 && specialSortedMeasureDefintion == null) {
                measuresAndMembers.append(")");
            }
        }
        if (specialSortedMeasureDefintion == null) {
            if (endOfMeasures > 0) {
                measuresAndMembers.append(",");
            }
            for (i = 0; i < endOfMembers; ++i) {
                Object memberObject = memberNames.get(i);
                String member = null;
                if (memberObject instanceof String) {
                    member = (String)memberObject;
                } else if (memberObject instanceof ExpressionInterface) {
                    ExpressionInterface dataItemExpression = (ExpressionInterface)memberObject;
                    member = BusinessQueryDataBaseSort.buildCoreExpression(dataItemExpression, businessQuery, olapValues);
                }
                if (member == null) continue;
                if (member.indexOf("&SS") > 0 || member.indexOf("&TT") > 0) {
                    throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedSortIllegalSortName.fmt.txt", new Object[0]));
                }
                measuresAndMembers.append(member);
                if (i >= endOfMembers - 1) continue;
                measuresAndMembers.append(",  ");
            }
        }
        if ((lastCommaIndex = measuresAndMembers.lastIndexOf(",")) >= measuresAndMembers.length() - 2) {
            measuresAndMembers.setLength(lastCommaIndex);
        }
        return measuresAndMembers.toString();
    }

    private static void buildMemberAndMeasureLists(List<Object> sortCriteria, List<Object> measuresNames, List<Object> memberNames) {
        for (int count = 0; count < sortCriteria.size(); ++count) {
            Object obj = sortCriteria.get(count);
            if (obj instanceof List) {
                List listObj = (List)obj;
                for (Object objectInList : listObj) {
                    if (objectInList instanceof ExpressionInterface) {
                        measuresNames.add(objectInList);
                        continue;
                    }
                    if (!(objectInList instanceof String)) continue;
                    memberNames.add(objectInList);
                }
            } else if (obj instanceof String[]) {
                String[] members;
                if (count == 0) {
                    String[] measures = (String[])sortCriteria.get(0);
                    if (measures.length > 0) {
                        for (String measureFromMeasures : measures) {
                            if (measureFromMeasures == null) continue;
                            measuresNames.add(measureFromMeasures);
                        }
                    }
                } else if (count == 1 && obj instanceof String[] && (members = (String[])sortCriteria.get(1)).length > 0) {
                    for (String memberFromMembers : members) {
                        if (memberFromMembers == null) continue;
                        memberNames.add(memberFromMembers);
                    }
                }
            }
            if (obj instanceof ExpressionInterface) {
                measuresNames.add(obj);
                continue;
            }
            if (!(obj instanceof String)) continue;
            memberNames.add(obj);
        }
    }
}

