/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.util;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelResource;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.olap.BaseFilterExpression;
import com.sas.iquery.metadata.expr.olap.BusinessGroupMemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.SlicerFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.physical.CalculatedMember;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.NamedSet;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.olap.AllLevel;
import com.sas.iquery.metadata.physical.oma.OMACalculatedMeasure;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXVariable;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPGeneratedCollection;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPGeneratedItem;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPItemType;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPServerUtilities;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLAPValues {
    private static final Object _lock = new Object();
    private String _measureName = null;
    private DataSelection _dataSelection;
    static final Logger _perfCLogger = LogManager.getLogger((String)"com.sas.iquery.perf.Connections");
    private List<String> _resultItemLabels = new ArrayList<String>();
    private OLAPServerUtilities _olapServerUtil = null;
    private BusinessModel _businessModel;
    private MetadataInterface _metadataInterface = null;
    private boolean _isTimePresent = false;
    private Map<String, OLAPGeneratedItem> _olapValuesAppliedForEachDataItem;
    private OLAPGeneratedCollection _olapGeneratedLists = null;
    private IdentityList _filterListOfDataItem;
    private String _timeHierName;
    private String _timeHierUName = null;
    private String _timeTopLevelName;
    private static final Logger _logger = LogManager.getLogger(OLAPValues.class);
    private static final Level ERROR_LEVEL = Level.ERROR;

    public OLAPValues(MetadataInterface metaI, List<DataItem> resultItems, DataSelection model) throws GenerationException {
        String cubeName = OLAPConnectionInfoUtil.getCubeName(model);
        if (metaI == null) {
            String message = IQDataServicesResourceBundle.getStringResource("OLAPConnectionInfoUtilBadMetaI.txt");
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, cubeName, model.getIdentityString(), message);
            throw new GenerationException(msF);
        }
        this._metadataInterface = metaI;
        this._olapServerUtil = OLAPServerUtilities.getInstance();
        this._olapServerUtil.setMetadataInterace(metaI);
        this._dataSelection = model;
        this._olapValuesAppliedForEachDataItem = new HashMap<String, OLAPGeneratedItem>();
        this._businessModel = this._dataSelection.getBusinessModel();
        this._olapGeneratedLists = new OLAPGeneratedCollection();
        if (this._businessModel == null) {
            this._businessModel = this._dataSelection.getBaseModel();
        }
        this._measureName = MDXGenerationUtil.getLocalMeasure(this._businessModel, this._metadataInterface);
        for (DataItem resultItem : resultItems) {
            if (resultItem == null) continue;
            String checkLabel = resultItem.getLabel();
            this._resultItemLabels.add(checkLabel);
        }
        this.buildFilterLists(resultItems, cubeName);
        this.buildOLAPDataItemComponents(resultItems, this._olapValuesAppliedForEachDataItem, true, cubeName);
    }

    public void release() {
        this._olapValuesAppliedForEachDataItem.clear();
        this._resultItemLabels.clear();
        this._olapGeneratedLists.release();
    }

    public String getMeasureCaption() {
        return this._measureName;
    }

    public static List<String> getDDLFilterList(DataSelection model) throws GenerationException {
        return OLAPValues.getDDLFilterList(model, false);
    }

    public static boolean isDLLFiltered(DataSelection model) throws GenerationException {
        return OLAPValues.getDDLFilterList(model, true).size() != 0;
    }

    private static List<String> getDDLFilterList(DataSelection model, boolean justOne) throws GenerationException {
        ArrayList<String> filterListForDDL = new ArrayList<String>();
        for (FilterItem filterItemDefinition : model.getEffectiveFilters()) {
            String filterId = "";
            try {
                filterId = filterItemDefinition.getID();
            }
            catch (InvalidIDException e) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                throw new GenerationException(e.getLocalizedMessage());
            }
            boolean isOldByGroup = false;
            ExpressionInterface filterExpression = filterItemDefinition.getExpression();
            DataItem filterDataItem = null;
            if (!(filterExpression instanceof BaseFilterExpression)) continue;
            BaseFilterExpression baseFilter = (BaseFilterExpression)filterExpression;
            ExpressionInterface whatToCompare = baseFilter.getWhatToCompare();
            while (whatToCompare instanceof DataItemReference) {
                filterDataItem = ((DataItemReference)whatToCompare).getBaseDataItem();
                whatToCompare = filterDataItem;
            }
            if (whatToCompare instanceof DataItem) {
                filterDataItem = (DataItem)whatToCompare;
            }
            if (filterDataItem == null) {
                _logger.error("Filter data item is null");
                MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("OLAPValuesBadType.txt", new Object[0]);
                throw new GenerationException(mft);
            }
            if (filterExpression instanceof MemberFilterExpression) {
                isOldByGroup = MDXGenerationUtil.isOldByGroupExpression(filterExpression, model, filterId, filterItemDefinition);
            }
            if (filterExpression instanceof SlicerFilterExpression || isOldByGroup) continue;
            if (filterExpression instanceof MemberFilterExpression && !(filterExpression instanceof BusinessGroupMemberFilterExpression)) {
                MemberFilterExpression memberFilterExpression = (MemberFilterExpression)filterExpression;
                filterListForDDL.add(((Object)memberFilterExpression).toString());
                if (!justOne) continue;
                break;
            }
            if (filterExpression instanceof TimeFilterFirstLastPeriodsExpression) {
                TimeFilterFirstLastPeriodsExpression timeFilterFirstLastPeriodsExpression = (TimeFilterFirstLastPeriodsExpression)filterExpression;
                filterListForDDL.add(((Object)timeFilterFirstLastPeriodsExpression).toString());
                if (!justOne) continue;
                break;
            }
            if (filterExpression instanceof TimeFilterNParallelPeriodsExpression) {
                TimeFilterNParallelPeriodsExpression timeFilterNParallelPeriodsExpression = (TimeFilterNParallelPeriodsExpression)filterExpression;
                filterListForDDL.add(((Object)timeFilterNParallelPeriodsExpression).toString());
                if (!justOne) continue;
                break;
            }
            if (filterExpression instanceof TimeFilterNPeriodsExpression) {
                TimeFilterNPeriodsExpression timeFilterNPeriodsExpression = (TimeFilterNPeriodsExpression)filterExpression;
                filterListForDDL.add(((Object)timeFilterNPeriodsExpression).toString());
                if (!justOne) continue;
                break;
            }
            if (!(filterExpression instanceof TimeRangeFilterExpression)) continue;
            TimeRangeFilterExpression timeRangeFilterExpression = (TimeRangeFilterExpression)filterExpression;
            filterListForDDL.add(((Object)timeRangeFilterExpression).toString());
            if (!justOne) continue;
            break;
        }
        return filterListForDDL;
    }

    private void buildFilterLists(List<DataItem> resultItems, String cubeName) throws GenerationException {
        this._filterListOfDataItem = new IdentityList();
        for (FilterItem filterItemDefinition : this._dataSelection.getEffectiveFilters()) {
            String filterId = "";
            try {
                filterId = filterItemDefinition.getID();
            }
            catch (InvalidIDException e) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                throw new GenerationException(e.getLocalizedMessage());
            }
            boolean isOldByGroup = false;
            ExpressionInterface filterExpression = filterItemDefinition.getExpression();
            DataItem filterDataItem = null;
            DataItem actualDataItem = null;
            Role role = null;
            try {
                ExpressionInterface whatToCompare;
                BaseFilterExpression baseFilter;
                if (filterExpression instanceof BaseFilterExpression) {
                    GenerationException e;
                    baseFilter = (BaseFilterExpression)filterExpression;
                    whatToCompare = baseFilter.getWhatToCompare();
                    while (whatToCompare instanceof DataItemReference) {
                        if (role == null) {
                            role = this._dataSelection.getResultItemRole((DataItemReference)whatToCompare);
                        }
                        filterDataItem = ((DataItemReference)whatToCompare).getBaseDataItem();
                        if (role == null) {
                            role = this._dataSelection.getResultItemRole(filterDataItem);
                        }
                        whatToCompare = filterDataItem;
                    }
                    if (whatToCompare instanceof DataItem) {
                        filterDataItem = (DataItem)whatToCompare;
                        if (role == null) {
                            role = this._dataSelection.getResultItemRole(filterDataItem);
                        }
                    } else {
                        if (_logger.isEnabled(ERROR_LEVEL)) {
                            _logger.error(filterExpression.toString());
                        }
                        e = new GenerationException(IQDataServicesResourceBundle.getStringResource("OLAPValuesBadType.txt"));
                        throw e;
                    }
                    actualDataItem = (DataItem)baseFilter.getWhatToCompare();
                    if (filterDataItem == null || actualDataItem == null) {
                        if (_logger.isEnabled(ERROR_LEVEL)) {
                            _logger.error(filterExpression.toString());
                        }
                        e = new GenerationException(IQDataServicesResourceBundle.getStringResource("OLAPValuesBadType.txt"));
                        throw e;
                    }
                    if (role == null) {
                        List<DataItem> items = this._dataSelection.getResultItems();
                        String label1 = filterDataItem.getLabel();
                        for (DataItem item : items) {
                            String label2 = item.getLabel();
                            if (!label1.equalsIgnoreCase(label2)) continue;
                            role = this._dataSelection.getResultItemRole(item);
                            break;
                        }
                    }
                    if (filterExpression instanceof MemberFilterExpression) {
                        isOldByGroup = MDXGenerationUtil.isOldByGroupExpression(filterExpression, this._dataSelection, filterId, filterItemDefinition);
                    }
                }
                if (filterExpression instanceof SlicerFilterExpression || filterExpression instanceof BusinessGroupMemberFilterExpression) {
                    baseFilter = (BaseFilterExpression)filterExpression;
                    whatToCompare = baseFilter.getWhatToCompare();
                    this._olapGeneratedLists.setValue(OLAPItemType.SLICER, ((DataItem)whatToCompare).getLabel(), null);
                    this._olapGeneratedLists.setValue(OLAPItemType.MDXFILTERS, filterItemDefinition, null);
                    continue;
                }
                if (isOldByGroup) {
                    baseFilter = (BaseFilterExpression)filterExpression;
                    whatToCompare = baseFilter.getWhatToCompare();
                    this._olapGeneratedLists.setValue(OLAPItemType.SLICER, ((DataItem)whatToCompare).getLabel(), null);
                    this._olapGeneratedLists.setValue(OLAPItemType.MDXFILTERS, filterItemDefinition, null);
                    continue;
                }
                if (filterExpression instanceof MemberFilterExpression && !(filterExpression instanceof BusinessGroupMemberFilterExpression) || filterExpression instanceof TimeFilterFirstLastPeriodsExpression || filterExpression instanceof TimeFilterNParallelPeriodsExpression || filterExpression instanceof TimeFilterNPeriodsExpression || filterExpression instanceof TimeRangeFilterExpression) {
                    this._olapGeneratedLists.setValue(OLAPItemType.DDLFILTERS, filterItemDefinition, null);
                    if (filterExpression instanceof BaseFilterExpression) {
                        if (filterDataItem != null) {
                            this._olapGeneratedLists.setValue(OLAPItemType.DDLDATAITEMS, filterId, filterDataItem);
                            this._filterListOfDataItem.add(filterDataItem.getExpression());
                            this._olapGeneratedLists.setValue(OLAPItemType.DDLEXPRESSION, filterDataItem.getLabel(), filterExpression);
                        }
                        if (filterDataItem == null || actualDataItem == null) continue;
                        boolean doesFilterHaveSelectedDataItem = this.getOLAPInfoOnOrphanedFilter(resultItems, filterDataItem, cubeName);
                        boolean totalOn = false;
                        if (role != null) {
                            if (this._dataSelection.getTotalType(role).equalsIgnoreCase(BusinessQuery.AXISTOTAL) || this._dataSelection.getTotalType(role).equalsIgnoreCase(BusinessQuery.ALLTOTAL) || this._dataSelection.getTotalType(role).equalsIgnoreCase(BusinessQuery.GRANDTOTAL)) {
                                totalOn = true;
                            }
                            if (!(totalOn || role != Role.BACKGROUND && role != Role.HIDDEN)) {
                                totalOn = true;
                            }
                        }
                        if (!totalOn && !doesFilterHaveSelectedDataItem) {
                            totalOn = true;
                        }
                        BaseFilterExpression baseFilter2 = (BaseFilterExpression)filterExpression;
                        if (totalOn && !baseFilter2.isNegated()) {
                            this._olapGeneratedLists.setValue(OLAPItemType.DDLDATAITEMTOTALED, baseFilter2.getWhatToCompare(), null);
                        }
                        if (baseFilter2.isNegated()) continue;
                        this._olapGeneratedLists.setValue(OLAPItemType.DDLFILTEREXPRESSIONTOTALED, filterExpression, filterDataItem);
                        continue;
                    }
                    if (_logger.isEnabled(ERROR_LEVEL)) {
                        _logger.error(filterExpression.toString());
                    }
                    GenerationException e = new GenerationException(IQDataServicesResourceBundle.getStringResource("OLAPValuesBadType.txt"));
                    throw e;
                }
                this._olapGeneratedLists.setValue(OLAPItemType.MDXFILTERS, filterItemDefinition, null);
            }
            catch (MetadataException e) {
                MDXGenerationUtil.applyDebugStatement(filterItemDefinition.toString() + filterExpression.toString(), this.getClass());
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                throw new GenerationException(e.getLocalizedMessage());
            }
        }
    }

    private boolean getOLAPInfoOnOrphanedFilter(List<DataItem> resultItems, DataItem filterDataItem, String cubeName) throws GenerationException {
        boolean foundMatchingDataItem = this.isDataItemOrphaned(filterDataItem.getLabel());
        if (!foundMatchingDataItem) {
            ArrayList<DataItem> orphanedInOlapValuesAppliedForEachDataItem = new ArrayList<DataItem>();
            orphanedInOlapValuesAppliedForEachDataItem.add(filterDataItem);
            this.buildOLAPDataItemComponents(orphanedInOlapValuesAppliedForEachDataItem, this._olapValuesAppliedForEachDataItem, false, cubeName);
        }
        return foundMatchingDataItem;
    }

    public void buildOLAPDataItemComponents(List<DataItem> resultItems, Map<String, OLAPGeneratedItem> olapValuesAppliedForEachDataItem, boolean checkAccessible, String cubeName) throws GenerationException {
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        long start = 0L;
        if (_perfCLogger.isDebugEnabled()) {
            ExtraLoggingContexts.debugLogConnectionPerformance("> Reading metadata to get metadata elements for generation. ");
            start = System.currentTimeMillis();
        }
        for (DataItem resultItem : resultItems) {
            try {
                Dimension physDim;
                List<Hierarchy> hier;
                OlapItem resultOLAPItem;
                String uniqueName;
                String dName;
                boolean isResultItemMeasure;
                OLAPGeneratedItem olapItemResultItem;
                String hierName;
                ExpressionInterface expression;
                int dimType;
                int counter;
                Filter filter;
                StringBuilder preFilterDataItemLabel;
                block60: {
                    preFilterDataItemLabel = new StringBuilder(500);
                    if (resultItem == null) continue;
                    String checkLabel = resultItem.getLabel();
                    boolean foundLabel = prefixMap.containsKey(checkLabel);
                    filter = new Filter();
                    filter.setCubeName(cubeName);
                    counter = 1;
                    if (foundLabel) {
                        String countera = (String)prefixMap.get(checkLabel);
                        counter = Integer.parseInt(countera);
                        ++counter;
                    }
                    prefixMap.put(checkLabel, String.valueOf(counter));
                    dimType = 1;
                    expression = resultItem.getExpression();
                    MDXGenerationUtil.applyDebugStatement("OLAP values are being retrieved: ", this.getClass());
                    MDXGenerationUtil.applyDebugStatement(expression.toString(), this.getClass());
                    hierName = this._measureName;
                    olapItemResultItem = new OLAPGeneratedItem(this._dataSelection, resultItem, this._measureName);
                    isResultItemMeasure = olapItemResultItem.isMeasure();
                    dName = this._measureName;
                    if (!isResultItemMeasure) {
                        hierName = BusinessQueryOLAPUtil.getHierarchyName(this._businessModel, resultItem, this._dataSelection.getComputationalLocale());
                        if (expression instanceof Hierarchy) {
                            filter.setHierarchyName(((Hierarchy)expression).getHierarchyName());
                        } else if (expression instanceof NamedSet) {
                            NamedSet namedSet = (NamedSet)expression;
                            Hierarchy hierarchy = namedSet.getOwningHierarchy();
                            hierName = hierarchy.getHierarchyName();
                            filter.setHierarchyName(hierName);
                        } else if (expression instanceof CalculatedMember) {
                            CalculatedMember calcMem = (CalculatedMember)expression;
                            uniqueName = calcMem.getUniqueName();
                            hierName = calcMem.getOwningHierarchy().getHierarchyName();
                            filter.setUniqueMemberName(uniqueName);
                        }
                        dName = BusinessQueryOLAPUtil.getDimensionName(this._dataSelection.getBusinessModel(), resultItem);
                    }
                    resultOLAPItem = BusinessQueryOLAPUtil.getOlapItem(resultItem);
                    if (hierName == null && resultOLAPItem != null && resultOLAPItem instanceof Hierarchy) {
                        hierName = ((Hierarchy)resultOLAPItem).getHierarchyName();
                    } else if (hierName == null && resultOLAPItem != null && resultOLAPItem instanceof NamedSet) {
                        NamedSet namedSet = (NamedSet)resultOLAPItem;
                        Hierarchy hierarchy = namedSet.getOwningHierarchy();
                        hierName = hierarchy.getHierarchyName();
                    } else if (hierName == null && resultOLAPItem != null && resultOLAPItem instanceof CalculatedMember) {
                        CalculatedMember calcMem = (CalculatedMember)resultOLAPItem;
                        try {
                            hierName = calcMem.getOwningHierarchy().getHierarchyName();
                        }
                        catch (MetadataException e1) {
                            if (!_logger.isEnabled(ERROR_LEVEL)) break block60;
                            _logger.error(e1.getLocalizedMessage(), (Throwable)e1);
                        }
                    }
                }
                uniqueName = this.getUniqueName(resultItem, olapItemResultItem);
                if (hierName == null && !isResultItemMeasure) {
                    preFilterDataItemLabel.append(uniqueName);
                } else if (hierName != null) {
                    if (hierName.length() > 0) {
                        preFilterDataItemLabel.append(hierName);
                    }
                } else {
                    preFilterDataItemLabel.append(this._measureName);
                }
                Locale locale = LocaleUtilities.getDefaultViewerLocale(this._dataSelection);
                String resultItemLabel = resultItem.getLabel(locale);
                resultItemLabel = MDXGenerationUtil.repairQuotes(resultItemLabel);
                olapItemResultItem.setValue(OLAPItemType.LABEL, resultItemLabel);
                olapItemResultItem.setValue(OLAPItemType.NAME, resultItemLabel);
                String dimensionLabel = this.getMemberLabel(resultItem);
                filter.setDimensionName(dimensionLabel);
                if (expression instanceof ResourceAwareStringExpression) {
                    if (null == dName) {
                        if (dimensionLabel.length() > 0 && !isResultItemMeasure) {
                            preFilterDataItemLabel.append(".[").append(dimensionLabel).append("]");
                        }
                    } else if (dName.length() > 0 && !isResultItemMeasure) {
                        preFilterDataItemLabel.append(".[").append(dName).append("]");
                        olapItemResultItem.setValue(OLAPItemType.DIMNAME, dName);
                    }
                } else {
                    olapItemResultItem.setValue(OLAPItemType.DIMNAME, dimensionLabel);
                    if (dimensionLabel.length() > 0 && !isResultItemMeasure) {
                        preFilterDataItemLabel.append(".[").append(dimensionLabel).append("]");
                    }
                }
                olapItemResultItem.setValue(OLAPItemType.PREFILTERLABEL, preFilterDataItemLabel.toString());
                if (expression instanceof ResourceAwareStringExpression) {
                    olapItemResultItem.setValue(OLAPItemType.MEMBERNAME, dimensionLabel);
                } else {
                    olapItemResultItem.setValue(OLAPItemType.MEMBERNAME, "[" + dimensionLabel + "]");
                }
                if (uniqueName == null) {
                    Object[] msgArgs2 = new Object[]{expression.toString(), IQDataServicesResourceBundle.getStringResource("OLAPValuesNullUniqueName.txt")};
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                    GenerationException e = new GenerationException(msF);
                    throw e;
                }
                olapItemResultItem.setValue(OLAPItemType.UNIQUENAME, uniqueName);
                String allMember = null;
                Hierarchy physHierarchy = null;
                if (expression instanceof Hierarchy) {
                    physHierarchy = (Hierarchy)expression;
                } else if (expression instanceof NamedSet) {
                    NamedSet namedSet = (NamedSet)expression;
                    physHierarchy = namedSet.getOwningHierarchy();
                } else if (expression instanceof CalculatedMember) {
                    CalculatedMember calcMem = (CalculatedMember)expression;
                    physHierarchy = calcMem.getOwningHierarchy();
                } else if (expression instanceof com.sas.iquery.metadata.physical.Level) {
                    com.sas.iquery.metadata.physical.Level physLevel = (com.sas.iquery.metadata.physical.Level)expression;
                    List<Hierarchy> hier2 = physLevel.getOwningDimension().getHierarchies();
                    if (hier2.size() > 0) {
                        physHierarchy = hier2.get(0);
                    }
                } else if (expression instanceof Dimension && (hier = (physDim = (Dimension)expression).getHierarchies()).size() > 0) {
                    physHierarchy = hier.get(0);
                }
                if (physHierarchy != null) {
                    allMember = physHierarchy.getAllMember();
                }
                if (allMember == null && !(expression instanceof OLAPResourceAwareStringExpression)) {
                    allMember = "All";
                }
                olapItemResultItem.setValue(OLAPItemType.ALL, allMember);
                boolean isAccessible = true;
                if (!(expression instanceof ResourceAwareStringExpression || expression instanceof TimeExpressionMeasure || expression instanceof FractionOfTotalExpression || isResultItemMeasure || !checkAccessible)) {
                    isAccessible = this.isAllMemberAccessible(filter, resultItem);
                }
                olapItemResultItem.setValue(OLAPItemType.ISACCESSIBLE, MDXGenerationUtil.BooleanValue(isAccessible));
                boolean isVisible = true;
                Role role = this._dataSelection.getResultItemRole(resultItem);
                if (role != null) {
                    if (!Role.isOutputResultRole(this._dataSelection, role)) {
                        isVisible = false;
                    }
                } else {
                    isVisible = false;
                }
                olapItemResultItem.setValue(OLAPItemType.ISVISIBLE, MDXGenerationUtil.BooleanValue(isVisible));
                olapItemResultItem.setValue(OLAPItemType.FILTER, filter);
                if (expression instanceof Measure) {
                    if (resultOLAPItem != null && resultOLAPItem instanceof OMACalculatedMeasure) {
                        uniqueName = resultOLAPItem.getUniqueName();
                        olapItemResultItem.setValue(OLAPItemType.UNIQUENAME, uniqueName);
                    }
                    Measure meas = (Measure)expression;
                    String name = meas.getMeasureName();
                    String measureDimensionLabel = resultItem.getLabel(locale);
                    measureDimensionLabel = MDXGenerationUtil.repairQuotes(measureDimensionLabel);
                    olapItemResultItem.setValue(OLAPItemType.LABEL, measureDimensionLabel);
                    olapItemResultItem.setValue(OLAPItemType.NAME, name);
                    olapItemResultItem.setValue(OLAPItemType.FORMAT, meas.getSasFormat());
                } else {
                    if (hierName == null) {
                        olapItemResultItem.setValue(OLAPItemType.HIERNAME, uniqueName);
                    } else {
                        olapItemResultItem.setValue(OLAPItemType.HIERNAME, hierName);
                    }
                    if (expression instanceof Hierarchy && !this._isTimePresent) {
                        Hierarchy timeHierarchy = (Hierarchy)expression;
                        Dimension omaD = timeHierarchy.getOwningDimension();
                        dimType = omaD.getDimensionType();
                        if (dimType == 0) {
                            this._isTimePresent = true;
                            this._timeHierUName = timeHierarchy.getHierarchyUniqueName();
                            this._timeHierName = timeHierarchy.getHierarchyUniqueName();
                            this.buildTimeHierarchyName(false, timeHierarchy, this._timeHierName, cubeName);
                        }
                    } else if (expression instanceof ResourceAwareStringExpression && !this._isTimePresent && (dimType = BusinessQueryOLAPUtil.getDimensionType(resultItem, (Object)expression)) == 1) {
                        this._isTimePresent = true;
                        this._timeHierName = BusinessQueryOLAPUtil.getHierarchyName(resultItem.getBusinessModel(), resultItem);
                        this.buildTimeHierarchyName(true, null, this._timeHierName, cubeName);
                    }
                }
                String key = this.getKey(resultItem);
                olapValuesAppliedForEachDataItem.put(key, olapItemResultItem);
                this.setMDXLabel(expression, resultItem, resultItem.getStructure(), this._dataSelection.getResultItemRole(resultItem), counter, olapItemResultItem);
            }
            catch (MetadataException e) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                throw new GenerationException(e.getLocalizedMessage());
            }
        }
        if (_perfCLogger.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTimeHierarchyName(boolean isTimeRASE, Hierarchy timeHierarchy, String timeHierName, String cubeName) throws GenerationException {
        block15: {
            try {
                if (!isTimeRASE) {
                    if (timeHierarchy == null) {
                        if (_logger.isEnabled(ERROR_LEVEL)) {
                            Object[] msgArgs2 = new Object[]{timeHierName, IQDataServicesResourceBundle.getStringResource("OLAPValuesNullLevel.txt")};
                            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                            _logger.error(msF.toString());
                        }
                        return;
                    }
                    List<com.sas.iquery.metadata.physical.Level> levels = timeHierarchy.getLevels();
                    if (levels.size() == 0) {
                        if (_logger.isEnabled(ERROR_LEVEL)) {
                            _logger.error(timeHierarchy.toString());
                        }
                        GenerationException e = new GenerationException(IQDataServicesResourceBundle.getStringResource("OLAPValuesNullLevel.txt"));
                        throw e;
                    }
                    com.sas.iquery.metadata.physical.Level topLevel = levels.get(0);
                    if (topLevel instanceof AllLevel && levels.size() >= 2) {
                        topLevel = levels.get(1);
                    }
                    StringBuilder topBuff = new StringBuilder(400);
                    topBuff.append(this._timeHierUName).append(".[").append(topLevel.getLevelName()).append("]");
                    this._timeTopLevelName = this._timeHierUName = topBuff.toString();
                    break block15;
                }
                Filter filter = new Filter();
                filter.setCubeName(cubeName);
                filter.setUniqueHierarchyName(timeHierName);
                LevelInterface[] levelI = null;
                Object topBuff = _lock;
                synchronized (topBuff) {
                    levelI = this._metadataInterface.getLevels(filter);
                }
                if (null == levelI) {
                    _logger.error((Object)filter);
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("OLAPValuesNullLevel.txt", new Object[0]);
                    throw new GenerationException(mft);
                }
                if (levelI.length > 1) {
                    this._timeHierUName = this._timeTopLevelName = levelI[1].getUniqueName();
                }
            }
            catch (MetadataException e) {
                _logger.error((Object)e);
                throw new GenerationException(e);
            }
            catch (OLAPException e) {
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
                throw new GenerationException(e.getLocalizedMessage());
            }
        }
    }

    private boolean checkFormat(DataItem resultItem, MDXVariable mdxVariable, int counter, OLAPGeneratedItem olapGeneratedItem) throws GenerationException {
        boolean formatDifference = false;
        String formatInCube = this.getMeasureFormat(resultItem);
        String formatInMap = resultItem.getFormat();
        if (null == formatInMap || formatInMap.trim().length() == 0) {
            return formatDifference;
        }
        if ((null == formatInCube || 0 == formatInCube.trim().length()) && null != formatInMap) {
            mdxVariable.setSpecialLabel(true);
            mdxVariable.setCounter(counter);
            formatDifference = true;
            mdxVariable.setFormat(formatInMap);
        } else if (null != formatInCube) {
            String decimal;
            int indexFormat;
            if (formatInCube.substring(0, 1).equalsIgnoreCase("F") && (indexFormat = (formatInCube = formatInCube.substring(1)).indexOf(".")) > 0 && (decimal = formatInCube.substring(indexFormat)).equalsIgnoreCase(".0")) {
                formatInCube = formatInCube.substring(0, indexFormat + 1);
            }
            if (!formatInCube.equalsIgnoreCase(formatInMap)) {
                mdxVariable.setSpecialLabel(true);
                mdxVariable.setCounter(counter);
                formatDifference = true;
                mdxVariable.setFormat(formatInMap);
            }
        }
        return formatDifference;
    }

    private String getKey(DataItem dataItem) {
        ExpressionInterface expressionDataItem = dataItem.getExpression();
        StringBuilder key = new StringBuilder(100);
        key.append(dataItem.getLabel());
        if (expressionDataItem instanceof ResourceAwareStringExpression) {
            key.append(expressionDataItem.toString());
        } else {
            key.append(dataItem.getStructure().toString());
        }
        return key.toString();
    }

    public List<FilterItem> getFilterListForMDX() {
        List objectValue = (List)this._olapGeneratedLists.getObjectValue(OLAPItemType.MDXFILTERS, null);
        return objectValue;
    }

    private String getMeasureFormat(DataItem dataItem) throws GenerationException {
        String format = "";
        ExpressionInterface expression = dataItem.getExpression();
        if (expression instanceof Measure) {
            return this.getOLAPValue(dataItem, OLAPItemType.FORMAT).toString();
        }
        return format;
    }

    private String getMemberLabel(DataItem resultItem) throws GenerationException {
        String memberLabel = null;
        try {
            ExpressionInterface dataItemExpression = resultItem.getExpression();
            if (dataItemExpression instanceof Hierarchy) {
                Hierarchy dH = (Hierarchy)dataItemExpression;
                memberLabel = dH.getDimensionName();
            } else if (dataItemExpression instanceof NamedSet) {
                NamedSet namedSet = (NamedSet)dataItemExpression;
                memberLabel = namedSet.getOwningDimension().getDimensionName();
            } else if (dataItemExpression instanceof CalculatedMember) {
                CalculatedMember calcMember = (CalculatedMember)dataItemExpression;
                memberLabel = calcMember.getOwningDimension().getDimensionName();
            } else if (dataItemExpression instanceof Dimension) {
                Dimension dD = (Dimension)dataItemExpression;
                memberLabel = dD.getDimensionName();
            } else if (dataItemExpression instanceof com.sas.iquery.metadata.physical.Level) {
                com.sas.iquery.metadata.physical.Level dL = (com.sas.iquery.metadata.physical.Level)dataItemExpression;
                memberLabel = dL.getDimensionName();
            } else if (dataItemExpression instanceof Measure) {
                Measure meas = (Measure)dataItemExpression;
                memberLabel = meas.getDimensionName();
            } else if (dataItemExpression instanceof ResourceAwareStringExpression) {
                ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)dataItemExpression;
                List<BusinessModelResource> resources = resourceExp.getResources(BusinessModelResource.class, 65535);
                if (resources.isEmpty()) {
                    return resultItem.getLabel();
                }
                for (BusinessModelResource bmaResource : resources) {
                    if (bmaResource instanceof Dimension) {
                        Dimension physDimension = (Dimension)bmaResource;
                        memberLabel = BusinessQueryOLAPUtil.getPhysDimensionName(physDimension);
                        continue;
                    }
                    if (bmaResource instanceof Hierarchy) {
                        Hierarchy physHierarchy = (Hierarchy)bmaResource;
                        memberLabel = BusinessQueryOLAPUtil.getPhysHierarchyName(physHierarchy);
                        continue;
                    }
                    if (dataItemExpression instanceof NamedSet) {
                        NamedSet namedSet = (NamedSet)dataItemExpression;
                        memberLabel = namedSet.getOwningDimension().getUniqueName();
                        continue;
                    }
                    if (dataItemExpression instanceof CalculatedMember) {
                        CalculatedMember calcMember = (CalculatedMember)dataItemExpression;
                        memberLabel = calcMember.getOwningDimension().getUniqueName();
                        continue;
                    }
                    if (bmaResource instanceof com.sas.iquery.metadata.physical.Level) {
                        com.sas.iquery.metadata.physical.Level physLevel = (com.sas.iquery.metadata.physical.Level)bmaResource;
                        memberLabel = BusinessQueryOLAPUtil.getPhysLevelName(physLevel);
                        continue;
                    }
                    memberLabel = resultItem.getLabel();
                }
            } else {
                memberLabel = resultItem.getLabel();
            }
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            throw new GenerationException(e.getLocalizedMessage());
        }
        return memberLabel;
    }

    public MetadataInterface getMetadataInterface() {
        return this._metadataInterface;
    }

    public Map<String, OLAPGeneratedItem> getOLAPConstantValues() {
        return this._olapValuesAppliedForEachDataItem;
    }

    public Object getOLAPValue(DataItem dataItem, OLAPItemType key) {
        Object valueObject = null;
        String generatedItemKey = this.getKey(dataItem);
        OLAPGeneratedItem olapResultItem = this._olapValuesAppliedForEachDataItem.get(generatedItemKey);
        if (olapResultItem == null) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.debug(IQDataServicesResourceBundle.getStringResource("OLAPValuesValueIsNull.txt"));
            }
            valueObject = "";
        } else {
            valueObject = olapResultItem.getValue(key);
        }
        if (valueObject == null) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.debug(IQDataServicesResourceBundle.getStringResource("OLAPValuesValueIsNull.txt"));
            }
            valueObject = "";
        }
        return valueObject;
    }

    public List<?> getFilterListForDDL() {
        List objectValue = (List)this._olapGeneratedLists.getObjectValue(OLAPItemType.DDLFILTERS, null);
        return objectValue;
    }

    public boolean isVisible(DataItem dataItem) {
        Object returnValue = this.getOLAPValue(dataItem, OLAPItemType.ISVISIBLE);
        Boolean returnValueOfObject = MDXGenerationUtil.BooleanStringValueOf(returnValue.toString());
        return returnValueOfObject;
    }

    public boolean isMeasure(DataItem dataItem) {
        Object returnValue = this.getOLAPValue(dataItem, OLAPItemType.ISMEASURE);
        Boolean returnValueOfObject = MDXGenerationUtil.BooleanStringValueOf(returnValue.toString());
        return returnValueOfObject;
    }

    public boolean isFormatDifferent(DataItem dataItem) {
        Object returnValue = this.getOLAPValue(dataItem, OLAPItemType.ISFORMATDIFFERENCE);
        Boolean returnValueOfObject = MDXGenerationUtil.BooleanStringValueOf(returnValue.toString());
        return returnValueOfObject;
    }

    public boolean isAllMemberPresent(DataItem dataItem) {
        Object returnValue = this.getOLAPValue(dataItem, OLAPItemType.ISACCESSIBLE);
        Boolean returnValueOfObject = MDXGenerationUtil.BooleanStringValueOf(returnValue.toString());
        return returnValueOfObject;
    }

    public DataItem getDataItemForDDLFilter(String filterId) {
        return (DataItem)this._olapGeneratedLists.getObjectValue(OLAPItemType.DDLDATAITEMS, filterId);
    }

    public ExpressionInterface getFilterExpressionListForDDL(String filterId) {
        return (ExpressionInterface)this._olapGeneratedLists.getObjectValue(OLAPItemType.DDLEXPRESSION, filterId);
    }

    public boolean isFilterDDLApplied(DataItem filterDataItem, boolean checkPreviousDDLSetting) {
        return this._filterListOfDataItem.contains(filterDataItem.getExpression());
    }

    public boolean doesFilterDDLHaveTotal(DataItem dataItem) {
        return this._olapGeneratedLists.isAValue(OLAPItemType.DDLDATAITEMTOTALED, dataItem);
    }

    public String getAllTotalLabelForDDL(ExpressionInterface filterExpression) {
        DataItem da = (DataItem)this._olapGeneratedLists.getObjectValue(OLAPItemType.DDLFILTEREXPRESSIONTOTALED, filterExpression);
        return this.getAllTotalLabelForDDL(da);
    }

    public String getAllTotalLabelForDDL(DataItem da) {
        String returnValue = "";
        if (da != null) {
            returnValue = (String)this.getOLAPValue(da, OLAPItemType.ALL);
        }
        return returnValue;
    }

    public boolean isSlicerFilterApplied(String key) {
        return this._olapGeneratedLists.isAValue(OLAPItemType.SLICER, key);
    }

    public String getTimeHierName() {
        return this._timeHierName;
    }

    public String getTimeHierUniqueName() {
        return this._timeHierUName;
    }

    public String getTimeTopLevelName() {
        return this._timeTopLevelName;
    }

    private String getUniqueName(DataItem dataItem, OLAPGeneratedItem olapItemResultItem) throws GenerationException {
        ExpressionInterface expression = dataItem.getExpression();
        String returnValue = "";
        try {
            if (expression instanceof Dimension) {
                returnValue = MDXGenerationUtil.getDimensionExpression((Dimension)expression, this._olapServerUtil);
            } else if (expression instanceof NamedSet) {
                NamedSet namedSet = (NamedSet)expression;
                returnValue = namedSet.getUniqueName();
            } else if (expression instanceof CalculatedMember) {
                CalculatedMember calcMember = (CalculatedMember)expression;
                returnValue = calcMember.getUniqueName();
            } else if (expression instanceof Hierarchy) {
                Hierarchy hierExpression = (Hierarchy)expression;
                String hierarchy = hierExpression.getUniqueName();
                String hierarchyStart = this._olapServerUtil.getHierarchyExpression((Hierarchy)expression, MDXGenerationUtil.getStartingLevel(dataItem));
                hierarchy = hierarchyStart.equalsIgnoreCase("All") ? hierarchy + ".[" + hierarchyStart + "]" : hierarchyStart;
                returnValue = hierarchy;
            } else if (expression instanceof com.sas.iquery.metadata.physical.Level) {
                returnValue = MDXGenerationUtil.getLevelExpression((com.sas.iquery.metadata.physical.Level)expression);
            } else if (expression instanceof Measure) {
                returnValue = MDXGenerationUtil.getMeasureExpression((Measure)expression);
            } else if (expression instanceof ResourceAwareStringExpression) {
                ResourceAwareStringExpression resourceExp = (ResourceAwareStringExpression)expression;
                HashMap<BusinessModelResource, String> resourceToMDXMap = new HashMap<BusinessModelResource, String>();
                List<BusinessModelResource> resources = resourceExp.getResources(BusinessModelResource.class, 65535);
                for (BusinessModelResource bmaResource : resources) {
                    Hierarchy hierarchy;
                    if (bmaResource instanceof DataItem) {
                        DataItem di = (DataItem)bmaResource;
                        resourceToMDXMap.put(di, this.getUniqueName(di, olapItemResultItem));
                        continue;
                    }
                    if (bmaResource instanceof Dimension) {
                        Dimension physDimension = (Dimension)bmaResource;
                        String dimName = BusinessQueryOLAPUtil.getPhysDimensionName(physDimension);
                        resourceToMDXMap.put(physDimension, dimName);
                        continue;
                    }
                    if (bmaResource instanceof Hierarchy) {
                        Hierarchy physHierarchy = (Hierarchy)bmaResource;
                        String hierName = BusinessQueryOLAPUtil.getPhysHierarchyName(physHierarchy);
                        resourceToMDXMap.put(physHierarchy, hierName);
                        continue;
                    }
                    if (bmaResource instanceof com.sas.iquery.metadata.physical.Level) {
                        com.sas.iquery.metadata.physical.Level physLevel = (com.sas.iquery.metadata.physical.Level)bmaResource;
                        String levelName = BusinessQueryOLAPUtil.getPhysLevelName(physLevel);
                        resourceToMDXMap.put(physLevel, levelName);
                        continue;
                    }
                    if (bmaResource instanceof Measure) {
                        Measure physMeasure = (Measure)bmaResource;
                        String measureName = BusinessQueryOLAPUtil.getPhysMeasureName(physMeasure);
                        resourceToMDXMap.put(physMeasure, measureName);
                        continue;
                    }
                    if (bmaResource instanceof NamedSet) {
                        NamedSet namedSet = (NamedSet)bmaResource;
                        hierarchy = namedSet.getOwningHierarchy();
                        resourceToMDXMap.put(hierarchy, hierarchy.getHierarchyName());
                        continue;
                    }
                    if (!(bmaResource instanceof CalculatedMember)) continue;
                    CalculatedMember calcName = (CalculatedMember)bmaResource;
                    hierarchy = calcName.getOwningHierarchy();
                    resourceToMDXMap.put(hierarchy, hierarchy.getHierarchyName());
                }
                String resourceMDX = resourceExp.getText(resourceToMDXMap);
                olapItemResultItem.setValue(OLAPItemType.RASENAME, resourceMDX);
                returnValue = "( " + resourceMDX + " )";
            }
        }
        catch (MetadataException e) {
            _logger.error((Object)e);
            throw new GenerationException(e);
        }
        return returnValue;
    }

    public boolean hasOLAPValue(DataItem dataItem) {
        OLAPGeneratedItem valueInResult = this._olapValuesAppliedForEachDataItem.get(this.getKey(dataItem));
        return valueInResult != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAllMemberAccessible(Filter filter, DataItem dataItem) throws GenerationException {
        try {
            HierarchyInterface hierarchy = null;
            Object object = _lock;
            synchronized (object) {
                hierarchy = this._metadataInterface.getHierarchy(filter);
            }
            if (hierarchy == null) {
                Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("OLAPValuesNullHier.txt")};
                if (_logger.isEnabled(ERROR_LEVEL)) {
                    _logger.error(filter.toString());
                }
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                GenerationException e = new GenerationException(msF);
                throw e;
            }
            MemberInterface topMember = null;
            if (!this.isFilterDDLApplied(dataItem, true)) {
                try {
                    topMember = hierarchy.getTopMember();
                }
                catch (OLAPException me) {
                    if (_logger.isEnabled(ERROR_LEVEL)) {
                        _logger.error(me.getLocalizedMessage(), (Throwable)me);
                    }
                    return false;
                }
            } else {
                return true;
            }
            if (topMember == null) {
                return false;
            }
        }
        catch (OLAPException e) {
            if (_logger.isEnabled(ERROR_LEVEL)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            throw new GenerationException(e.getLocalizedMessage());
        }
        return true;
    }

    public boolean isDataItemOrphaned(String dataItemLabel) {
        return this._resultItemLabels.contains(dataItemLabel);
    }

    public boolean isTimeDimensionPresent() {
        return this._isTimePresent;
    }

    public DataSelection getDataSelection() {
        return this._dataSelection;
    }

    private void setMDXLabel(ExpressionInterface expressionForResultItem, DataItem resultItem, StructureOfDataItem resultItemStructure, Role role, int counter, OLAPGeneratedItem olapGeneratedItem) throws GenerationException {
        MDXVariable mdxVariable = new MDXVariable(this._metadataInterface, resultItem, Role.isOutputResultRole(this._dataSelection, role), this._dataSelection);
        boolean isFormatDifferent = false;
        if (expressionForResultItem instanceof ResourceAwareStringExpression) {
            mdxVariable.setCounter(counter);
            mdxVariable.setSpecialLabel(true);
        } else if (expressionForResultItem instanceof TimeExpressionMeasure || expressionForResultItem instanceof FractionOfTotalExpression) {
            mdxVariable.setCounter(counter);
        }
        if (resultItemStructure.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
            isFormatDifferent = this.checkFormat(resultItem, mdxVariable, counter, olapGeneratedItem);
            mdxVariable.setLabel(this._measureName);
            olapGeneratedItem.setValue(OLAPItemType.MDXVARIABLE, mdxVariable);
        } else {
            mdxVariable.setCounter(counter);
            mdxVariable.setLabel((String)olapGeneratedItem.getValue(OLAPItemType.UNIQUENAME));
            olapGeneratedItem.setValue(OLAPItemType.MDXVARIABLE, mdxVariable);
        }
        olapGeneratedItem.setValue(OLAPItemType.ISFORMATDIFFERENCE, MDXGenerationUtil.BooleanValue(isFormatDifferent));
    }

    public void setPromptMemberLevelRoot(String dataItemLabel, String levelRoot) {
        this._olapGeneratedLists.setValue(OLAPItemType.PROMPTROOTS, dataItemLabel, levelRoot);
    }

    public String getPromptMemberLevelRoot(String dataItemLabel) {
        return this._olapGeneratedLists.getStringValue(OLAPItemType.PROMPTROOTS, dataItemLabel);
    }

    public void setOLAPValue(DataItem dataItem, OLAPItemType olapItemType, Object value) throws GenerationException {
        OLAPGeneratedItem olapItemResultItem = this._olapValuesAppliedForEachDataItem.get(this.getKey(dataItem));
        if (olapItemResultItem == null) {
            olapItemResultItem = new OLAPGeneratedItem(this._dataSelection, dataItem, this._measureName);
        }
        olapItemResultItem.setValue(olapItemType, value);
        this._olapValuesAppliedForEachDataItem.put(this.getKey(dataItem), olapItemResultItem);
    }
}

