/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.util;

import com.sas.iom.SASMDX.ISession;
import com.sas.iquery.metadata.business.impl.IdentityList;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CubeAssociatedISessionContainer {
    private IdentityList _sessionsFiltered = new IdentityList();
    private List _activeSessionsAttachedToCube = new ArrayList();
    private Map _cacheKeys = new HashMap();

    public CubeAssociatedISessionContainer(ISession isession, String cacheKey) {
        this.setISessionActive(isession, cacheKey);
    }

    public synchronized void setISessionActive(ISession isession, String cacheKey) {
        if (!this._activeSessionsAttachedToCube.contains(isession)) {
            this._activeSessionsAttachedToCube.add(isession);
        }
        List<String> keys = null;
        MDXGenerationUtil.applyDebugStatement("Setting this ISession as being active for this cube. ", this.getClass());
        if (cacheKey != null) {
            if (!this._cacheKeys.containsKey(isession)) {
                keys = new ArrayList<String>();
                keys.add(cacheKey);
            } else {
                keys = (List)this._cacheKeys.get(isession);
                if (!keys.contains(cacheKey)) {
                    keys.add(cacheKey);
                }
            }
            if (keys != null) {
                this._cacheKeys.put(isession, keys);
            }
        }
    }

    public synchronized void removeActiveISession(ISession isession) {
        if (this._activeSessionsAttachedToCube.contains(isession)) {
            this._activeSessionsAttachedToCube.remove(isession);
        }
        while (this._cacheKeys.containsKey(isession)) {
            this._cacheKeys.remove(isession);
        }
        MDXGenerationUtil.applyDebugStatement("Remove this ISession as being active for this cube. ", this.getClass());
    }

    public synchronized void removeKeyCache(ISession isession, String cacheKey) {
        List cache = (List)this._cacheKeys.get(isession);
        MDXGenerationUtil.applyDebugStatement("Removing this cacheKey from cubeISession object " + cacheKey, this.getClass());
        while (cache.contains(cacheKey)) {
            cache.remove(cacheKey);
        }
    }

    public synchronized String getFirstKeyCache(ISession isession) {
        List keysCache;
        String keyCache = null;
        if (this._cacheKeys.containsKey(isession) && this._cacheKeys.containsKey(isession) && !(keysCache = (List)this._cacheKeys.get(isession)).isEmpty() && keysCache.size() > 0) {
            keyCache = (String)keysCache.get(0);
        }
        return keyCache;
    }

    public String reportISessionCaches(String cubeName) {
        List activeISessions = this.getActiveISessions();
        Iterator iterator = activeISessions.iterator();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            ISession isessionObject = (ISession)iterator.next();
            List keyOldCache = this.getKeyCache(isessionObject);
            Iterator it = keyOldCache.iterator();
            builder.append("ISession: ").append(isessionObject).append(MDXGenerationUtil.NEWLINE);
            while (it.hasNext()) {
                String key = (String)it.next();
                builder.append("     ").append("Key: ").append(key).append(MDXGenerationUtil.NEWLINE);
            }
        }
        return builder.toString();
    }

    public synchronized String getSpecifiKeyCache(ISession isession, int number) {
        List keysCache;
        String keyCache = null;
        if (this._cacheKeys.containsKey(isession) && (keysCache = (List)this._cacheKeys.get(isession)).size() > number) {
            keyCache = (String)keysCache.get(number);
        }
        return keyCache;
    }

    public synchronized List getKeyCache(ISession isession) {
        List keyCache = null;
        if (this._cacheKeys.containsKey(isession)) {
            keyCache = (List)this._cacheKeys.get(isession);
        }
        return keyCache;
    }

    public synchronized List getActiveISessions() {
        return this._activeSessionsAttachedToCube;
    }

    public synchronized void setISessionFilter(ISession isession) {
        this._sessionsFiltered.add(isession);
        MDXGenerationUtil.applyDebugStatement("Set an ISession as being filtered.", this.getClass());
    }

    public synchronized void setISessionUnFilter(ISession isession) {
        this._sessionsFiltered.remove(isession);
        MDXGenerationUtil.applyDebugStatement("Set an ISession as being unfiltered.", this.getClass());
    }

    public synchronized boolean isCubeFiltered() {
        boolean isFiltered = false;
        if (this._sessionsFiltered.size() > 0) {
            isFiltered = true;
        }
        return isFiltered;
    }

    public synchronized boolean isCubeSessionFiltered(ISession isession) {
        boolean isFiltered = false;
        if (this._sessionsFiltered.contains(isession)) {
            isFiltered = true;
        }
        return isFiltered;
    }
}

