/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepFilterInterface;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFirstLastPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNParallelPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.OLAPResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.physical.Cube;
import com.sas.iquery.metadata.physical.Dimension;
import com.sas.iquery.metadata.physical.Hierarchy;
import com.sas.iquery.metadata.physical.Measure;
import com.sas.iquery.metadata.physical.olap.AllLevel;
import com.sas.iquery.strategies.sas.oma.olap.step.BusinessQueryFilterDataBased;
import com.sas.iquery.strategies.sas.oma.olap.step.BusinessQueryFilterRank;
import com.sas.iquery.strategies.sas.oma.olap.step.DataBasedFilter;
import com.sas.iquery.strategies.sas.oma.olap.step.MemberFilter;
import com.sas.iquery.strategies.sas.oma.olap.step.MemberPropertyFilter;
import com.sas.iquery.strategies.sas.oma.olap.step.NavigationFilter;
import com.sas.iquery.strategies.sas.oma.olap.step.RankFilter;
import com.sas.iquery.strategies.sas.oma.olap.step.TimeFirstLastPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olap.step.TimeNParallelPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olap.step.TimeNPeriodsFilter;
import com.sas.iquery.strategies.sas.oma.olap.step.TimeRangeFilter;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class StepManager {
    private DataItem _dataItem;
    private int _endOfSteps;
    private Map _drillMemberList = null;
    private CompoundStep _compoundStep;
    private List _stepsBeingProcessed;
    private String _condition = null;
    private StepInterface _previousStepInCompoundStep = null;
    private StepInterface _nextStepInCompoundStep = null;
    private String _dataBasedFilterMDX = null;
    private String _memberPropertyFilterMDX = null;
    private String _rankFilterMDX = null;
    private String _memberFilterMDX = null;
    private String _navigationFilterMDX = null;
    private boolean _isNegate = false;
    private Role _role = null;
    private String _cubeName = null;
    private String _dim = null;
    private MetadataInterface _metaI = null;
    private Hierarchy _hierarchy = null;
    private boolean _isMultiSortWithQueryFilter = false;
    private static final Logger _logger = LogManager.getLogger(StepManager.class);

    public StepManager(DataItem dataItem) {
        this._dataItem = dataItem;
        this._compoundStep = null;
        this._stepsBeingProcessed = dataItem.getSteps();
        this._endOfSteps = this._stepsBeingProcessed.size();
    }

    public StepManager(DataSelection ds, Role role) {
        this._role = role;
        this._stepsBeingProcessed = ds.getSteps(role);
        this._endOfSteps = this._stepsBeingProcessed.size();
    }

    public StepManager(DataItem dataItem, int stepNumber) {
        this._dataItem = dataItem;
        this._compoundStep = null;
        this._endOfSteps = stepNumber;
    }

    public StepManager(CompoundStep compoundStep) {
        this._dataItem = null;
        this._compoundStep = compoundStep;
        this._stepsBeingProcessed = compoundStep.getSteps();
        this._endOfSteps = this._stepsBeingProcessed.size();
    }

    public StepManager(CompoundStep compoundStep, int stepNumber) {
        this._dataItem = null;
        this._compoundStep = compoundStep;
        this._stepsBeingProcessed = compoundStep.getSteps();
        this._endOfSteps = stepNumber;
    }

    public boolean isMultiSortWithQueryFilter() {
        return this._isMultiSortWithQueryFilter;
    }

    public String generateMDX(DataSelection dataSelection, String currentExpression) throws GenerationException {
        this._drillMemberList = new HashMap();
        String stepExpression = null;
        stepExpression = this._dataItem == null && this._compoundStep != null ? this.processSteps(dataSelection, this._compoundStep, currentExpression) : (this._dataItem == null && this._role != null ? this.processSteps(dataSelection, currentExpression) : this.processSteps(dataSelection, this._dataItem, currentExpression));
        if (!this._drillMemberList.isEmpty()) {
            String finalizeSteps = this.processRecursiveMDX(stepExpression);
            return finalizeSteps;
        }
        return stepExpression;
    }

    private String processRecursiveMDX(String currentExpression) {
        StringBuffer tempExpression = new StringBuffer();
        tempExpression = new StringBuffer("EXCEPT(DRILLDOWNMEMBER(");
        tempExpression.append(currentExpression).append(", ");
        Set expandedMembers = this._drillMemberList.keySet();
        Iterator iterator = expandedMembers.iterator();
        StringBuffer drillMemberExpression = new StringBuffer("{");
        while (iterator.hasNext()) {
            String checkLab = iterator.next().toString();
            checkLab = StepManager.replaceQuote(checkLab);
            drillMemberExpression.append(checkLab).append(", ");
        }
        drillMemberExpression.setLength(drillMemberExpression.length() - 2);
        drillMemberExpression.append("}");
        tempExpression.append(drillMemberExpression).append(", RECURSIVE), ").append(drillMemberExpression).append(")");
        return tempExpression.toString();
    }

    private String processSteps(DataSelection dataSelection, DataItem dataItem, String initialExpression) throws GenerationException {
        String currentExpression = initialExpression;
        this.getDataItemInfo(dataItem);
        for (int stepNumber = 0; stepNumber < this._endOfSteps; ++stepNumber) {
            StepInterface step = dataItem.getStep(stepNumber);
            currentExpression = this.processStep(dataSelection, step, currentExpression, initialExpression, dataItem);
        }
        return currentExpression;
    }

    private String processSteps(DataSelection dataSelection, String initialExpression) throws GenerationException {
        String currentExpression = initialExpression;
        for (int stepNumber = 0; stepNumber < this._endOfSteps; ++stepNumber) {
            StepInterface step = dataSelection.getStep(stepNumber, this._role);
            currentExpression = this.processStep(dataSelection, step, currentExpression, initialExpression, null);
        }
        return currentExpression;
    }

    private void getDataItemInfo(DataItem dataItem) {
        block16: {
            ExpressionInterface expression = dataItem.getExpression();
            if (expression instanceof Hierarchy) {
                this._hierarchy = (Hierarchy)expression;
            } else if (expression instanceof OLAPResourceAwareStringExpression) {
                OLAPResourceAwareStringExpression olapRASE = (OLAPResourceAwareStringExpression)expression;
                this._hierarchy = olapRASE.getHierarchy();
            }
            if (this._hierarchy != null) {
                List<com.sas.iquery.metadata.physical.Level> levels = null;
                try {
                    Dimension dim;
                    levels = this._hierarchy.getLevels();
                    if (levels == null) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            Object[] msgArgs2 = new Object[]{dataItem.toString(), expression.toString(), IQDataServicesResourceBundle.getStringResource("MDXGenerationNoLevels.txt")};
                            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                            _logger.error(msF.toString());
                        }
                        return;
                    }
                    if (levels.size() == 0) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            Object[] msgArgs2 = new Object[]{dataItem.toString(), expression.toString(), IQDataServicesResourceBundle.getStringResource("MDXGenerationNoLevels.txt")};
                            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                            _logger.error(msF.toString());
                        }
                        return;
                    }
                    com.sas.iquery.metadata.physical.Level topLevel = levels.get(0);
                    if (topLevel instanceof AllLevel) {
                        if (levels.size() == 1) {
                            if (_logger.isEnabled(Level.ERROR)) {
                                Object[] msgArgs2 = new Object[]{dataItem.toString(), expression.toString(), IQDataServicesResourceBundle.getStringResource("MDXGenerationNoLevels.txt")};
                                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                                _logger.error(msF.toString());
                            }
                            return;
                        }
                        topLevel = levels.get(1);
                    }
                    if ((dim = topLevel.getOwningDimension()) != null) {
                        Cube owningCube = dim.getOwningCube();
                        this._cubeName = owningCube != null ? owningCube.getCubeName() : OLAPConnectionInfoUtil.getCube(dataItem.getBusinessModel()).getCubeName();
                        this._dim = dim.getDimensionName();
                    }
                }
                catch (MetadataException e) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        Object[] msgArgs2 = new Object[]{dataItem.toString(), expression.toString(), e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("MDXGenerationHierLevelsException.txt")};
                        ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                        _logger.error(msF.toString());
                    }
                }
                catch (GenerationException e) {
                    if (!_logger.isEnabled(Level.ERROR)) break block16;
                    Object[] msgArgs2 = new Object[]{dataItem.toString(), expression.toString(), e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("MDXGenerationHierLevelsException.txt")};
                    ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                    _logger.error(msF.toString());
                }
            }
        }
    }

    private String processSteps(DataSelection dataSelection, CompoundStep step, String initialExpression) throws GenerationException {
        StepInterface stepInCompoundStep;
        int stepNumber;
        StringBuffer MDXExpression = new StringBuffer();
        String currentExpression = initialExpression;
        List<String> conditionsOfSteps = step.getStepsConditions();
        if (this._stepsBeingProcessed.size() == 0) {
            return currentExpression;
        }
        --this._endOfSteps;
        int numberOfConditions = conditionsOfSteps.size();
        --numberOfConditions;
        this._isNegate = step.isNegated();
        ArrayList<StepInterface> reversedCompoundSteps = new ArrayList<StepInterface>();
        ArrayList<String> reversedConditionOfSteps = new ArrayList<String>();
        for (stepNumber = this._endOfSteps; stepNumber > -1; --stepNumber) {
            stepInCompoundStep = (StepInterface)this._stepsBeingProcessed.get(stepNumber);
            reversedCompoundSteps.add(stepInCompoundStep);
        }
        for (stepNumber = numberOfConditions; stepNumber > -1; --stepNumber) {
            String conditionInCompoundStep = conditionsOfSteps.get(stepNumber);
            reversedConditionOfSteps.add(conditionInCompoundStep);
        }
        for (stepNumber = this._endOfSteps; stepNumber > -1; --stepNumber) {
            stepInCompoundStep = (StepInterface)reversedCompoundSteps.get(stepNumber);
            int nextNumber = stepNumber;
            this._nextStepInCompoundStep = --nextNumber > -1 ? (StepInterface)reversedCompoundSteps.get(nextNumber) : null;
            currentExpression = this.processStep(dataSelection, stepInCompoundStep, currentExpression, initialExpression, null);
            this._previousStepInCompoundStep = stepInCompoundStep;
            if (numberOfConditions > -1) {
                this._condition = (String)reversedConditionOfSteps.get(numberOfConditions);
            }
            --numberOfConditions;
        }
        MDXExpression.append(currentExpression);
        currentExpression = MDXExpression.toString();
        return currentExpression;
    }

    private static String replaceQuote(String checkLabel) {
        String checkLab = checkLabel;
        int quotePosition = checkLab.indexOf("'");
        if (quotePosition > -1) {
            String checkLabel2 = checkLab.replaceAll("'", "''");
            checkLabel = checkLabel2.replaceAll("''''", "''");
            return checkLabel;
        }
        return checkLabel;
    }

    private String processStep(DataSelection dataSelection, StepInterface step, String currentExpression, String initialExpression, DataItem dataItem) {
        BusinessQueryActionType sortDirection;
        StringBuffer MDXExpression;
        block130: {
            int paren = 0;
            int sep = 0;
            MDXExpression = new StringBuffer();
            if (step instanceof CompoundStep) {
                CompoundStep cStep = (CompoundStep)step;
                StepManager sm = new StepManager(cStep);
                String compoundExpression = null;
                try {
                    compoundExpression = sm.generateMDX(dataSelection, currentExpression);
                }
                catch (GenerationException e) {
                    if (_logger.isEnabled(Level.ERROR)) {
                        Object[] msgArgs2 = new Object[]{dataItem.toString(), currentExpression, e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("StepManagerCantCreateCompound.txt")};
                        ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                        _logger.error(msF.toString());
                    }
                    return initialExpression;
                }
                return compoundExpression;
            }
            StepFilterInterface sf = (StepFilterInterface)step;
            int stepActionType = sf.getActionType();
            boolean specialOperation = false;
            if (stepActionType == 6 && step instanceof DataItemNavigationFilter) {
                specialOperation = true;
            }
            boolean applySeparator = false;
            boolean applyParenFirst = false;
            if (!specialOperation) {
                if (!this._drillMemberList.isEmpty()) {
                    currentExpression = this.processRecursiveMDX(currentExpression);
                    this._drillMemberList.clear();
                }
                if (step instanceof DataItemTimeFirstLastPeriodsFilter || step instanceof DataItemTimeNParallelPeriodsFilter || step instanceof DataItemTimeNPeriodsFilter || step instanceof DataItemTimeRangeFilter) {
                    if (this._compoundStep != null && this._previousStepInCompoundStep != null) {
                        if (this._isNegate) {
                            stepActionType = 4;
                        } else if (this._condition.equals("OR")) {
                            stepActionType = 7;
                        } else if (this._condition.equals("AND")) {
                            stepActionType = 5;
                        }
                    }
                    if (step instanceof DataItemTimeFirstLastPeriodsFilter) {
                        this._memberFilterMDX = TimeFirstLastPeriodsFilter.getMDXExpression((DataItemTimeFirstLastPeriodsFilter)step);
                    }
                    if (step instanceof DataItemTimeNParallelPeriodsFilter) {
                        this._memberFilterMDX = TimeNParallelPeriodsFilter.getMDXExpression((DataItemTimeNParallelPeriodsFilter)step);
                    }
                    if (step instanceof DataItemTimeNPeriodsFilter) {
                        this._memberFilterMDX = TimeNPeriodsFilter.getMDXExpression((DataItemTimeNPeriodsFilter)step);
                    }
                    if (step instanceof DataItemTimeRangeFilter) {
                        this._memberFilterMDX = TimeRangeFilter.getMDXExpression((DataItemTimeRangeFilter)step);
                    }
                    if (this._memberFilterMDX != null) {
                        String Expression = this.completeStepMDX(this._memberFilterMDX, stepActionType, sf, currentExpression);
                        MDXExpression.append(Expression);
                    }
                    currentExpression = StepManager.replaceQuote(MDXExpression.toString());
                    return currentExpression;
                }
                if (step instanceof DataItemDataBasedFilter) {
                    try {
                        StringBuffer filterExp = new StringBuffer();
                        if (this._compoundStep != null) {
                            if (!(this._nextStepInCompoundStep instanceof DataItemDataBasedFilter)) {
                                filterExp.append(" { FILTER({").append(initialExpression).append("}, ");
                                applySeparator = true;
                                ++paren;
                                ++sep;
                                applyParenFirst = true;
                                if (this._isNegate) {
                                    filterExp.append(" NOT (");
                                    ++paren;
                                }
                            }
                            if (this._previousStepInCompoundStep instanceof DataItemDataBasedFilter) {
                                filterExp.append(currentExpression).append(" ");
                                if (this._condition.equals("AND")) {
                                    filterExp.append("AND");
                                }
                                if (this._condition.equals("OR")) {
                                    filterExp.append("OR");
                                }
                                filterExp.append(" ");
                            } else if (this._previousStepInCompoundStep != null) {
                                if (this._condition.equals("OR")) {
                                    stepActionType = 7;
                                } else if (this._condition.equals("AND")) {
                                    stepActionType = 5;
                                }
                            }
                        } else {
                            filterExp.append(" FILTER({").append(currentExpression).append("}, ");
                            applySeparator = true;
                            ++paren;
                            if (this._isNegate) {
                                filterExp.append(" NOT (");
                                ++paren;
                            }
                        }
                        this._dataBasedFilterMDX = DataBasedFilter.getMDXExpression(dataSelection, filterExp.toString(), (DataItemDataBasedFilter)step);
                        if (applyParenFirst && (stepActionType == 7 || stepActionType == 5)) {
                            --paren;
                        }
                    }
                    catch (GenerationException e) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            Object[] msgArgs2 = new Object[]{dataItem.toString(), currentExpression, e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("StepManagerCantCreateCompound.txt")};
                            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                            _logger.error(msF.toString());
                        }
                        return initialExpression;
                    }
                    if (this._dataBasedFilterMDX != null) {
                        String Expression = this.completeStepMDX(this._dataBasedFilterMDX, stepActionType, sf, currentExpression);
                        MDXExpression.append(Expression);
                        if (applySeparator) {
                            int i;
                            for (i = 0; i < paren; ++i) {
                                MDXExpression.append(")");
                            }
                            for (i = 0; i < sep; ++i) {
                                MDXExpression.append("}");
                            }
                            if (applyParenFirst && (stepActionType == 7 || stepActionType == 5)) {
                                MDXExpression.append(")");
                            }
                        }
                    }
                    currentExpression = StepManager.replaceQuote(MDXExpression.toString());
                    return currentExpression;
                }
                if (step instanceof DataItemMemberPropertiesFilter) {
                    Filter filter = new Filter();
                    Filter filter1 = new Filter();
                    if (this._hierarchy == null || this._cubeName == null || this._dim == null) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            Object[] msgArgs2 = new Object[]{dataItem.toString(), this._cubeName, filter.toString(), IQDataServicesResourceBundle.getStringResource("OLAPValuesNullHier.txt")};
                            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                            _logger.error(msF.toString());
                        }
                        return initialExpression;
                    }
                    try {
                        StringBuffer filterExp = new StringBuffer();
                        if (this._compoundStep != null) {
                            if (!(this._nextStepInCompoundStep instanceof DataItemDataBasedFilter)) {
                                filterExp.append(" { FILTER({").append(initialExpression).append("}, ");
                                applySeparator = true;
                                ++paren;
                                ++sep;
                                applyParenFirst = true;
                                if (this._isNegate) {
                                    filterExp.append(" NOT (");
                                    ++paren;
                                }
                            }
                            if (this._previousStepInCompoundStep instanceof DataItemDataBasedFilter) {
                                filterExp.append(currentExpression).append(" ");
                                if (this._condition.equals("AND")) {
                                    filterExp.append("AND");
                                }
                                if (this._condition.equals("OR")) {
                                    filterExp.append("OR");
                                }
                                filterExp.append(" ");
                            } else if (this._previousStepInCompoundStep != null) {
                                if (this._condition.equals("OR")) {
                                    stepActionType = 7;
                                } else if (this._condition.equals("AND")) {
                                    stepActionType = 5;
                                }
                            }
                        } else {
                            filterExp.append(" FILTER({").append(currentExpression).append("}, ");
                            applySeparator = true;
                            ++paren;
                            if (this._isNegate) {
                                filterExp.append(" NOT (");
                                ++paren;
                            }
                        }
                        if (this._metaI == null) {
                            if (_logger.isEnabled(Level.ERROR)) {
                                Object[] msgArgs2 = new Object[]{initialExpression, IQDataServicesResourceBundle.getStringResource("OLAPConnectionResource.OLAPEX.noMeta.txt")};
                                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                                _logger.error(msF.toString());
                            }
                            return initialExpression;
                        }
                        filter.setCubeName(this._cubeName);
                        filter.setDimensionName(this._dim);
                        String hierarchyName = null;
                        try {
                            hierarchyName = this._hierarchy.getHierarchyName();
                        }
                        catch (MetadataException e) {
                            if (_logger.isEnabled(Level.ERROR)) {
                                Object[] msgArgs2 = new Object[]{dataItem.toString(), this._cubeName, IQDataServicesResourceBundle.getStringResource("StepManagerCantGetProperty.txt")};
                                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                                _logger.error(msF.toString());
                            }
                            return initialExpression;
                        }
                        filter.setHierarchyName(hierarchyName);
                        filter1.setHierarchyName(hierarchyName);
                        filter1.setCubeName(this._cubeName);
                        filter1.setDimensionName(this._dim);
                        DataItemMemberPropertiesFilter pF = (DataItemMemberPropertiesFilter)step;
                        String propName = pF.getMemberPropertyName();
                        filter.setPropertyName(propName);
                        PropertyInterface propL = null;
                        Class<String> propDataType = null;
                        ArrayList<String> listOfLevels = new ArrayList<String>();
                        propL = this._metaI.getProperty(filter);
                        PropertyInterface[] props = this._metaI.getProperties(filter1);
                        if (props == null) {
                            if (_logger.isEnabled(Level.ERROR)) {
                                Object[] msgArgs2 = new Object[]{dataItem.toString(), this._cubeName, filter.toString(), IQDataServicesResourceBundle.getStringResource("StepManagerCantGetProperty.txt")};
                                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                                _logger.error(msF.toString());
                            }
                            return initialExpression;
                        }
                        for (int i = 0; i < props.length; ++i) {
                            LevelInterface l1;
                            HierarchyInterface h1;
                            String s1;
                            PropertyInterface p1 = props[i];
                            if (!propName.equalsIgnoreCase(p1.getName()) || !(s1 = (h1 = (l1 = p1.getLevel()).getHierarchy()).getName()).equalsIgnoreCase(hierarchyName)) continue;
                            String levelName = l1.getName();
                            listOfLevels.add(levelName);
                        }
                        if (propL == null) {
                            if (_logger.isEnabled(Level.ERROR)) {
                                Object[] msgArgs2 = new Object[]{dataItem.toString(), filter.toString(), IQDataServicesResourceBundle.getStringResource("StepManagerCantGetProperty.txt")};
                                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                                _logger.error(msF.toString());
                            }
                            propDataType = String.class;
                        } else {
                            propDataType = propL.getDataType();
                        }
                        this._memberPropertyFilterMDX = MemberPropertyFilter.getMDXExpression(dataSelection, filterExp.toString(), (DataItemMemberPropertiesFilter)step, propDataType, dataItem, listOfLevels);
                        if (applyParenFirst && (stepActionType == 7 || stepActionType == 5)) {
                            --paren;
                        }
                    }
                    catch (GenerationException e) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            Object[] msgArgs2 = new Object[]{dataItem.toString(), this._cubeName, e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("StepManagerCantCreateCompound.txt")};
                            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                            _logger.error(msF.toString());
                        }
                        return initialExpression;
                    }
                    catch (OLAPException e) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            Object[] msgArgs2 = new Object[]{dataItem.toString(), filter.toString(), e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("StepManagerCantGetProperty.txt")};
                            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                            _logger.error(msF.toString());
                        }
                        return initialExpression;
                    }
                    if (this._memberPropertyFilterMDX != null) {
                        String Expression = this.completeStepMDX(this._memberPropertyFilterMDX, stepActionType, sf, currentExpression);
                        MDXExpression.append(Expression);
                        if (applySeparator) {
                            int i;
                            for (i = 0; i < paren; ++i) {
                                MDXExpression.append(")");
                            }
                            for (i = 0; i < sep; ++i) {
                                MDXExpression.append("}");
                            }
                            if (applyParenFirst && (stepActionType == 7 || stepActionType == 5)) {
                                MDXExpression.append(")");
                            }
                        }
                    }
                    currentExpression = MDXExpression.toString();
                    return currentExpression;
                }
                if (step instanceof DataItemRankFilter) {
                    StringBuffer rankExp = new StringBuffer();
                    if (this._compoundStep != null && this._previousStepInCompoundStep != null) {
                        if (this._previousStepInCompoundStep instanceof DataItemRankFilter) {
                            if (this._condition.equals("OR")) {
                                rankExp.append(" ,");
                            }
                        } else if (this._isNegate) {
                            stepActionType = 4;
                        } else if (this._condition.equals("OR")) {
                            stepActionType = 7;
                        }
                    }
                    rankExp.append(currentExpression);
                    String rankExprStr = rankExp.toString();
                    this._rankFilterMDX = RankFilter.getMDXExpression(rankExprStr, (DataItemRankFilter)step);
                    if (this._rankFilterMDX != null) {
                        MDXExpression.append(this.completeStepMDX(this._rankFilterMDX, stepActionType, sf, currentExpression));
                    }
                    currentExpression = StepManager.replaceQuote(MDXExpression.toString());
                    return currentExpression;
                }
                if (step instanceof DataItemMemberFilter) {
                    if (this._compoundStep != null && this._previousStepInCompoundStep != null) {
                        if (this._isNegate) {
                            stepActionType = 4;
                        } else if (this._condition.equals("OR")) {
                            stepActionType = 7;
                        } else if (this._condition.equals("AND")) {
                            stepActionType = 5;
                        }
                    }
                    try {
                        this._memberFilterMDX = MemberFilter.getMDXExpression(dataSelection, initialExpression, (DataItemMemberFilter)step);
                    }
                    catch (GenerationException e) {
                        if (_logger.isEnabled(Level.ERROR)) {
                            Object[] msgArgs2 = new Object[]{dataItem.toString(), currentExpression, e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("StepManagerCantCreateMemberStep.txt")};
                            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                            _logger.error(msF.toString());
                        }
                        return initialExpression;
                    }
                    if (this._memberFilterMDX != null) {
                        String Expression = this.completeStepMDX(this._memberFilterMDX, stepActionType, sf, currentExpression);
                        MDXExpression.append(Expression);
                    }
                    currentExpression = MDXExpression.toString();
                    return currentExpression;
                }
                if (step instanceof DataItemNavigationFilter) {
                    this._navigationFilterMDX = NavigationFilter.getMDXExpression(currentExpression, (DataItemNavigationFilter)step);
                    if (this._navigationFilterMDX != null) {
                        String Expression = this.completeStepMDX(this._navigationFilterMDX, stepActionType, sf, currentExpression);
                        if (this._compoundStep != null) {
                            if (this._previousStepInCompoundStep != null) {
                                int i;
                                if (this._isNegate) {
                                    MDXExpression.append("{ EXCEPT(");
                                } else if (this._condition.equals("OR")) {
                                    MDXExpression.append("{ UNION(");
                                } else if (this._condition.equals("AND")) {
                                    MDXExpression.append("{ INTERSECT(");
                                }
                                if (this._condition.equals("AND") || this._condition.equals("OR")) {
                                    MDXExpression.append(currentExpression).append(", ").append(Expression);
                                    applySeparator = true;
                                    ++paren;
                                    ++sep;
                                }
                                for (i = 0; i < paren; ++i) {
                                    MDXExpression.append(")");
                                }
                                for (i = 0; i < sep; ++i) {
                                    MDXExpression.append("}");
                                }
                            } else {
                                MDXExpression.append(Expression);
                            }
                        } else {
                            MDXExpression.append(Expression);
                        }
                    }
                    currentExpression = StepManager.replaceQuote(MDXExpression.toString());
                    return currentExpression;
                }
            } else {
                String drillMemberName = ((DataItemNavigationFilter)step).getNavigationName();
                if (((DataItemNavigationFilter)step).getNavigationFilterType() == 4) {
                    this._drillMemberList.put(drillMemberName, null);
                } else {
                    this._drillMemberList.remove(drillMemberName);
                }
            }
            DataSelection bs = dataSelection;
            sortDirection = null;
            sortDirection = bs == null ? BusinessQueryActionType.SORT_NONE : bs.getSortDirection(this._role);
            if (step instanceof BusinessQueryRankFilter) {
                String businessQueryRankFilterMDX = BusinessQueryFilterRank.getMDXExpression(currentExpression, (BusinessQueryRankFilter)step);
                currentExpression = businessQueryRankFilterMDX != null ? (businessQueryRankFilterMDX = StepManager.replaceQuote(businessQueryRankFilterMDX)) : StepManager.replaceQuote(MDXExpression.toString());
            } else if (step instanceof BusinessQueryDataBasedFilter) {
                String businessBusinessQueryDataBasedFilterMDX;
                block129: {
                    businessBusinessQueryDataBasedFilterMDX = null;
                    try {
                        businessBusinessQueryDataBasedFilterMDX = BusinessQueryFilterDataBased.getMDXExpression(dataSelection, currentExpression, (BusinessQueryDataBasedFilter)step);
                    }
                    catch (GenerationException e) {
                        if (!_logger.isEnabled(Level.ERROR)) break block129;
                        Object[] msgArgs2 = new Object[]{dataItem.toString(), currentExpression, e.getLocalizedMessage(), IQDataServicesResourceBundle.getStringResource("StepManagerFilterGenE.txt")};
                        ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                        _logger.error(msF.toString());
                    }
                }
                currentExpression = businessBusinessQueryDataBasedFilterMDX != null ? (businessBusinessQueryDataBasedFilterMDX = StepManager.replaceQuote(businessBusinessQueryDataBasedFilterMDX)) : StepManager.replaceQuote(MDXExpression.toString());
            }
            try {
                if (!(step instanceof BusinessQueryDataBasedFilter) && !(step instanceof BusinessQueryRankFilter) || sortDirection == BusinessQueryActionType.SORT_NONE) break block130;
                List<DataItem> resultItems = dataSelection.getResultItems();
                for (DataItem resultItem : resultItems) {
                    DataItemActionType dataSortDir;
                    Role roleResultItem = dataSelection.getResultItemRole(resultItem);
                    if (!roleResultItem.equals(this._role) || (dataSortDir = resultItem.getSortDirection()) == DataItemActionType.SORT_NONE) continue;
                    this._isMultiSortWithQueryFilter = true;
                    break;
                }
            }
            catch (MetadataException ex) {
                if (!_logger.isEnabled(Level.ERROR)) break block130;
                _logger.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        if (!this._isMultiSortWithQueryFilter && sortDirection == BusinessQueryActionType.SORT_NONE && step instanceof BusinessQueryRankFilter) {
            StringBuffer overLay = new StringBuffer();
            overLay.append("ORDER(").append(currentExpression).append(",");
            String measure = "[MEASURES].CURRENTMEMBER";
            List listOfMeas = ((BusinessQueryRankFilter)step).getRankQualifiers();
            if (listOfMeas != null && listOfMeas.size() > 0) {
                try {
                    measure = StepManager.getRankQualifier(listOfMeas);
                }
                catch (GenerationException e) {
                    return currentExpression;
                }
            }
            overLay.append(measure).append(", BASC)");
            String bQFilterMDX = overLay.toString();
            currentExpression = StepManager.replaceQuote(bQFilterMDX);
        }
        MDXGenerationUtil.applyDebugStatement("MDX expression at end of step processing" + MDXExpression.toString(), this.getClass());
        return currentExpression;
    }

    private String completeStepMDX(String stepExpression, int actionType, StepFilterInterface step, String currentExpression) {
        StringBuffer MDXExpression = new StringBuffer();
        switch (actionType) {
            case 1: {
                MDXExpression.append(", ").append(stepExpression);
                break;
            }
            case 4: {
                MDXExpression.append("EXCEPT(").append(currentExpression).append(", ").append(stepExpression).append(")");
                break;
            }
            case 3: {
                MDXExpression.append(stepExpression);
                if (!_logger.isEnabled(Level.ERROR)) break;
                Object[] msgArgs2 = new Object[]{currentExpression, IQDataServicesResourceBundle.getStringResource("StepManagerInsertNotSupport.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                _logger.error(msF.toString());
                break;
            }
            case 5: {
                MDXExpression.append("INTERSECT(").append(currentExpression).append(", ").append(stepExpression).append(")");
                break;
            }
            case 7: {
                MDXExpression.append("UNION(").append(currentExpression).append(", ").append(stepExpression).append(")");
                break;
            }
            case 2: {
                MDXExpression.append(", ").append(currentExpression);
                break;
            }
            default: {
                MDXExpression.append(stepExpression);
            }
        }
        MDXGenerationUtil.applyDebugStatement("MDX expression at end of step processing as completed step: " + MDXExpression.toString(), this.getClass());
        return MDXExpression.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String buildCoreExpression(ExpressionInterface expression) throws GenerationException {
        StringBuffer coreExpression = new StringBuffer();
        if (expression instanceof Measure) {
            try {
                return ((Measure)expression).getUniqueName();
            }
            catch (MetadataException e) {
                Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("MDXGenerationMeasureLevelNameException.txt")};
                ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
                if (!_logger.isEnabled(Level.ERROR)) throw new GenerationException((MessageFormatter)msF, (Throwable)e);
                _logger.error(expression.toString());
                throw new GenerationException((MessageFormatter)msF, (Throwable)e);
            }
        }
        if (!(expression instanceof DataItem)) {
            Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("BusinessQueryDataBasedBadTypeForDataItem.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (!_logger.isEnabled(Level.ERROR)) throw new GenerationException(msF.toString());
            _logger.error(expression.toString());
            throw new GenerationException(msF.toString());
        }
        DataItem da = (DataItem)expression;
        String Exp = da.getLabel();
        expression = da.getExpression();
        StructureOfDataItem struct = da.getStructure();
        if (struct != StructureOfDataItem.STRUCTURE_MEASURE) {
            Object[] msgArgs2 = new Object[]{expression.toString(), struct.toString()};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(msF.toString());
            }
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("BusinessQueryDataBasedDataItemMustBeMeasure.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        if (expression instanceof Measure) {
            String measure = StepManager.getMeasureExpression((Measure)expression);
            coreExpression.append(measure);
            return StepManager.replaceQuote(coreExpression.toString());
        }
        if (!(expression instanceof ResourceAwareStringExpression) && !(expression instanceof StringExpression)) {
            Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("BusinessQueryDataBasedBadStringTypeForDataItem.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            if (!_logger.isEnabled(Level.ERROR)) throw new GenerationException(msF.toString());
            _logger.error(expression.toString());
            throw new GenerationException(msF.toString());
        }
        coreExpression.append("[Measures].[&1").append(Exp).append("]");
        return StepManager.replaceQuote(coreExpression.toString());
    }

    private static String getMeasureExpression(Measure measure) {
        String measureName = null;
        return measureName;
    }

    private static String getRankQualifier(List listOfMeas) throws GenerationException {
        if (listOfMeas.size() == 0) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("StepManagerRankQualifierIsEmpty.txt", new Object[0]);
            throw new GenerationException(mft);
        }
        try {
            Object obj = listOfMeas.get(0);
            if (obj instanceof StringExpression) {
                StringExpression s = (StringExpression)obj;
                return s.getText();
            }
            if (obj instanceof ExpressionInterface) {
                ExpressionInterface da = (ExpressionInterface)obj;
                return StepManager.buildCoreExpression(da);
            }
            return "";
        }
        catch (MetadataException e) {
            Object[] msgArgs2 = new Object[]{IQDataServicesResourceBundle.getStringResource("StepManagerBadMeasureExc.txt")};
            ArrayMessageFormatter msF = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, msgArgs2);
            throw new GenerationException((MessageFormatter)msF, (Throwable)e);
        }
    }
}

