/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.physical.Measure;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class RankFilter {
    private static final Logger _logger = LogManager.getLogger(RankFilter.class);

    public static String getMDXExpression(String currentExpression, DataItemRankFilter step) {
        String packageName = "com.sas.iquery.generation.step.olap";
        if (step.isIncludeTies() && step.getRankType() != 0) {
            if (_logger.isEnabled(Level.ERROR)) {
                String includeTiesError = IQDataServicesResourceBundle.getStringResource("RankFilterIncludeTiesError.txt");
                _logger.error(includeTiesError);
            }
            return currentExpression;
        }
        StringBuffer MDXExpression = new StringBuffer();
        block2 : switch (step.getRankOrder()) {
            case 0: {
                MDXExpression.append("Top");
                switch (step.getRankType()) {
                    case 0: {
                        MDXExpression.append("Count(");
                        break block2;
                    }
                    case 1: {
                        MDXExpression.append("Percent(");
                        break block2;
                    }
                    case 2: {
                        MDXExpression.append("Sum(");
                        break block2;
                    }
                }
                if (_logger.isEnabled(Level.ERROR)) {
                    String rankTypeError = IQDataServicesResourceBundle.getStringResource("RankFilterRankTypeError.txt");
                    _logger.error(rankTypeError);
                }
                return currentExpression;
            }
            case 1: {
                MDXExpression.append("Bottom");
                switch (step.getRankType()) {
                    case 0: {
                        MDXExpression.append("Count(");
                        break block2;
                    }
                    case 1: {
                        MDXExpression.append("Percent(");
                        break block2;
                    }
                    case 2: {
                        MDXExpression.append("Sum(");
                        break block2;
                    }
                }
                if (_logger.isEnabled(Level.ERROR)) {
                    String rankTypeError = IQDataServicesResourceBundle.getStringResource("RankFilterRankTypeError.txt");
                    _logger.error(rankTypeError);
                }
                return currentExpression;
            }
            default: {
                if (_logger.isEnabled(Level.ERROR)) {
                    String rankOrderError = IQDataServicesResourceBundle.getStringResource("RankFilterRankOrderError.txt");
                    _logger.error(rankOrderError);
                }
                return currentExpression;
            }
        }
        MDXExpression.append("{");
        MDXExpression.append(currentExpression);
        MDXExpression.append("}");
        MDXExpression.append(", ");
        String[] byRankNames = null;
        ArrayList<String> byNames = null;
        byRankNames = step.getbyRankNames();
        if (byRankNames == null) {
            List<ExpressionInterface> byRankQualifier = step.getRankQualifiers();
            if (byRankQualifier != null && byRankQualifier.size() > 0) {
                byNames = new ArrayList();
                for (int i = 0; i < byRankQualifier.size(); ++i) {
                    ExpressionInterface obj = byRankQualifier.get(i);
                    if (obj instanceof StringExpression) {
                        StringExpression s = (StringExpression)obj;
                        String ss = null;
                        try {
                            ss = s.getText();
                        }
                        catch (MetadataException metadataException) {
                            // empty catch block
                        }
                        if (ss == null) continue;
                        byNames.add(ss);
                        continue;
                    }
                    if (!(obj instanceof ExpressionInterface)) continue;
                    ExpressionInterface da = obj;
                    String daCore = null;
                    try {
                        daCore = RankFilter.buildCoreExpression(da);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (daCore == null) continue;
                    byNames.add(daCore);
                }
            }
        } else {
            byNames = new ArrayList<String>();
            for (int i = 0; i < byRankNames.length; ++i) {
                String rankName = byRankNames[i];
                byNames.add(rankName);
            }
        }
        MDXExpression.append(step.getValue());
        if (byNames == null) {
            if (step.isIncludeTies()) {
                MDXExpression.append(", TRUE");
            }
            MDXExpression.append(")");
            return MDXExpression.toString();
        }
        MDXExpression.append(", ");
        if (byNames.size() == 1) {
            MDXExpression.append(byNames.get(0));
        } else {
            StringBuffer RankNameBuf = new StringBuffer();
            int numOfRankNames = 0;
            for (int i = 0; i < byNames.size(); ++i) {
                String rankName = (String)byNames.get(i);
                if (rankName == null) {
                    i = byNames.size();
                    continue;
                }
                if (i > 0) {
                    RankNameBuf.append(", ");
                }
                RankNameBuf.append((String)byNames.get(i));
                ++numOfRankNames;
            }
            if (numOfRankNames > 1) {
                MDXExpression.append("(");
            }
            MDXExpression.append(RankNameBuf.toString());
            if (numOfRankNames > 1) {
                MDXExpression.append(")");
            }
        }
        if (step.isIncludeTies()) {
            MDXExpression.append(", TRUE");
        }
        MDXExpression.append(")");
        return MDXExpression.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildCoreExpression(ExpressionInterface expression) throws Exception {
        StringBuffer coreExpression = new StringBuffer();
        if (expression instanceof Measure) {
            String measure = RankFilter.getMeasureExpression((Measure)expression);
            coreExpression.append(measure);
            return coreExpression.toString();
        } else {
            if (!(expression instanceof DataItem)) throw new Exception(IQDataServicesResourceBundle.getStringResource("DataItemDataBasedBadTypeForDataItem.txt"));
            DataItem da = (DataItem)expression;
            expression = da.getExpression();
            StructureOfDataItem struct = da.getStructure();
            if (struct != StructureOfDataItem.STRUCTURE_MEASURE) {
                throw new Exception(IQDataServicesResourceBundle.getStringResource("DataItemDataBasedDataItemMustBeMeasure.txt"));
            }
            if (expression instanceof Measure) {
                String measure = RankFilter.getMeasureExpression((Measure)expression);
                coreExpression.append(measure);
                return coreExpression.toString();
            } else {
                if (!(expression instanceof ResourceAwareStringExpression) && !(expression instanceof StringExpression) && !(expression instanceof TimeExpressionMeasure)) throw new Exception(IQDataServicesResourceBundle.getStringResource("DataItemDataBasedBadStringTypeForDataItem.txt"));
                String Exp = da.getLabel();
                coreExpression.append("[Measures].[&1");
                coreExpression.append(Exp);
                coreExpression.append("]");
            }
        }
        return coreExpression.toString();
    }

    private static String getMeasureExpression(Measure measure) {
        StringBuffer buildExpression = new StringBuffer();
        String measureName = null;
        try {
            measureName = measure.getUniqueName();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationMeasureLevelNameException.txt"), (Throwable)e);
            }
            return null;
        }
        buildExpression.append(measureName);
        return buildExpression.toString();
    }
}

