/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap.step;

import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.olap.BusinessQueryRankFilter;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.TimeExpressionMeasure;
import com.sas.iquery.metadata.physical.Measure;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated
public class BusinessQueryFilterRank {
    private static final Logger _logger = LogManager.getLogger(BusinessQueryFilterRank.class);

    public static String getMDXExpression(String currentExpression, BusinessQueryRankFilter step) {
        String packageName = "com.sas.iquery.generation.step.olap";
        if (step.isIncludeTies() && !step.getRankType().equalsIgnoreCase("Count")) {
            if (_logger.isEnabled(Level.ERROR)) {
                String includeTiesError = IQDataServicesResourceBundle.getStringResource("RankFilterIncludeTiesError.txt");
                _logger.error(includeTiesError);
            }
            return currentExpression;
        }
        StringBuffer MDXExpression = new StringBuffer();
        if (step.getRankOrder().equals("Top")) {
            MDXExpression.append("Top");
        } else if (step.getRankOrder().equals("Bottom")) {
            MDXExpression.append("Bottom");
        } else {
            if (_logger.isEnabled(Level.ERROR)) {
                String rankOrderError = IQDataServicesResourceBundle.getStringResource("RankFilterRankOrderError.txt");
                _logger.error(rankOrderError);
            }
            return currentExpression;
        }
        if (step.getRankType().equals("Count")) {
            MDXExpression.append("Count(");
        } else if (step.getRankType().equals("Percent")) {
            MDXExpression.append("Percent(");
        } else if (step.getRankType().equals("Sum")) {
            MDXExpression.append("Sum(");
        } else {
            if (_logger.isEnabled(Level.ERROR)) {
                String rankTypeError = IQDataServicesResourceBundle.getStringResource("RankFilterRankTypeError.txt");
                _logger.error(rankTypeError);
            }
            return currentExpression;
        }
        MDXExpression.append("{");
        MDXExpression.append(currentExpression);
        MDXExpression.append("}");
        MDXExpression.append(", ");
        ArrayList<String> byNames = null;
        List byRankQualifier = step.getRankQualifiers();
        if (byRankQualifier != null) {
            byNames = new ArrayList<String>();
            for (int i = 0; i < byRankQualifier.size(); ++i) {
                Object obj = byRankQualifier.get(i);
                if (obj instanceof StringExpression) {
                    StringExpression s = (StringExpression)obj;
                    String ss = null;
                    try {
                        ss = s.getText();
                    }
                    catch (MetadataException metadataException) {
                        // empty catch block
                    }
                    if (ss == null) continue;
                    byNames.add(ss);
                    continue;
                }
                if (!(obj instanceof ExpressionInterface)) continue;
                ExpressionInterface da = (ExpressionInterface)obj;
                String daCore = null;
                try {
                    daCore = BusinessQueryFilterRank.buildCoreExpression(da);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (daCore == null) continue;
                byNames.add(daCore);
            }
        }
        MDXExpression.append(step.getValue());
        if (byNames == null) {
            if (step.isIncludeTies()) {
                MDXExpression.append(", TRUE");
            }
            MDXExpression.append(")");
            return MDXExpression.toString();
        }
        if (byNames.size() == 1) {
            String itemByNames = byNames.get(0).toString();
            if (itemByNames != null) {
                MDXExpression.append(", ");
                MDXExpression.append(itemByNames);
            }
        } else {
            StringBuffer RankNameBuf = new StringBuffer();
            int numOfRankNames = 0;
            for (int i = 0; i < byNames.size(); ++i) {
                String rankName;
                if (i == 0) {
                    MDXExpression.append(", ");
                }
                if ((rankName = (String)byNames.get(i)) == null) {
                    i = byNames.size();
                    continue;
                }
                if (i > 0) {
                    RankNameBuf.append(", ");
                }
                RankNameBuf.append((String)byNames.get(i));
                ++numOfRankNames;
            }
            if (numOfRankNames > 1) {
                MDXExpression.append("(");
            }
            MDXExpression.append(RankNameBuf.toString());
            if (numOfRankNames > 1) {
                MDXExpression.append(")");
            }
        }
        if (step.isIncludeTies()) {
            MDXExpression.append(", TRUE");
        }
        MDXExpression.append(")");
        return MDXExpression.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String buildCoreExpression(ExpressionInterface expression) throws Exception {
        StringBuffer coreExpression = new StringBuffer();
        if (expression instanceof Measure) {
            String measure = BusinessQueryFilterRank.getMeasureExpression((Measure)expression);
            coreExpression.append(measure);
            return coreExpression.toString();
        } else {
            if (!(expression instanceof DataItem)) throw new Exception(IQDataServicesResourceBundle.getStringResource("BusinessQueryDataBasedBadTypeForDataItem.txt"));
            DataItem da = (DataItem)expression;
            expression = da.getExpression();
            StructureOfDataItem struct = da.getStructure();
            if (struct != StructureOfDataItem.STRUCTURE_MEASURE) {
                throw new Exception(IQDataServicesResourceBundle.getStringResource("BusinessQueryDataBasedDataItemMustBeMeasure.txt"));
            }
            if (expression instanceof Measure) {
                String measure = BusinessQueryFilterRank.getMeasureExpression((Measure)expression);
                coreExpression.append(measure);
                return coreExpression.toString();
            } else {
                if (!(expression instanceof ResourceAwareStringExpression) && !(expression instanceof StringExpression) && !(expression instanceof TimeExpressionMeasure)) throw new Exception(IQDataServicesResourceBundle.getStringResource("BusinessQueryDataBasedBadStringTypeForDataItem.txt"));
                String Exp = da.getLabel();
                coreExpression.append("[Measures].[&1");
                coreExpression.append(Exp);
                coreExpression.append("]");
            }
        }
        return coreExpression.toString();
    }

    private static String getMeasureExpression(Measure measure) {
        StringBuffer buildExpression = new StringBuffer();
        String measureName = null;
        try {
            measureName = measure.getUniqueName();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(IQDataServicesResourceBundle.getStringResource("MDXGenerationMeasureLevelNameException.txt"), (Throwable)e);
            }
            return null;
        }
        buildExpression.append(measureName);
        return buildExpression.toString();
    }
}

