/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma.olap;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesIllegalArgumentException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.StoredProcessHandler;
import com.sas.iquery.dataretrieval.StrategyInterface;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ConnectionRecycler;
import com.sas.iquery.execution.ConnectionUtil;
import com.sas.iquery.execution.OLAPConnectionResource;
import com.sas.iquery.execution.instructions.ExecutionBlock;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution.instructions.MDXInstruction;
import com.sas.iquery.execution.instructions.StoredProcessInstruction;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.IQMetadataResourceBundle;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceCube;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Reason;
import com.sas.iquery.metadata.business.impl.ExtraLoggingContexts;
import com.sas.iquery.metadata.business.impl.InformationMapImpl2;
import com.sas.iquery.metadata.physical.SoftwareServer;
import com.sas.iquery.strategies.sas.oma.AbstractStrategy;
import com.sas.iquery.strategies.sas.oma.olap.util.IQMetadataInterface;
import com.sas.iquery.strategies.sas.oma.olap.util.MDXGenerationUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPValues;
import com.sas.iquery.strategies.sas.oma.olapv2.MDXGeneration;
import com.sas.iquery.strategies.sas.oma.olapv2.PreFilterDLLGeneration;
import com.sas.iquery.util.IOMServerUtils;
import com.sas.iquery.util.LocaleUtilities;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.iquery.util.impl.OLAPUtilities;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OLAPStrategy
extends AbstractStrategy
implements StrategyInterface {
    private static final String ERROR_MODEL_IS_NULL = "OLAPConnectionInfoUtilNoModel.txt";
    private static final String ERROR_DS_INVALID_SEE_REASONS_ABOVE = "SQLGeneration.checkValid.invalid.txt";
    private static final String ERROR_MAP_NO_READ_AUTHORITY = "InformationMapImpl2.ErrorMissingReadFlag.fmt.txt";
    private static final String ERROR_BAD_IMETA_NOT_RELEASED = "BusinessqueryOLAPBadIQMetdataInterface.txt";
    private Map<String, String> _labelNameMap = new LinkedHashMap<String, String>();
    private static final Logger _logger = LogManager.getLogger(OLAPStrategy.class);
    private static final Logger _sessionLogger = LogManager.getLogger((String)"com.sas.services.session.SessionService");
    private static final Logger _perfCLogger = LogManager.getLogger((String)"com.sas.iquery.perf.Connections");

    private InformationMap getInformationMap(BusinessModel businessModel) {
        InformationMap informationMap = null;
        BusinessModel model = businessModel;
        while (model != null && informationMap == null) {
            if (model instanceof InformationMap) {
                informationMap = (InformationMap)model;
                continue;
            }
            model = model.getParentBusinessModel();
        }
        return informationMap;
    }

    public Map<String, String> getLabelNameMap() {
        return this._labelNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionInstructionInterface createInstructions(DataSelection dataSelection, EntityInterface entity) throws GenerationException {
        ExecutionBlock block;
        block63: {
            Double versionInt;
            List<Reason> reasons;
            Locale connectionLocale;
            block = new ExecutionBlock();
            if (dataSelection == null) {
                throw new IQueryServicesIllegalArgumentException(IQDataServicesResourceBundle.getStringResource(ERROR_MODEL_IS_NULL));
            }
            BusinessModel businessModel = dataSelection.getBusinessModel();
            Locale tempLocale = connectionLocale = LocaleUtilities.getDefaultViewerLocale(dataSelection);
            Locale newLocale = this.getComputationalLocale();
            if (dataSelection != null) {
                try {
                    DataSourceCube dataCube = OLAPConnectionInfoUtil.getCube(dataSelection);
                    tempLocale = IOMServerUtils.negotiateStoredCubeLocale(dataCube, newLocale, dataSelection.getComputationalLocale());
                    if (tempLocale != null) {
                        connectionLocale = tempLocale;
                    }
                }
                catch (GenerationException e) {
                    _logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (!(reasons = dataSelection.getReasonsNotValid()).isEmpty()) {
                if (_logger.isEnabled(Level.ERROR)) {
                    for (Reason reason : reasons) {
                        String reasonMessage = reason.getReasonString(connectionLocale);
                        _logger.error(reasonMessage);
                    }
                }
                MessageFormatter baseMessage1 = IQDataServicesResourceBundle.getMessageFormatter(ERROR_DS_INVALID_SEE_REASONS_ABOVE, new Object[0]);
                MessageFormatter reasonListFormatter1 = Reason.getMessageFormatter(baseMessage1, reasons, false);
                GenerationException e6 = new GenerationException(reasonListFormatter1, reasons);
                throw e6;
            }
            InformationMap map = this.getInformationMap(dataSelection);
            if (map != null) {
                ArrayList permConds = new ArrayList();
                boolean canAccess = true;
                map.setComputationalLocale(newLocale);
                if (map instanceof InformationMapImpl2) {
                    try {
                        canAccess = ((InformationMapImpl2)map).getOmrPermissionForUser(null, null, permConds);
                        if (canAccess && permConds.size() > 0) {
                            canAccess = false;
                        }
                    }
                    catch (MetadataException e5) {
                        throw MDXGenerationUtil.newGenerationException(null, dataSelection, e5);
                    }
                }
                if (!canAccess) {
                    SessionContextInterface sessionI = dataSelection.getSession();
                    Object absolutePath = "";
                    String mapName = map.getLabel();
                    try {
                        BriefInformationMap mBr = map.getBriefMap();
                        if (mBr != null) {
                            mapName = mBr.getName();
                            absolutePath = mBr.getPathUrl().getAbsolutePath();
                        }
                    }
                    catch (Throwable e3) {
                        if (_logger.isEnabled(Level.WARN)) {
                            if (_sessionLogger.isEnabled(Level.WARN)) {
                                _sessionLogger.warn(e3.toString(), e3);
                            } else {
                                _logger.warn(e3.toString(), e3);
                            }
                        }
                        absolutePath = e3;
                    }
                    Object userName = "";
                    try {
                        UserContextInterface userI = sessionI.getUserContext();
                        userName = userI.getName();
                    }
                    catch (Throwable e4) {
                        if (_logger.isEnabled(Level.WARN)) {
                            if (_sessionLogger.isEnabled(Level.WARN)) {
                                _sessionLogger.warn(e4.toString(), e4);
                            } else {
                                _logger.warn(e4.toString(), e4);
                            }
                        }
                        userName = e4;
                    }
                    Object[] logMsgArgs = new Object[]{userName, mapName, absolutePath};
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter(ERROR_MAP_NO_READ_AUTHORITY, logMsgArgs);
                    if (_logger.isEnabled(Level.ERROR)) {
                        if (_sessionLogger.isEnabled(Level.ERROR)) {
                            _sessionLogger.error((Object)mft);
                        } else {
                            _logger.error((Object)mft);
                        }
                    }
                    throw new GenerationException(mft);
                }
            }
            RetrievalPolicy userSessionPolicy = new RetrievalPolicy();
            userSessionPolicy.getConnectionConfiguration().setConnectionLifetime(1);
            String constructor = "GENERATION";
            SessionContextInterface sessionContext = dataSelection.getSession();
            OLAPConnectionResource olapConnection = null;
            String cubeName = null;
            LogicalServerInterface logicalServer = null;
            DataSourceCube dataCube = null;
            try {
                if (!dataSelection.getStructure().isOLAP()) {
                    MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("MetadataProviderNoValidModel.txt", new Object[0]);
                    ConnectionUtil.LoggerErrorWithObjects(_logger, mft, dataSelection);
                    throw new GenerationException(mft);
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Connection locale for the OLAP server: " + connectionLocale);
                }
                dataCube = OLAPUtilities.findDataSourceCube(dataSelection);
                cubeName = OLAPUtilities.findCubeName(dataCube);
                SoftwareServer softwareServer = OLAPUtilities.findSoftwareServer(dataCube);
                logicalServer = OLAPUtilities.findLogicalServerInterface(softwareServer);
                ConnectionRecycler recycler = ConnectionUtil.getConnectionRecycler(sessionContext);
                UserContextInterface userContext = ConnectionUtil.getUserContext(sessionContext);
                ConnectionInterface connection = ConnectionUtil.findConnection(recycler, dataSelection, logicalServer, userContext, userSessionPolicy, connectionLocale);
                ConnectionUtil.LoggerDebugConnectionObtained(_logger, OLAPConnectionInfoUtil.class, connection);
                ConnectionInterface pfsConnection = ConnectionUtil.findPfsConnection(connection);
                olapConnection = OLAPUtilities.findOlapConnectionResource(pfsConnection);
            }
            catch (ExecutionException e) {
                throw MDXGenerationUtil.newGenerationException(null, dataSelection, e);
            }
            catch (MetadataException e) {
                throw MDXGenerationUtil.newGenerationException(null, dataSelection, e);
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("OLAP Connection = " + olapConnection);
            }
            long start = 0L;
            if (_perfCLogger.isDebugEnabled()) {
                ExtraLoggingContexts.debugLogConnectionPerformance("> Manage the list of ISessions ");
                start = System.currentTimeMillis();
            }
            try {
                olapConnection.closeUnusedConnectionObjects(cubeName);
            }
            catch (ExecutionException e) {
                throw MDXGenerationUtil.newGenerationException(null, dataSelection, e);
            }
            if (_perfCLogger.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
            }
            if (_logger.isDebugEnabled()) {
                _logger.debug("OLAP Connection (after close unused) = " + olapConnection);
            }
            if ((versionInt = MDXGenerationUtil.getMDXVersion(dataSelection, cubeName, olapConnection)) >= 9.02) {
                String uID = this._generateUniqueID();
                StoredProcessHandler storedProcessHandler = new StoredProcessHandler(dataSelection);
                if (storedProcessHandler.hasStoredProcess()) {
                    StoredProcessInstruction storedProcessInstruction = new StoredProcessInstruction(storedProcessHandler);
                    block.addInstruction(storedProcessInstruction);
                }
                String prefilterComments = "";
                IQMetadataInterface metaInterface = null;
                PreFilterDLLGeneration prefilter = null;
                List<DataItem> resultItems = dataSelection.getResultItems();
                start = 0L;
                if (_perfCLogger.isDebugEnabled()) {
                    ExtraLoggingContexts.debugLogConnectionPerformance("> Create Metadata Interface for Generation portion.");
                    start = System.currentTimeMillis();
                }
                try {
                    metaInterface = olapConnection.createMetadataInterface(dataSelection, constructor, dataCube, true, true, null);
                }
                catch (ExecutionException e) {
                    _logger.error(e.getLocalizedMessage() + ":" + cubeName);
                    throw MDXGenerationUtil.newGenerationException(null, dataSelection, e);
                }
                if (_perfCLogger.isDebugEnabled()) {
                    long end = System.currentTimeMillis();
                    ExtraLoggingContexts.debugLogConnectionPerformance("< done (" + (end - start) + "ms)");
                }
                OLAPValues olapValues = null;
                try {
                    olapValues = new OLAPValues(metaInterface, resultItems, dataSelection);
                    try {
                        MDXGeneration generatorMDX;
                        ExecutionInstructionInterface mdxInst;
                        String cacheKey = MDXGenerationUtil.buildCacheKey(dataSelection, connectionLocale, "GENERATION");
                        if (olapConnection.isFilterToBeApplied(cacheKey)) {
                            try {
                                olapConnection.applyFilterStateOnCube(dataSelection, cacheKey, olapValues);
                            }
                            catch (ExecutionException e) {
                                if (_logger.isEnabled(Level.ERROR)) {
                                    _logger.error(e.getLocalizedMessage() + cubeName);
                                }
                                throw MDXGenerationUtil.newGenerationException(null, dataSelection, e);
                            }
                        }
                        if ((prefilter = olapConnection.getFullParentFilterObjectForBusinessModel(businessModel, cacheKey)) != null) {
                            prefilterComments = prefilter.getPreFilterClause();
                            List prompts = prefilter.getPromptList();
                            Iterator ipromp = prompts.iterator();
                            OLAPValues olapValuPre = prefilter.getOLAPValues();
                            while (ipromp.hasNext()) {
                                String dataItemPrompt = (String)ipromp.next();
                                String rootDataItemPrompt = olapValuPre.getPromptMemberLevelRoot(dataItemPrompt);
                                olapValues.setPromptMemberLevelRoot(dataItemPrompt, rootDataItemPrompt);
                            }
                        }
                        if ((mdxInst = (generatorMDX = this.newMDXGenerator(olapConnection, cubeName, logicalServer, prefilterComments, metaInterface, prefilter, olapValues)).generateInstructions(dataSelection, uID)) instanceof MDXInstruction) {
                            MDXInstruction mdxInstr = (MDXInstruction)mdxInst;
                            this._labelNameMap = mdxInstr.getLabelNameMap();
                        }
                        block.addInstruction(mdxInst);
                        break block63;
                    }
                    finally {
                        if (prefilter == null) {
                            olapValues.release();
                        }
                    }
                }
                finally {
                    if (metaInterface instanceof IQMetadataInterface) {
                        IQMetadataInterface iqMetadataInterface = metaInterface;
                        OLAPConnectionResource olapConnection1 = iqMetadataInterface.getRelatedConnection();
                        if (olapConnection1 != null) {
                            olapConnection1.releaseMetadataInterfaceFromISession(iqMetadataInterface);
                        }
                    } else if (_logger.isEnabled(Level.WARN)) {
                        String msg = IQMetadataResourceBundle.getStringResource(ERROR_BAD_IMETA_NOT_RELEASED);
                        _logger.warn(msg);
                    }
                }
            }
            com.sas.iquery.strategies.sas.oma.olap.MDXGeneration generator = new com.sas.iquery.strategies.sas.oma.olap.MDXGeneration();
            String uID = this._generateUniqueID();
            ExecutionInstructionInterface mdxInst = generator.generateInstructions(dataSelection, uID);
            block.addInstruction(mdxInst);
        }
        MDXGenerationUtil.applyDebugStatement("Instruction block: " + block.toString(), this.getClass());
        return block;
    }

    private MDXGeneration newMDXGenerator(OLAPConnectionResource olapConnection, String cubeName, LogicalServerInterface logicalServer, String prefilterComments, IQMetadataInterface metaInterface, PreFilterDLLGeneration prefilter, OLAPValues olapValues) {
        MDXGeneration generatorMDX = new MDXGeneration();
        generatorMDX.setComputationalLocale(this.getComputationalLocale());
        generatorMDX.setStpNames(this.getStpNames());
        generatorMDX.setMLSLookups(this.getMLSLookups());
        generatorMDX.setLogicalServer(logicalServer);
        generatorMDX.setMetadataInterface(metaInterface);
        generatorMDX.setCubeName(cubeName);
        generatorMDX.setOLAPValues(olapValues);
        generatorMDX.setOLAPConnection(olapConnection);
        if (prefilterComments.length() > 0) {
            StringBuilder prefilterBuilderClause = new StringBuilder();
            prefilterBuilderClause.append("/*").append(MDXGenerationUtil.NEWLINE).append(prefilter.getFilterMDXText()).append(MDXGenerationUtil.NEWLINE).append("*/");
            generatorMDX.setPrefilterString(prefilterBuilderClause.toString());
        }
        return generatorMDX;
    }

    @Override
    public String getResultSetStructure(BusinessQuery businessQuery, RetrievalPolicy retrievalPolicy) throws IntelligentQueryException {
        return "MultiDimensional";
    }
}

