/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma;

import com.sas.iquery.execution.OverrideLocaleInterface;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.MetadataUnresolvedException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryProperty;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSourceTable;
import com.sas.iquery.metadata.business.QualifiedColumn;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.business.impl.DataItemImpl;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.iqtextparser.AggregateDefinition;
import com.sas.iquery.metadata.expr.iqtextparser.ParseError;
import com.sas.iquery.metadata.expr.iqtextparser.ParsedNode;
import com.sas.iquery.metadata.expr.iqtextparser.ParserUtil;
import com.sas.iquery.metadata.expr.iqtextparser.TokenError;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.physical.AccessPath;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.physical.OlapItem;
import com.sas.iquery.metadata.physical.SASLibrary;
import com.sas.iquery.metadata.physical.Schema;
import com.sas.iquery.metadata.serverprop.Category;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.iquery.metadata.serverprop.formats.SASFormatAttributes;
import com.sas.iquery.metadata.serverprop.formats.SASFormatCategory;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescription;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionUtil;
import com.sas.iquery.metadata.serverprop.formats.SASFormatException;
import com.sas.iquery.strategies.sas.oma.FractionOfTotalUtilImpl;
import com.sas.iquery.strategies.sas.oma.relational.DataSelectionProcessorAbstract;
import com.sas.iquery.util.LocaleUtilities;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GenerationUtil {
    private static final Logger _logger = LogManager.getLogger(GenerationUtil.class);
    private static final List<String> _SAS_PREDEFINED_IDENTIFIERS = Arrays.asList("_N_", "_ERROR_", "_CHARACTER_", "_NUMERIC_", "_ALL_", "_NULL_", "_DATA_", "_LAST_");
    private static final List<String> _SDPS_SQL_RESERVED_WORDS = Arrays.asList("all", "alter", "and", "any", "append", "as", "asc", "ascending", "ascformatted", "async", "begin", "between", "both", "by", "calculated", "cascade", "case", "char", "character", "class", "clear", "column", "connect", "connection", "contains", "contents", "copy", "corr", "corresponding", "create", "cross", "data", "date", "dec", "decimal", "default", "delete", "desc", "descending", "describe", "desformatted", "dictionary", "dimension", "disconnect", "display", "distinct", "double", "drop", "dsorder", "else", "end", "engname", "engopt", "eq", "except", "execute", "exists", "false", "fileopts", "fileref", "float", "for", "format", "from", "full", "ge", "grant", "group", "gt", "having", "in", "index", "indexes", "informat", "inner", "input", "insert", "int", "integer", "intersect", "into", "is", "join", "label", "le", "leading", "left", "lib", "libref", "like", "load", "lower", "lt", "match", "mddb", "missing", "modify", "natural", "ne", "no", "not", "notin", "null", "num", "numeric", "on", "operation", "option", "or", "order", "outer", "output", "overlaps", "partial", "pgm", "precision", "privileges", "public", "real", "redirect", "references", "reset", "restrict", "revoke", "right", "select", "set", "smallint", "some", "table", "then", "to", "trailing", "trim", "true", "union", "unique", "unknown", "update", "upper", "using", "validate", "values", "var", "varchar", "verbose", "view", "weight", "when", "where", "with", "without", "yes");
    private static final List<String> _TSSQL_SQL_RESERVED_WORDS = Arrays.asList("ABORT", "ABSOLUTE", "ACCESS", "ACTION", "ADD", "AFTER", "AGGREGATE", "ALL", "ALLOCATE", "ALTER", "ANALYSE", "ANALYZE", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASENSITIVE", "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", "ATOMIC", "AUTORIZATION", "BACKWARD", "BEFORE", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BLOB", "BOOLEAN", "BOTH", "BY", "CACHE", "CALL", "CALLED", "CARDINALITY", "CASCADE", "CASCADED", "CASE", "CAST", "CHAIN", "CHAR", "CHAR_LENGTH", "CHARACTER", "CHARACTER_LENGTH", "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOB", "CLOSE", "CLUSTER", "COALESCE", "COLLATE", "COLLECT", "COLUMN", "COMMENT", "COMMIT", "COMMITTED", "CONDITION", "CONNECT", "CONSTRAINT", "CONSTRAINTS", "CONVERSION", "CONVERT", "COPY", "CORR", "CORRESPONDING", "COVAR_POP", "COVAR_SAMP", "CREATE", "CREATEDB", "CREATEUSER", "CROSS", "CUBE", "CUME_DIST", "CURRENT", "CURRENT_DATE", "CURRENT_DEFAULT_TRANSFORM_GROUP", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSFORM_GROUP_FOR_TYPE", "CURRENT_USER", "CURSOR", "CYCLE", "DATABASE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFAULTS", "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE", "DELIMITER", "DELIMITERS", "DENSE_RANK", "DEREF", "DESC", "DESCRIBE", "DETERMINISTIC", "DISCONNECT", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELEMENT", "ELSE", "ENCODING", "ENCRYPTED", "END", "END-EXEC", "ESCAPE", "EVERY", "EXCEPT", "EXCLUDING", "EXCLUSIVE", "EXEC", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE", "FETCH", "FILTER", "FIRST", "FLOAT", "FOR", "FORCE", "FOREIGN", "FORWARD", "FREE", "FREEZE", "FROM", "FULL", "FUNCTION", "FUSION", "GET", "GLOBAL", "GRANT", "GROUP", "GROUPING", "HANDLER", "HAVING", "HOLD", "ILIKE", "IMMEDIATE", "IMMUTABLE", "IMPLICIT", "IN", "INCLUDING", "INCREMENT", "INDEX", "INDICATOR", "INHERITS", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INSTEAD", "INT", "INTEGER", "INTERSECT", "INTERSECTION", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", "ISOLATION", "JOIN", "KEY", "LANCOMPILER", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEFT", "LEVEL", "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATION", "LOCK", "MATCH", "MAXVALUE", "MEMBER", "MERGE", "METHOD", "MINUTE", "MINVALUE", "MODE", "MODIFIES", "MODULE", "MONTH", "MOVE", "MULTISET", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NOCREATEDB", "NOCREATEUSER", "NONE", "NORMALIZE", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NULL", "NULLIF", "NUMERIC", "OF", "OFF", "OFFSET", "OIDS", "OLD", "ON", "ONLY", "OPEN", "OPERATOR", "OPTION", "OR", "ORDER", "OUT", "OUTER", "OVER", "OVERLAPS", "OVERLAY", "OWNER", "PARAMETER", "PARTIAL", "PARTITION", "PASSWORD", "PATH", "PENDANT", "PERCENT_RANK", "PERCENTILE_CONT", "PERCENTILE_DESC", "PLACING", "POLITION", "PRECISION", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", "RANK", "READ", "READS", "REAL", "RECHECK", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "REGR_AVGX", "REGR_AVGY", "REGR_COUNT", "REGR_INTERCEPT", "REGR_R2", "REGR_SLOPE", "REGR_SXX", "REGR_SXY", "REGR_SYY", "REINDEX", "RELATIVE", "RENAME", "REPLACE", "RESET", "RESTART", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "ROW", "ROWS", "ROW_NUMBER", "RULE", "SCHEMA", "SCOPE", "SCROLL", "SEARCH", "SECOND", "SECURITY", "SELECT", "SENSITIVE", "SPECIFIC", "SPECIFICTYPE", "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", "SIMPLE", "SMALLINT", "SOME", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "STABLE", "START", "STATEMENT", "STATIC", "STATISTICS", "STDDEV_POP", "STDDEV_SAMP", "STDIN", "STDOUT", "STORAGE", "STRICT", "SUBMULTISET", "SUBSTRING", "SYMMETRIC", "SYSID", "SYSTEM", "SYSTEM_USER", "TABLE", "TABLESAMPLE", "TEMP", "TEMPLATE", "TEMPORARY", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TOAST", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "TRUNCATE", "TRUSTED", "TYPE", "UESCAPE", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", "UNLISTEN", "UNNEST", "UNTIL", "UPDATE", "USAGE", "USER", "USING", "VACUUM", "VALID", "VALIDATOR", "VALUE", "VALUES", "VARCHAR", "VARYING", "VAR_POP", "VAR_SAMP", "VERBOSE", "VERSION", "VIEW", "VOLATILE", "WHEN", "WHENEVER", "WHERE", "WIDTH_BUCKET", "WINDOW", "WITH", "WITHIN", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE");
    private static final String OLAP_INVALID_ID_CHARS = "'\"";
    public static final int LANG_ID_UNSPECIFIED = 0;
    public static final int LANG_ID_SAS_SQL_PROC = 1;
    public static final int LANG_ID_SAS_SQL_SPDS = 2;
    public static final int LANG_ID_SAS_MDX = 3;
    public static final int LANG_ID_SAS_TSSQL = 4;
    private static final List<String> RESERVED_LIBREFS = Arrays.asList("SPDTEMP");
    private static final List<String> invalidTSSQLAggregateFunctions = Arrays.asList("NMISS", "FREQ", "N", "CSS", "CV", "PRT", "RANGE", "STD", "STDERR", "SUMWGT", "T", "USS", "VAR");
    private static final List<String> invalidTSSQLFunctions = Arrays.asList("Time", "Contains", "NotContains", "LikeEscape", "NotLikeEscape", "IsMissing", "IsNotMissing", "Eqt", "Net", "Ltt", "Let", "Gtt", "Get", "DHMS", "DATEPART");
    private static final List<FunctionNameID> invalidTSSQLAggregateFunctionNameIDs = Collections.unmodifiableList(Arrays.asList(FunctionNameID.FREQ, FunctionNameID.FREQ_DISTINCT, FunctionNameID.N, FunctionNameID.N_DISTINCT, FunctionNameID.NMISS, FunctionNameID.NMISS_DISTINCT, FunctionNameID.COUNT_PLUS_NMISS, FunctionNameID.COUNT_PLUS_NMISS_DISTINCT, FunctionNameID.CV, FunctionNameID.CV_DISTINCT, FunctionNameID.CSS, FunctionNameID.CSS_DISTINCT, FunctionNameID.PRT, FunctionNameID.PRT_DISTINCT, FunctionNameID.RANGE, FunctionNameID.RANGE_DISTINCT, FunctionNameID.STD, FunctionNameID.STDERR_DISTINCT, FunctionNameID.STDERR, FunctionNameID.T, FunctionNameID.T_DISTINCT, FunctionNameID.USS, FunctionNameID.USS_DISTINCT, FunctionNameID.VAR, FunctionNameID.VAR_DISTINCT));
    private static final int NOT_CHARACTER = -1;

    public static String generateFormat(DataItem dataItem) throws GenerationException {
        return GenerationUtil.generateFormat(dataItem, true);
    }

    public static String generateFormat(DataItem dataItem, boolean lookupDefaultFormat) {
        String format = dataItem.getFormat();
        if (GenerationUtil.hasAFormatString(format)) {
            boolean isFormatCompatible = GenerationUtil.isFormatCompatibleWithType(dataItem);
            if (!isFormatCompatible) {
                format = "";
            }
        } else if (lookupDefaultFormat) {
            format = IQModelImplUtilities.generateDefaultFormat(dataItem);
        }
        return format;
    }

    public static String generateFormatEqStatement(DataItem dataItem) {
        StringBuffer code = new StringBuffer();
        String format = GenerationUtil.generateFormat(dataItem, false);
        if (GenerationUtil.hasAFormatString(format)) {
            code.append(" format=");
            code.append(format);
        }
        return code.toString();
    }

    public static String generateLabelEqStatement(DataItem dataItem) {
        StringBuffer code = new StringBuffer();
        String label = dataItem.getLabel();
        if (label == null) {
            label = "";
        }
        code.append(" label=");
        code.append(GenerationUtil.generateQuotedLiteral(label));
        return code.toString();
    }

    public static String generateQuotedLiteral(String s) {
        StringBuffer result = new StringBuffer();
        result.append("'");
        s = s.replaceAll("'", "''");
        s = GenerationUtil.hexifySpecialChars(s);
        result.append(s);
        result.append("'");
        return result.toString();
    }

    private static String hexifySpecialChars(String s) {
        Pattern p1 = Pattern.compile("\b");
        Matcher m1 = p1.matcher(s);
        s = m1.replaceAll("' || '08'x || '");
        Pattern p2 = Pattern.compile("\t");
        Matcher m2 = p2.matcher(s);
        s = m2.replaceAll("' || '09'x || '");
        Pattern p3 = Pattern.compile("\n");
        Matcher m3 = p3.matcher(s);
        s = m3.replaceAll("' || '0A'x || '");
        Pattern p4 = Pattern.compile("\f");
        Matcher m4 = p4.matcher(s);
        s = m4.replaceAll("' || '0C'x || '");
        Pattern p5 = Pattern.compile("\r");
        Matcher m5 = p5.matcher(s);
        s = m5.replaceAll("' || '0D'x || '");
        return s;
    }

    public static String generatePut(DataSelectionProcessorAbstract dsp, String text, String format) throws GenerationException {
        boolean disablePutQ = Boolean.getBoolean("SASQueryServices.sasDisablePutQ");
        boolean usePutQ = !disablePutQ;
        boolean isTssql = dsp.isTSSQL();
        boolean isSPDS = dsp.isSPDS() || dsp.isUseConnectionTo();
        usePutQ = isTssql || isSPDS ? false : usePutQ;
        ServerProperties properties = null;
        try {
            properties = dsp.getDataSelection().getServerProperties();
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        return GenerationUtil.generatePut(properties, text, format, usePutQ, isTssql);
    }

    public static String generatePut(BusinessModel model, String s, String format) throws GenerationException {
        ServerProperties properties = null;
        try {
            properties = model.getServerProperties();
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        boolean disablePutQ = Boolean.getBoolean("SASQueryServices.sasDisablePutQ");
        return GenerationUtil.generatePut(properties, s, format, !disablePutQ, false);
    }

    public static String generatePut(DataSelectionProcessorAbstract dsProcessor, BusinessModel model, String s, String format) throws GenerationException {
        ServerProperties properties = null;
        try {
            properties = model.getServerProperties();
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        String putSql = dsProcessor != null && (dsProcessor.isSPDS() || dsProcessor.isUseConnectionTo() || dsProcessor.isTSSQL()) ? GenerationUtil.generatePut(properties, s, format, false, dsProcessor.isTSSQL()) : GenerationUtil.generatePut(properties, s, format);
        return putSql;
    }

    public static String generatePut(DataSelectionProcessorAbstract dsProcessor, ServerProperties properties, String s, String format) throws GenerationException {
        String putSql = dsProcessor != null && (dsProcessor.isSPDS() || dsProcessor.isUseConnectionTo() || dsProcessor.isTSSQL()) ? GenerationUtil.generatePut(properties, s, format, false, dsProcessor.isTSSQL()) : GenerationUtil.generatePut(properties, s, format);
        return putSql;
    }

    public static String generateDataStepPut(String s, String format) {
        boolean disablePutQ = Boolean.getBoolean("SASQueryServices.sasDisablePutQ");
        return GenerationUtil.generatePut(null, s, format, !disablePutQ, false);
    }

    public static String generatePut(ServerProperties properties, String s, String format) {
        boolean disablePutQ = Boolean.getBoolean("SASQueryServices.sasDisablePutQ");
        return GenerationUtil.generatePut(properties, s, format, !disablePutQ, false);
    }

    public static String generatePut(ServerProperties properties, String s, String format, boolean usePutQ, boolean forceCast) {
        Function function;
        String result = s;
        Function function2 = properties == null ? null : (function = usePutQ ? properties.getFunctionByNameID(FunctionNameID.PUT_Q) : properties.getFunctionByNameID(FunctionNameID.PUT));
        if (function != null) {
            Object[] insertText = new Object[]{s, format};
            String syntaxTemplate = function.getSyntaxTemplateFor(2);
            result = MessageFormat.format(syntaxTemplate, insertText);
        } else {
            StringBuffer wingIt = new StringBuffer();
            wingIt.append("PUT(").append(s).append(',').append(usePutQ ? "? " : " ").append(format).append(')');
            result = wingIt.toString();
        }
        if (forceCast) {
            result = "CAST (" + result + " AS CHAR)";
        }
        return result;
    }

    public static String[] getReservedWords(int languageID) {
        String[] values = null;
        switch (languageID) {
            case 2: {
                values = _SDPS_SQL_RESERVED_WORDS.toArray(new String[0]);
                break;
            }
            case 4: {
                values = _TSSQL_SQL_RESERVED_WORDS.toArray(new String[0]);
                break;
            }
            default: {
                values = new String[]{};
            }
        }
        return values;
    }

    public static boolean isReservedLibref(@Nullable String libref) {
        String temp = libref != null ? libref.toUpperCase() : libref;
        return RESERVED_LIBREFS.contains(temp);
    }

    public static boolean isValidIdentifierLength(String identifier, int languageID) {
        boolean valid = true;
        if (identifier == null) {
            valid = false;
        } else {
            int len = identifier.length();
            switch (languageID) {
                case 3: {
                    valid = len > 0 && len <= 30;
                    break;
                }
                default: {
                    valid = len > 0 && len <= 32;
                }
            }
        }
        return valid;
    }

    public static boolean isPredefinedIdentifier(String identifier, int languageID) {
        boolean isReserved = false;
        if (identifier != null) {
            switch (languageID) {
                case 3: {
                    break;
                }
                default: {
                    if (!_SAS_PREDEFINED_IDENTIFIERS.contains(identifier.toUpperCase())) break;
                    isReserved = true;
                }
            }
        }
        return isReserved;
    }

    public static boolean isValidIdentifierText(String identifier, int languageID) {
        boolean valid = true;
        if (identifier == null) {
            valid = false;
        } else {
            block0 : switch (languageID) {
                case 3: {
                    for (int i = 0; i < identifier.length(); ++i) {
                        char ch = identifier.charAt(i);
                        if (OLAP_INVALID_ID_CHARS.indexOf(ch) == -1 && !Character.isISOControl(ch) && !Character.isWhitespace(ch)) continue;
                        valid = false;
                        break block0;
                    }
                    break;
                }
                default: {
                    boolean simpleIdentifierName = GenerationUtil.isSimpleIdentifierName(identifier);
                    if (simpleIdentifierName) break;
                    if (languageID == 2) {
                        valid = false;
                        break;
                    }
                    for (int i = 0; i < identifier.length(); ++i) {
                        char ch = identifier.charAt(i);
                        if (ch >= ' ' || ch == '\u000e' || ch == '\u000f' || ch == '\u0000') continue;
                        valid = false;
                        break block0;
                    }
                }
            }
        }
        return valid;
    }

    public static boolean isSimpleIdentifierName(String identifier) {
        boolean simpleIdentifierName = identifier.matches("[\\w&&\\D][\\w]*");
        return simpleIdentifierName;
    }

    public static boolean isValidIdentifierName(String identifier, int languageID) {
        boolean valid = GenerationUtil.isValidIdentifierLength(identifier, languageID) && !GenerationUtil.isPredefinedIdentifier(identifier, languageID) && GenerationUtil.isValidIdentifierText(identifier, languageID);
        return valid;
    }

    public static boolean isInvalidTSSQL(DataSelection dataSelection, DataItem dataItem) throws GenerationException {
        Stack<DataItem> diStack = new Stack<DataItem>();
        diStack.push(dataItem);
        while (diStack.size() > 0) {
            boolean isAggregate;
            DataItem di = (DataItem)diStack.pop();
            DataItemActionType usage = di.getUsage();
            boolean bl = isAggregate = usage != null && (usage == DataItemActionType.USAGE_AGGREGATE || usage == DataItemActionType.USAGE_CATEGORY);
            if (isAggregate) {
                Function function = di.getAggregationType();
                FunctionNameID functionNameID = null;
                if (function != null) {
                    functionNameID = function.getFunctionNameID();
                }
                if (invalidTSSQLAggregateFunctionNameIDs.contains(functionNameID)) {
                    return true;
                }
                if (!FunctionNameID.INTERNAL_AGGREGATION.equals(functionNameID) && !FunctionNameID.INTERNAL_AGGREGATION_ADDITIVE.equals(functionNameID)) continue;
                List<DataItem> subItems = di.getLeafDataItems();
                subItems.remove(di);
                diStack.addAll(subItems);
                continue;
            }
            boolean keepComments = false;
            boolean enableTuples = true;
            boolean enableSets = false;
            boolean enableObjRefs = false;
            String expressionText = null;
            ExpressionInterface expression = di.getExpression();
            if (expression == null) continue;
            try {
                expressionText = StringExpressionUtil.getInstance().getText(expression, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE, dataSelection);
                ParsedNode parent = ParserUtil.parsePredicate(expressionText, keepComments, enableTuples, enableSets, enableObjRefs);
                Stack<ParsedNode> nodeStack = new Stack<ParsedNode>();
                if (parent == null) continue;
                nodeStack.push(parent);
                while (nodeStack.size() > 0) {
                    ParsedNode node = (ParsedNode)nodeStack.pop();
                    if (node == null) continue;
                    int type = node.getType();
                    switch (type) {
                        case 327690: 
                        case 327691: 
                        case 327692: {
                            AggregateDefinition aggregateDefinition;
                            Object[] keywords = node.getKeywords();
                            String functionName = (String)keywords[0];
                            if (keywords.length > 1 && (aggregateDefinition = (AggregateDefinition)keywords[1]) != null) {
                                functionName = aggregateDefinition.getFunctionKeyword();
                            }
                            if (invalidTSSQLAggregateFunctions.contains(functionName)) {
                                return true;
                            }
                            nodeStack.addAll(Arrays.asList(node.getChildren()));
                            break;
                        }
                        case 327681: {
                            Object[] keywords = node.getKeywords();
                            String functionName = (String)keywords[0];
                            if (invalidTSSQLFunctions.contains(functionName)) {
                                return true;
                            }
                            nodeStack.addAll(Arrays.asList(node.getChildren()));
                            break;
                        }
                        case 327682: {
                            nodeStack.addAll(Arrays.asList(node.getChildren()));
                        }
                    }
                }
            }
            catch (MetadataException e) {
                throw new GenerationException(e);
            }
            catch (TokenError e) {
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug("TokenError: " + e.getMessage() + "\n Parsing Options = {Perserve Comments: " + (keepComments ? "enabled" : "disabled") + ", Tuples Syntax: " + (enableTuples ? "enabled" : "disabled") + ", Sets Syntax " + (enableSets ? "enabled" : "disabled") + ", Object References: " + (enableObjRefs ? "enabled" : "disabled") + "}\n*** COULD NOT PARSE [" + expressionText + "]", (Throwable)e);
            }
            catch (ParseError e) {
                if (!_logger.isDebugEnabled()) continue;
                _logger.debug("ParseError: " + e.getMessage() + "\n Parsing Options = {Perserve Comments: " + (keepComments ? "enabled" : "disabled") + ", Tuples Syntax: " + (enableTuples ? "enabled" : "disabled") + ", Sets Syntax " + (enableSets ? "enabled" : "disabled") + ", Object References: " + (enableObjRefs ? "enabled" : "disabled") + "}\n*** COULD NOT PARSE [" + expressionText + "]", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isSPDS(SASLibrary sasLibrary) throws MetadataException {
        String engineName;
        boolean isSPDS = false;
        if (!sasLibrary.isUnresolved() && !sasLibrary.isPreassigned() && (engineName = sasLibrary.getEngine().toUpperCase()).equals("SASSPDS")) {
            isSPDS = true;
        }
        return isSPDS;
    }

    public static boolean isSPDS(ExpressionInterface expression) throws MetadataException {
        boolean isSPDS = false;
        List<QualifiedColumn> qcolumns = expression.getResources(QualifiedColumn.class, 65535);
        if (expression instanceof QualifiedColumn) {
            qcolumns.add((QualifiedColumn)expression);
        }
        for (QualifiedColumn qcolumn : qcolumns) {
            SASLibrary sasLibrary;
            AccessPath path;
            Schema accessingSchema;
            DataSourceTable dstable;
            if (qcolumn.isUnresolved() || (dstable = qcolumn.getDataSource()) == null || !((accessingSchema = (path = dstable.getAccessPath()).getSchema()) instanceof SASLibrary) || !GenerationUtil.isSPDS(sasLibrary = (SASLibrary)accessingSchema)) continue;
            isSPDS = true;
            break;
        }
        return isSPDS;
    }

    public static boolean useTSSQL() {
        boolean useTSSQL = Boolean.getBoolean("SASQueryServices.useTSSQL");
        return useTSSQL;
    }

    public static boolean columnNeedsEscaping(String identifier, int langID) {
        boolean needsEscaping = false;
        if (identifier != null) {
            block0 : switch (langID) {
                case 2: {
                    String[] reservedWords = GenerationUtil.getReservedWords(langID);
                    for (int i = 0; i < reservedWords.length; ++i) {
                        if (!identifier.equalsIgnoreCase(reservedWords[i])) continue;
                        needsEscaping = true;
                        break block0;
                    }
                    break;
                }
                case 4: {
                    String[] reservedWords = GenerationUtil.getReservedWords(langID);
                    for (int i = 0; i < reservedWords.length; ++i) {
                        if (!identifier.equalsIgnoreCase(reservedWords[i])) continue;
                        needsEscaping = true;
                        break;
                    }
                    if (needsEscaping) break;
                    needsEscaping = !identifier.matches("[_A-Za-z][A-Za-z0-9_]*");
                    break;
                }
                default: {
                    needsEscaping = !identifier.matches("[\\w&&\\D][\\w]*");
                }
            }
        }
        return needsEscaping;
    }

    public static boolean tableNeedsEscaping(String identifier, int langID) {
        boolean needsEscaping = false;
        if (identifier != null) {
            block0 : switch (langID) {
                case 2: {
                    String[] reservedWords = GenerationUtil.getReservedWords(langID);
                    for (int i = 0; i < reservedWords.length; ++i) {
                        if (!identifier.equalsIgnoreCase(reservedWords[i])) continue;
                        needsEscaping = true;
                        break block0;
                    }
                    break;
                }
                case 4: {
                    String[] reservedWords = GenerationUtil.getReservedWords(langID);
                    for (int i = 0; i < reservedWords.length; ++i) {
                        if (!identifier.equalsIgnoreCase(reservedWords[i])) continue;
                        needsEscaping = true;
                        break;
                    }
                    if (needsEscaping) break;
                    needsEscaping = !identifier.matches("[_A-Za-z][A-Za-z0-9_]*");
                    break;
                }
                default: {
                    needsEscaping = !identifier.matches("[\\w&&\\D][\\w]*");
                }
            }
        }
        return needsEscaping;
    }

    public static String generateEscapedIdentifier(String identifier, int langID) {
        StringBuffer result = new StringBuffer();
        if (langID == 2) {
            result.append('\\').append(identifier);
        } else {
            String identifierQuoteStart = null;
            String identifierQuoteEnd = null;
            if (langID == 4) {
                identifierQuoteStart = "\"";
                identifierQuoteEnd = "\"";
            } else {
                identifierQuoteStart = "'";
                identifierQuoteEnd = "'n";
            }
            String escaped = identifier.replaceAll(identifierQuoteStart, identifierQuoteStart + identifierQuoteStart);
            result.append(identifierQuoteStart).append(escaped).append(identifierQuoteEnd);
        }
        return result.toString();
    }

    public static boolean isFormatCompatibleWithType(DataItem item) {
        Function aggregationFunction;
        DataItemActionType usage;
        ExpressionInterface expression;
        boolean isFormatCompatible = true;
        String format = item.getFormat();
        try {
            expression = item.getExpression();
            usage = item.getUsage();
            aggregationFunction = item.getAggregationType();
        }
        catch (MetadataUnresolvedException e) {
            return isFormatCompatible;
        }
        boolean valid = DataItemImpl.isValidFormatForType(format, expression, usage, aggregationFunction);
        if (!valid) {
            isFormatCompatible = false;
            if (_logger.isDebugEnabled()) {
                _logger.debug("The data item's (" + item.getLabel() + ") expression type is incompatible with the given format.  No format will be provided in the query.");
            }
        } else if (item instanceof DataItemReference) {
            DataItemReference dir = (DataItemReference)item;
            boolean typeChanged = GenerationUtil.isTypeChanged(dir);
            if (dir.isAggregationTypeModified() && typeChanged) {
                isFormatCompatible = false;
                if (_logger.isDebugEnabled()) {
                    _logger.debug("The data item reference's (" + dir.getLabel() + ") expression type is incompatible with the given format.  No format will be provided in the query.");
                }
            }
        }
        return isFormatCompatible;
    }

    public static boolean isTypeChanged(DataItem di) {
        boolean typeChanged = false;
        try {
            boolean isFormatConsistent;
            int newType;
            int oldType;
            DataItemActionType oldUsage = GenerationUtil.getParentUsage(di);
            Function oldAggFunction = GenerationUtil.getParentFunction(di);
            DataItemActionType newUsage = di.getUsage();
            ExpressionInterface expression = di.getExpression();
            Function newAggFunction = di.getAggregationType();
            boolean isCheckNeeded = false;
            if (oldUsage != newUsage && (oldUsage == DataItemActionType.USAGE_AGGREGATE || newUsage == DataItemActionType.USAGE_AGGREGATE)) {
                isCheckNeeded = true;
            }
            if (oldUsage == DataItemActionType.USAGE_AGGREGATE && newUsage == DataItemActionType.USAGE_AGGREGATE && GenerationUtil.isCountBased(oldAggFunction) != GenerationUtil.isCountBased(newAggFunction)) {
                isCheckNeeded = true;
            }
            if (isCheckNeeded && (oldType = IQModelImplUtilities.getExpressionTypeFactoringInAggregation(expression, oldUsage, oldAggFunction)) != (newType = IQModelImplUtilities.getExpressionTypeFactoringInAggregation(expression, newUsage, newAggFunction)) && !(isFormatConsistent = GenerationUtil.isFormatTypeEqExprType(di, newType))) {
                typeChanged = true;
            }
        }
        catch (MetadataUnresolvedException e) {
            if (_logger.isDebugEnabled()) {
                String msg = "Cannot determine whether the format [" + di.getFormat() + "] is compatible with the expression.  " + e.getLocalizedMessage();
                _logger.debug(msg, (Throwable)e);
            }
            return typeChanged;
        }
        catch (SASFormatException e) {
            if (_logger.isDebugEnabled()) {
                String msg = "Cannot determine whether the format [" + di.getFormat() + "] is compatible with the expression.   " + e.getLocalizedMessage();
                _logger.debug(msg, (Throwable)e);
            }
            return typeChanged;
        }
        return typeChanged;
    }

    public static boolean isMeasureAndDetailTypeSame(DataItem di) {
        boolean typeChanged = false;
        int measureType = 0;
        int detailType = 0;
        try {
            DataItemActionType measureUsage = DataItemActionType.USAGE_AGGREGATE;
            Function measureAggFunction = di.getAggregationType();
            ExpressionInterface expression = di.getExpression();
            Function nullAggFunction = null;
            DataItemActionType detailUsage = DataItemActionType.USAGE_DETAIL;
            measureType = IQModelImplUtilities.getExpressionTypeFactoringInAggregation(expression, measureUsage, measureAggFunction);
            detailType = IQModelImplUtilities.getExpressionTypeFactoringInAggregation(expression, detailUsage, nullAggFunction);
        }
        catch (MetadataUnresolvedException e) {
            return typeChanged;
        }
        if (measureType != detailType) {
            typeChanged = true;
        }
        return typeChanged;
    }

    private static boolean isCountBased(Function function) {
        boolean isCountBased = false;
        if (function != null) {
            Category category = function.getCategory();
            isCountBased = category == Category.CAT_COUNTING_AGGREGATE;
        }
        return isCountBased;
    }

    private static boolean isFormatTypeEqExprType(DataItem di, int newType) throws SASFormatException {
        boolean isFormatEqual = false;
        String sasFormatText = di.getFormat();
        if (sasFormatText == null || sasFormatText.length() == 0) {
            isFormatEqual = true;
        } else {
            int formatType;
            SASFormatAttributes formatAttrs = SASFormatDescriptionUtil.getFormatAttributes(sasFormatText);
            SASFormatCategory formatCategory = null;
            if (formatAttrs != null) {
                formatCategory = formatAttrs.getType();
            }
            if (newType == (formatType = GenerationUtil.getFormatType(sasFormatText, formatAttrs, formatCategory))) {
                isFormatEqual = true;
            }
        }
        return isFormatEqual;
    }

    private static int getFormatType(String format, SASFormatAttributes attrs, SASFormatCategory formatCategory) {
        int returnValue = -1;
        if (attrs != null && formatCategory != null) {
            if (formatCategory.equals(SASFormatCategory.CHARACTER_CATEGORY)) {
                returnValue = 3;
            } else if (formatCategory.equals(SASFormatCategory.CURRENCY_CONVERSION_CATEGORY)) {
                returnValue = 2;
            } else if (formatCategory.equals(SASFormatCategory.USER_DEFINED_CATEGORY)) {
                returnValue = format.startsWith("$") ? 3 : -1;
            } else if (formatCategory.equals(SASFormatCategory.NUMERIC_CATEGORY)) {
                returnValue = 2;
            } else if (formatCategory.equals(SASFormatCategory.DATE_TIME_CATEGORY)) {
                String baseFormatName = attrs.getBaseFormatName();
                SASFormatDescription formatDescription = SASFormatDescriptionUtil.getFormatDescription(baseFormatName);
                returnValue = formatDescription.isDate() ? 4 : (formatDescription.isTime() ? 5 : 6);
            }
        } else {
            returnValue = format.startsWith("$") ? 3 : -1;
        }
        return returnValue;
    }

    private static Function getParentFunction(DataItem di) {
        Function parentAggFunction = di.getAggregationType();
        DataItem parentItem = di;
        while (parentItem instanceof DataItemReference) {
            DataItemReference dir = (DataItemReference)parentItem;
            Function aggFunctForItemInChain = (parentItem = dir.getBaseDataItem()).getAggregationType();
            if (parentAggFunction == aggFunctForItemInChain) continue;
            parentAggFunction = aggFunctForItemInChain;
            break;
        }
        return parentAggFunction;
    }

    private static DataItemActionType getParentUsage(DataItem di) {
        DataItemActionType parentUsage = di.getUsage();
        DataItem parentItem = di;
        while (parentItem instanceof DataItemReference) {
            DataItemReference dir = (DataItemReference)parentItem;
            DataItemActionType usageForItemInChain = (parentItem = dir.getBaseDataItem()).getUsage();
            if (parentUsage == usageForItemInChain) continue;
            parentUsage = usageForItemInChain;
            break;
        }
        return parentUsage;
    }

    private static boolean hasAFormatString(String format) {
        boolean hasFormat = false;
        if (format != null && !format.trim().equals("")) {
            hasFormat = true;
        }
        return hasFormat;
    }

    public static boolean isFormatTransforming(DataItem item) {
        String format = item.getFormat();
        ExpressionInterface expression = item.getExpression();
        int unformattedType = item.getExpressionTypeIgnoringFormattingForced();
        boolean isTransforming = GenerationUtil.isFormatTransforming(format, expression, unformattedType);
        return isTransforming;
    }

    public static boolean isFormatTransforming(String format, ExpressionInterface expression, int unformattedType) {
        boolean isTransforming = true;
        if (format == null) {
            format = "";
        }
        if (unformattedType == 3) {
            isTransforming = GenerationUtil.isCharacterFormatTransforming(isTransforming, format, expression);
        }
        return isTransforming;
    }

    public static boolean isCharacterFormatTransforming(boolean isTransforming, String format, ExpressionInterface expression) {
        if ((format = format.toUpperCase()).trim().length() == 0 || format.equals("$.") || format.equals("$CHAR.")) {
            isTransforming = false;
        } else if (expression instanceof Column && (Pattern.matches("\\$\\d+.", format) || Pattern.matches("\\$CHAR\\d+.", format))) {
            int length = 0;
            try {
                length = format.indexOf("$CHAR") == 0 ? Integer.parseInt(format.substring(5, format.length() - 1)) : Integer.parseInt(format.substring(1, format.length() - 1));
                Column column = (Column)expression;
                int columnLength = Math.max(column.getDbmsLength(), column.getSasLength());
                if (length == columnLength || length > columnLength) {
                    isTransforming = false;
                }
            }
            catch (NumberFormatException nfe) {
                _logger.error("The format could not be parsed properly. ", (Throwable)nfe);
            }
            catch (MetadataException me) {
                _logger.error("Exception while getting the DBMS length of the dataitem. ", (Throwable)me);
            }
        }
        return isTransforming;
    }

    public static String getSqlOutputFormat(DataItem item) throws GenerationException {
        boolean valid;
        String format = item.getFormat();
        ExpressionInterface expression = item.getExpression();
        DataItemActionType usage = item.getUsage();
        Function aggregationFunction = item.getAggregationType();
        boolean hasFormat = format != null && !format.trim().equals("");
        boolean bl = valid = hasFormat && DataItemImpl.isValidFormatForType(format, expression, usage, aggregationFunction);
        if (!valid) {
            int type = item.getExpressionTypeIgnoringFormattingForced();
            switch (type) {
                case 2: {
                    format = "BEST.";
                    break;
                }
                case 4: {
                    format = "DATE.";
                    break;
                }
                case 6: {
                    format = "DATETIME.";
                    break;
                }
                case 0: {
                    format = "$.";
                    break;
                }
                case 3: {
                    format = "$.";
                    break;
                }
                default: {
                    format = "$.";
                }
            }
        }
        return format;
    }

    public static String getSortFormat(DataItem item) throws GenerationException {
        boolean hasSortDirection;
        String sortFormat = null;
        DataItemActionType sort = item.getSortDirection();
        boolean bl = hasSortDirection = sort == DataItemActionType.SORT_ASCENDING || sort == DataItemActionType.SORT_DESCENDING;
        if (hasSortDirection) {
            Function aggregationFunction;
            DataItemActionType usage;
            ExpressionInterface expression;
            boolean valid;
            boolean hasFormat;
            String format = item.getFormat();
            boolean bl2 = hasFormat = format != null && !format.trim().equals("");
            if (hasFormat && (valid = DataItemImpl.isValidFormatForType(format, expression = item.getExpression(), usage = item.getUsage(), aggregationFunction = item.getAggregationType()))) {
                int expressionTypeIgnoringFormattingForced;
                boolean isTransforming;
                boolean isCharacter;
                boolean bl3 = isCharacter = item.getExpression().getExpressionType() == 3;
                if (isCharacter && (isTransforming = GenerationUtil.isFormatTransforming(format, expression, expressionTypeIgnoringFormattingForced = item.getExpressionTypeIgnoringFormattingForced()))) {
                    sortFormat = format;
                }
            }
        }
        return sortFormat;
    }

    public static String generateAnalysisFunction(DataItem item, String sql) throws GenerationException {
        Function function;
        if (_logger.isDebugEnabled()) {
            _logger.debug("generateAnalysisFunction: item=" + item);
        }
        if ((function = GenerationUtil.getAnalysisFunction(item)) != null) {
            Object[] insertText = new Object[]{sql};
            String syntaxTemplate = function.getSyntaxTemplateFor(1);
            sql = MessageFormat.format(syntaxTemplate, insertText);
        }
        return sql;
    }

    public static Function getAnalysisFunction(DataItem item) {
        Function returnValue = null;
        DataItemActionType usage = item.getUsage();
        Function function = item.getAggregationType();
        if (usage == DataItemActionType.USAGE_AGGREGATE && function != null) {
            returnValue = function;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("returnAnalysisFunction: usage=" + usage);
            _logger.debug("returnAnalysisFunction: function=" + function);
        }
        return returnValue;
    }

    public static boolean useFormattedValueForReference(DataItem item) {
        boolean formattingForced = item.isFormattingForced();
        boolean formatTransforming = GenerationUtil.isFormatTransforming(item);
        return formattingForced && formatTransforming;
    }

    public static Locale getEffectiveComputationalLocale(BusinessQuery businessQuery, OverrideLocaleInterface computationalLocaleObject) {
        Locale overrideLocale = computationalLocaleObject.getComputationalLocale();
        Locale effectiveComputationalLocale = GenerationUtil.getEffectiveComputationLocale(businessQuery, overrideLocale);
        return effectiveComputationalLocale;
    }

    private static Locale getEffectiveComputationLocale(BusinessQuery businessQuery, Locale overrideLocale) {
        if (overrideLocale == null) {
            BusinessModel model = null;
            model = businessQuery instanceof BusinessModel ? (BusinessModel)((Object)businessQuery) : businessQuery.getBusinessModel();
            if (model != null) {
                overrideLocale = LocaleUtilities.getDefaultComputationalLocale(model);
            }
        }
        return overrideLocale;
    }

    public static boolean useFormattedValueForGrouping(DataItem item) throws GenerationException {
        DataItemActionType usage = item.getUsage();
        boolean isGroupBy = usage == DataItemActionType.USAGE_CATEGORY;
        boolean useFormattedValueForGrouping = !isGroupBy ? false : GenerationUtil._isGroupFormatted(item);
        return useFormattedValueForGrouping;
    }

    public static boolean useFormattedValueForGroupingDefault(DataItem item) {
        DataItemActionType usage = item.getUsage();
        boolean isGroupBy = usage == DataItemActionType.USAGE_CATEGORY;
        boolean useFormattedValueForGrouping = !isGroupBy ? false : GenerationUtil._isDefaultGroupFormatted(item);
        return useFormattedValueForGrouping;
    }

    private static boolean _isGroupFormatted(DataItem item) throws GenerationException {
        DataItemActionType groupFormatting;
        try {
            groupFormatting = item.getGroupFormatting();
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        boolean useFormattedValueForGrouping = groupFormatting == DataItemActionType.GROUP_FORMATTING_BY_FORMATTED_VALUES ? true : (groupFormatting == DataItemActionType.GROUP_FORMATTING_BY_UNFORMATTED_VALUES ? false : GenerationUtil._isDefaultGroupFormatted(item));
        return useFormattedValueForGrouping;
    }

    private static boolean _isDefaultGroupFormatted(DataItem item) {
        boolean formatTransformsData = GenerationUtil.isFormatTransforming(item);
        boolean useFormattedValueForGrouping = !formatTransformsData ? false : item.isFormattingForced();
        return useFormattedValueForGrouping;
    }

    public static boolean useFormattedValueForSorting(DataItem item) throws GenerationException {
        return GenerationUtil._isSortFormatted(item);
    }

    public static boolean useFormattedValueForSortingDefault(DataItem item) {
        DataItemActionType sort = item.getSortDirection();
        boolean hasSortDirection = sort != null && sort != DataItemActionType.SORT_NONE;
        boolean useFormattedValueForSorting = !hasSortDirection ? false : GenerationUtil._isDefaultSortFormatted(item);
        return useFormattedValueForSorting;
    }

    private static boolean _isSortFormatted(DataItem item) throws GenerationException {
        DataItemActionType sortFormatting;
        try {
            sortFormatting = item.getSortFormatting();
        }
        catch (MetadataException e) {
            throw new GenerationException(e);
        }
        boolean useFormattedValueForSorting = sortFormatting == DataItemActionType.SORT_FORMATTING_BY_FORMATTED_VALUES ? true : (sortFormatting == DataItemActionType.SORT_FORMATTING_BY_UNFORMATTED_VALUES ? false : GenerationUtil._isDefaultSortFormatted(item));
        return useFormattedValueForSorting;
    }

    private static boolean _isDefaultSortFormatted(DataItem item) {
        boolean useFormattedValueForSorting;
        boolean formatTransformsData = GenerationUtil.isFormatTransforming(item);
        if (!formatTransformsData) {
            useFormattedValueForSorting = false;
        } else {
            int typeWithoutFF = item.getExpressionTypeIgnoringFormattingForced();
            if (item.isFormattingForced()) {
                if (item.getUsage() == DataItemActionType.USAGE_AGGREGATE) {
                    useFormattedValueForSorting = true;
                } else if (item.getUsage() == DataItemActionType.USAGE_CATEGORY) {
                    switch (typeWithoutFF) {
                        case 2: 
                        case 4: 
                        case 5: 
                        case 6: {
                            useFormattedValueForSorting = false;
                            break;
                        }
                        default: {
                            useFormattedValueForSorting = true;
                            break;
                        }
                    }
                } else {
                    useFormattedValueForSorting = true;
                }
            } else {
                useFormattedValueForSorting = typeWithoutFF == 3;
            }
        }
        return useFormattedValueForSorting;
    }

    public static boolean useFormattedValueForSelect(DataItem item) throws GenerationException {
        return false;
    }

    public static boolean isOutputDataFormatted(BusinessQuery query, SelectedItem selectedItem, boolean isChildQuery) {
        DataItem dataItem = selectedItem.getItem();
        int formatType = selectedItem.getFormatType();
        return GenerationUtil.isOutputDataFormatted(query, dataItem, formatType, isChildQuery);
    }

    public static boolean isOutputDataFormatted(BusinessQuery query, DataItem dataItem, int formatType, boolean isChildQuery) {
        boolean formatOutput;
        boolean dataItemIsFormatted = GenerationUtil.useFormattedValueForReference(dataItem);
        if (dataItemIsFormatted) {
            boolean isFFCategory;
            boolean bl = isFFCategory = dataItem.isFormattingForced() && dataItem.getUsage() == DataItemActionType.USAGE_CATEGORY;
            if (!isFFCategory) {
                formatOutput = true;
            } else {
                boolean isUnformattedData;
                boolean isNumericTypeWithoutFF;
                int typeWithoutFF = dataItem.getExpressionTypeIgnoringFormattingForced();
                boolean bl2 = isNumericTypeWithoutFF = typeWithoutFF == 4 || typeWithoutFF == 5 || typeWithoutFF == 6 || typeWithoutFF == 2;
                formatOutput = !isNumericTypeWithoutFF ? true : !(isUnformattedData = GenerationUtil.isOutputUnformatted(query, isChildQuery, formatType));
            }
        } else {
            formatOutput = false;
        }
        return formatOutput;
    }

    private static boolean isOutputUnformatted(BusinessQuery query, boolean isChildQuery, int formatType) {
        boolean isOutputUnformatted = false;
        if (!isChildQuery) {
            boolean isUnformattedDataBQ;
            isOutputUnformatted = isUnformattedDataBQ = query.getQueryProperty(BusinessQueryProperty.RETURN_UNFORMATTED_DATA);
            if (!isUnformattedDataBQ) {
                isOutputUnformatted = formatType == 1;
            }
        }
        return isOutputUnformatted;
    }

    public static boolean isOutputDataFormatted(BusinessQuery query, SelectedItem selectedItem) {
        return GenerationUtil.isOutputDataFormatted(query, selectedItem, false);
    }

    public static String toString(DataItem item) {
        String isFoT = null;
        try {
            FractionOfTotalUtilImpl.isFractionOfTotalItem(item);
        }
        catch (GenerationException e) {
            isFoT = e.toString();
        }
        return "Rsid=" + item.getResultSetID() + ", " + item.getIdentityString() + ", Usage=" + item.getUsage() + ", Aggr=" + item.getAggregationType() + ", ExprType=" + item.getExpressionType() + ", Format=" + item.getFormat() + ", isFF=" + item.isFormattingForced() + (item.isFormattingForced() ? " (ExprType w/o FF=" + item.getExpressionTypeIgnoringFormattingForced() + ")" : "") + ", isFoT=" + isFoT;
    }

    public static String replaceTableName(String code, String pattern, String tableName) {
        if (tableName != null) {
            String rawTableName;
            boolean isQuotedLiteral;
            boolean bl = isQuotedLiteral = tableName.length() > 2 && tableName.charAt(0) == '\'' && tableName.charAt(tableName.length() - 2) == '\'' && tableName.charAt(tableName.length() - 1) == 'n';
            if (isQuotedLiteral) {
                rawTableName = tableName.substring(1, tableName.length() - 2);
                rawTableName = rawTableName.replace("\\", "\\\\");
                rawTableName = rawTableName.replace("$", "\\$");
            } else {
                rawTableName = tableName;
            }
            boolean needsQuoting = GenerationUtil.tableNeedsEscaping(rawTableName, 1);
            if (needsQuoting) {
                Pattern p = null;
                try {
                    String replacedString;
                    p = Pattern.compile("(\\w*)(" + pattern + ")(\\w*)");
                    Matcher m = p.matcher(code);
                    code = replacedString = m.replaceAll("'$1" + rawTableName + "$3'n");
                }
                catch (IllegalStateException ise) {
                    code = code.replaceAll(pattern, tableName);
                    _logger.debug("regex pattern match failed in GenerationUtil. Pattern was \"" + p + "\".");
                }
            } else {
                code = code.replaceAll(pattern, tableName);
            }
        }
        return code;
    }

    public static String generateFullyQualifiedIdentifier(String qualifier, String identifier) {
        String escapedIdentifier = GenerationUtil.generateEscapedIdentifier(identifier);
        StringBuffer sb = new StringBuffer(qualifier);
        sb.append(".").append(escapedIdentifier);
        return sb.toString();
    }

    public static String generateEscapedIdentifier(String identifier) {
        boolean needsEscaping = GenerationUtil.columnNeedsEscaping(identifier, 1);
        String escapedIdentifier = needsEscaping ? GenerationUtil.generateEscapedIdentifier(identifier, 1) : identifier;
        return escapedIdentifier;
    }

    public static String generateResourceBasedRSID(BusinessModel model, DataItem dataItem) throws MetadataException {
        String rsid = dataItem.getIntraModelID();
        ExpressionInterface expr = dataItem.getExpression();
        if (dataItem.getStructure().isOLAP()) {
            OlapItem useForName = null;
            List<OlapItem> resources = dataItem.getResources(OlapItem.class, 65535);
            if (resources.size() > 0) {
                useForName = resources.get(0);
            }
            rsid = useForName != null ? useForName.getUniqueName() : dataItem.getLabel();
            rsid = rsid.replaceAll("^\\[Measures\\]\\.", "M_");
            rsid = rsid.replaceAll("[\\[\\.\\]'\\s\"]+", "_");
            rsid = rsid.replaceAll("_+", "_");
            rsid = rsid.replaceAll("^_", "");
            if ((rsid = rsid.replaceAll("_$", "")).length() > 30) {
                rsid = rsid.substring(0, 29);
            }
            rsid = model.generateIntraModelID(rsid);
        } else {
            Column useForName = null;
            List<QualifiedColumn> resources = dataItem.getResources(QualifiedColumn.class, 65535);
            if (resources.size() > 0) {
                useForName = resources.get(0);
            }
            if (useForName != null) {
                rsid = useForName.getSasName();
            } else {
                rsid = dataItem.getIntraModelID();
                if (rsid.length() > 30) {
                    rsid = rsid.substring(0, 29);
                }
                rsid = model.generateIntraModelID(rsid);
            }
        }
        return rsid;
    }

    static {
        for (String s : invalidTSSQLAggregateFunctions) {
            s = s.toUpperCase();
        }
        for (String s : invalidTSSQLFunctions) {
            String string = s.toUpperCase();
        }
    }
}

