/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma;

import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.SelectedItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FractionOfTotalUtilImpl {
    public static List<DataItem> getFractionOfTotalItems(DataSelection dataSelection) throws GenerationException {
        ArrayList<DataItem> fractionItems = new ArrayList<DataItem>();
        if (dataSelection != null) {
            List<SelectedItem> selectedItems = dataSelection.getSelectedItems();
            for (SelectedItem si : selectedItems) {
                DataItem item = si.getItem();
                Role role = si.getRole();
                boolean isInactive = role == Role.BACKGROUND || Role.isInactiveRole(dataSelection, role);
                if (isInactive || !FractionOfTotalUtilImpl.isFractionOfTotalItem(item)) continue;
                fractionItems.add(item);
            }
        }
        return fractionItems;
    }

    public static boolean isFractionOfTotalItem(DataItem item) throws GenerationException {
        if (item == null) {
            return false;
        }
        ExpressionInterface expression = item.getExpression();
        if (expression instanceof FractionOfTotalExpression) {
            FractionOfTotalUtilImpl.verifyFractionOfTotal(item);
            return true;
        }
        return false;
    }

    private static void verifyFractionOfTotal(DataItem item) throws GenerationException {
        FractionOfTotalExpression fractionExpr = (FractionOfTotalExpression)item.getExpression();
        DataItem numerator = fractionExpr.getNumerator();
        if (numerator == null) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("FractionOfTotalUtil.verifyFractionOfTotal.NullNumerator.fmt.txt", item.getLabel());
            throw new GenerationException(mft);
        }
        if (!numerator.getUsage().equals(DataItemActionType.USAGE_AGGREGATE) && !numerator.getUsage().equals(DataItemActionType.USAGE_DETAIL)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("FractionOfTotalUtil.verifyFractionOfTotal.InvalidNumerator.fmt.txt", numerator.getLabel(), item.getLabel(), numerator.getUsage());
            throw new GenerationException(mft);
        }
        if (FractionOfTotalUtilImpl.isFractionOfTotalItem(numerator)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("FractionOfTotalUtil.verifyFractionOfTotal.NestedNumerator.fmt.txt", numerator.getLabel(), item.getLabel());
            throw new GenerationException(mft);
        }
        DataItem denominator = fractionExpr.getDenominator();
        if (denominator != null && !denominator.getUsage().equals(DataItemActionType.USAGE_CATEGORY)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("FractionOfTotalUtil.verifyFractionOfTotal.InvalidDenominator.fmt.txt", denominator.getLabel(), item.getLabel(), denominator.getUsage());
            throw new GenerationException(mft);
        }
    }

    public static boolean isFractionOfGrandTotalItem(DataItem item) throws GenerationException {
        if (!FractionOfTotalUtilImpl.isFractionOfTotalItem(item)) {
            return false;
        }
        FractionOfTotalExpression fractionExpression = (FractionOfTotalExpression)item.getExpression();
        return fractionExpression.getDenominatorType() == 1;
    }

    public static boolean checkGrandTotalComparisonItems(DataSelection dataSelection) throws GenerationException {
        boolean containsFractionOfGT = false;
        List<DataItem> fractionItems = FractionOfTotalUtilImpl.getFractionOfTotalItems(dataSelection);
        Iterator<DataItem> iter = fractionItems.iterator();
        while (iter.hasNext() && !containsFractionOfGT) {
            DataItem item = iter.next();
            if (!FractionOfTotalUtilImpl.isFractionOfGrandTotalItem(item)) continue;
            FractionOfTotalUtilImpl.verifyFractionOfGrandTotalItem(item);
            containsFractionOfGT = true;
        }
        return containsFractionOfGT;
    }

    private static void verifyFractionOfGrandTotalItem(DataItem item) throws GenerationException {
        FractionOfTotalUtilImpl.verifyFractionOfTotal(item);
        FractionOfTotalExpression fractionExpr = (FractionOfTotalExpression)item.getExpression();
        DataItem numerator = fractionExpr.getNumerator();
        if (!DataRetrievalUtil.isSummarizableItem(numerator)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("FractionOfTotalUtil.verifyFractionOfGrandTotalItem.UnsupportedNumeratorAggr.fmt.txt", numerator.getLabel(), item.getLabel());
            throw new GenerationException(mft);
        }
    }

    public static boolean isUsedByFractionOfTotalInQuery(BusinessQuery query, DataItem item) throws GenerationException {
        List<SelectedItem> selectedItems = query.getSelectedItems();
        for (SelectedItem selectedItem : selectedItems) {
            DataItem resultItem = selectedItem.getItem();
            Role role = selectedItem.getRole();
            boolean isInactive = role == Role.BACKGROUND || Role.isInactiveRole(query, role);
            if (isInactive || !FractionOfTotalUtilImpl.isFractionOfTotalItem(resultItem)) continue;
            FractionOfTotalExpression fote = (FractionOfTotalExpression)resultItem.getExpression();
            DataItem numerator = fote.getNumerator();
            if (numerator != null && numerator == item) {
                return true;
            }
            DataItem denominator = fote.getDenominator();
            if (denominator == null || denominator != item) continue;
            return true;
        }
        return false;
    }

    public static Role getNumeratorRoleInQuery(DataSelection dataSelection, DataItem item) throws GenerationException {
        Role fotNumRole = null;
        DataItem numerator = FractionOfTotalUtilImpl.getFractionOfTotalNumerator(item);
        Iterator<SelectedItem> iterator = dataSelection.getSelectedItems().iterator();
        while (iterator.hasNext() && fotNumRole == null) {
            SelectedItem selectedItem = iterator.next();
            if (selectedItem.getItem() != numerator) continue;
            fotNumRole = selectedItem.getRole();
        }
        return fotNumRole;
    }

    public static DataItem getFractionOfTotalNumerator(DataItem totalFractionItem) throws GenerationException {
        ExpressionInterface expression = totalFractionItem.getExpression();
        if (!(expression instanceof FractionOfTotalExpression)) {
            MessageFormatter mft = IQDataServicesResourceBundle.getMessageFormatter("FractionOfTotalUtil.getFractionOfTotalNumerator.NotFraction.fmt.txt", totalFractionItem.getResultSetID());
            throw new GenerationException(mft);
        }
        DataItem numeratorItem = ((FractionOfTotalExpression)expression).getNumerator();
        return numeratorItem;
    }
}

