/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma;

import com.sas.iquery.builder.DisabledTotalsBuilder;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.generation2.GenerationException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelReferenceInfo;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.TotalingType;
import com.sas.iquery.metadata.business.impl.DataSelectionImpl;
import com.sas.iquery.strategies.combined.CombinedDataSelectionFactory;
import com.sas.iquery.strategies.combined.DataSelectionWithEmbedded;
import com.sas.iquery.strategies.combined.LookThroughDataSelectionWithEmbedded;
import com.sas.iquery.util.Preconditions;
import com.sas.iquery.util.impl.MessageFormatter;
import com.sas.services.session.SessionContextInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CloneDataSelectionFactory {
    private static final String CLONE_DATASELECTION_PREFIX = "CLONE_ROLAP";
    private static int cloneID = 1;

    public static DataSelection createCloneDataSelection(DataSelection dataSelection) throws GenerationException {
        HashMap<BusinessModelReferenceInfo, BusinessModel> reuseModels = new HashMap<BusinessModelReferenceInfo, BusinessModel>();
        if (dataSelection instanceof DataSelectionImpl) {
            BusinessModel busModel = dataSelection.getBusinessModel();
            reuseModels.put(busModel.getReferenceInfo(), busModel);
            BusinessModel baseModel = busModel.getBaseModel();
            if (baseModel != null) {
                reuseModels.put(baseModel.getReferenceInfo(), baseModel);
            }
        }
        DataSelection clonedDataSelection = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new GenerationException(IQDataServicesResourceBundle.getMessageFormatter("CloneDataSelectionFactory.createCloneDataSelection.ParserConfigurationException.txt", new Object[0]), (Throwable)e);
        }
        Document doc = docBuilder.newDocument();
        Element dummyParentElement = doc.createElement("ThisShouldNotShowUpInAReport");
        Element dataSelectionElement = null;
        try {
            dataSelectionElement = dataSelection.write(dummyParentElement);
        }
        catch (Exception e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("CloneDataSelectionFactory.createCloneDataSelection.serialize.txt", new Object[0]);
            throw new GenerationException(formatter, (Throwable)e);
        }
        try {
            Map<DataItem, Set<TotalingType>> disabledTotalingByItem;
            clonedDataSelection = CloneDataSelectionFactory.readDataSelection(dataSelectionElement, dataSelection.getMetadataService(), dataSelection.getSession(), reuseModels);
            clonedDataSelection.setID(dataSelection.getID() + "_" + CLONE_DATASELECTION_PREFIX + "_" + cloneID++);
            if (!DisabledTotalsBuilder.isPersistGroups(dataSelection) && (disabledTotalingByItem = DisabledTotalsBuilder.getDisabledTotalingByItem(dataSelection, false)) != null && !disabledTotalingByItem.isEmpty()) {
                for (Map.Entry<DataItem, Set<TotalingType>> entry : disabledTotalingByItem.entrySet()) {
                    DataItem updateDataItem;
                    DataItem originalDataItem = entry.getKey();
                    Set<TotalingType> disabledTypes = entry.getValue();
                    if (originalDataItem.getBusinessModel() == dataSelection) {
                        String id = originalDataItem.getIntraModelID();
                        updateDataItem = (DataItem)clonedDataSelection.getBusinessItemByID(id);
                    } else {
                        updateDataItem = originalDataItem;
                    }
                    for (TotalingType totalingType : disabledTypes) {
                        DisabledTotalsBuilder.disableTotaling(clonedDataSelection, totalingType, updateDataItem);
                    }
                }
            }
        }
        catch (Exception e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("CloneDataSelectionFactory.createCloneDataSelection.DataSelectionCreationError.txt", new Object[0]);
            throw new GenerationException(formatter, (Throwable)e);
        }
        return clonedDataSelection;
    }

    public static DataSelection readDataSelection(Element dataSelectionOrDualElement, IntelligentQueryMetadataServiceInterface metadataService, SessionContextInterface session, Map<BusinessModelReferenceInfo, BusinessModel> reuseBusinessModels) throws MetadataException {
        DataSelection dataSelection = null;
        Preconditions.ensureNonNull(dataSelectionOrDualElement, "dataSelectionOrDualElement");
        String elementName = dataSelectionOrDualElement.getTagName();
        if (elementName.equals("DataSelection") || elementName.equals("LookThroughDataSelection")) {
            dataSelection = DataSelectionFactory.readDataSelection(dataSelectionOrDualElement, reuseBusinessModels, metadataService, session);
        } else {
            if (elementName.equals("EmbeddedData")) {
                throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("CloneDataSelectionFactory.readDataSelection.embeddedDataSelection.txt", new Object[0]));
            }
            if (elementName.equals("DualBusinessQuery") || elementName.equals("DataSelectionWithEmbedded") || elementName.equals("LookThroughDataSelectionWithEmbedded")) {
                NodeList lookthroughNodes;
                NodeList embeddedNodes = dataSelectionOrDualElement.getElementsByTagName("EmbeddedData");
                Element embeddedDataElement = null;
                if (embeddedNodes.getLength() > 0) {
                    embeddedDataElement = (Element)embeddedNodes.item(0);
                }
                if ((lookthroughNodes = dataSelectionOrDualElement.getElementsByTagName("LookThroughDataSelection")).getLength() > 0) {
                    Element lookthroughElement = (Element)lookthroughNodes.item(0);
                    LookThroughDataSelectionWithEmbedded ltDS = LookThroughDataSelectionWithEmbedded.readInNewLookThroughDataSelectionWithEmbedded(session, metadataService, lookthroughElement, embeddedDataElement, reuseBusinessModels);
                    dataSelection = ltDS;
                } else {
                    NodeList dataselectionNodes = dataSelectionOrDualElement.getElementsByTagName("DataSelection");
                    Element dsElement = (Element)dataselectionNodes.item(0);
                    DataSelectionWithEmbedded ds = DataSelectionWithEmbedded.readInNewDataSelectionWithEmbedded(session, metadataService, dsElement, embeddedDataElement, reuseBusinessModels);
                    dataSelection = ds;
                }
            } else {
                throw new MetadataException(IQDataServicesResourceBundle.getMessageFormatter("CloneDataSelectionFactory.readDataSelection.invalidElement.fmt.txt", elementName));
            }
        }
        return dataSelection;
    }

    public static DataSelection copyBottomUp(DataSelection ds) throws MetadataException {
        return CloneDataSelectionFactory.copyBottomUp(ds, null);
    }

    public static DataSelection copyBottomUp(DataSelection ds, BusinessModel stopAt) throws MetadataException {
        DataSelection copy = null;
        DataSelection parent = ds.getParentDataSelection();
        if (parent == null || stopAt == parent) {
            BusinessModel parentModel = ds.getParentBusinessModel();
            copy = CloneDataSelectionFactory.copy(ds, parentModel);
        } else {
            DataSelection copyOfParent = CloneDataSelectionFactory.copyBottomUp(parent, stopAt);
            copy = CloneDataSelectionFactory.copy(ds, copyOfParent);
        }
        copy.setLabel("Copy of " + copy.getLabel());
        return copy;
    }

    private static DataSelection copy(DataSelection toCopy, BusinessModel parent) throws MetadataException {
        HashMap<BusinessModelReferenceInfo, BusinessModel> reuseTheseBusinessModels = new HashMap<BusinessModelReferenceInfo, BusinessModel>();
        if (parent != null) {
            BusinessModelReferenceInfo reusedParentBusinessModelRefInfo = parent.getReferenceInfo();
            reuseTheseBusinessModels.put(reusedParentBusinessModelRefInfo, parent);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new MetadataException(e);
        }
        Document doc = builder.newDocument();
        Element outElement = doc.createElement("bogus");
        doc.appendChild(outElement);
        Element dsElement = toCopy.write(outElement);
        DataSelectionFactory dsFactory = CombinedDataSelectionFactory.getInstance();
        DataSelection newDataSelection = dsFactory.readDataSelectionNonStatic(dsElement, reuseTheseBusinessModels, toCopy.getMetadataService(), toCopy.getSession());
        return newDataSelection;
    }

    public static void removeOldClonesOfRelational(DataSelection dataSelection) {
        if (dataSelection == null) {
            return;
        }
        BusinessModel parentBusinessModel = dataSelection.getParentBusinessModel();
        if (parentBusinessModel != null) {
            while (parentBusinessModel.getParentBusinessModel() != null) {
                parentBusinessModel = parentBusinessModel.getParentBusinessModel();
            }
            CloneDataSelectionFactory.removeClonedChildren(parentBusinessModel, dataSelection.getBusinessModel().getID());
        }
    }

    private static void removeClonedChildren(BusinessModel parentBusinessModel, String id) {
        List<BusinessModel> children = parentBusinessModel.getChildren();
        for (BusinessModel childBusinessModel : children) {
            CloneDataSelectionFactory.removeClonedChildren(childBusinessModel, id);
            if (!childBusinessModel.getID().startsWith(id)) continue;
            childBusinessModel.dispose();
        }
    }
}

