/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iquery.strategies.sas.oma;

import com.sas.entities.EntityInterface;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.dataretrieval.DataRetrievalException;
import com.sas.iquery.dataretrieval.InstructionInterface;
import com.sas.iquery.dataretrieval.RetrievalPolicy;
import com.sas.iquery.dataretrieval.StrategyInterface;
import com.sas.iquery.dataservices.IQDataServicesResourceBundle;
import com.sas.iquery.execution.ExecutionProcessor;
import com.sas.iquery.execution.OverrideLocaleInterface;
import com.sas.iquery.execution.OverrideMLSLookupsInterface;
import com.sas.iquery.execution.OverrideStpNamesInterface;
import com.sas.iquery.execution.instructions.ExecutionContext;
import com.sas.iquery.execution.instructions.ExecutionInstructionInterface;
import com.sas.iquery.execution.instructions.StpNames;
import com.sas.iquery.execution2.ExecutionException;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.physical.MLSLookup;
import com.sas.iquery.util.impl.MessageFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public abstract class AbstractStrategy
implements StrategyInterface,
InstructionInterface,
OverrideLocaleInterface,
OverrideMLSLookupsInterface,
OverrideStpNamesInterface {
    private ExecutionProcessor _processor = null;
    private RetrievalPolicy _retrievalPolicy;
    private IntelligentQueryMetadataServiceInterface _service = null;
    private static final Logger _auditLogger = LogManager.getLogger((String)"com.sas.iquery.audit");
    private static final Logger _logger = LogManager.getLogger(AbstractStrategy.class);
    private static final int KEYACTIONS_GENERATE_ID = 12;
    private static final int KEYACTIONS_EXECUTE_ID = 13;
    private int m_nNextGeneratedId;
    Locale _computationLocale = null;
    private StpNames _stpNames = null;
    private Map<String, MLSLookup> _mlsLookups = null;
    private List<DataSelection> _auxDataSelections = new ArrayList<DataSelection>();

    public AbstractStrategy() throws DataRetrievalException {
        this.loadIQService();
    }

    protected String _generateUniqueID() {
        return "_generatedName" + ++this.m_nNextGeneratedId + "_";
    }

    @Override
    public abstract ExecutionInstructionInterface createInstructions(DataSelection var1, EntityInterface var2) throws IQueryServicesException;

    @Override
    public String getPhysicalQuery(BusinessQuery businessQuery) throws IntelligentQueryException {
        ExecutionInstructionInterface instruction;
        try {
            instruction = this.createInstructions((DataSelection)businessQuery, null);
        }
        catch (IntelligentQueryException e) {
            throw e;
        }
        catch (IQueryServicesException e) {
            IntelligentQueryException e2 = new IntelligentQueryException(e);
            throw e2;
        }
        ExecutionContext context = this.newExecutionContext();
        instruction.setExecutionContext(context);
        instruction.setID(businessQuery.getID());
        StringBuffer strBuf = new StringBuffer();
        try {
            String text = instruction.getText();
            strBuf.append(text).append('\n');
        }
        catch (Exception e) {
            throw new IntelligentQueryException(e);
        }
        return strBuf.toString();
    }

    protected ExecutionContext newExecutionContext() {
        ExecutionContext context = new ExecutionContext(this.getRetrievalPolicy());
        context.setComputationalLocale(this.getComputationalLocale());
        context.setStpNames(this.getStpNames());
        context.setMLSLookups(this.getMLSLookups());
        return context;
    }

    @Override
    public abstract String getResultSetStructure(BusinessQuery var1, RetrievalPolicy var2) throws IntelligentQueryException;

    protected RetrievalPolicy getRetrievalPolicy() {
        return this._retrievalPolicy;
    }

    public boolean isPolicySupported(int retrievalPolicy) {
        if (retrievalPolicy == 1) {
            return false;
        }
        return retrievalPolicy == 0;
    }

    private void loadIQService() throws DataRetrievalException {
        _logger.info("Entering loadIQService()");
        try {
            this._service = IntelligentQueryMetadataServiceFactory.newService();
        }
        catch (MetadataException e) {
            if (_logger.isEnabled(Level.ERROR)) {
                _logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("AbstractStrategy.loadIQService.MetadataException.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        _logger.info("Exiting loadIQService()");
    }

    @Override
    public ResultSetInterface retrieveResultSet(BusinessQuery businessQuery, RetrievalPolicy retrievalPolicy) throws DataRetrievalException {
        ExecutionInstructionInterface executionInstruction;
        this.setRetrievalPolicy(retrievalPolicy);
        String id = businessQuery.getID();
        try {
            executionInstruction = this.createInstructions((DataSelection)businessQuery, null);
        }
        catch (DataRetrievalException e) {
            throw e;
        }
        catch (IQueryServicesException e) {
            throw new DataRetrievalException(e);
        }
        executionInstruction.setID(id);
        List<ExecutionInstructionInterface> instructions = Collections.singletonList(executionInstruction);
        ThreadContext.put((String)"actionID", (String)String.valueOf(12));
        ThreadContext.put((String)"action", (String)"Generate");
        ThreadContext.put((String)"actionType", (String)"MapQuery");
        _auditLogger.info("");
        if (_logger.isDebugEnabled()) {
            _logger.debug("Generated IQ Instructions: " + instructions);
        }
        this._processor = this.newExecutionProcessor(this.getRetrievalPolicy());
        try {
            this._processor.execute(instructions);
        }
        catch (ExecutionException e) {
            throw new DataRetrievalException(e);
        }
        ThreadContext.put((String)"actionID", (String)String.valueOf(13));
        ThreadContext.put((String)"action", (String)"Execute");
        ThreadContext.put((String)"actionType", (String)"MapQuery");
        _auditLogger.info("");
        ResultSetInterface rsi = null;
        try {
            rsi = this._processor.getResult(id);
        }
        catch (ExecutionException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("AbstractStrategy.retrieveModel.ExecutionException.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        catch (NullPointerException e) {
            MessageFormatter formatter = IQDataServicesResourceBundle.getMessageFormatter("AbstractStrategy.retrieveModel.NullPointerException.txt", new Object[0]);
            throw new DataRetrievalException(formatter, (Throwable)e);
        }
        return rsi;
    }

    public List<DataSelection> getAuxDataSelections() {
        return this._auxDataSelections;
    }

    public void addAuxDataSelection(DataSelection auxDataSelection) {
        this._auxDataSelections.add(auxDataSelection);
    }

    public void addAuxDataSelections(List<DataSelection> auxDataSelections) {
        this._auxDataSelections.addAll(auxDataSelections);
    }

    protected ExecutionProcessor newExecutionProcessor(RetrievalPolicy retrievalPolicy) {
        ExecutionProcessor processor = new ExecutionProcessor(this.getRetrievalPolicy());
        processor.setComputationalLocale(this.getComputationalLocale());
        processor.setStpNames(this.getStpNames());
        processor.setMLSLookups(this.getMLSLookups());
        return processor;
    }

    private void setRetrievalPolicy(RetrievalPolicy retrievalPolicy) {
        this._retrievalPolicy = retrievalPolicy;
    }

    @Override
    public Locale getComputationalLocale() {
        return this._computationLocale;
    }

    @Override
    public void setComputationalLocale(Locale overrideComputationalLocale) {
        this._computationLocale = overrideComputationalLocale;
    }

    @Override
    public StpNames getStpNames() {
        return this._stpNames;
    }

    @Override
    public void setStpNames(StpNames stpNames) {
        this._stpNames = stpNames;
    }

    @Override
    public Map<String, MLSLookup> getMLSLookups() {
        return this._mlsLookups;
    }

    @Override
    public void setMLSLookups(Map<String, MLSLookup> mlsLookupsByColumnName) {
        this._mlsLookups = mlsLookupsByColumnName;
    }
}

